/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

public class Config {
    private final Config parent;
    private final String name;
    private String comment;
    private boolean saveWithParent = true;
    private final Map<String, Config> sections = new LinkedHashMap<String, Config>();
    private final Map<String, Value> values = new LinkedHashMap<String, Value>();
    private static final String lineSeparator = System.getProperty("line.separator");

    public Config(String name) {
        this(null, name, "");
    }

    private Config(Config parent, String name, String comment) {
        assert (parent != this);
        this.parent = parent;
        this.name = name;
        this.comment = comment;
    }

    public Config getRoot() {
        Config ret = this;
        while (ret.parent != null) {
            ret = ret.parent;
        }
        return ret;
    }

    public Config getSub(String key) {
        List<String> parts = Config.split(key, '/');
        return this.getSub(parts, parts.size(), false);
    }

    public Config addSub(String key, String aComment) {
        assert (Config.split(key, '/').size() == 1);
        Config config = this.sections.get(key);
        if (config == null) {
            config = new Config(this, key, aComment);
            this.sections.put(key, config);
        } else {
            config.comment = aComment;
        }
        return config;
    }

    public Value get(String key) {
        List<String> parts = Config.split(key, '/');
        Config config = this.getSub(parts, parts.size() - 1, false);
        if (config == null) {
            return null;
        }
        return config.values.get(parts.get(parts.size() - 1));
    }

    public void set(String key, Value value) {
        List<String> parts = Config.split(key, '/');
        assert (parts.get(parts.size() - 1).equals(value.name));
        Config config = this.getSub(parts, parts.size() - 1, true);
        config.values.put(parts.get(parts.size() - 1), value);
    }

    public <T> void set(String key, T value) {
        List<String> parts = Config.split(key, '/');
        Config config = this.getSub(parts, parts.size() - 1, true);
        String tName = parts.get(parts.size() - 1);
        Value existingValue = config.values.get(tName);
        if (existingValue == null) {
            existingValue = new Value(tName, "", null);
            config.values.put(tName, existingValue);
        }
        existingValue.set(value);
    }

    public void clear() {
        this.sections.clear();
        this.values.clear();
    }

    public void sort() {
        ArrayList<Map.Entry<String, Value>> valueList = new ArrayList<Map.Entry<String, Value>>(this.values.entrySet());
        Collections.sort(valueList, new Comparator<Map.Entry<String, Value>>(){

            @Override
            public int compare(Map.Entry<String, Value> a, Map.Entry<String, Value> b) {
                return a.getKey().compareTo(b.getKey());
            }
        });
        this.values.clear();
        for (Map.Entry entry : valueList) {
            this.values.put((String)entry.getKey(), (Value)entry.getValue());
        }
    }

    public Iterator<Config> sectionIterator() {
        return this.sections.values().iterator();
    }

    public Iterator<Value> valueIterator() {
        return this.values.values().iterator();
    }

    public void setSaveWithParent(boolean saveWithParent) {
        this.saveWithParent = saveWithParent;
    }

    public void load(InputStream is) throws IOException, ParseException {
        Config root;
        InputStreamReader isReader;
        try {
            isReader = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        LineNumberReader reader = new LineNumberReader(isReader);
        Config config = root = this;
        StringBuilder tComment = new StringBuilder();
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(";")) {
                    if (line.equals(";---")) {
                        tComment = new StringBuilder();
                        continue;
                    }
                    line = line.substring(1).trim();
                    if (tComment.length() != 0) {
                        tComment.append(lineSeparator);
                    }
                    tComment.append(line);
                    continue;
                }
                if (line.startsWith("[")) {
                    if (!line.endsWith("]")) {
                        throw new ParseException("section without closing bracket", reader.getLineNumber(), line);
                    }
                    String section = line.substring(1, line.length() - 1);
                    List<String> keys = Config.split(section, '/');
                    ListIterator<String> it = keys.listIterator();
                    while (it.hasNext()) {
                        it.set(Config.unescapeSection(it.next()));
                    }
                    if (tComment.length() > 0) {
                        config = root.getSub(keys, keys.size() - 1, true);
                        config = config.addSub(keys.get(keys.size() - 1), tComment.toString());
                        tComment = new StringBuilder();
                        continue;
                    }
                    config = root.getSub(keys, keys.size(), true);
                    continue;
                }
                List<String> parts = Config.split(line, '=');
                if (parts.size() != 2) {
                    throw new ParseException("invalid key-value pair", reader.getLineNumber(), line);
                }
                String key = Config.unescapeValue(parts.get(0).trim());
                if (key.isEmpty()) {
                    throw new ParseException("empty key", reader.getLineNumber(), line);
                }
                String valueStr = parts.get(1).trim();
                while (valueStr.replaceAll("\\\\.", "xx").endsWith("\\")) {
                    valueStr = valueStr.substring(0, valueStr.length() - 1) + " ";
                    valueStr = valueStr + reader.readLine().trim();
                }
                valueStr = Config.unescapeValue(valueStr);
                config.set(key, new Value(key, tComment.toString(), valueStr, reader.getLineNumber()));
                if (tComment.length() <= 0) continue;
                tComment = new StringBuilder();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException("general parse error", reader.getLineNumber(), line, e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws ParseException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.load(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream os) throws IOException {
        OutputStreamWriter osWriter;
        try {
            osWriter = new OutputStreamWriter(os, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        BufferedWriter writer = new BufferedWriter(osWriter);
        try {
            Config config;
            writer.write("; ");
            writer.write(this.name);
            writer.newLine();
            writer.write("; created ");
            writer.write(DateFormat.getDateTimeInstance().format(new Date()));
            writer.newLine();
            writer.write(";---");
            writer.newLine();
            Config root = this;
            ArrayDeque<Config> todo = new ArrayDeque<Config>();
            todo.add(this);
            while ((config = (Config)todo.poll()) != null) {
                if (!config.values.isEmpty() || !config.comment.isEmpty() || config.sections.isEmpty()) {
                    writer.newLine();
                    if (config != root) {
                        if (!config.comment.isEmpty()) {
                            String[] commentParts;
                            for (String comment : commentParts = config.comment.split("\\n")) {
                                writer.write("; ");
                                writer.write(comment);
                                writer.newLine();
                            }
                        }
                        writer.write(91);
                        ArrayList<String> keys = new ArrayList<String>();
                        Config cSection = config;
                        do {
                            keys.add(cSection.name);
                        } while ((cSection = cSection.parent) != root);
                        for (int i = keys.size() - 1; i >= 0; --i) {
                            writer.write(Config.escapeSection((String)keys.get(i)));
                            if (i <= 0) continue;
                            writer.write(" / ");
                        }
                        writer.write(93);
                        writer.newLine();
                    }
                    for (Value value : config.values.values()) {
                        if (!value.comment.isEmpty()) {
                            for (String line : value.comment.split("\\n")) {
                                writer.write("; ");
                                writer.write(line);
                                writer.newLine();
                            }
                        }
                        writer.write(Config.escapeValue(value.name));
                        writer.write(" = ");
                        writer.write(Config.escapeValue(value.getString()));
                        writer.newLine();
                    }
                }
                ArrayList<Config> toAdd = new ArrayList<Config>(config.sections.size());
                for (Config section : config.sections.values()) {
                    if (!section.saveWithParent) continue;
                    toAdd.add(section);
                }
                ListIterator it = toAdd.listIterator(toAdd.size());
                while (it.hasPrevious()) {
                    todo.addFirst((Config)it.previous());
                }
            }
            writer.newLine();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.save(os);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private Config getSub(List<String> keys, int end, boolean create) {
        Config ret = this;
        for (int i = 0; i < end; ++i) {
            String key = keys.get(i);
            assert (key.length() > 0);
            Config config = ret.sections.get(key);
            if (config == null) {
                if (create) {
                    config = new Config(ret, key, "");
                    ret.sections.put(key, config);
                } else {
                    return null;
                }
            }
            ret = config;
        }
        return ret;
    }

    private static List<String> split(String str, char splitChar) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean empty = true;
        boolean passNext = false;
        boolean quoted = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (passNext) {
                current.append(c);
                empty = false;
                passNext = false;
                continue;
            }
            if (c == '\\') {
                current.append(c);
                empty = false;
                passNext = true;
                continue;
            }
            if (c == '\"') {
                current.append(c);
                empty = false;
                quoted = !quoted;
                continue;
            }
            if (!quoted && c == splitChar) {
                ret.add(current.toString().trim());
                current = new StringBuilder();
                empty = true;
                continue;
            }
            if (Character.isWhitespace(c) && empty) continue;
            current.append(c);
            empty = false;
        }
        ret.add(current.toString().trim());
        return ret;
    }

    private static String escapeSection(String str) {
        return str.replaceAll("([\\[\\];/])", "\\\\$1").replace("\n", "\\n");
    }

    private static String unescapeSection(String str) {
        return str.replaceAll("\\\\([\\[\\];/])", "$1").replace("\\n", "\n");
    }

    private static String escapeValue(String str) {
        return str.replaceAll("([\\[\\];=\\\\])", "\\\\$1").replace("\n", "\\\n");
    }

    private static String unescapeValue(String str) {
        return str.replaceAll("\\\\([\\[\\];=])", "$1");
    }

    public static class ParseException
    extends RuntimeException {
        private static final long serialVersionUID = 8721912755972301225L;

        public ParseException(String msg, int line, String content) {
            super(msg + " at line " + line + " (" + content + ").");
        }

        public ParseException(String msg, int line, String content, Exception e) {
            super(msg + " at line " + line + " (" + content + ").", e);
        }

        public ParseException(String msg, Value value) {
            super(msg + " at line " + (value.getLine() == -1 ? "(unknown)" : Integer.valueOf(value.getLine())) + " (" + value.name + " = " + value.getString() + ").");
        }

        public ParseException(String msg, Value value, Exception e) {
            super(msg + " at line " + (value.getLine() == -1 ? "(unknown)" : Integer.valueOf(value.getLine())) + " (" + value.name + " = " + value.getString() + ").", e);
        }
    }

    public static class Value {
        public final String name;
        public String comment;
        public String value;
        private final int line;
        private Number numberCache;

        public Value(String name, String comment, String value) {
            this(name, comment, value, -1);
        }

        private Value(String name, String comment, String value, int line) {
            this.name = name;
            this.comment = comment;
            this.value = value;
            this.line = line;
        }

        public String getString() {
            return this.value;
        }

        public boolean getBool() {
            return Boolean.valueOf(this.value);
        }

        public int getInt() {
            try {
                return this.getNumber().intValue();
            }
            catch (java.text.ParseException e) {
                throw new ParseException("invalid value", this, e);
            }
        }

        public float getFloat() {
            try {
                return this.getNumber().floatValue();
            }
            catch (java.text.ParseException e) {
                throw new ParseException("invalid value", this, e);
            }
        }

        public double getDouble() {
            try {
                return this.getNumber().doubleValue();
            }
            catch (java.text.ParseException e) {
                throw new ParseException("invalid value", this, e);
            }
        }

        public <T> void set(T value) {
            this.value = String.valueOf(value);
            this.numberCache = null;
        }

        public int getLine() {
            return this.line;
        }

        private Number getNumber() throws java.text.ParseException {
            if (this.numberCache == null) {
                this.numberCache = NumberFormat.getInstance(Locale.US).parse(this.value);
            }
            return this.numberCache;
        }
    }
}

