/*
 * Decompiled with CFR 0.152.
 */
package putils.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import ic2.api.item.IC2Items;
import ic2.api.recipe.Recipes;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import putils.common.ServerProxy;
import putils.common.blocks.BlockMain;
import putils.common.items.ItemMainBlock;
import putils.common.items.ItemStorageModule;
import putils.common.tiles.TileEntityPowerConverter;
import putils.network.PacketHandler;
import putils.utils.Info;

@Mod(modid="PowerUtils", name="PowerUtils", dependencies="required-after:IC2; after:gregtech_addon; after:ThermalExpansion;", version="1.7.10-1.0.4")
public class PowerUtils {
    public static CreativeTabs ic2Tab;
    public static final Side side;
    public static Configuration config;
    public static String configFileName;
    public static Block blockMain;
    public static int ratioICTE;
    public static int ratioBCIC;
    public static int ratioICEU;
    public static int ratioBCTE;
    public static int ratioBCEU;
    public static int ratioTEEU;
    public static int idBlockMachine;
    public static int idModule;
    public static boolean disableRecipeBCModule;
    public static boolean disableRecipeICModule;
    public static boolean disableRecipeEUModule;
    public static boolean disableRecipeTEModule;
    public static final String CATEGORY_RECIPES = "recipes settings";
    public static final String CATEGORY_RATIO = " convert ratio";
    public static Item itemStorageModule;
    public static ItemStack itemModuleIC;
    public static ItemStack itemModuleBC;
    public static ItemStack itemModuleTE;
    public static ItemStack itemModuleUE;
    public static ItemStack itemPowerConverter;
    public static PacketHandler packetHandler;
    @SidedProxy(clientSide="putils.client.ClientProxy", serverSide="putils.common.ServerProxy")
    public static ServerProxy proxy;
    @Mod.Instance(value="PowerUtils")
    public static PowerUtils instance;

    public static ItemStack setItemsSize(ItemStack itemStack, int newSize) {
        ItemStack newStack = itemStack.func_77946_l();
        newStack.field_77994_a = newSize;
        return newStack;
    }

    public static boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static void addLog(String logLine) {
        System.out.println("[PowerUtilites] " + logLine);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            configFileName = event.getSuggestedConfigurationFile().getAbsolutePath();
            idBlockMachine = config.get("BLOCK", "blockMachine", 196).getInt(196);
            idModule = config.get("ITEMS", "itemModule", 30579).getInt(30579);
            ratioICTE = config.get(CATEGORY_RATIO, "RF for 1 EU", 8).getInt(8);
        }
        catch (Exception e) {
            PowerUtils.addLog("error while loading config file");
            throw new RuntimeException(e);
        }
        finally {
            config.save();
        }
        if (side == Side.CLIENT) {
            Info.getIC2Tab();
        }
        Info.ic2transformerUpg = IC2Items.getItem("transformerUpgrade").func_77946_l();
        Info.ic2storageUpg = IC2Items.getItem("energyStorageUpgrade").func_77946_l();
        blockMain = new BlockMain();
        GameRegistry.registerBlock((Block)blockMain, ItemMainBlock.class, (String)"BlockMain");
        GameRegistry.registerTileEntity(TileEntityPowerConverter.class, (String)"Power Converter");
        itemStorageModule = new ItemStorageModule();
        GameRegistry.registerItem((Item)itemStorageModule, (String)"pu_storage_module");
        itemModuleIC = new ItemStack(itemStorageModule.func_77655_b("itemModuleIC"), 1, 0);
        itemModuleTE = new ItemStack(itemStorageModule.func_77655_b("itemModuleTE"), 1, 1);
        itemModuleBC = new ItemStack(itemStorageModule.func_77655_b("itemModuleBC"), 1, 2);
        itemModuleUE = new ItemStack(itemStorageModule.func_77655_b("itemModuleUE"), 1, 3);
        itemPowerConverter = new ItemStack(blockMain, 1, 0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        packetHandler = new PacketHandler();
        proxy.load();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void afterModsLoaded(FMLPostInitializationEvent event) {
        Recipes.advRecipes.addRecipe(itemModuleIC, "ABA", "CDC", "ABA", Character.valueOf('A'), IC2Items.getItem("insulatedCopperCableItem"), Character.valueOf('B'), IC2Items.getItem("mvTransformer"), Character.valueOf('C'), "circuitBasic", Character.valueOf('D'), IC2Items.getItem("batBox"));
        ItemStack teCell = Info.getTECell("cellBasic");
        if (teCell != null) {
            if (Info.isModLoaded("ThermalExpansion")) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemModuleTE, new Object[]{"ABA", "BDB", "ABA", Character.valueOf('A'), "ingotElectrum", Character.valueOf('B'), "gearLead", Character.valueOf('D'), teCell}));
            }
        } else {
            PowerUtils.addLog("Error in register TE module recipe. TE cell not found");
        }
        Recipes.advRecipes.addRecipe(itemPowerConverter, "ABA", "CDE", "ABA", Character.valueOf('A'), IC2Items.getItem("advancedAlloy"), Character.valueOf('B'), "circuitAdvanced", Character.valueOf('C'), itemModuleIC, Character.valueOf('D'), IC2Items.getItem("machine"), Character.valueOf('E'), itemModuleTE);
    }

    static {
        side = FMLCommonHandler.instance().getEffectiveSide();
        instance = new PowerUtils();
    }
}

