/*
 * Decompiled with CFR 0.152.
 */
package putils.common.tiles;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import putils.common.PowerUtils;
import putils.common.containers.ContainerPowerConverter;
import putils.common.tiles.TileEntityBase;
import putils.network.IReceiveServerEvents;
import putils.utils.Info;

public class TileEntityPowerConverter
extends TileEntityBase
implements IEnergyTile,
IWrenchable,
IEnergySource,
IInventory,
IEnergyHandler,
IEnergySink,
IReceiveServerEvents {
    public static Random randomizer = new Random();
    public int convertState = 0;
    public int convertType = 1;
    public boolean active = true;
    public int storage1;
    public int storage2;
    public int maxStorage1 = 40000;
    public int maxStorage2 = 400000;
    public int storage1ModuleType;
    public int storage2ModuleType;
    public int inputEnergyValue;
    public int outputEnergyValue;
    public int inputEnergyBuffer;
    public int outputEnergyBuffer;
    public int inputOverFlowEUBuffer;
    public int tickRateFlush = 5;
    public int tickRate = 40;
    public int elapsedTicks;
    public int ticker = 0;
    public long lastTimeStamp;
    public int baseEUproduction;
    public int maxEUproduction = this.baseEUproduction = 128;
    public int maxRFproduction = this.maxStorage2;
    public int maxTransformersUpgrade = 4;
    public boolean initialized = false;
    private short facing = (short)2;
    public boolean addedToEnergyNet = false;
    private boolean created = false;
    private ItemStack[] converterSlots = new ItemStack[4];
    public static int slotsCount = 4;
    public int fuel;
    private int lastX = this.field_145851_c;
    private int lastY = this.field_145848_d;
    private int lastZ = this.field_145849_e;
    public boolean loaded = false;
    private int machineTire = 5;

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || !this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onUnloaded() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        this.loaded = false;
    }

    public void intialize() {
        this.initialized = true;
        this.lastTimeStamp = System.currentTimeMillis();
        if (!this.addedToEnergyNet) {
            this.onLoaded();
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.initialized && this.field_145850_b != null) {
            this.intialize();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145849_e || this.lastY != this.field_145848_d) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.intialize();
        }
        if (this.ticker++ % this.tickRate == 0) {
            long nowTimeStamp = System.currentTimeMillis();
            int testStamp = Math.round((float)(nowTimeStamp - this.lastTimeStamp) / 1000.0f * 20.0f);
            this.elapsedTicks += testStamp;
            if (this.elapsedTicks == 0) {
                this.elapsedTicks = 1;
            }
            this.inputEnergyValue = this.inputEnergyBuffer > 0 ? Math.round(this.inputEnergyBuffer / this.elapsedTicks) : 0;
            this.outputEnergyValue = this.outputEnergyBuffer > 0 ? Math.round(this.outputEnergyBuffer / this.elapsedTicks) : 0;
            if (this.elapsedTicks >= this.tickRate * this.tickRateFlush) {
                this.outputEnergyBuffer = 0;
                this.inputEnergyBuffer = 0;
                this.elapsedTicks = 0;
            }
            this.lastTimeStamp = System.currentTimeMillis();
        }
        if (this.inputOverFlowEUBuffer > 0) {
            if (this.storage1 + this.inputOverFlowEUBuffer > this.maxStorage1) {
                this.inputOverFlowEUBuffer = this.storage1 + this.inputOverFlowEUBuffer - this.maxStorage1;
                this.storage1 = this.maxStorage1;
            } else {
                this.storage1 += this.inputOverFlowEUBuffer;
                this.inputOverFlowEUBuffer = 0;
            }
        }
        if (this.convertState == 0 && this.storage1 > 0 && this.storage2 < this.maxStorage2) {
            int maxConvertEnergy = this.storage1 * PowerUtils.ratioICTE;
            if (this.maxStorage2 < maxConvertEnergy + this.storage2) {
                int requestRFEnergy = this.maxStorage2 - this.storage2;
                int requestEUEnergy = requestRFEnergy / PowerUtils.ratioICTE;
                requestRFEnergy = requestEUEnergy * PowerUtils.ratioICTE;
                this.storage2 += requestRFEnergy;
                this.storage1 -= requestEUEnergy;
            } else {
                this.storage2 += maxConvertEnergy;
                this.storage1 = 0;
            }
        }
        if (this.convertState == 1 && this.storage2 >= PowerUtils.ratioICTE && this.storage1 < this.maxStorage1) {
            int maxConvertEnergy = this.storage2 / PowerUtils.ratioICTE;
            if (this.maxStorage1 < maxConvertEnergy + this.storage1) {
                int requestEUEnergy = this.maxStorage1 - this.storage1;
                int requestRFEnergy = requestEUEnergy * PowerUtils.ratioICTE;
                this.storage1 += requestEUEnergy;
                this.storage2 -= requestRFEnergy;
            } else {
                this.storage1 += maxConvertEnergy;
                this.storage2 = 0;
            }
        }
        if (this.convertState == 0) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
                if (!(tile instanceof IEnergyHandler)) continue;
                this.extractEnergy(side.getOpposite(), ((IEnergyHandler)tile).receiveEnergy(side.getOpposite(), this.extractEnergy(side.getOpposite(), this.maxRFproduction, true), false), false);
            }
        }
    }

    @Override
    public void onServerEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.convertState = 0;
                this.onUnloaded();
                this.intialize();
                break;
            }
            case 1: {
                this.convertState = 1;
                this.onUnloaded();
                this.intialize();
            }
        }
    }

    public void CheckModuleSlots() {
        int transformerUpgCount = 0;
        int storageUpgCount = 0;
        for (int i = 0; i < slotsCount; ++i) {
            ItemStack stack = this.converterSlots[i];
            if (stack == null) continue;
            if (stack.func_77969_a(Info.ic2storageUpg)) {
                storageUpgCount += stack.field_77994_a;
                continue;
            }
            if (!stack.func_77969_a(Info.ic2transformerUpg)) continue;
            transformerUpgCount += stack.field_77994_a;
        }
        if (transformerUpgCount > this.maxTransformersUpgrade) {
            transformerUpgCount = this.maxTransformersUpgrade;
        }
        this.maxEUproduction = (int)Math.pow(2.0, 2 * (2 + transformerUpgCount) + 3);
    }

    public int checkConvertMode(int module1, int module2) {
        return -1;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.storage1 = nbttagcompound.func_74762_e("storage1");
        this.storage2 = nbttagcompound.func_74762_e("storage2");
        this.convertState = nbttagcompound.func_74762_e("convertState");
        this.lastX = nbttagcompound.func_74762_e("lastX");
        this.lastY = nbttagcompound.func_74762_e("lastY");
        this.lastZ = nbttagcompound.func_74762_e("lastZ");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.converterSlots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.converterSlots.length) continue;
            this.converterSlots[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.CheckModuleSlots();
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        nbttagcompound.func_74768_a("storage1", this.storage1);
        nbttagcompound.func_74768_a("storage2", this.storage2);
        nbttagcompound.func_74768_a("convertState", this.convertState);
        nbttagcompound.func_74768_a("lastX", this.lastX);
        nbttagcompound.func_74768_a("lastY", this.lastY);
        nbttagcompound.func_74768_a("lastZ", this.lastZ);
        for (int i = 0; i < this.converterSlots.length; ++i) {
            if (this.converterSlots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.converterSlots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    public int gaugeICEnergyScaled(int i) {
        return this.storage1 * i / this.maxStorage1;
    }

    public int gaugeTEEnergyScaled(int i) {
        return this.storage2 * i / this.maxStorage2;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityplayer, int i) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public ItemStack[] getContents() {
        return this.converterSlots;
    }

    public int func_70302_i_() {
        return slotsCount;
    }

    public ItemStack func_70301_a(int i) {
        return this.converterSlots[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.converterSlots[i] != null) {
            if (this.converterSlots[i].field_77994_a <= j) {
                ItemStack itemstack = this.converterSlots[i];
                this.converterSlots[i] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.converterSlots[i].func_77979_a(j);
            if (this.converterSlots[i].field_77994_a == 0) {
                this.converterSlots[i] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.converterSlots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.onInventoryChanged();
    }

    public int func_70297_j_() {
        return 64;
    }

    protected void selfDestroy() {
        this.onUnloaded();
        this.dropContents();
        ItemStack stack = new ItemStack(PowerUtils.blockMain, 1, 0);
        this.dropItem(stack);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145843_s();
    }

    public void dropItem(ItemStack item) {
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, item);
        entityitem.field_145804_b = 10;
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }

    public void dropContents() {
        for (int i = 0; i < this.converterSlots.length; ++i) {
            ItemStack item = this.converterSlots[i];
            this.converterSlots[i] = null;
            if (item == null || item.field_77994_a <= 0) continue;
            this.dropItem(item);
        }
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer) {
        return new ContainerPowerConverter(inventoryplayer, this);
    }

    public ItemStack func_70304_b(int var1) {
        if (this.converterSlots[var1] != null) {
            ItemStack var2 = this.converterSlots[var1];
            this.converterSlots[var1] = null;
            return var2;
        }
        return null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void onInventoryChanged() {
        this.CheckModuleSlots();
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.convertState == 1;
    }

    @Override
    public double getOfferedEnergy() {
        if (this.storage1 == 0 && this.convertState == 1) {
            this.outputEnergyBuffer = 0;
        }
        return Math.min(this.maxEUproduction, this.storage1);
    }

    @Override
    public void drawEnergy(double amount) {
        this.storage1 = (int)((double)this.storage1 - amount);
        this.outputEnergyBuffer += (int)amount;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.convertState == 0;
    }

    @Override
    public double getDemandedEnergy() {
        if (this.convertState != 0) {
            return 0.0;
        }
        if (this.maxStorage1 - this.storage1 - this.inputOverFlowEUBuffer < 0) {
            return 0.0;
        }
        return this.maxStorage1 - this.storage1 - this.inputOverFlowEUBuffer;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (amount > (double)this.maxEUproduction) {
            // empty if block
        }
        if (this.storage1 >= this.maxStorage1) {
            return amount;
        }
        if (this.storage1 + (int)amount > this.maxStorage1) {
            int returnEnergy = this.storage1 + (int)amount - this.maxStorage1;
            this.inputEnergyBuffer += (int)amount;
            this.storage1 = this.maxStorage1;
            this.inputOverFlowEUBuffer += returnEnergy;
            return 0.0;
        }
        this.inputEnergyBuffer += (int)amount;
        this.storage1 = (int)((double)this.storage1 + amount);
        return 0.0;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.convertState == 1) {
            if (this.storage2 >= this.maxStorage2) {
                return 0;
            }
            if (this.storage2 + maxReceive > this.maxStorage2) {
                int energyReceived = this.maxStorage2 - this.storage2;
                if (!simulate) {
                    this.storage2 = this.maxStorage2;
                    this.inputEnergyBuffer += energyReceived;
                }
                return energyReceived;
            }
            if (!simulate) {
                this.inputEnergyBuffer += maxReceive;
                this.storage2 += maxReceive;
            }
            return maxReceive;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.convertState == 0 && this.storage2 > 0) {
            int energyExtracted = Math.min(this.storage2, maxExtract);
            if (!simulate) {
                this.storage2 -= energyExtracted;
                this.outputEnergyBuffer += energyExtracted;
            }
            return energyExtracted;
        }
        if (this.convertState == 0) {
            // empty if block
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection arg0) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage2;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.maxStorage2;
    }

    @Override
    public int getSinkTier() {
        return this.machineTire;
    }

    public String func_145825_b() {
        return "PowerConverter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getSourceTier() {
        return this.machineTire;
    }
}

