/*
 * Decompiled with CFR 0.152.
 */
package ihl.collector;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotDischarge;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.collector.ChargerEjectorContainer;
import ihl.collector.ChargerEjectorGui;
import ihl.collector.CollectorEntity;
import ihl.collector.CollectorItem;
import ihl.collector.InvSlotMultiCharge;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class ChargerEjectorTileEntity
extends TileEntityInventory
implements IEnergySink,
IHasGui,
INetworkClientTileEntityEventListener {
    private int tier = 4;
    public int maxStorage = 10000000;
    private double energy = 0.0;
    public final InvSlotDischarge dischargeSlot;
    public final InvSlotMultiCharge chargeSlot;
    public boolean addedToEnergyNet = false;
    public int[] chargeSlotStatus = new int[9];
    public int[] prevChargeSlotStatus = new int[9];
    public ItemStack chargeItemStack0;
    public ItemStack chargeItemStack1;
    public ItemStack chargeItemStack2;
    public ItemStack chargeItemStack3;
    public ItemStack chargeItemStack4;
    public ItemStack chargeItemStack5;
    public ItemStack chargeItemStack6;
    public ItemStack chargeItemStack7;
    public ItemStack chargeItemStack8;
    private int slotNumNet = 0;
    public boolean isGuiScreenOpened = false;
    public boolean autoEject = true;
    public boolean firstTickUpdate = true;

    public ChargerEjectorTileEntity() {
        this.dischargeSlot = new InvSlotDischarge((TileEntityInventory)this, 0, this.tier, InvSlot.InvSide.BOTTOM);
        this.chargeSlot = new InvSlotMultiCharge(this, 1, this.tier, 9);
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        if (this.dischargeSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.dischargeSlot.get()));
        }
        for (int i = 0; i < this.chargeSlot.size(); ++i) {
            if (this.chargeSlot.get(i) == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.chargeSlot.get(i)));
        }
        ItemStack stack = new ItemStack(IHLMod.chargerEjectorBlock, 1);
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74780_a("energy", this.energy);
        return stack;
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        for (int i = 0; i < this.chargeSlot.size(); ++i) {
            fields.add("chargeItemStack" + i);
        }
        return fields;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean enableUpdateEntity() {
        return true;
    }

    public void func_145845_h() {
        int i;
        if (this.firstTickUpdate && this.isGuiScreenOpened && IC2.platform.isSimulating()) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "autoEject");
            this.firstTickUpdate = false;
        }
        if (IC2.platform.isSimulating() && this.energy < 1.0 && this.getActive()) {
            this.setActive(false);
        } else if (IC2.platform.isSimulating() && this.energy >= 1.0 && !this.getActive()) {
            this.setActive(true);
        }
        for (i = 0; i < this.chargeSlotStatus.length; ++i) {
            if (!this.getActive() && this.chargeSlot.get(i) == null) {
                this.chargeSlotStatus[i] = 0;
                continue;
            }
            if (!this.getActive() && this.chargeSlot.get(i) != null) {
                this.chargeSlotStatus[i] = -1;
                continue;
            }
            if (this.getActive() && this.chargeSlot.get(i) == null) {
                this.chargeSlotStatus[i] = -2;
                continue;
            }
            if (!this.getActive() || this.chargeSlot.get(i) == null) continue;
            this.chargeSlotStatus[i] = ElectricItem.manager.charge(this.chargeSlot.get(i), 1.0, this.tier, false, true) > 0.0 ? 1 : 2;
        }
        if (IC2.platform.isSimulating()) {
            EntityPlayer player;
            super.func_145845_h();
            List<EntityItem> eItemsList = this.getEItemsList();
            if (eItemsList != null && eItemsList.size() > 0) {
                for (EntityItem entity : eItemsList) {
                    if (!entity.field_70128_L && entity.func_92059_d() != null && entity.func_92059_d().field_77994_a > 0) {
                        if (!this.chargeSlot.addItemStackToFirstEmptyStack(entity.func_92059_d())) continue;
                        entity.func_70106_y();
                        continue;
                    }
                    entity.func_70106_y();
                }
            }
            if ((player = this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1.1)) != null && player instanceof EntityPlayerMP) {
                for (int i2 = 0; i2 < this.chargeSlot.size(); ++i2) {
                    if (this.chargeSlotStatus[i2] != 2 || player.field_71071_by.func_70447_i() < 0 || !player.field_71071_by.func_70441_a(this.chargeSlot.get(i2))) continue;
                    this.chargeSlot.put(i2, null);
                }
            }
            this.slotNumNet = this.slotNumNet < this.chargeSlotStatus.length - 1 ? ++this.slotNumNet : 0;
            if (this.chargeSlotStatus[this.slotNumNet] != this.prevChargeSlotStatus[this.slotNumNet]) {
                ItemStack stack1 = this.chargeSlot.get(this.slotNumNet);
                if (stack1 != null) {
                    if (this.chargeSlotStatus[this.slotNumNet] == 2 && this.chargeSlot.get(this.slotNumNet).func_77973_b() instanceof CollectorItem) {
                        if (this.autoEject) {
                            CollectorItem item = (CollectorItem)this.chargeSlot.get(this.slotNumNet).func_77973_b();
                            if (item.spawnEntityInWorld(this.field_145850_b, this.chargeSlot.get(this.slotNumNet), this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                                this.setChargeISByNum(this.slotNumNet, null);
                                this.chargeSlot.put(this.slotNumNet, null);
                            } else {
                                this.setChargeISByNum(this.slotNumNet, this.chargeSlot.get(this.slotNumNet).func_77946_l());
                            }
                        } else {
                            this.setChargeISByNum(this.slotNumNet, this.chargeSlot.get(this.slotNumNet).func_77946_l());
                        }
                    } else {
                        this.setChargeISByNum(this.slotNumNet, this.chargeSlot.get(this.slotNumNet).func_77946_l());
                    }
                } else {
                    this.setChargeISByNum(this.slotNumNet, null);
                }
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "chargeItemStack" + this.slotNumNet);
                this.prevChargeSlotStatus[this.slotNumNet] = this.chargeSlotStatus[this.slotNumNet];
            }
            if (this.energy >= 1.0) {
                for (int i3 = 0; i3 < this.chargeSlotStatus.length; ++i3) {
                    double amount = this.chargeSlot.charge((int)this.energy, i3);
                    this.energy -= amount;
                }
            }
            if (this.getDemandedEnergy() > 1.0) {
                double amount = this.dischargeSlot.discharge(this.getDemandedEnergy(), false);
                this.energy += amount;
            }
        } else if (!this.isGuiScreenOpened) {
            for (i = 0; i < this.chargeSlot.size(); ++i) {
                if (this.chargeSlot.get(i) == this.getChargeISByNum(i)) continue;
                this.chargeSlot.put(i, this.getChargeISByNum(i));
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        block2: {
            super.func_145839_a(nbttagcompound);
            try {
                this.energy = nbttagcompound.func_74769_h("energy");
            }
            catch (Exception var3) {
                this.energy = nbttagcompound.func_74762_e("energy");
                if (this.maxStorage <= Integer.MAX_VALUE) break block2;
                this.energy *= 10.0;
            }
        }
        this.autoEject = nbttagcompound.func_74767_n("autoeject");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74757_a("autoeject", this.autoEject);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction == ForgeDirection.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer arg0, boolean arg1) {
        return new ChargerEjectorGui(new ChargerEjectorContainer(arg0, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer arg0) {
        return new ChargerEjectorContainer(arg0, this);
    }

    public void onGuiClosed(EntityPlayer arg0) {
        this.isGuiScreenOpened = false;
    }

    public String func_145825_b() {
        return "charger_ejector";
    }

    public int getStored() {
        return Math.round((float)this.energy);
    }

    public void setStored(double value) {
        this.energy = value;
    }

    public boolean getGui(EntityPlayer player) {
        this.isGuiScreenOpened = this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
        return this.isGuiScreenOpened;
    }

    private ItemStack getChargeISByNum(int num) {
        switch (num) {
            case 0: {
                return this.chargeItemStack0;
            }
            case 1: {
                return this.chargeItemStack1;
            }
            case 2: {
                return this.chargeItemStack2;
            }
            case 3: {
                return this.chargeItemStack3;
            }
            case 4: {
                return this.chargeItemStack4;
            }
            case 5: {
                return this.chargeItemStack5;
            }
            case 6: {
                return this.chargeItemStack6;
            }
            case 7: {
                return this.chargeItemStack7;
            }
            case 8: {
                return this.chargeItemStack8;
            }
        }
        return this.chargeItemStack0;
    }

    private void setChargeISByNum(int num, ItemStack stack) {
        switch (num) {
            case 0: {
                this.chargeItemStack0 = stack;
                break;
            }
            case 1: {
                this.chargeItemStack1 = stack;
                break;
            }
            case 2: {
                this.chargeItemStack2 = stack;
                break;
            }
            case 3: {
                this.chargeItemStack3 = stack;
                break;
            }
            case 4: {
                this.chargeItemStack4 = stack;
                break;
            }
            case 5: {
                this.chargeItemStack5 = stack;
                break;
            }
            case 6: {
                this.chargeItemStack6 = stack;
                break;
            }
            case 7: {
                this.chargeItemStack7 = stack;
                break;
            }
            case 8: {
                this.chargeItemStack8 = stack;
                break;
            }
            default: {
                this.chargeItemStack0 = stack;
            }
        }
    }

    protected List<EntityItem> getEItemsList() {
        double range = 0.2;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)this.field_145848_d, (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + 1.0 + range), (double)((double)this.field_145848_d + 1.0 + range), (double)((double)this.field_145849_e + 1.0 + range));
        List eItemsList = this.field_145850_b.func_72872_a(EntityItem.class, searchArea);
        return eItemsList;
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                if (this.autoEject) break;
                this.autoEject = true;
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "autoEject");
                break;
            }
            case 1: {
                if (!this.autoEject) break;
                this.autoEject = false;
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "autoEject");
                break;
            }
            case 2: {
                this.callCollectors();
                break;
            }
            case 3: {
                this.eraseMemory();
                break;
            }
        }
    }

    private void callCollectors() {
        double range = 64.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)this.field_145848_d, (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + 1.0 + range), (double)((double)this.field_145848_d + 1.0 + range), (double)((double)this.field_145849_e + 1.0 + range));
        List eList = this.field_145850_b.func_72872_a(CollectorEntity.class, searchArea);
        if (!eList.isEmpty()) {
            for (CollectorEntity fbbe : eList) {
                fbbe.currentTask = CollectorEntity.Tasks.RECHARGE;
                fbbe.charger = this;
            }
        }
    }

    private void eraseMemory() {
        for (int i = 0; i < this.chargeSlot.size(); ++i) {
            ItemStack item;
            if (this.chargeSlot.get(i) == null || !((item = this.chargeSlot.get(i)).func_77973_b() instanceof CollectorItem) || item.field_77990_d == null || !item.field_77990_d.func_74764_b("hopperxyz")) continue;
            int[] clearCoord = new int[]{0, 0, 0};
            item.field_77990_d.func_74783_a("hopperxyz", clearCoord);
        }
    }
}

