/*
 * Decompiled with CFR 0.152.
 */
package ihl.crop_harvestors;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotDischarge;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.item.IUpgradeItem;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.crop_harvestors.ElectricEvaporatorContainer;
import ihl.crop_harvestors.ElectricEvaporatorGui;
import ihl.recipes.IHLRecipeManager;
import ihl.recipes.RecipeInputFluidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class ElectricEvaporatorTileEntity
extends TileEntityLiquidTankInventory
implements IEnergySink,
IHasGui,
IUpgradableBlock,
INetworkTileEntityEventListener {
    public final InvSlotOutput outputSlot;
    public final InvSlotDischarge dischargeSlot;
    public final InvSlotConsumableLiquid fluidItemsSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public final InvSlotUpgrade upgradeSlot;
    private int tier = 1;
    private int lastTier = 1;
    public int maxStorage = this.defaultMaxStorage = this.defaultEnergyConsume * this.defaultOperationLength;
    private int defaultMaxStorage;
    private double energy = 0.0;
    protected short progress;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public int energyConsume = 8;
    public int operationLength = 400;
    public int operationsPerTick;
    public AudioSource audioSource;
    private static final int EventStart = 0;
    private static final int EventInterrupt = 1;
    private static final int EventStop = 2;
    private int updateChecksum = 0;
    private boolean addedToEnergyNet = false;
    private static final IHLRecipeManager recipeManager = new IHLRecipeManager();

    public ElectricEvaporatorTileEntity() {
        super(8);
        this.defaultEnergyConsume = 8;
        this.defaultOperationLength = 400;
        this.defaultTier = 1;
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 0, 1);
        this.dischargeSlot = new InvSlotDischarge((TileEntityInventory)this, 1, this.tier, InvSlot.InvSide.BOTTOM);
        this.fluidItemsSlot = new InvSlotConsumableLiquidByTank((TileEntityInventory)this, "drainInput", 2, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain, (IFluidTank)this.fluidTank);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 3, 1);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 4, 4);
    }

    public static void init() {
        ElectricEvaporatorTileEntity.addRecipe(new FluidStack(FluidRegistry.getFluid((String)"fluidrubbertreesap"), 180), IC2Items.getItem((String)"resin"));
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("tier");
        fields.add("maxStorage");
        fields.add("operationLength");
        return fields;
    }

    public void setOverclockRates() {
        int speedUp = 0;
        int tierUp = 0;
        int capacityUp = 0;
        int checksum = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            if (this.upgradeSlot.get(i) == null) continue;
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"overclockerUpgrade").func_77960_j()) {
                speedUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"transformerUpgrade").func_77960_j()) {
                tierUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() != IC2Items.getItem((String)"energyStorageUpgrade").func_77960_j()) continue;
            capacityUp += this.upgradeSlot.get((int)i).field_77994_a;
        }
        checksum = speedUp * 4096 + tierUp * 64 + capacityUp;
        if (this.updateChecksum != checksum) {
            this.operationLength = (int)Math.max((double)this.defaultOperationLength * Math.pow(0.7, speedUp), 2.0);
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "operationLength");
            this.maxStorage = this.defaultMaxStorage + capacityUp * 10000;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "maxStorage");
            this.energyConsume = (int)Math.min((double)this.defaultEnergyConsume * Math.pow(1.6, speedUp), (double)this.maxStorage);
            this.tier = this.defaultTier + tierUp;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "tier");
            this.updateChecksum = checksum;
        }
    }

    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        if (this.outputSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.outputSlot.get()));
        }
        if (this.dischargeSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.dischargeSlot.get()));
        }
        if (this.emptyFluidItemsSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.emptyFluidItemsSlot.get()));
        }
        if (this.upgradeSlot.get(0) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(0)));
        }
        if (this.upgradeSlot.get(1) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(1)));
        }
        if (this.upgradeSlot.get(2) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(2)));
        }
        if (this.upgradeSlot.get(3) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(3)));
        }
        return new ItemStack(IHLMod.electricEvaporatorBlock, 1);
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    public int getGUIEnergy(int i) {
        if (this.energy < 3.4028234663852886E38) {
            return Math.round((float)this.energy / (float)this.maxStorage * (float)i);
        }
        return Math.round((float)(this.energy / (double)this.maxStorage) * (float)i);
    }

    public boolean enableUpdateEntity() {
        return true;
    }

    public void func_145845_h() {
        if (this.dischargeSlot.tier != this.tier) {
            this.dischargeSlot.tier = this.tier;
        }
        if (IC2.platform.isSimulating()) {
            MutableObject newActive;
            super.func_145845_h();
            boolean needsInvUpdate = false;
            this.setOverclockRates();
            if (this.getDemandedEnergy() > 1.0) {
                double amount = this.dischargeSlot.discharge(this.getDemandedEnergy(), false);
                this.energy += amount;
            }
            if (this.needsFluid() && this.fluidItemsSlot.transferToTank((IFluidTank)this.fluidTank, newActive = new MutableObject(), true) && (newActive.getValue() == null || this.emptyFluidItemsSlot.canAdd((ItemStack)newActive.getValue()))) {
                needsInvUpdate = this.fluidItemsSlot.transferToTank((IFluidTank)this.fluidTank, newActive, false);
                if (newActive.getValue() != null) {
                    this.emptyFluidItemsSlot.add((ItemStack)newActive.getValue());
                }
            }
            if (this.canOperate() && this.energy >= (double)this.energyConsume) {
                this.setActive(true);
                if (this.progress == 0) {
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
                }
                this.progress = (short)(this.progress + 1);
                this.energy -= (double)this.energyConsume;
                if (this.progress >= this.operationLength) {
                    this.operate();
                    needsInvUpdate = true;
                    this.progress = 0;
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
                }
            } else {
                if (this.progress != 0 && this.getActive()) {
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
                }
                if (!this.canOperate()) {
                    this.progress = 0;
                }
                this.setActive(false);
            }
            for (int i = 0; i < this.upgradeSlot.size(); ++i) {
                ItemStack stack = this.upgradeSlot.get(i);
                if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
                needsInvUpdate = true;
            }
        }
    }

    public void operate() {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            RecipeOutput output = this.getOutput();
            List processResult = output.items;
            for (int j = 0; j < this.upgradeSlot.size(); ++j) {
                ItemStack stack = this.upgradeSlot.get(j);
                if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
                ((IUpgradeItem)stack.func_77973_b()).onProcessEnd(stack, (IUpgradableBlock)this, processResult);
            }
            if (!this.canOperate()) break;
        }
        if (this.canOperate()) {
            this.outputSlot.add(this.getOutput().items);
        }
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public String getStartSoundFile() {
        return "Machines/Electro Furnace/ElectroFurnaceLoop.ogg";
    }

    public boolean canOperate() {
        if (this.fluidTank.getFluid() == null) {
            return false;
        }
        RecipeOutput output = recipeManager.getOutputFor(this.fluidTank.getFluid(), false);
        return output == null ? false : this.outputSlot.canAdd(output.items);
    }

    public String func_145825_b() {
        return "Solid fuel evaporator";
    }

    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ElectricEvaporatorContainer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new ElectricEvaporatorGui(new ElectricEvaporatorContainer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection arg0, Fluid fluid1) {
        return true;
    }

    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static void addRecipe(FluidStack input, ItemStack output) {
        recipeManager.addRecipe(new RecipeInputFluidStack(input), null, output);
    }

    public RecipeOutput getOutput() {
        if (this.fluidTank.getFluid() == null) {
            return null;
        }
        RecipeOutput output = recipeManager.getOutputFor(this.fluidTank.getFluid(), true);
        return output == null ? null : (this.outputSlot.canAdd(output.items) ? output : null);
    }

    public boolean needsFluid() {
        return this.getFluidTank().getFluidAmount() <= this.getFluidTank().getCapacity();
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> compatibleUpgrades = new ArrayList<ItemStack>();
        compatibleUpgrades.add(IC2Items.getItem((String)"overclockerUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"transformerUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"energyStorageUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"ejectorUpgrade"));
        return compatibleUpgrades;
    }

    public double getEnergy() {
        return this.energy;
    }

    public int getOutputSize() {
        return this.outputSlot.size();
    }

    public ItemStack getOutput(int index) {
        return this.outputSlot.get(index);
    }

    public void setOutput(int index, ItemStack stack) {
        this.outputSlot.put(index, stack);
    }

    public void setRedstonePowered(boolean isRedstonePowered1) {
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public void setEnergy(double i) {
        this.energy = i;
    }

    public int gaugeLiquidScaled(int i) {
        if (this.getFluidTank().getFluid() != null) {
            return this.getFluidTank().getFluidAmount() * i / this.getFluidTank().getCapacity();
        }
        return 0;
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }
}

