/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ihl.IHLMod;
import ihl.flexible_cable.AnchorTileEntity;
import ihl.flexible_cable.IHLCable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class IHLGrid {
    private static final double powerLossLimitPerMeter = 1.6;
    public List<AnchorTileEntity> telist = new ArrayList<AnchorTileEntity>();
    public double energy = 0.0;
    private AnchorTileEntity sink;
    private AnchorTileEntity source;
    private double voltage;
    private double lastVoltage;
    public boolean isGridValid = true;
    private double total20TicksEU;
    private int lastTickCounter = 0;
    public List<AnchorTileEntity> calculatedSinks = new ArrayList<AnchorTileEntity>();
    public List<AnchorTileEntity> calculatedSources = new ArrayList<AnchorTileEntity>();
    private Map<AnchorTileEntity, Double> energyLossSinkMap = new HashMap<AnchorTileEntity, Double>();
    private double averageEUTransfered;
    private double lastAverageEUTransfered;

    public double getDemandedEnergy() {
        if (this.energy <= 0.0) {
            return 8192.0;
        }
        return 0.0;
    }

    public void drawEnergy(double amount, AnchorTileEntity sink1) {
        this.energy = this.energyLossSinkMap.get((Object)sink1) != null ? (this.energy -= amount + this.energyLossSinkMap.get((Object)sink1) * amount * amount) : (this.energy -= amount);
        this.sink = sink1;
    }

    public void injectEnergy(double amount, double voltage1, AnchorTileEntity source1) {
        int d;
        this.energy += amount;
        this.voltage = voltage1;
        this.source = source1;
        this.total20TicksEU += amount;
        int tickCounter = MinecraftServer.func_71276_C().func_71259_af();
        if (tickCounter - this.lastTickCounter < 0) {
            this.lastTickCounter = tickCounter;
            this.total20TicksEU = 0.0;
        }
        if ((d = tickCounter - this.lastTickCounter) >= 200) {
            this.averageEUTransfered = this.total20TicksEU / (double)d;
            this.lastTickCounter = tickCounter;
            this.total20TicksEU = 0.0;
        }
        if (IHLMod.config.enableFlexibleCablesGridPowerLossCalculations && this.isGridValid && this.averageEUTransfered > 1.0) {
            this.updateGrid();
        }
    }

    private void updateGrid() {
        if (!(this.source == null || this.sink == null || this.source == this.sink || this.calculatedSources.contains((Object)this.source) && this.calculatedSinks.contains((Object)this.sink) && !(this.averageEUTransfered > this.lastAverageEUTransfered))) {
            HashMap<AnchorTileEntity, IHLCable> map = new HashMap<AnchorTileEntity, IHLCable>();
            ArrayList<AnchorTileEntity> templist = new ArrayList<AnchorTileEntity>();
            ArrayList<AnchorTileEntity> processlist = new ArrayList<AnchorTileEntity>();
            ArrayList<AnchorTileEntity> templist2 = new ArrayList<AnchorTileEntity>();
            templist.addAll(this.telist);
            processlist.add(this.sink);
            int threads = 0;
            block0: while (!templist.isEmpty()) {
                if (threads++ > 1000) {
                    this.isGridValid = false;
                    return;
                }
                templist.removeAll(processlist);
                templist2.clear();
                Iterator it1 = processlist.iterator();
                while (it1.hasNext()) {
                    if (threads++ > 1000) {
                        this.isGridValid = false;
                        return;
                    }
                    AnchorTileEntity ate1 = (AnchorTileEntity)((Object)it1.next());
                    Iterator it2 = templist.iterator();
                    while (it2.hasNext()) {
                        IHLCable cable;
                        if (threads++ > 1000) {
                            this.isGridValid = false;
                            return;
                        }
                        AnchorTileEntity ate2 = (AnchorTileEntity)((Object)it2.next());
                        if (ate1 == ate2 || (cable = this.getSame(ate1.cableList, ate2.cableList)) == null) continue;
                        map.put(ate2, cable);
                        templist2.add(ate2);
                        if (ate2 != this.source) continue;
                        break block0;
                    }
                    templist.removeAll(templist2);
                }
                processlist.clear();
                processlist.addAll(templist2);
            }
            AnchorTileEntity cursor = this.source;
            double voltage1 = this.voltage;
            double euTransfered = this.averageEUTransfered;
            double voltageLossPerMeter = 0.0;
            double powerLossPerMeter = 0.0;
            double powerLossPerSquaredEU = 0.0;
            this.energyLossSinkMap.remove((Object)this.sink);
            while (cursor != this.sink) {
                IHLCable cable = (IHLCable)map.get((Object)cursor);
                voltageLossPerMeter = (double)cable.resistivity / 1000.0 * euTransfered / voltage1;
                powerLossPerMeter = voltageLossPerMeter * euTransfered / voltage1;
                euTransfered -= powerLossPerMeter * (double)cable.length;
                voltage1 -= voltageLossPerMeter;
                powerLossPerSquaredEU += (double)cable.resistivity / 1000.0 * (double)cable.length / (voltage1 += powerLossPerMeter * (double)cable.length) / voltage1;
                if (powerLossPerMeter > 1.6 || voltage1 > (double)cable.voltageLimit) {
                    cursor.initiateCableBurnout(cable);
                }
                cursor = this.getHasCable(cable, cursor);
            }
            this.energyLossSinkMap.put(this.sink, powerLossPerSquaredEU);
            this.calculatedSources.add(this.source);
            this.calculatedSinks.add(this.sink);
            this.lastAverageEUTransfered = this.averageEUTransfered;
            this.lastVoltage = this.voltage;
        }
    }

    private IHLCable getSame(List<IHLCable> cableList, List<IHLCable> cableList2) {
        for (IHLCable cable : cableList) {
            if (!cableList2.contains(cable)) continue;
            return cable;
        }
        return null;
    }

    private AnchorTileEntity getHasCable(IHLCable cable, AnchorTileEntity exclude) {
        for (AnchorTileEntity ate1 : this.telist) {
            if (ate1 == exclude || !ate1.cableList.contains(cable)) continue;
            return ate1;
        }
        return null;
    }
}

