/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeOutput;
import java.util.HashMap;
import java.util.Map;

public class UniversalRecipeManager {
    private final Map<UniversalRecipeInput, UniversalRecipeOutput> recipes = new HashMap<UniversalRecipeInput, UniversalRecipeOutput>();

    public void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        if (input == null) {
            throw new NullPointerException("The recipe input is null");
        }
        if (output.getFluidOutputs() == null || output.getItemOutputs() == null || output.getFluidOutputs().size() == 0 && output.getItemOutputs().size() == 0) {
            throw new NullPointerException("The output is empty");
        }
        for (UniversalRecipeInput existingInput : this.recipes.keySet()) {
            if (!existingInput.matches(input)) continue;
            throw new RuntimeException("ambiguous recipe");
        }
        this.recipes.put(input, output);
    }

    public UniversalRecipeOutput getOutputFor(UniversalRecipeInput input, boolean adjustInput, boolean inputAffectOutput) {
        if (input == null) {
            return null;
        }
        for (Map.Entry<UniversalRecipeInput, UniversalRecipeOutput> entry : this.recipes.entrySet()) {
            UniversalRecipeInput recipeInput = entry.getKey();
            if (!recipeInput.matches(input)) continue;
            if (!recipeInput.adjustAmounts(input, false)) break;
            UniversalRecipeOutput output = entry.getValue();
            if (adjustInput) {
                if (inputAffectOutput) {
                    int mulipier = recipeInput.getMultiplierAndAdjustAmounts(input);
                    return output.copyWithMultiplier(mulipier);
                }
                recipeInput.adjustAmounts(input, true);
            }
            return output;
        }
        return null;
    }

    public Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return this.recipes;
    }

    public UniversalRecipeInput getRecipeInput(UniversalRecipeInput input) {
        if (input == null) {
            return null;
        }
        for (Map.Entry<UniversalRecipeInput, UniversalRecipeOutput> entry : this.recipes.entrySet()) {
            UniversalRecipeInput recipeInput = entry.getKey();
            if (!recipeInput.matches(input)) continue;
            if (!recipeInput.adjustAmounts(input, false)) break;
            return recipeInput;
        }
        return null;
    }
}

