/*
 * Decompiled with CFR 0.152.
 */
package ihl.chemistry;

import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import ihl.worldgen.ores.IHLFluid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PrecipitatorCondenserTileEntity
extends TileEntityInventory
implements IFluidHandler {
    private static float kF = 24000.0f;
    private static float gasC = 1.0f;
    private static float fluidC = 4.0f;
    private static float H = 2256.0f;
    private final IHLFluidTank gasBuffer = new IHLFluidTank(10000);
    private final IHLFluidTank condensedGasBuffer = new IHLFluidTank(10000);
    private final IHLFluidTank fluidTank = new IHLFluidTank(100);
    private ForgeDirection gasInputDirection = ForgeDirection.WEST;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.gasBuffer.readFromNBT(nbttagcompound.func_74775_l("gasBuffer"));
        this.condensedGasBuffer.readFromNBT(nbttagcompound.func_74775_l("condensedGasBuffer"));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        NBTTagCompound gasBufferTag = new NBTTagCompound();
        this.gasBuffer.writeToNBT(gasBufferTag);
        nbttagcompound.func_74782_a("gasBuffer", (NBTBase)gasBufferTag);
        NBTTagCompound condensedGasBufferTag = new NBTTagCompound();
        this.condensedGasBuffer.writeToNBT(gasBufferTag);
        nbttagcompound.func_74782_a("condensedGasBuffer", (NBTBase)condensedGasBufferTag);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("goldPrecipitatorCondenser");
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.getFacing() < 2) {
            this.setFacing((short)2);
        }
        FluidStack fluidStack = this.fluidTank.getFluid();
        FluidStack gasStack = this.gasBuffer.getFluid();
        if (fluidStack != null && gasStack != null && fluidStack.amount > 0 && gasStack.amount > 0) {
            if (fluidStack.tag == null) {
                fluidStack.tag = new NBTTagCompound();
            }
            if (gasStack.tag == null) {
                gasStack.tag = new NBTTagCompound();
            }
            if (!fluidStack.tag.func_74764_b("temperature")) {
                fluidStack.tag.func_74768_a("temperature", fluidStack.getFluid().getTemperature());
            }
            if (!gasStack.tag.func_74764_b("temperature")) {
                gasStack.tag.func_74768_a("temperature", gasStack.getFluid().getTemperature());
            }
            int t1 = fluidStack.tag.func_74762_e("temperature");
            int t2 = gasStack.tag.func_74762_e("temperature");
            int dt1 = t2 - t1;
            if (IHLFluid.getBoilingPoint(gasStack.getFluid()) - t1 > 20) {
                FluidStack condensationResult;
                float Q2;
                int t1_1;
                int dt2;
                float deltaT;
                float Q1;
                int L = gasStack.amount;
                t2 = IHLFluid.getBoilingPoint(gasStack.getFluid());
                float maxQ = H * (float)L * (float)gasStack.getFluid().getDensity();
                for (int i = 0; i < 10 && !((Q1 = kF * (deltaT = dt1 > 2 * (dt2 = t2 - (t1_1 = t1 + (int)((Q2 = H * (float)L * (float)gasStack.getFluid().getDensity()) / fluidC / (float)fluidStack.amount / (float)fluidStack.getFluid().getDensity()))) ? (float)((double)(dt1 - dt2) / Math.log((double)dt2 / (double)dt1)) : (float)(dt1 + dt2) * 0.5f)) >= maxQ); ++i) {
                    int next_L = (int)(Q1 / H / (float)gasStack.getFluid().getDensity());
                    if (Math.abs(next_L - L) < 4) {
                        L = next_L;
                        break;
                    }
                    L = next_L;
                    if (t1_1 > t1) {
                        this.fluidTank.setTag("temperature", t1_1);
                        continue;
                    }
                    this.fluidTank.setTag("temperature", t1 + 1);
                }
                int filled = this.condensedGasBuffer.fill(this.gasBuffer.drain(L, true), true);
                if (this.condensedGasBuffer.getFluid() != null && IHLFluid.getCondensationConversionRate(this.condensedGasBuffer.getFluid().getFluid()) > 0.0f && (float)this.condensedGasBuffer.getFluidAmount() > 1.0f / IHLFluid.getCondensationConversionRate(this.condensedGasBuffer.getFluid().getFluid()) + 1.0f && (condensationResult = IHLFluid.getCondensationResult(this.condensedGasBuffer.drain(this.condensedGasBuffer.getCapacity(), true))) != null) {
                    this.fillCondensateOutputApparatus(ForgeDirection.UP, condensationResult, true);
                }
            } else if (t2 - t1 > 20) {
                int t2_1 = t1 + (t2 - t1) / 2;
                float maxQ = (float)(t2 - t1) * gasC * (float)gasStack.amount * (float)gasStack.getFluid().getDensity();
                float Q2 = (float)(t2 - t2_1) * gasC * (float)gasStack.amount * (float)gasStack.getFluid().getDensity();
                int t1_1 = t1 + (int)(Q2 / fluidC / (float)fluidStack.amount / (float)fluidStack.getFluid().getDensity());
                if (t1_1 > t2_1) {
                    int tmp = t1_1;
                    t1_1 = t2_1;
                    t2_1 = tmp;
                }
                for (int i = 0; i < 10; ++i) {
                    int dt2 = t2_1 - t1_1;
                    float deltaT = dt1 > 2 * dt2 ? (float)((double)(dt1 - dt2) / Math.log((double)dt2 / (double)dt1)) : (float)(dt1 + dt2) * 0.5f;
                    float Q1 = kF * deltaT;
                    if (Q1 >= maxQ) {
                        if (t2_1 == t1 + 1 && t1_1 == t1) break;
                        t2_1 = t1 + 1;
                        t1_1 = t1;
                        continue;
                    }
                    int next_t2_1 = t2 - (int)(Q1 / gasC / (float)gasStack.amount / (float)gasStack.getFluid().getDensity());
                    int next_t1_1 = t1 + (int)(Q1 / fluidC / (float)fluidStack.amount / (float)fluidStack.getFluid().getDensity());
                    if (Math.abs(next_t2_1 - t2_1) + Math.abs(next_t1_1 - t1_1) < 4) {
                        t2_1 = next_t2_1;
                        t1_1 = next_t1_1;
                        break;
                    }
                    t2_1 = next_t2_1;
                    t1_1 = next_t1_1;
                }
            }
        }
        if (this.fluidTank.getFluid() != null) {
            FluidStack fs = this.fluidTank.drain(this.fluidTank.getCapacity(), true);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if (te != null) {
                ForgeDirection direction = ForgeDirection.UP;
                if (te instanceof IFluidHandler) {
                    ((IFluidHandler)te).fill(direction, fs, true);
                }
            }
        }
        if (this.gasBuffer.getFluid() != null) {
            if (this.condensedGasBuffer.getFluid() != null && !this.gasBuffer.getFluid().containsFluid(this.condensedGasBuffer.getFluid())) {
                this.condensedGasBuffer.setEmpty();
            }
            FluidStack skipGas = this.gasBuffer.drain(this.gasBuffer.getCapacity(), true);
            this.fillGaseousOutputApparatus(this.gasInputDirection, skipGas, true);
        }
    }

    public String func_145825_b() {
        return "precipitatorCondenser";
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public int mLZ() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mLX() {
        switch (this.getFacing()) {
            case 2: {
                return 1;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection direction, Fluid fluid) {
        return direction == ForgeDirection.UP || this.gasCanPass(direction) && fluid.isGaseous();
    }

    public int fill(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        if (this.gasCanPass(direction) && fluidStack != null && fluidStack.getFluid() != null) {
            this.gasInputDirection = direction;
            if (fluidStack.getFluid().isGaseous() && fluidStack.getFluid().getDensity() < 40) {
                return this.gasBuffer.fill(fluidStack, doFill);
            }
            return this.fillCondensateOutputApparatus(ForgeDirection.UP, fluidStack, doFill);
        }
        if (direction == ForgeDirection.UP) {
            return this.fluidTank.fill(fluidStack, doFill);
        }
        return 0;
    }

    private int fillCondensateOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.mLX(), this.field_145848_d - 1, this.field_145849_e + this.mLZ());
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(direction, fluidStack, doFill);
        }
        return 0;
    }

    private int fillHeatTransferAgentOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(direction, fluidStack, doFill);
        }
        return 0;
    }

    private int fillGaseousOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - direction.offsetX, this.field_145848_d, this.field_145849_e - direction.offsetZ);
        if (te instanceof IFluidHandler) {
            int amountFilled = ((IFluidHandler)te).fill(direction, fluidStack, doFill);
            return amountFilled;
        }
        return 0;
    }

    public boolean gasCanPass(ForgeDirection direction) {
        switch (this.getFacing()) {
            case 4: {
                return direction == ForgeDirection.WEST || direction == ForgeDirection.EAST;
            }
            case 5: {
                return direction == ForgeDirection.WEST || direction == ForgeDirection.EAST;
            }
            case 2: {
                return direction == ForgeDirection.NORTH || direction == ForgeDirection.SOUTH;
            }
            case 3: {
                return direction == ForgeDirection.NORTH || direction == ForgeDirection.SOUTH;
            }
        }
        return direction == ForgeDirection.NORTH || direction == ForgeDirection.SOUTH;
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return null;
    }

    public FluidStack drain(ForgeDirection arg0, int arg1, boolean arg2) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo(), this.gasBuffer.getInfo()};
    }
}

