/*
 * Decompiled with CFR 0.152.
 */
package ihl.crop_harvestors;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IC2Items;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableFuel;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.IHLMod;
import ihl.crop_harvestors.EvaporatorContainer;
import ihl.crop_harvestors.EvaporatorGui;
import ihl.recipes.IHLRecipeManager;
import ihl.recipes.RecipeInputFluidStack;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class EvaporatorTileEntity
extends TileEntityLiquidTankInventory
implements IHasGui {
    public final InvSlotOutput outputSlot;
    public final InvSlotConsumableFuel fuelSlot;
    public final InvSlotConsumableLiquid fluidItemsSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public short progress = 0;
    public final short maxProgress = (short)450;
    public int fuel = 0;
    public int maxFuel = 0;
    private static final IHLRecipeManager recipeManager = new IHLRecipeManager();

    public EvaporatorTileEntity() {
        super(8);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 0, 1);
        this.fuelSlot = new InvSlotConsumableFuel((TileEntityInventory)this, "fuel", 1, 1, true);
        this.fluidItemsSlot = new InvSlotConsumableLiquidByTank((TileEntityInventory)this, "drainInput", 2, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain, (IFluidTank)this.fluidTank);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 3, 1);
    }

    public static void init() {
        EvaporatorTileEntity.addRecipe(new FluidStack(FluidRegistry.getFluid((String)"fluidrubbertreesap"), 200), IC2Items.getItem((String)"resin"));
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.func_74762_e("fuel");
        }
        catch (Throwable var4) {
            this.fuel = nbttagcompound.func_74765_d("fuel");
        }
        try {
            this.maxFuel = nbttagcompound.func_74762_e("maxFuel");
        }
        catch (Throwable var3) {
            this.maxFuel = nbttagcompound.func_74765_d("maxFuel");
        }
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74768_a("maxFuel", this.maxFuel);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        if (this.outputSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.outputSlot.get()));
        }
        if (this.fuelSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.fuelSlot.get()));
        }
        if (this.emptyFluidItemsSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.emptyFluidItemsSlot.get()));
        }
        return new ItemStack(IHLMod.evaporatorBlock, 1);
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / 450;
    }

    public int gaugeFuelScaled(int i) {
        if (this.maxFuel == 0) {
            this.maxFuel = this.fuel;
            if (this.maxFuel == 0) {
                this.maxFuel = 160;
            }
        }
        return this.fuel * i / this.maxFuel;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        MutableObject newActive;
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.needsFluid() && this.fluidItemsSlot.transferToTank((IFluidTank)this.fluidTank, newActive = new MutableObject(), true) && (newActive.getValue() == null || this.outputSlot.canAdd((ItemStack)newActive.getValue()))) {
            needsInvUpdate = this.fluidItemsSlot.transferToTank((IFluidTank)this.fluidTank, newActive, false);
            if (newActive.getValue() != null) {
                this.emptyFluidItemsSlot.add((ItemStack)newActive.getValue());
            }
        }
        if (this.fuel <= 0 && this.canOperate()) {
            this.fuel = this.maxFuel = this.fuelSlot.consumeFuel();
            if (this.fuel > 0) {
                needsInvUpdate = true;
            }
        }
        if (this.isBurning() && this.canOperate()) {
            this.progress = (short)(this.progress + 1);
            if (this.progress >= 450) {
                this.progress = 0;
                this.operate();
                needsInvUpdate = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.getActive() != this.isBurning()) {
            this.setActive(this.isBurning());
            needsInvUpdate = true;
        }
    }

    public void operate() {
        this.outputSlot.add(this.getOutput().items);
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canOperate() {
        if (this.fluidTank.getFluid() == null) {
            return false;
        }
        RecipeOutput output = recipeManager.getOutputFor(this.fluidTank.getFluid(), false);
        return output == null ? false : this.outputSlot.canAdd(output.items);
    }

    public String func_145825_b() {
        return "Solid fuel evaporator";
    }

    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new EvaporatorContainer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new EvaporatorGui(new EvaporatorContainer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection arg0, Fluid fluid1) {
        return true;
    }

    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static void addRecipe(FluidStack input, ItemStack output) {
        recipeManager.addRecipe(new RecipeInputFluidStack(input), null, output);
    }

    public RecipeOutput getOutput() {
        if (this.fluidTank.getFluid() == null) {
            return null;
        }
        RecipeOutput output = recipeManager.getOutputFor(this.fluidTank.getFluid(), true);
        return output == null ? null : (this.outputSlot.canAdd(output.items) ? output : null);
    }
}

