/*
 * Decompiled with CFR 0.152.
 */
package ihl.handpump;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.Ic2Items;
import ic2.core.item.resources.ItemCell;
import ic2.core.util.LiquidUtil;
import ihl.IHLCreativeTab;
import ihl.IHLMod;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class IHLHandPump
extends Item
implements IElectricItem,
IBoxable,
IItemHudInfo {
    protected int tier = 1;
    protected int maxCharge = 30000;
    protected int operationEUCost = 600;
    protected int transferLimit = 2000;

    public IHLHandPump() {
        this.func_77656_e(27);
        this.maxCharge = IHLMod.config.handpumpMaxCharge;
        this.operationEUCost = IHLMod.config.handpumpOperationEUCost;
        this.tier = IHLMod.config.handpumpTier;
        this.func_77637_a(IHLCreativeTab.tab);
        this.field_77777_bU = 1;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        MovingObjectPosition movingobjectposition = this.returnMOPFromPlayer(entityPlayer, world);
        if (movingobjectposition != null) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            int type = 1;
            Block block = world.func_147439_a(x, y, z);
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == IHLMod.flowing_water) {
                type = 1;
            } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == IHLMod.flowing_lava) {
                type = 2;
            } else if ((block = world.func_147439_a(x, ++y, z)) == Blocks.field_150355_j || block == Blocks.field_150358_i || block == IHLMod.flowing_water) {
                type = 1;
            } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == IHLMod.flowing_lava) {
                type = 2;
            } else {
                return itemStack;
            }
            FluidStack fluid1 = null;
            int amount2 = -1;
            if (type == 1) {
                fluid1 = new FluidStack(FluidRegistry.WATER, 1000);
            } else if (type == 2) {
                fluid1 = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            ItemStack stack = this.getItemStackContains(fluid1, entityPlayer);
            if (stack != null && fluid1 != null) {
                amount2 = LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)entityPlayer, (FluidStack)fluid1, (boolean)true);
            }
            if (amount2 > 0) {
                if (ElectricItem.manager.use(itemStack, (double)this.operationEUCost, (EntityLivingBase)entityPlayer) && this.searchSourceAndDestroy(world, x, y, z, type)) {
                    ElectricItem.manager.discharge(itemStack, (double)this.operationEUCost, 1, false, false, false);
                    if (world.field_72995_K) {
                        entityPlayer.func_85030_a("ihl:handpumpOne", (float)(Math.random() * 0.2 + 0.6), (float)(Math.random() * 0.1 + 0.9));
                    } else {
                        LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)entityPlayer, (FluidStack)fluid1, (boolean)false);
                    }
                    entityPlayer.field_71069_bz.func_75142_b();
                }
                return itemStack;
            }
            if (entityPlayer.field_71071_by.func_70431_c(IC2Items.getItem((String)"cell")) && ElectricItem.manager.use(itemStack, (double)this.operationEUCost, (EntityLivingBase)entityPlayer) && this.searchSourceAndDestroy(world, x, y, z, type)) {
                ElectricItem.manager.discharge(itemStack, (double)this.operationEUCost, 1, false, false, false);
                if (world.field_72995_K) {
                    entityPlayer.func_85030_a("ihl:handpumpOne", (float)(Math.random() * 0.2 + 0.6), (float)(Math.random() * 0.1 + 0.9));
                } else if (type == 1) {
                    this.fillFluidCell(Ic2Items.waterCell.func_77946_l(), entityPlayer);
                    entityPlayer.field_71069_bz.func_75142_b();
                } else if (type == 2) {
                    this.fillFluidCell(Ic2Items.lavaCell.func_77946_l(), entityPlayer);
                    entityPlayer.field_71069_bz.func_75142_b();
                }
                return itemStack;
            }
        }
        return itemStack;
    }

    protected ItemStack getItemStackContains(FluidStack fluidStack, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) == null || !(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof IFluidContainerItem) || LiquidUtil.fillContainerStack((ItemStack)player.field_71071_by.func_70301_a(i), (EntityPlayer)player, (FluidStack)fluidStack, (boolean)true) <= 0) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("ihl:itemElectricHandpump");
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        info.add("Power Tier: " + this.tier);
        return info;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add("PowerTier: " + this.tier);
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        itemList.add(this.getItemStack(this.maxCharge));
        itemList.add(this.getItemStack(0));
    }

    public ItemStack getItemStack(int charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, (double)charge, this.maxCharge, true, false);
        return ret;
    }

    public int getDamage(ItemStack stack) {
        return MathHelper.func_76141_d((float)(((float)this.maxCharge - (float)ElectricItem.manager.getCharge(stack)) / (float)this.maxCharge * (float)this.func_77612_l())) + 1;
    }

    protected void fillFluidCell(ItemStack cell, EntityPlayer player) {
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        for (int i = 0; i <= 35; ++i) {
            if (inv[i] == null || !(inv[i].func_77973_b() instanceof ItemCell) || inv[i].func_77960_j() != 0 || !player.field_71071_by.func_70441_a(cell)) continue;
            if (inv[i].field_77994_a <= 1) {
                ItemStack sourceItemStack = inv[i].func_77946_l();
                sourceItemStack.field_77994_a = player.field_71071_by.func_146027_a(sourceItemStack.func_77973_b(), 0) - 1;
                if (sourceItemStack.field_77994_a > 0) {
                    player.field_71071_by.func_70441_a(sourceItemStack);
                }
            } else {
                --inv[i].field_77994_a;
            }
            return;
        }
    }

    private boolean searchSourceAndDestroy(World world, int startx, int starty, int startz, int type) {
        int currentFlowDecay = this.getFlowDecay(world, startx, starty, startz);
        for (int i = 0; i < 256; ++i) {
            if (this.getFlowDecay(world, startx, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx + 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, ++startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx - 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, --startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty + 1, startz + 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty + 1, startz - 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, --startz);
                continue;
            }
            if (this.getFlowDecay(world, startx - 1, starty, startz) < currentFlowDecay && this.getFlowDecay(world, startx - 1, starty, startz) != -1) {
                currentFlowDecay = this.getFlowDecay(world, --startx, starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty, startz + 1) < currentFlowDecay && this.getFlowDecay(world, startx, starty, startz + 1) != -1) {
                currentFlowDecay = this.getFlowDecay(world, startx, starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty, startz - 1) < currentFlowDecay && this.getFlowDecay(world, startx, starty, startz - 1) != -1) {
                currentFlowDecay = this.getFlowDecay(world, startx, starty, --startz);
                continue;
            }
            if (this.getFlowDecay(world, startx + 1, starty, startz) >= currentFlowDecay || this.getFlowDecay(world, startx + 1, starty, startz) == -1) break;
            currentFlowDecay = this.getFlowDecay(world, ++startx, starty, startz);
        }
        if (currentFlowDecay == 0) {
            if (!world.field_72995_K) {
                return this.replaceBlock(world, startx, starty, startz, type);
            }
            return true;
        }
        if (!world.field_72995_K && currentFlowDecay < 7) {
            world.func_72921_c(startx, starty, startz, currentFlowDecay + 1, 3);
            return false;
        }
        return false;
    }

    protected boolean replaceBlock(World world, int x, int y, int z, int type) {
        if (type == 1 && IHLMod.cccFiniteWater) {
            if (world.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 1, 3)) {
                world.func_147464_a(x, y, z, (Block)Blocks.field_150358_i, 2);
                return true;
            }
            return false;
        }
        if (type == 1) {
            if (world.func_147465_d(x, y, z, IHLMod.flowing_water, 1, 3)) {
                world.func_147464_a(x, y, z, IHLMod.flowing_water, 2);
                return true;
            }
            return false;
        }
        if (type == 2 && world.field_73011_w.field_76575_d && !IHLMod.cccFiniteWater) {
            if (world.func_147465_d(x, y, z, IHLMod.flowing_lava, 1, 3)) {
                world.func_147464_a(x, y, z, IHLMod.flowing_lava, 2);
                return true;
            }
            return false;
        }
        if (type == 2) {
            if (world.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 1, 3)) {
                world.func_147464_a(x, y, z, (Block)Blocks.field_150356_k, 2);
                return true;
            }
            return false;
        }
        return false;
    }

    protected int getFlowDecay(World par1World, int par2, int par3, int par4) {
        return par1World.func_147439_a(par2, par3, par4).func_149688_o().func_76224_d() ? par1World.func_72805_g(par2, par3, par4) : -1;
    }

    protected MovingObjectPosition returnMOPFromPlayer(EntityPlayer entityplayer, World world) {
        float f9;
        float f6;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = entityplayer.field_70127_C + (entityplayer.field_70125_A - entityplayer.field_70127_C) * f;
        float f2 = entityplayer.field_70126_B + (entityplayer.field_70177_z - entityplayer.field_70126_B) * f;
        double d = entityplayer.field_70169_q + (entityplayer.field_70165_t - entityplayer.field_70169_q) * (double)f;
        double d1 = entityplayer.field_70167_r + (entityplayer.field_70163_u - entityplayer.field_70167_r) * (double)f + (double)entityplayer.func_70047_e();
        if (world.field_72995_K) {
            d1 -= (double)entityplayer.getDefaultEyeHeight();
        }
        double d2 = entityplayer.field_70166_s + (entityplayer.field_70161_v - entityplayer.field_70166_s) * (double)f;
        Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * 0.01745329f - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f)));
        Vec3 vec3d1 = vec3d.func_72441_c((double)f7 * (d3 = 5.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f))) * d3, (double)(f9 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.func_72901_a(vec3d, vec3d1, true);
        if (movingobjectposition == null) {
            return null;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return movingobjectposition;
        }
        return null;
    }
}

