/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.core.block.invslot.InvSlot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class UniversalRecipeInput {
    private final List<FluidStack> fluidInputs = new ArrayList<FluidStack>();
    private final List<ItemStack> itemInputs = new ArrayList<ItemStack>();

    public UniversalRecipeInput(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1) {
        if (fluidInputs1 != null) {
            this.fluidInputs.addAll(fluidInputs1);
        }
        if (itemInputs1 != null) {
            this.itemInputs.addAll(itemInputs1);
        }
    }

    public UniversalRecipeInput(FluidTank tank1, InvSlot inputSlot1) {
        ArrayList fluidlist = new ArrayList();
        Object inputFluid = null;
        if (tank1 != null && tank1.getFluid() != null) {
            this.fluidInputs.add(tank1.getFluid());
        }
        for (int i = 0; i < inputSlot1.size(); ++i) {
            this.itemInputs.add(inputSlot1.get(i));
        }
    }

    public UniversalRecipeInput(ItemStack[] itemStacks) {
        for (int i = 0; i < itemStacks.length; ++i) {
            this.itemInputs.add(itemStacks[i]);
        }
    }

    public UniversalRecipeInput(FluidStack fs1) {
        this.fluidInputs.add(fs1);
    }

    public UniversalRecipeInput(FluidStack fluid, ItemStack[] itemStacks) {
        this.fluidInputs.add(fluid);
        for (int i = 0; i < itemStacks.length; ++i) {
            this.itemInputs.add(itemStacks[i]);
        }
    }

    public UniversalRecipeInput(FluidStack[] fluidStacks) {
        for (int i = 0; i < fluidStacks.length; ++i) {
            this.fluidInputs.add(fluidStacks[i]);
        }
    }

    public UniversalRecipeInput(ItemStack itemStack) {
        this.itemInputs.add(itemStack);
    }

    public boolean matches(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1) {
        if (this.fluidInputs.size() != fluidInputs1.size() || this.itemInputs.size() != this.itemInputs.size()) {
            return false;
        }
        Iterator<FluidStack> fi1 = fluidInputs1.iterator();
        Iterator<ItemStack> ii1 = itemInputs1.iterator();
        Iterator<FluidStack> fi = this.fluidInputs.iterator();
        Iterator<ItemStack> ii = this.itemInputs.iterator();
        while (fi.hasNext()) {
            FluidStack fs = fi.next();
            FluidStack fs1 = fi1.next();
            if (fs1 != null && fs.getFluid() == fs1.getFluid()) continue;
            return false;
        }
        while (ii.hasNext()) {
            ItemStack is = ii.next();
            ItemStack is1 = ii1.next();
            if (is == null) {
                return true;
            }
            if (is != null && is1 == null || is.func_77973_b() != is1.func_77973_b()) {
                return false;
            }
            if (is.func_77960_j() == Short.MAX_VALUE || is.func_77960_j() == is1.func_77960_j()) continue;
            return false;
        }
        return true;
    }

    public List<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    public List<ItemStack> getItemInputs() {
        return this.itemInputs;
    }

    public boolean matches(UniversalRecipeInput input) {
        return this.matches(input.getFluidInputs(), input.getItemInputs());
    }

    public boolean adjustAmounts(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1, boolean doAdjustAmounts) {
        if (this.fluidInputs.size() != fluidInputs1.size() || this.itemInputs.size() != itemInputs1.size()) {
            return false;
        }
        Iterator<FluidStack> fi1 = fluidInputs1.iterator();
        Iterator<ItemStack> ii1 = itemInputs1.iterator();
        Iterator<FluidStack> fi = this.fluidInputs.iterator();
        Iterator<ItemStack> ii = this.itemInputs.iterator();
        while (fi.hasNext()) {
            FluidStack fs = fi.next();
            FluidStack fs1 = fi1.next();
            if (fs.getFluid() != fs1.getFluid() || fs1.amount < fs.amount) {
                return false;
            }
            if (!doAdjustAmounts) continue;
            fs1.amount -= fs.amount;
            if (fs1.amount > 0) continue;
            fs1 = null;
        }
        while (ii.hasNext()) {
            ItemStack is = ii.next();
            ItemStack is1 = ii1.next();
            if (is == null) continue;
            if (is1 == null || is.func_77973_b() != is1.func_77973_b()) {
                return false;
            }
            if (is.func_77960_j() != Short.MAX_VALUE && is.func_77960_j() != is1.func_77960_j() || is1.field_77994_a < is.field_77994_a) {
                return false;
            }
            if (!doAdjustAmounts) continue;
            is1.field_77994_a -= is.field_77994_a;
            if (is1.field_77994_a > 0) continue;
            is1 = null;
        }
        return true;
    }

    public boolean adjustAmounts(UniversalRecipeInput input, boolean doAdjustAmounts) {
        return this.adjustAmounts(input.getFluidInputs(), input.getItemInputs(), doAdjustAmounts);
    }

    public boolean containItem(Item item) {
        if (this.itemInputs == null || this.itemInputs.isEmpty()) {
            return false;
        }
        for (ItemStack is : this.itemInputs) {
            if (is == null || is.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public ItemStack getItemStack(Item item) {
        if (this.itemInputs == null || this.itemInputs.isEmpty()) {
            return null;
        }
        for (ItemStack is : this.itemInputs) {
            if (is.func_77973_b() != item) continue;
            return is;
        }
        return null;
    }

    public int getMultiplierAndAdjustAmounts(UniversalRecipeInput input) {
        int multiplier1;
        List<FluidStack> fluidInputs1 = input.fluidInputs;
        List<ItemStack> itemInputs1 = input.itemInputs;
        int multiplier = Integer.MAX_VALUE;
        if (this.fluidInputs.size() != fluidInputs1.size() || this.itemInputs.size() != itemInputs1.size()) {
            return 0;
        }
        Iterator<FluidStack> fi1 = fluidInputs1.iterator();
        Iterator<ItemStack> ii1 = itemInputs1.iterator();
        Iterator<FluidStack> fi = this.fluidInputs.iterator();
        Iterator<ItemStack> ii = this.itemInputs.iterator();
        while (fi.hasNext()) {
            FluidStack fs = fi.next();
            FluidStack fs1 = fi1.next();
            if (fs.getFluid() != fs1.getFluid() || fs1.amount < fs.amount) {
                return 0;
            }
            if (fs.amount <= 0) continue;
            multiplier1 = Math.floorDiv(fs1.amount, fs.amount);
            if (multiplier1 < multiplier) {
                multiplier = multiplier1;
            }
            fs1.amount -= fs.amount * multiplier;
            if (fs1.amount > 0) continue;
            fs1 = null;
        }
        while (ii.hasNext()) {
            ItemStack is = ii.next();
            ItemStack is1 = ii1.next();
            if (is == null) continue;
            if (is1 == null || is.func_77973_b() != is1.func_77973_b()) {
                return 0;
            }
            if (is.func_77960_j() != Short.MAX_VALUE && is.func_77960_j() != is1.func_77960_j()) {
                return 0;
            }
            if (is1.field_77994_a < is.field_77994_a) {
                return 0;
            }
            if (is.field_77994_a <= 0) continue;
            multiplier1 = Math.floorDiv(is1.field_77994_a, is.field_77994_a);
            if (multiplier1 < multiplier) {
                multiplier = multiplier1;
            }
            is1.field_77994_a -= is.field_77994_a * multiplier;
            if (is1.field_77994_a > 0) continue;
            is1 = null;
        }
        if (multiplier < Integer.MAX_VALUE) {
            return multiplier;
        }
        return 1;
    }
}

