/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.api.recipe.RecipeOutput;
import ihl.recipes.IFluidRecipeInput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class IHLRecipeManager {
    private final Map<IFluidRecipeInput, RecipeOutput> recipes = new HashMap<IFluidRecipeInput, RecipeOutput>();

    public void addRecipe(IFluidRecipeInput input, NBTTagCompound metadata, ItemStack ... outputs) {
        if (input == null) {
            throw new NullPointerException("The recipe input is null");
        }
        for (int i$ = 0; i$ < outputs.length; ++i$) {
            if (outputs[i$] == null) {
                throw new NullPointerException("The output ItemStack #" + i$ + " is null (counting from 0)");
            }
            outputs[i$] = outputs[i$].func_77946_l();
        }
        for (IFluidRecipeInput existingInput : this.recipes.keySet()) {
            for (FluidStack is : input.getInputs()) {
                if (!existingInput.matches(is)) continue;
                throw new RuntimeException("ambiguous recipe: [" + is + " -> " + Arrays.asList(outputs) + "]" + ", conflicts with [" + existingInput.getInputs() + " -> " + this.recipes.get((Object)existingInput).items + "]");
            }
        }
        this.recipes.put(input, new RecipeOutput(metadata, outputs));
    }

    public RecipeOutput getOutputFor(FluidStack input, boolean adjustInput) {
        if (input == null) {
            return null;
        }
        for (Map.Entry<IFluidRecipeInput, RecipeOutput> entry : this.recipes.entrySet()) {
            IFluidRecipeInput recipeInput = entry.getKey();
            if (!recipeInput.matches(input)) continue;
            if (input.amount < recipeInput.getAmount()) break;
            if (adjustInput) {
                input.amount -= recipeInput.getAmount();
            }
            return entry.getValue();
        }
        return null;
    }

    public Map<IFluidRecipeInput, RecipeOutput> getRecipes() {
        return this.recipes;
    }
}

