/*
 * Decompiled with CFR 0.152.
 */
package ihl.chemistry;

import ic2.api.network.INetworkDataProvider;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class GoldChimneyKneeTileEntity
extends TileEntity
implements IWrenchable,
INetworkDataProvider,
IFluidHandler {
    private short facing = (short)2;
    private short lastFacing = (short)2;
    private final IHLFluidTank gasBuffer = new IHLFluidTank(10000);
    private final IHLFluidTank fluidTank = new IHLFluidTank(10000);
    private static UniversalRecipeManager recipeManager = new UniversalRecipeManager();

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.facing != side;
    }

    public short getFacing() {
        return this.facing;
    }

    public List<String> getNetworkedFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("facing");
        return fields;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (IC2.platform.isSimulating()) {
            if (this.facing != this.lastFacing) {
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
                this.lastFacing = this.facing;
            }
            if (this.fluidTank.getFluid() != null && this.gasBuffer.getFluid() != null && this.getOutput() != null) {
                List<FluidStack> output = recipeManager.getOutputFor(this.getInput(), true, true).getFluidOutputs();
                if (output.size() > 0) {
                    this.fillOutputApparatus(this.getConnectDirection(), output.get(0), true);
                }
            }
            if (this.fluidTank.getFluid() != null && this.fillOutputApparatus(this.getConnectDirection(), this.fluidTank.drain(this.fluidTank.getCapacity(), false), false) > 0) {
                this.fillOutputApparatus(this.getConnectDirection(), this.fluidTank.drain(this.fluidTank.getCapacity(), true), true);
            }
            if (this.gasBuffer.getFluid() != null && this.fillOutputApparatus(this.getConnectDirection(), this.gasBuffer.drain(this.gasBuffer.getCapacity(), false), false) > 0) {
                this.fillOutputApparatus(this.getConnectDirection(), this.gasBuffer.drain(this.gasBuffer.getCapacity(), true), true);
            }
        }
    }

    private int fillOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.mX(), this.field_145848_d, this.field_145849_e + this.mZ());
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(direction, fluidStack, doFill);
        }
        return 0;
    }

    public void setFacing(short facing1) {
        this.facing = (short)Math.max(2, facing1);
        if (IC2.platform.isSimulating()) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("goldChimneyKnee");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("facing", this.facing);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        NBTTagCompound gasBufferTag = new NBTTagCompound();
        this.gasBuffer.writeToNBT(gasBufferTag);
        nbttagcompound.func_74782_a("gasBuffer", (NBTBase)gasBufferTag);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.facing = nbttagcompound.func_74765_d("facing");
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.gasBuffer.readFromNBT(nbttagcompound.func_74775_l("gasBuffer"));
    }

    protected int mX() {
        switch (this.getFacing()) {
            case 4: {
                return 1;
            }
            case 5: {
                return -1;
            }
        }
        return 0;
    }

    protected int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return 1;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    public TileEntity getConnectedTileEntity() {
        return this.field_145850_b.func_147438_o(this.field_145851_c + this.mX(), this.field_145848_d, this.field_145849_e + this.mZ());
    }

    public ForgeDirection getConnectDirection() {
        switch (this.getFacing()) {
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 5: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.NORTH;
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection direction, Fluid fluid) {
        return fluid.isGaseous() && (direction == ForgeDirection.DOWN || direction == this.getConnectDirection());
    }

    public int fill(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        if (direction == this.getConnectDirection() && fluidStack != null && fluidStack.getFluid() != null) {
            if (fluidStack.getFluid().isGaseous() && fluidStack.getFluid().getDensity() < 40) {
                return this.gasBuffer.fill(fluidStack, doFill);
            }
            return 0;
        }
        if (direction == ForgeDirection.DOWN) {
            if (fluidStack.getFluid().isGaseous() && fluidStack.getFluid().getDensity() < 40) {
                return this.fluidTank.fill(fluidStack, doFill);
            }
            return 0;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return null;
    }

    public FluidStack drain(ForgeDirection arg0, int arg1, boolean arg2) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo(), this.gasBuffer.getInfo()};
    }

    public static void addRecipe(UniversalRecipeInput input, FluidStack fluidStackWithSize) {
        recipeManager.addRecipe(input, new UniversalRecipeOutput(fluidStackWithSize));
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public UniversalRecipeInput getInput() {
        return new UniversalRecipeInput(new FluidStack[]{this.gasBuffer.getFluid(), this.fluidTank.getFluid()});
    }
}

