/*
 * Decompiled with CFR 0.152.
 */
package ihl.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankInventory;
import ic2.core.block.invslot.InvSlotConsumableFuel;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.chemistry.LeadOvenContainer;
import ihl.chemistry.LeadOvenGui;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class LeadOvenTileEntity
extends TileEntityLiquidTankInventory
implements IHasGui {
    public final InvSlotConsumableFuel fuelSlot;
    private ItemStack currentFuel;
    public final InvSlotConsumableItemStack inputSlot;
    public final InvSlotOutput outputSlot;
    public short progress = 0;
    public final short maxProgress = (short)160;
    public int fuel = 0;
    public int maxFuel = 0;
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();

    public LeadOvenTileEntity() {
        super(1000);
        this.fuelSlot = new InvSlotConsumableFuel((TileEntityInventory)this, "fuel", 1, 1, true);
        ArrayList saltPeterDusts = OreDictionary.getOres((String)"dustSaltpeter");
        ItemStack[] cis = new ItemStack[saltPeterDusts.size()];
        for (int i = 0; i < cis.length; ++i) {
            cis[i] = (ItemStack)saltPeterDusts.get(i);
        }
        this.inputSlot = new InvSlotConsumableItemStack((TileEntityInventory)this, "input", 2, 1, cis);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 0, 1);
    }

    public static void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        recipeManager.addRecipe(input, output);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.func_74762_e("fuel");
        }
        catch (Throwable var4) {
            this.fuel = nbttagcompound.func_74765_d("fuel");
        }
        try {
            this.maxFuel = nbttagcompound.func_74762_e("maxFuel");
        }
        catch (Throwable var3) {
            this.maxFuel = nbttagcompound.func_74765_d("maxFuel");
        }
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74768_a("maxFuel", this.maxFuel);
        nbttagcompound.func_74777_a("progress", this.progress);
        NBTTagCompound gasBufferTag = new NBTTagCompound();
        nbttagcompound.func_74782_a("gasBuffer", (NBTBase)gasBufferTag);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("leadOven");
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / 160;
    }

    public int gaugeFuelScaled(int i) {
        if (this.maxFuel == 0) {
            this.maxFuel = this.fuel;
            if (this.maxFuel == 0) {
                this.maxFuel = 160;
            }
        }
        return this.fuel * i / this.maxFuel;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.getFluidTank().getFluid() != null) {
            FluidStack fs = this.maxFuel > 0 && this.getOutput() != null && this.getOutput().getFluidOutputs() != null && this.getOutput().getFluidOutputs().size() > 0 ? this.getFluidTank().drain(this.getOutput().getFluidOutputs().get((int)0).amount / this.maxFuel, true) : this.getFluidTank().drain(1000, true);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (te != null) {
                ForgeDirection direction = ForgeDirection.DOWN;
                if (te instanceof IFluidHandler) {
                    ((IFluidHandler)te).fill(direction, fs, true);
                }
            }
        }
        this.currentFuel = this.fuelSlot.get() != null ? this.fuelSlot.get().func_77946_l() : null;
        boolean needsInvUpdate = false;
        if (this.fuel <= 0 && this.canOperate()) {
            this.fuel = this.maxFuel = this.fuelSlot.consumeFuel();
            if (this.fuel > 0) {
                needsInvUpdate = true;
            }
        }
        if (this.isBurning() && this.canOperate()) {
            this.progress = (short)(this.progress + 1);
            if (this.progress >= 160) {
                this.progress = 0;
                this.operate();
                needsInvUpdate = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.getActive() != this.isBurning()) {
            this.setActive(this.isBurning());
            needsInvUpdate = true;
        }
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canOperate() {
        return this.getOutput() != null;
    }

    public String func_145825_b() {
        return "goldOven";
    }

    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new LeadOvenContainer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new LeadOvenGui(new LeadOvenContainer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public UniversalRecipeInput getInput() {
        return new UniversalRecipeInput(new ItemStack[]{this.currentFuel, this.inputSlot.get()});
    }

    public void operate() {
        for (int i = 0; i < this.inputSlot.size(); ++i) {
            if (this.inputSlot.get(i) == null || this.inputSlot.get((int)i).field_77994_a > 0) continue;
            this.inputSlot.put(i, null);
        }
        List<FluidStack> output2 = recipeManager.getOutputFor(this.getInput(), true, false).getFluidOutputs();
        if (output2.get(0) != null) {
            this.getFluidTank().fill(output2.get(0), true);
        }
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public static void addRecipe(UniversalRecipeInput input, FluidStack fluidStackWithSize) {
        recipeManager.addRecipe(input, new UniversalRecipeOutput(fluidStackWithSize));
    }
}

