/*
 * Decompiled with CFR 0.152.
 */
package ihl.collector;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ihl.IHLCreativeTab;
import ihl.collector.CollectorEntity;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class CollectorItem
extends Item
implements IElectricItem,
IItemHudInfo {
    protected int tier = 1;
    protected int maxCharge = 20000;
    protected int minCharge = 100;
    private int transferLimit = 100;

    public CollectorItem() {
        this.func_77656_e(27);
        this.func_77664_n();
        this.func_77637_a(IHLCreativeTab.tab);
        this.field_77777_bU = 1;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        int z;
        int y;
        int x;
        MovingObjectPosition mop;
        if (ElectricItem.manager.use(itemStack, (double)this.minCharge, (EntityLivingBase)entityPlayer) && !world.field_72995_K && (mop = this.returnMOPFromPlayer(entityPlayer, world)) != null && this.spawnEntityInWorld(world, itemStack, x = mop.field_72311_b, y = mop.field_72312_c, z = mop.field_72309_d)) {
            --itemStack.field_77994_a;
        }
        return itemStack;
    }

    public boolean spawnEntityInWorld(World world, ItemStack itemStack, int x, int y, int z) {
        CollectorEntity se = new CollectorEntity(world, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
        se.setEnergy(ElectricItem.manager.getCharge(itemStack), this.getMaxCharge(itemStack));
        if (itemStack.field_77990_d != null) {
            se.hopperx = itemStack.field_77990_d.func_74762_e("hopperx");
            se.hoppery = itemStack.field_77990_d.func_74762_e("hoppery");
            se.hopperz = itemStack.field_77990_d.func_74762_e("hopperz");
        } else {
            se.hopperx = x;
            se.hoppery = y;
            se.hopperz = z;
        }
        return world.func_72838_d((Entity)se);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("ihl:itemElectricHandpump");
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public MovingObjectPosition returnMOPFromPlayer(EntityPlayer entityplayer, World world) {
        float f9;
        float f6;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = entityplayer.field_70127_C + (entityplayer.field_70125_A - entityplayer.field_70127_C) * f;
        float f2 = entityplayer.field_70126_B + (entityplayer.field_70177_z - entityplayer.field_70126_B) * f;
        double d = entityplayer.field_70169_q + (entityplayer.field_70165_t - entityplayer.field_70169_q) * (double)f;
        double d1 = entityplayer.field_70167_r + (entityplayer.field_70163_u - entityplayer.field_70167_r) * (double)f + (double)entityplayer.func_70047_e();
        if (world.field_72995_K) {
            d1 -= (double)entityplayer.getDefaultEyeHeight();
        }
        double d2 = entityplayer.field_70166_s + (entityplayer.field_70161_v - entityplayer.field_70166_s) * (double)f;
        Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * 0.01745329f - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f)));
        Vec3 vec3d1 = vec3d.func_72441_c((double)f7 * (d3 = 5.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f))) * d3, (double)(f9 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.func_72901_a(vec3d, vec3d1, true);
        if (movingobjectposition == null) {
            return null;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return movingobjectposition;
        }
        return null;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        info.add("Power Tier: " + this.tier);
        return info;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add("PowerTier: " + this.tier);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        itemList.add(this.getItemStack(this.maxCharge));
        itemList.add(this.getItemStack(0));
    }

    public ItemStack getItemStack(int charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, (double)charge, this.maxCharge, true, false);
        return ret;
    }

    public int getDamage(ItemStack stack) {
        return MathHelper.func_76141_d((float)(((float)this.maxCharge - (float)ElectricItem.manager.getCharge(stack)) / (float)this.maxCharge * (float)this.func_77612_l())) + 1;
    }
}

