/*
 * Decompiled with CFR 0.152.
 */
package ihl.handpump;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.core.Ic2Items;
import ic2.core.util.LiquidUtil;
import ihl.IHLMod;
import ihl.handpump.IHLHandPump;
import ihl.i_hate_liquids.XYZ;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class AdvancedHandPump
extends IHLHandPump {
    public AdvancedHandPump() {
        this.maxCharge = IHLMod.config.advancedHandpumpMaxCharge;
        this.operationEUCost = IHLMod.config.advancedHandpumpOperationEUCost;
        this.tier = IHLMod.config.advancedHandpumpTier;
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        MovingObjectPosition movingobjectposition = this.returnMOPFromPlayer(entityPlayer, world);
        if (movingobjectposition != null) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            int type = 1;
            Block block = world.func_147439_a(x, y, z);
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == IHLMod.flowing_water) {
                type = 1;
            } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == IHLMod.flowing_lava) {
                type = 2;
            } else if ((block = world.func_147439_a(x, ++y, z)) == Blocks.field_150355_j || block == Blocks.field_150358_i || block == IHLMod.flowing_water) {
                type = 1;
            } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == IHLMod.flowing_lava) {
                type = 2;
            } else {
                return itemStack;
            }
            FluidStack fluid1 = null;
            int amount2 = -1;
            if (type == 1) {
                fluid1 = new FluidStack(FluidRegistry.WATER, 1000);
            } else if (type == 2) {
                fluid1 = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            ItemStack stack = this.getItemStackContains(fluid1, entityPlayer);
            if (stack != null && fluid1 != null) {
                amount2 = LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)entityPlayer, (FluidStack)fluid1, (boolean)true);
            }
            if (amount2 > 0) {
                if (ElectricItem.manager.use(itemStack, (double)this.operationEUCost, (EntityLivingBase)entityPlayer)) {
                    fluid1.amount = Integer.MAX_VALUE;
                    int countFreeAmount = this.countAmountOfEmptyFluidCells(Ic2Items.FluidCell, fluid1, entityPlayer);
                    int countDestroedSources = this.searchSourceDestroyCount(world, x, y, z, type, countFreeAmount / 1000);
                    ElectricItem.manager.discharge(itemStack, (double)this.operationEUCost, 1, false, false, false);
                    if (world.field_72995_K) {
                        entityPlayer.func_85030_a("ihl:handpumpOne", (float)(Math.random() * 0.2 + 0.6), (float)(Math.random() * 0.1 + 0.9));
                    } else {
                        this.fillUniversalFluidCells(fluid1, entityPlayer, countDestroedSources);
                    }
                    entityPlayer.field_71069_bz.func_75142_b();
                }
                return itemStack;
            }
            if (entityPlayer.field_71071_by.func_70431_c(IC2Items.getItem((String)"cell")) && ElectricItem.manager.use(itemStack, (double)this.operationEUCost, (EntityLivingBase)entityPlayer)) {
                int countCells = this.countEmptyCells(IC2Items.getItem((String)"cell"), entityPlayer);
                int countDestroedSources = this.searchSourceDestroyCount(world, x, y, z, type, countCells);
                ElectricItem.manager.discharge(itemStack, (double)this.operationEUCost, 1, false, false, false);
                if (world.field_72995_K) {
                    entityPlayer.func_85030_a("ihl:handpumpOne", (float)(Math.random() * 0.2 + 0.6), (float)(Math.random() * 0.1 + 0.9));
                } else if (type == 1) {
                    this.fillFluidCells(Ic2Items.waterCell.func_77946_l(), entityPlayer, countDestroedSources);
                    entityPlayer.field_71069_bz.func_75142_b();
                } else if (type == 2) {
                    this.fillFluidCells(Ic2Items.lavaCell.func_77946_l(), entityPlayer, countDestroedSources);
                    entityPlayer.field_71069_bz.func_75142_b();
                }
                return itemStack;
            }
        }
        return itemStack;
    }

    private void fillUniversalFluidCells(FluidStack fluid1, EntityPlayer entityPlayer, int countDestroedSources) {
        fluid1.amount = countDestroedSources * 1000;
        for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
            if (entityPlayer.field_71071_by.func_70301_a(i) == null || !(entityPlayer.field_71071_by.func_70301_a(i).func_77973_b() instanceof IFluidContainerItem)) continue;
            int amount2 = LiquidUtil.fillContainerStack((ItemStack)entityPlayer.field_71071_by.func_70301_a(i), (EntityPlayer)entityPlayer, (FluidStack)fluid1, (boolean)false);
            fluid1.amount -= amount2;
            while (fluid1.amount >= 1000 && entityPlayer.field_71071_by.func_70301_a((int)i).field_77994_a >= 1 && amount2 > 0) {
                amount2 = LiquidUtil.fillContainerStack((ItemStack)entityPlayer.field_71071_by.func_70301_a(i), (EntityPlayer)entityPlayer, (FluidStack)fluid1, (boolean)false);
                fluid1.amount -= amount2;
            }
            if (fluid1.amount < 1000) break;
        }
    }

    private void fillFluidCells(ItemStack copy, EntityPlayer entityPlayer, int countDestroedSources) {
        ItemStack emptyCells = IC2Items.getItem((String)"cell").func_77946_l();
        emptyCells.field_77994_a = entityPlayer.field_71071_by.func_146027_a(IC2Items.getItem((String)"cell").func_77973_b(), 0) - countDestroedSources;
        copy.field_77994_a = countDestroedSources;
        entityPlayer.field_71071_by.func_70441_a(copy);
        if (emptyCells.field_77994_a > 0) {
            entityPlayer.field_71071_by.func_70441_a(emptyCells);
        }
    }

    private int searchSourceDestroyCount(World world, int startx, int starty, int startz, int type, int countCells) {
        int currentFlowDecay = this.getFlowDecay(world, startx, starty, startz);
        for (int i = 0; i < 256; ++i) {
            if (this.getFlowDecay(world, startx, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx + 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, ++startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx - 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, --startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty + 1, startz + 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty + 1, startz - 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, --startz);
                continue;
            }
            if (this.getFlowDecay(world, startx - 1, starty, startz) < currentFlowDecay && this.getFlowDecay(world, startx - 1, starty, startz) != -1) {
                currentFlowDecay = this.getFlowDecay(world, --startx, starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty, startz + 1) < currentFlowDecay && this.getFlowDecay(world, startx, starty, startz + 1) != -1) {
                currentFlowDecay = this.getFlowDecay(world, startx, starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty, startz - 1) < currentFlowDecay && this.getFlowDecay(world, startx, starty, startz - 1) != -1) {
                currentFlowDecay = this.getFlowDecay(world, startx, starty, --startz);
                continue;
            }
            if (this.getFlowDecay(world, startx + 1, starty, startz) >= currentFlowDecay || this.getFlowDecay(world, startx + 1, starty, startz) == -1) break;
            currentFlowDecay = this.getFlowDecay(world, ++startx, starty, startz);
        }
        ArrayList<XYZ> xyzlist = new ArrayList<XYZ>();
        if (currentFlowDecay == 0) {
            xyzlist.add(new XYZ(startx, starty, startz));
            this.replaceBlock(world, startx, starty, startz, type);
            int listPos = 0;
            for (int i = 0; i <= countCells; ++i) {
                if (this.getFlowDecay(world, startx - 1, starty, startz) == 0 && !xyzlist.contains(new XYZ(startx - 1, starty, startz))) {
                    xyzlist.add(new XYZ(--startx, starty, startz));
                    listPos = xyzlist.size() - 1;
                    this.replaceBlock(world, startx, starty, startz, type);
                    continue;
                }
                if (this.getFlowDecay(world, startx, starty, startz + 1) == 0 && !xyzlist.contains(new XYZ(startx, starty, startz + 1))) {
                    xyzlist.add(new XYZ(startx, starty, ++startz));
                    listPos = xyzlist.size() - 1;
                    this.replaceBlock(world, startx, starty, startz, type);
                    continue;
                }
                if (this.getFlowDecay(world, startx, starty, startz - 1) == 0 && !xyzlist.contains(new XYZ(startx, starty, startz - 1))) {
                    xyzlist.add(new XYZ(startx, starty, --startz));
                    listPos = xyzlist.size() - 1;
                    this.replaceBlock(world, startx, starty, startz, type);
                    continue;
                }
                if (this.getFlowDecay(world, startx + 1, starty, startz) == 0 && !xyzlist.contains(new XYZ(startx + 1, starty, startz))) {
                    xyzlist.add(new XYZ(++startx, starty, startz));
                    listPos = xyzlist.size() - 1;
                    this.replaceBlock(world, startx, starty, startz, type);
                    continue;
                }
                if (listPos <= 0) continue;
                XYZ xyz = (XYZ)xyzlist.get(--listPos);
                startx = xyz.x;
                starty = xyz.y;
                startz = xyz.z;
            }
        }
        return xyzlist.size();
    }

    private int countEmptyCells(ItemStack fluidCell, EntityPlayer player) {
        int num = 0;
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        for (int i = 0; i <= 35; ++i) {
            if (inv[i] == null || inv[i].func_77973_b() != fluidCell.func_77973_b() || !FluidContainerRegistry.isEmptyContainer((ItemStack)inv[i])) continue;
            num += inv[i].field_77994_a;
        }
        return num;
    }

    private int countAmountOfEmptyFluidCells(ItemStack fluidCell, FluidStack fluid, EntityPlayer entityPlayer) {
        int num = 0;
        for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
            if (entityPlayer.field_71071_by.func_70301_a(i) == null || !(entityPlayer.field_71071_by.func_70301_a(i).func_77973_b() instanceof IFluidContainerItem)) continue;
            int amount = LiquidUtil.fillContainerStack((ItemStack)entityPlayer.field_71071_by.func_70301_a(i), (EntityPlayer)entityPlayer, (FluidStack)fluid, (boolean)true) * entityPlayer.field_71071_by.func_70301_a((int)i).field_77994_a;
            num += amount;
        }
        return num;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("ihl:itemAdvancedElectricHandpump");
    }
}

