/*
 * Decompiled with CFR 0.152.
 */
package ihl.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.chemistry.ApparatusProcessableInvSlot;
import ihl.metallurgy.ImpregnatingMachineContainer;
import ihl.metallurgy.ImpregnatingMachineGui;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import java.util.Arrays;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class ImpregnatingMachineTileEntity
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
IFluidHandler {
    private static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();
    public final ApparatusProcessableInvSlot input;
    public final InvSlotOutput outputSlot;
    public final InvSlotConsumableLiquid drainInputSlot;
    public final InvSlotConsumableLiquid fillInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public short progress;
    protected short operationLength = (short)200;
    private final IHLFluidTank fluidTank = new IHLFluidTank(1000);
    public short temperature = (short)20;
    private ItemStack fractionalOutput;
    private int fractionalOutputAmount = 0;

    public ImpregnatingMachineTileEntity() {
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 0, 2);
        this.drainInputSlot = new InvSlotConsumableLiquid((TileEntityInventory)this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillInputSlot = new InvSlotConsumableLiquid((TileEntityInventory)this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 1);
        this.input = new ApparatusProcessableInvSlot(this, "input", 3, InvSlot.Access.IO, 1, 64);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        if (nbttagcompound.func_74764_b("fractionalOutput")) {
            this.fractionalOutput.func_77963_c(nbttagcompound.func_74775_l("fractionalOutput"));
            this.fractionalOutputAmount = nbttagcompound.func_74762_e("fractionalOutputAmount");
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        NBTTagCompound fractionalOutputNBT = new NBTTagCompound();
        if (this.fractionalOutput != null) {
            this.fractionalOutput.func_77955_b(fractionalOutputNBT);
            nbttagcompound.func_74782_a("fractionalOutput", (NBTBase)fractionalOutputNBT);
            nbttagcompound.func_74768_a("fractionalOutputAmount", this.fractionalOutputAmount);
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(IHLMod.sackBlock, 1);
    }

    public boolean enableUpdateEntity() {
        return true;
    }

    public void func_145845_h() {
        if (IC2.platform.isSimulating()) {
            MutableObject output;
            super.func_145845_h();
            if (this.fluidTank.getFluid() != null) {
                this.temperature = this.fluidTank.getFluid().tag != null && this.fluidTank.getFluid().tag.func_74764_b("temperature") ? (short)(this.fluidTank.getFluid().tag.func_74762_e("temperature") - 273) : (short)(this.fluidTank.getFluid().getFluid().getTemperature() - 273);
            }
            if (!this.drainInputSlot.isEmpty()) {
                output = new MutableObject();
                if (this.fluidTank.fill(this.drainInputSlot.drain(null, this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount(), output, true), false) > 0 && (output.getValue() == null || this.emptyFluidItemsSlot.canAdd((ItemStack)output.getValue()))) {
                    this.fluidTank.fill(this.drainInputSlot.drain(null, this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount(), output, false), true);
                    if (output.getValue() != null) {
                        this.emptyFluidItemsSlot.add((ItemStack)output.getValue());
                    }
                }
            }
            if (!this.fillInputSlot.isEmpty() && this.fillInputSlot.transferFromTank((IFluidTank)this.fluidTank, output = new MutableObject(), false) && (output.getValue() == null || this.emptyFluidItemsSlot.canAdd((ItemStack)output.getValue())) && output.getValue() != null) {
                this.emptyFluidItemsSlot.add((ItemStack)output.getValue());
            }
            boolean needsInvUpdate = false;
            if (this.canOperate()) {
                this.setActive(true);
                if (this.progress == 0) {
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
                }
                this.progress = (short)(this.progress + 1);
                if (this.progress >= this.operationLength) {
                    this.operate();
                    needsInvUpdate = true;
                    this.progress = 0;
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
                }
            } else {
                if (this.progress != 0 && this.getActive()) {
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
                }
                if (!this.canOperate()) {
                    this.progress = 0;
                }
                this.setActive(false);
            }
        }
    }

    public FluidStack drain(ForgeDirection from, int amount, boolean doDrain) {
        FluidStack fstack = this.fluidTank.drain(amount, doDrain);
        return fstack;
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection direction, Fluid arg1) {
        return true;
    }

    public String func_145825_b() {
        return "impregnatingMachine";
    }

    private int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mZ() {
        switch (this.getFacing()) {
            case 3: {
                return 1;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private short getFacingFromXZ(int x, int z) {
        switch (x) {
            case -1: {
                return 4;
            }
            case 1: {
                return 5;
            }
        }
        switch (z) {
            case 1: {
                return 3;
            }
            case -1: {
                return 2;
            }
        }
        return 2;
    }

    public float getRenderLiquidLevel() {
        return (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new ImpregnatingMachineGui(new ImpregnatingMachineContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        this.fluidTank.sortFluidsByDensity();
        return new ImpregnatingMachineContainer(player, this);
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean canOperate() {
        return this.getOutput() != null && this.outputSlot.canAdd(this.getOutput().getItemOutputs());
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public UniversalRecipeInput getInput() {
        if (this.drainInputSlot.isEmpty() && this.fluidTank.getNumberOfFluids() >= 2) {
            return new UniversalRecipeInput(Arrays.asList(this.fluidTank.getFluid(0), this.fluidTank.getFluid(1)), this.input.getItemStackList());
        }
        if (this.fluidTank.getNumberOfFluids() >= 2) {
            UniversalRecipeInput var1 = new UniversalRecipeInput(Arrays.asList(this.fluidTank.getFluid(1), this.drainInputSlot.drain(null, Integer.MAX_VALUE, new MutableObject(), true)), this.input.getItemStackList());
            if (recipeManager.getOutputFor(var1, false, false) != null) {
                return var1;
            }
        }
        return new UniversalRecipeInput(Arrays.asList(this.fluidTank.getFluid(), this.drainInputSlot.drain(null, Integer.MAX_VALUE, new MutableObject(), true)), this.input.getItemStackList());
    }

    public void operate() {
        UniversalRecipeInput recipeInput = recipeManager.getRecipeInput(this.getInput());
        UniversalRecipeOutput output1 = this.getOutput();
        for (int i = 0; i < this.input.size(); ++i) {
            this.input.consume(i, recipeInput.getItemInputs().get((int)i).field_77994_a);
        }
        MutableObject output2 = new MutableObject();
        if (this.drainInputSlot.drain(null, recipeInput.getFluidInputs().get((int)1).amount, output2, false) == null) {
            this.drainInputSlot.drain(null, Integer.MAX_VALUE, output2, false);
        }
        this.fluidTank.drain(recipeInput.getFluidInputs().get(1), true);
        this.fluidTank.drain(recipeInput.getFluidInputs().get(0), true);
        if (output1.getFluidOutputs().size() > 0) {
            this.fluidTank.fill(output1.getFluidOutputs().get(0), true);
        }
        if (output1.getItemOutputs().get(0) != null) {
            this.outputSlot.put(0, output1.getItemOutputs().get(0).func_77946_l());
        }
        if (output2.getValue() != null) {
            this.emptyFluidItemsSlot.add((ItemStack)output2.getValue());
        }
        if (this.drainInputSlot.get() != null && !(this.drainInputSlot.get().func_77973_b() instanceof IFluidContainerItem)) {
            this.drainInputSlot.consume(1);
        }
        if (output1.getItemOutputs().size() > 1) {
            if (this.fractionalOutput != null && this.fractionalOutput.func_77969_a(output1.getItemOutputs().get(1))) {
                this.fractionalOutputAmount += 26;
                if (this.fractionalOutputAmount >= 100) {
                    this.outputSlot.put(1, this.fractionalOutput);
                    this.fractionalOutputAmount -= 100;
                }
            } else {
                this.fractionalOutput = output1.getItemOutputs().get(1).func_77946_l();
                this.fractionalOutputAmount = 0;
            }
        }
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack fluidStack, boolean doDrain) {
        if (this.fluidTank.getFluid().containsFluid(fluidStack)) {
            return this.fluidTank.drain(fluidStack.amount, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return this.fluidTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    public boolean needsFluid() {
        return this.fluidTank.getFluidAmount() <= this.fluidTank.getCapacity();
    }

    public FluidStack getFluidStackfromTank() {
        return this.fluidTank.getFluid();
    }

    public int getTankAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int gaugeLiquidScaled(int i, int index) {
        return this.fluidTank.getFluidAmount() <= 0 ? 0 : this.fluidTank.getFluidAmount(index) * i / this.fluidTank.getCapacity();
    }

    public static void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        recipeManager.addRecipe(input, output);
    }

    public void setFluid(FluidStack fluidStack, int index) {
        this.fluidTank.setFluid(fluidStack, index);
    }

    public void setFluidAmount(int amount, int index) {
        this.fluidTank.setFluidAmount(amount, index);
    }

    public int getNumberOfFluidsInTank() {
        return this.fluidTank.getNumberOfFluids();
    }

    public int getFluidAmount(int i) {
        return this.fluidTank.getFluidAmount(i);
    }

    public int getFluidID(int i) {
        return this.fluidTank.getFluidID(i);
    }

    public FluidStack getFluid(int i) {
        return this.fluidTank.getFluid(i);
    }

    public void removeFluid(int i) {
        this.fluidTank.removeFluid(i);
    }
}

