/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UniversalRecipeOutput {
    private final List<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
    private final List<ItemStack> itemOutputs = new ArrayList<ItemStack>();
    private final int time;

    public UniversalRecipeOutput(List<FluidStack> fluidOutputs1, List<ItemStack> itemOutputs1, int time1) {
        if (fluidOutputs1 != null) {
            this.fluidOutputs.addAll(fluidOutputs1);
        }
        if (itemOutputs1 != null) {
            this.itemOutputs.addAll(itemOutputs1);
        }
        this.time = time1;
    }

    public UniversalRecipeOutput(FluidStack fluidStack) {
        this.fluidOutputs.add(fluidStack);
        this.time = 20;
    }

    public UniversalRecipeOutput(List<FluidStack> fluidOutputs1, int time1) {
        if (fluidOutputs1 != null) {
            this.fluidOutputs.addAll(fluidOutputs1);
        }
        this.time = time1;
    }

    public UniversalRecipeOutput(List<ItemStack> itemOutputs1) {
        if (itemOutputs1 != null) {
            this.itemOutputs.addAll(itemOutputs1);
        }
        this.time = 0;
    }

    public UniversalRecipeOutput(ItemStack itemStack) {
        this.itemOutputs.add(itemStack);
        this.time = 0;
    }

    public boolean matches(List<FluidStack> fluidOutputs1, List<ItemStack> itemOutputs1) {
        if (this.fluidOutputs.size() != fluidOutputs1.size() || this.itemOutputs.size() != this.itemOutputs.size()) {
            return false;
        }
        Iterator<FluidStack> fi1 = fluidOutputs1.iterator();
        Iterator<ItemStack> ii1 = itemOutputs1.iterator();
        Iterator<FluidStack> fi = this.fluidOutputs.iterator();
        Iterator<ItemStack> ii = this.itemOutputs.iterator();
        while (fi.hasNext()) {
            FluidStack fs = fi.next();
            FluidStack fs1 = fi1.next();
            if (fs.getFluid() == fs1.getFluid()) continue;
            return false;
        }
        while (ii.hasNext()) {
            ItemStack is = ii.next();
            ItemStack is1 = ii1.next();
            if (is == null) {
                return true;
            }
            if (is != null && is1 == null || is.func_77973_b() != is1.func_77973_b()) {
                return false;
            }
            if (is.func_77960_j() == Short.MAX_VALUE || is.func_77960_j() == is1.func_77960_j()) continue;
            return false;
        }
        return true;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public List<ItemStack> getItemOutputs() {
        return this.itemOutputs;
    }

    public UniversalRecipeOutput copy() {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (this.fluidOutputs != null && !this.fluidOutputs.isEmpty()) {
            for (FluidStack fs : this.fluidOutputs) {
                fluidStacks.add(fs.copy());
            }
        }
        if (this.itemOutputs != null && !this.itemOutputs.isEmpty()) {
            for (ItemStack is : this.itemOutputs) {
                if (is != null) {
                    itemStacks.add(is.func_77946_l());
                    continue;
                }
                itemStacks.add(is);
            }
        }
        return new UniversalRecipeOutput(fluidStacks, itemStacks, this.time);
    }

    public boolean containItem(Item item) {
        if (this.itemOutputs == null || this.itemOutputs.isEmpty()) {
            return false;
        }
        for (ItemStack is : this.itemOutputs) {
            if (is.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public boolean replaceItem(ItemStack newItemStack) {
        if (this.itemOutputs == null || this.itemOutputs.isEmpty()) {
            return false;
        }
        for (ItemStack is : this.itemOutputs) {
            if (is.func_77973_b() != newItemStack.func_77973_b()) continue;
            is = newItemStack;
            return true;
        }
        return false;
    }

    public UniversalRecipeOutput copyWithMultiplier(int mulipier) {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (this.fluidOutputs != null && !this.fluidOutputs.isEmpty()) {
            for (FluidStack fs : this.fluidOutputs) {
                FluidStack newFs = fs.copy();
                newFs.amount *= mulipier;
                fluidStacks.add(newFs);
            }
        }
        if (this.itemOutputs != null && !this.itemOutputs.isEmpty()) {
            for (ItemStack is : this.itemOutputs) {
                if (is != null) {
                    ItemStack newIs = is.func_77946_l();
                    newIs.field_77994_a *= mulipier;
                    itemStacks.add(newIs);
                    continue;
                }
                itemStacks.add(is);
            }
        }
        return new UniversalRecipeOutput(fluidStacks, itemStacks, this.time);
    }
}

