/*
 * Decompiled with CFR 0.152.
 */
package ihl.utils;

import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class IHLFluidTank
implements IFluidTank {
    protected List<FluidStack> fluidList = new ArrayList<FluidStack>();
    protected int capacity;
    protected boolean isOpenVessel = false;

    public IHLFluidTank(int capacity) {
        this.capacity = capacity;
    }

    public IHLFluidTank(int capacity, boolean isOpenVessel1) {
        this.isOpenVessel = isOpenVessel1;
        this.capacity = capacity;
    }

    public IHLFluidTank readFromNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("Empty")) {
            NBTTagList fluidList1 = nbt.func_150295_c("fluids", 10);
            for (int i = 0; i < fluidList1.func_74745_c(); ++i) {
                NBTTagCompound fluidNBT1 = fluidList1.func_150305_b(i);
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidNBT1);
                if (fluid == null) continue;
                this.fluidList.add(fluid);
            }
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (!this.fluidList.isEmpty()) {
            NBTTagList fluids = new NBTTagList();
            for (FluidStack fluid : this.fluidList) {
                NBTTagCompound fluidNBT1 = new NBTTagCompound();
                fluid.writeToNBT(fluidNBT1);
                fluids.func_74742_a((NBTBase)fluidNBT1);
            }
            nbt.func_74782_a("fluids", (NBTBase)fluids);
        } else {
            nbt.func_74778_a("Empty", "");
        }
        return nbt;
    }

    public FluidStack getFluid() {
        if (this.fluidList.isEmpty()) {
            return null;
        }
        return this.fluidList.get(0);
    }

    public int getFluidAmount() {
        int amount = 0;
        for (FluidStack fluid : this.fluidList) {
            amount += fluid.amount;
        }
        return amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (this.fluidList.isEmpty()) {
                return Math.min(this.capacity, resource.amount);
            }
            return Math.min(this.capacity - this.getFluidAmount(), resource.amount);
        }
        if (this.fluidList.isEmpty()) {
            FluidStack fluid = new FluidStack(resource.getFluid().getID(), Math.min(this.capacity, resource.amount), resource.tag);
            this.fluidList.add(fluid);
            return fluid.amount;
        }
        FluidStack fluid = this.getFluidStackWithSameFluid(resource);
        if (fluid != null) {
            fluid.tag = IHLUtils.makeTagsEqual(fluid, resource);
            int amount1 = Math.min(this.capacity - this.getFluidAmount(), resource.amount);
            fluid.amount += amount1;
            return amount1;
        }
        fluid = new FluidStack(resource.getFluid().getID(), Math.min(this.capacity, resource.amount), resource.tag);
        this.fluidList.add(fluid);
        this.sortFluidsByDensity();
        return fluid.amount;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidList.isEmpty()) {
            return null;
        }
        int drained = maxDrain;
        FluidStack fluid = this.fluidList.get(0);
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid.getFluid().getID(), drained, fluid.tag);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                this.fluidList.remove(fluid);
                fluid = null;
            }
        }
        return stack;
    }

    private FluidStack getFluidStackWithSameFluid(FluidStack resource) {
        for (FluidStack fluid : this.fluidList) {
            if (!fluid.isFluidEqual(resource)) continue;
            return fluid;
        }
        return null;
    }

    private FluidStack getHeaviestFluidStack() {
        FluidStack fluidStack = this.fluidList.get(0);
        int density = fluidStack.getFluid().getDensity();
        for (FluidStack fluid : this.fluidList) {
            if (fluid.getFluid().getDensity() >= density) continue;
            density = fluid.getFluid().getDensity();
            fluidStack = fluid;
        }
        return fluidStack;
    }

    public void setFluid(FluidStack fluidStack, int index) {
        if (this.fluidList.size() <= index) {
            while (this.fluidList.size() <= index) {
                this.fluidList.add(fluidStack);
            }
        }
        this.fluidList.set(index, fluidStack);
    }

    public int getNumberOfFluids() {
        return this.fluidList.size();
    }

    public void setFluidAmount(int amount1, int index) {
        if (this.fluidList.size() <= index) {
            while (this.fluidList.size() <= index) {
                this.fluidList.add(new FluidStack(FluidRegistry.WATER, 1));
            }
        }
        this.fluidList.get((int)index).amount = amount1;
    }

    public int getFluidAmount(int index) {
        if (this.fluidList.size() <= index) {
            return 0;
        }
        return this.fluidList.get((int)index).amount;
    }

    public int getFluidID(int i) {
        return this.fluidList.get(i).getFluid().getID();
    }

    public void sortFluidsByDensity() {
        HashMap<Integer, FluidStack> sortMap = new HashMap<Integer, FluidStack>();
        int[] keysArray = new int[this.fluidList.size()];
        for (FluidStack fluid : this.fluidList) {
            int key = fluid.getFluid().getDensity();
            while (sortMap.containsKey(key)) {
                ++key;
            }
            sortMap.put(key, fluid);
            keysArray[this.fluidList.indexOf((Object)fluid)] = key;
        }
        Arrays.sort(keysArray);
        ArrayList<FluidStack> newFluidList = new ArrayList<FluidStack>();
        for (int i = keysArray.length - 1; i >= 0; --i) {
            newFluidList.add((FluidStack)sortMap.get(keysArray[i]));
        }
        this.fluidList = newFluidList;
    }

    public FluidStack getFluid(int i) {
        return this.fluidList.get(i);
    }

    public void setTag(String string, int t1_1) {
        if (this.getFluid().tag == null) {
            this.getFluid().tag = new NBTTagCompound();
        }
        this.getFluid().tag.func_74768_a(string, t1_1);
    }

    public void setEmpty() {
        this.fluidList.clear();
    }

    public void removeFluid(int i) {
        if (this.fluidList.size() > i) {
            this.fluidList.remove(i);
        }
    }

    public FluidStack drain(FluidStack fluidStack, boolean doDrain) {
        if (this.fluidList.isEmpty()) {
            return null;
        }
        int drained = fluidStack.amount;
        FluidStack fluid = this.getFluidStackWithSameFluid(fluidStack);
        if (fluid == null) {
            return null;
        }
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid.getFluid().getID(), drained, fluid.tag);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                this.fluidList.remove(fluid);
                fluid = null;
            }
        }
        return stack;
    }
}

