/*
 * Decompiled with CFR 0.152.
 */
package ihl.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class IHLUtils {
    public static ItemStack getOreDictItemStack(String name) {
        ItemStack ore = (ItemStack)OreDictionary.getOres((String)name).get(0);
        if (ore == null) {
            return null;
        }
        ItemStack orecopy = ore.func_77946_l();
        orecopy.field_77994_a = 1;
        return orecopy;
    }

    public static Item getOreDictItem(String name) {
        return ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b();
    }

    public static Block getOreDictBlock(String name) {
        return Block.func_149634_a((Item)((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b());
    }

    public static ItemStack getOreDictItemStackWithSize(String name, int size) {
        ItemStack ore = (ItemStack)OreDictionary.getOres((String)name).get(0);
        if (ore == null) {
            return null;
        }
        ItemStack orecopy = ore.func_77946_l();
        orecopy.field_77994_a = size;
        return orecopy;
    }

    public static boolean hasOreDictEntry(String name) {
        return OreDictionary.getOres((String)name) == null ? false : OreDictionary.getOres((String)name).size() >= 1;
    }

    public static String getFirstOreDictName(ItemStack stack) {
        int[] arrayIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (arrayIDs.length > 0) {
            return OreDictionary.getOreName((int)arrayIDs[0]);
        }
        return "";
    }

    public static ItemStack getThisModItemStack(String name) {
        if (GameRegistry.findItem((String)"ihl", (String)name) != null) {
            return new ItemStack(GameRegistry.findItem((String)"ihl", (String)name));
        }
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            throw new IllegalArgumentException("No such item in item registry: ihl:" + name);
        }
        return new ItemStack(GameRegistry.findBlock((String)"ihl", (String)name));
    }

    public static ItemStack getThisModItemStackWithSize(String name, int i) {
        if (GameRegistry.findItem((String)"ihl", (String)name) != null) {
            return new ItemStack(GameRegistry.findItem((String)"ihl", (String)name), i);
        }
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            throw new IllegalArgumentException("No such item in item registry: ihl:" + name);
        }
        return new ItemStack(GameRegistry.findBlock((String)"ihl", (String)name), i);
    }

    public static NBTTagCompound makeTagsEqual(FluidStack resource1, FluidStack resource2) {
        NBTTagCompound impurityResult;
        int averageT;
        NBTTagCompound nbt1 = resource1.tag;
        NBTTagCompound nbt2 = resource2.tag;
        if (nbt1 == null && nbt2 == null) {
            return null;
        }
        if (nbt1 == null) {
            nbt1 = new NBTTagCompound();
        }
        if (nbt2 == null) {
            nbt2 = new NBTTagCompound();
        }
        if (!nbt1.func_74764_b("temperature")) {
            nbt1.func_74768_a("temperature", resource1.getFluid().getTemperature());
        }
        if (!nbt2.func_74764_b("temperature")) {
            nbt2.func_74768_a("temperature", resource2.getFluid().getTemperature());
        }
        if ((averageT = (nbt2.func_74762_e("temperature") * resource2.amount + nbt1.func_74762_e("temperature") * resource1.amount) / (resource2.amount + resource1.amount)) == nbt2.func_74762_e("temperature") || averageT == nbt1.func_74762_e("temperature")) {
            averageT = averageT < nbt1.func_74762_e("temperature") || averageT < nbt2.func_74762_e("temperature") ? ++averageT : --averageT;
        }
        ArrayList<String> addedImpurities = new ArrayList<String>();
        NBTTagList resultList = new NBTTagList();
        NBTTagList impuritiesList2 = nbt2.func_150295_c("impurities", 10);
        for (int i = 0; i < impuritiesList2.func_74745_c(); ++i) {
            NBTTagCompound impurity2 = impuritiesList2.func_150305_b(i);
            String impurityName2 = impurity2.func_74779_i("impurityName");
            int impurityConcentration2 = impurity2.func_74762_e("impurityConcentration");
            int newConcentration = IHLUtils.getAverageConcentration("impurityName2", impurityConcentration2, resource1, resource2);
            impurityResult = new NBTTagCompound();
            impurityResult.func_74778_a("impurityName", impurityName2);
            impurityResult.func_74768_a("impurityConcentration", newConcentration);
            resultList.func_74742_a((NBTBase)impurityResult);
            addedImpurities.add(impurityName2);
        }
        NBTTagList impuritiesList1 = nbt1.func_150295_c("impurities", 10);
        for (int i = 0; i < impuritiesList1.func_74745_c(); ++i) {
            NBTTagCompound impurity1 = impuritiesList1.func_150305_b(i);
            String impurityName1 = impurity1.func_74779_i("impurityName");
            if (addedImpurities.contains(impurityName1)) continue;
            int impurityConcentration1 = impurity1.func_74762_e("impurityConcentration");
            impurityResult = new NBTTagCompound();
            impurityResult.func_74778_a("impurityName", impurityName1);
            impurityResult.func_74768_a("impurityConcentration", impurityConcentration1);
            resultList.func_74742_a((NBTBase)impurityResult);
            addedImpurities.add(impurityName1);
        }
        NBTTagCompound result = new NBTTagCompound();
        if (resultList.func_74745_c() > 0) {
            result.func_74782_a("impurities", (NBTBase)resultList);
        }
        result.func_74768_a("temperature", averageT);
        return result;
    }

    private static int getAverageConcentration(String impurityName2, int impurityConcentration2, FluidStack resource1, FluidStack resource2) {
        int impurityConcentration1 = 0;
        NBTTagCompound nbt1 = resource1.tag;
        NBTTagList impuritiesList1 = nbt1.func_150295_c("impurities", 10);
        for (int i = 0; i < impuritiesList1.func_74745_c(); ++i) {
            NBTTagCompound impurity1 = impuritiesList1.func_150305_b(i);
            String impurityName1 = impurity1.func_74779_i("impurityName");
            if (!impurityName1.equals(impurityName2)) continue;
            impurityConcentration1 = impurity1.func_74762_e("impurityConcentration");
            break;
        }
        return (impurityConcentration2 * resource2.amount + impurityConcentration1 * resource1.amount) / (resource2.amount + resource1.amount);
    }

    public static FluidTank fillFluidTank(FluidTank tank, FluidStack resource, boolean doFill) {
        if (tank.getFluid() == null) {
            tank.fill(resource, doFill);
        } else {
            resource.tag = tank.getFluid().tag = IHLUtils.makeTagsEqual(tank.getFluid(), resource);
            tank.fill(resource, doFill);
        }
        return tank;
    }

    public static Item getThisModItem(String name) {
        if (GameRegistry.findItem((String)"ihl", (String)name) != null) {
            return GameRegistry.findItem((String)"ihl", (String)name);
        }
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            throw new IllegalArgumentException("No such item in item registry: ihl:" + name);
        }
        return Item.func_150898_a((Block)GameRegistry.findBlock((String)"ihl", (String)name));
    }

    public static FluidStack getFluidStackWithSize(String name, int i) {
        if (FluidRegistry.isFluidRegistered((String)name)) {
            return FluidRegistry.getFluidStack((String)name, (int)i);
        }
        throw new IllegalArgumentException("No such fluid: " + name);
    }

    public static Block getThisModBlock(String name) {
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            throw new IllegalArgumentException("No such block in item registry: ihl:" + name);
        }
        return GameRegistry.findBlock((String)"ihl", (String)name);
    }

    public static ItemStack getThisModItemStackWithDamage(String name, byte value) {
        ItemStack stack = IHLUtils.getThisModItemStack(name);
        stack.func_77964_b((int)value);
        return stack;
    }
}

