/*
 * Decompiled with CFR 0.152.
 */
package ihl.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableFuel;
import ihl.chemistry.ApparatusProcessableInvSlot;
import ihl.chemistry.ReactorContainer;
import ihl.chemistry.ReactorGui;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ReactorBaseTileEntity
extends TileEntityInventory
implements IHasGui {
    public final InvSlotConsumableFuel fuelSlot;
    public final ApparatusProcessableInvSlot inputSlot;
    public short progress = 0;
    public final short maxProgress = (short)450;
    public int fuel = 0;
    public int maxFuel = 0;
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();

    public ReactorBaseTileEntity(int inputSlots) {
        this.fuelSlot = new InvSlotConsumableFuel((TileEntityInventory)this, "fuel", 1, 1, true);
        this.inputSlot = new ApparatusProcessableInvSlot(this, "input", 2, InvSlot.Access.I, inputSlots, 1);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.func_74762_e("fuel");
        }
        catch (Throwable var4) {
            this.fuel = nbttagcompound.func_74765_d("fuel");
        }
        try {
            this.maxFuel = nbttagcompound.func_74762_e("maxFuel");
        }
        catch (Throwable var3) {
            this.maxFuel = nbttagcompound.func_74765_d("maxFuel");
        }
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74768_a("maxFuel", this.maxFuel);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(Items.field_151118_aC, 7);
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / 450;
    }

    public int gaugeFuelScaled(int i) {
        if (this.maxFuel == 0) {
            this.maxFuel = this.fuel;
            if (this.maxFuel == 0) {
                this.maxFuel = 160;
            }
        }
        return this.fuel * i / this.maxFuel;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.fuel <= 0 && this.canOperate()) {
            this.fuel = this.maxFuel = this.fuelSlot.consumeFuel();
            if (this.fuel > 0) {
                needsInvUpdate = true;
            }
        }
        if (this.isBurning() && this.canOperate()) {
            this.progress = (short)(this.progress + 1);
            if (this.progress >= 450) {
                this.progress = 0;
                this.operate();
                needsInvUpdate = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.getActive() != this.isBurning()) {
            this.setActive(this.isBurning());
            needsInvUpdate = true;
        }
    }

    public abstract void operate();

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public abstract String func_145825_b();

    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ReactorContainer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new ReactorGui(new ReactorContainer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public boolean canOperate() {
        return this.getOutput() != null;
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public abstract UniversalRecipeInput getInput();
}

