/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ihl.IHLMod;
import ihl.flexible_cable.IHLCable;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.flexible_cable.WireItem;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class AnchorTileEntity
extends TileEntityBlock
implements IEnergySink,
IEnergySource {
    private List<NodeEntity> nodeList = new ArrayList<NodeEntity>();
    private boolean addedToEnergyNet = false;
    public double connectionX;
    public double connectionY;
    public double connectionZ;
    private int gridID = -1;
    public List<IHLCable> cableList = new ArrayList<IHLCable>();
    private int countdownTimer = 200;
    private boolean startCableBurning = false;
    private IHLCable cableToBurn;

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        if (this.gridID != -1) {
            IHLGrid grid = IHLMod.enet.getGrid(this.gridID);
            grid.telist.add(this);
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    public boolean wrenchCanRemove(EntityPlayer var1) {
        return this.cableList.isEmpty();
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        if (this.startCableBurning) {
            --this.countdownTimer;
            if (this.countdownTimer <= 0) {
                double range = (double)this.cableToBurn.length * 2.0 + 32.0;
                AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
                List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
                if (!nodeList.isEmpty()) {
                    for (NodeEntity ne : nodeList) {
                        if (ne.getChainUniqueID() != this.cableToBurn.cableID) continue;
                        ne.func_70106_y();
                    }
                }
                IHLMod.enet.removeCableAndSplitGrids(this.gridID, this.cableToBurn);
                this.startCableBurning = false;
                this.countdownTimer = 200;
            }
        }
    }

    public void removeAttachedChains() {
        if (!this.cableList.isEmpty()) {
            double range = 128.0;
            AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
            List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
            if (!nodeList.isEmpty()) {
                for (NodeEntity ne : nodeList) {
                    if (!this.cableListContains(ne.getChainUniqueID())) continue;
                    ne.func_70106_y();
                }
            }
            for (IHLCable c : this.cableList) {
                ItemStack is = IHLUtils.getThisModItemStack("flexibleCableWithClamp");
                if (c.wireBasicTransverseSection.floatValue() != 0.0f) {
                    is = c.material.cablesMap.get(Float.valueOf((float)c.leadsNum * c.wireBasicTransverseSection.floatValue())).func_77946_l();
                }
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74757_a("firstConnection", false);
                is.field_77990_d.func_74768_a("length", c.length);
                is.field_77990_d.func_74768_a("fullLength", c.length);
                EntityItem eitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is);
                this.field_145850_b.func_72838_d((Entity)eitem);
            }
            if (this.gridID != -1) {
                IHLMod.enet.splitGrids(this.gridID, this);
            }
            this.cableList.clear();
        }
    }

    private boolean cableListContains(int chainUniqueID) {
        for (IHLCable c : this.cableList) {
            if (c.cableID != chainUniqueID) continue;
            return true;
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList var2 = new NBTTagList();
        for (IHLCable cc : this.cableList) {
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74768_a("cableID", cc.cableID);
            var4.func_74768_a("length", cc.length);
            var4.func_74768_a("resistivity", cc.resistivity);
            var4.func_74768_a("voltageLimit", cc.voltageLimit);
            var4.func_74768_a("leadsNum", cc.leadsNum);
            var4.func_74778_a("wireMaterial", cc.material.name());
            var4.func_74776_a("transverseSection", cc.wireBasicTransverseSection.floatValue());
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("cableList", (NBTBase)var2);
        nbt.func_74780_a("connectionX", this.connectionX);
        nbt.func_74780_a("connectionY", this.connectionY);
        nbt.func_74780_a("connectionZ", this.connectionZ);
        nbt.func_74768_a("gridID", this.gridID);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList var2 = nbt.func_150295_c("cableList", 10);
        for (int i = 0; i < var2.func_74745_c(); ++i) {
            NBTTagCompound var4 = var2.func_150305_b(i);
            int cableID = var4.func_74762_e("cableID");
            int length = var4.func_74762_e("length");
            int resistivity = var4.func_74762_e("resistivity");
            int voltageLimit = var4.func_74762_e("voltageLimit");
            int leadsNum = var4.func_74762_e("leadsNum");
            float transverseSection = var4.func_74760_g("transverseSection");
            WireItem.WireMaterial material = WireItem.WireMaterial.valueOf(var4.func_74779_i("wireMaterial"));
            IHLCable cable = material != null ? new IHLCable(cableID, material, transverseSection, length, resistivity, voltageLimit, leadsNum) : new IHLCable(cableID, WireItem.WireMaterial.Copper, 24.0f, length, resistivity, voltageLimit, leadsNum);
            this.cableList.add(cable);
        }
        this.connectionX = nbt.func_74769_h("connectionX");
        this.connectionY = nbt.func_74769_h("connectionY");
        this.connectionZ = nbt.func_74769_h("connectionZ");
        this.gridID = nbt.func_74762_e("gridID");
    }

    public void setFacing(short facing) {
        double d = 0.3;
        double f = 0.1;
        super.setFacing(facing);
        switch (facing) {
            case 0: {
                this.connectionX = (double)this.field_145851_c + d;
                this.connectionY = (double)this.field_145848_d + 1.0 - f;
                this.connectionZ = (double)this.field_145849_e + 0.5;
                break;
            }
            case 1: {
                this.connectionX = (double)this.field_145851_c + d;
                this.connectionY = (double)this.field_145848_d + f;
                this.connectionZ = (double)this.field_145849_e + 0.5;
                break;
            }
            case 2: {
                this.connectionX = (double)this.field_145851_c + 0.5;
                this.connectionY = (double)this.field_145848_d + d;
                this.connectionZ = (double)this.field_145849_e + 1.0 - f;
                break;
            }
            case 3: {
                this.connectionX = (double)this.field_145851_c + 0.5;
                this.connectionY = (double)this.field_145848_d + d;
                this.connectionZ = (double)this.field_145849_e + f;
                break;
            }
            case 4: {
                this.connectionX = (double)this.field_145851_c + 1.0 - f;
                this.connectionY = (double)this.field_145848_d + d;
                this.connectionZ = (double)this.field_145849_e + 0.5;
                break;
            }
            case 5: {
                this.connectionX = (double)this.field_145851_c + f;
                this.connectionY = (double)this.field_145848_d + d;
                this.connectionZ = (double)this.field_145849_e + 0.5;
                break;
            }
            default: {
                this.connectionX = (double)this.field_145851_c + f;
                this.connectionY = (double)this.field_145848_d + d;
                this.connectionZ = (double)this.field_145849_e + 0.5;
            }
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return this.getFacing() == 0;
            }
            case DOWN: {
                return this.getFacing() == 1;
            }
            case SOUTH: {
                return this.getFacing() == 2;
            }
            case NORTH: {
                return this.getFacing() == 3;
            }
            case EAST: {
                return this.getFacing() == 4;
            }
            case WEST: {
                return this.getFacing() == 5;
            }
        }
        return false;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.acceptsEnergyFrom(receiver, direction);
    }

    public double getOfferedEnergy() {
        if (this.gridID == -1) {
            return 0.0;
        }
        return Math.max(this.getGrid().energy, 0.0);
    }

    public void drawEnergy(double amount) {
        if (this.gridID != -1) {
            this.getGrid().drawEnergy(amount, this);
        }
    }

    public int getSourceTier() {
        return EnergyNet.instance.getTierFromPower(this.getGrid().getDemandedEnergy());
    }

    public double getDemandedEnergy() {
        if (this.gridID == -1) {
            return 0.0;
        }
        return this.getGrid().getDemandedEnergy();
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.gridID == -1 || this.getGrid().energy > 0.0) {
            return amount;
        }
        this.getGrid().injectEnergy(amount, 400.0, this);
        return 0.0;
    }

    public void setGrid(int newGridID) {
        if (newGridID != -1) {
            this.gridID = newGridID;
            IHLMod.enet.getGrid((int)newGridID).telist.add(this);
            IHLMod.enet.getGrid((int)newGridID).isGridValid = true;
        } else {
            this.gridID = -1;
        }
    }

    public int getGridID() {
        return this.gridID;
    }

    private IHLGrid getGrid() {
        return IHLMod.enet.getGrid(this.gridID);
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(IHLMod.cableAnchorBlock, 1);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public void initiateCableBurnout(IHLCable cable) {
        this.cableToBurn = cable;
        double range = (double)cable.length * 2.0 + 32.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.getChainUniqueID() != cable.cableID) continue;
                ne.func_70015_d(10);
            }
        }
        this.startCableBurning = true;
    }
}

