/*
 * Decompiled with CFR 0.152.
 */
package ihl.metallurgy;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ihl.IHLCreativeTab;
import ihl.chemistry.GoldChimneyKneeTileEntity;
import ihl.chemistry.LeadOvenTileEntity;
import ihl.chemistry.PrecipitatorCondenserTileEntity;
import ihl.metallurgy.AchesonFurnanceTileEntity;
import ihl.metallurgy.DetonationSprayingMachineTileEntity;
import ihl.metallurgy.DrawingDeskTileEntity;
import ihl.metallurgy.FiberglassSpinneretsTileEntity;
import ihl.metallurgy.ImpregnatingMachineTileEntity;
import ihl.metallurgy.MuffleFurnanceTileEntity;
import ihl.tunneling_shield.IHLItemBlock;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MachineBaseBlock
extends Block
implements ITileEntityProvider {
    @SideOnly(value=Side.CLIENT)
    IIcon textureSide;
    @SideOnly(value=Side.CLIENT)
    IIcon textureBack;
    @SideOnly(value=Side.CLIENT)
    IIcon textureFrontMuffleFurnance;
    @SideOnly(value=Side.CLIENT)
    IIcon textureTop;
    @SideOnly(value=Side.CLIENT)
    IIcon textureTopAchesonFurnance;
    @SideOnly(value=Side.CLIENT)
    IIcon textureTopGoldFurnace;
    @SideOnly(value=Side.CLIENT)
    IIcon textureFrontGoldFurnace;
    @SideOnly(value=Side.CLIENT)
    IIcon textureSideGoldFurnace;
    MachineType type;
    private static List<MachineBaseBlock> instances = new ArrayList<MachineBaseBlock>();

    public MachineBaseBlock(MachineType type1) {
        super(Material.field_151573_f);
        this.type = type1;
        this.func_149647_a(IHLCreativeTab.tab);
        this.func_149663_c(this.type.unlocalizedName);
        this.func_149711_c(2.0f);
        this.func_149752_b(1.0f);
        instances.add(this);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        switch (this.type) {
            case BronzeTub: {
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.1f, 0.8f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.21f, 1.0f, 0.8f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.21f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.79f, 0.0f, 0.0f, 0.8f, 1.0f, 0.8f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.0f, 0.0f, 0.79f, 0.8f, 1.0f, 0.8f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149683_g();
                break;
            }
            default: {
                super.func_149743_a(world, x, y, z, aabb, list, entity);
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void init() {
        AchesonFurnanceTileEntity.init();
        MachineType[] var1 = MachineType.values();
        for (int i = 0; i < var1.length; ++i) {
            GameRegistry.registerBlock((Block)new MachineBaseBlock(var1[i]), IHLItemBlock.class, (String)var1[i].unlocalizedName);
            GameRegistry.registerTileEntity((Class)var1[i].teclass, (String)var1[i].unlocalizedName);
        }
        IHLUtils.getThisModBlock("tubBronze").func_149658_d("tubBronzeIcon");
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return new ItemStack(Items.field_151118_aC, 4).func_77973_b();
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int flag) {
        ItemStack result = new ItemStack(Items.field_151118_aC, 4);
        this.func_149642_a(world, x, y, z, result);
    }

    public TileEntity func_149915_a(World world, int var2) {
        TileEntity newTE = null;
        try {
            newTE = (TileEntity)this.type.teclass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return newTE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("ihl:brickOvenSide");
        this.textureBack = par1IconRegister.func_94245_a("ihl:brickOvenBack");
        this.textureSide = par1IconRegister.func_94245_a("ihl:brickOvenSide");
        this.textureTop = par1IconRegister.func_94245_a("ihl:brickOvenTop");
        this.textureFrontMuffleFurnance = par1IconRegister.func_94245_a("ihl:muffleOvenFront");
        this.textureTopAchesonFurnance = par1IconRegister.func_94245_a("ihl:achesonOvenTop");
        this.textureTopGoldFurnace = par1IconRegister.func_94245_a("ihl:goldFurnaceTop");
        this.textureFrontGoldFurnace = par1IconRegister.func_94245_a("ihl:goldFurnaceFront");
        this.textureSideGoldFurnace = par1IconRegister.func_94245_a("ihl:goldFurnaceSide");
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float pos_x, float pos_y, float pos_z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof DetonationSprayingMachineTileEntity && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Items.field_151033_d) {
            ((DetonationSprayingMachineTileEntity)te).operate();
            return true;
        }
        return te instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)te) : true) : false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int var7 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof IWrenchable) {
            IWrenchable te = (IWrenchable)t;
            if (player.func_70093_af()) {
                switch (var7) {
                    case 0: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)4);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)5);
                        break;
                    }
                }
            } else {
                switch (var7) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                        break;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int facing = 3;
        int[] mask = new int[]{0, 1, 2, 3, 4, 5, 1, 0, 3, 2, 4, 5, 2, 3, 0, 1, 4, 5, 2, 3, 1, 0, 4, 5, 2, 3, 5, 4, 0, 1, 2, 3, 4, 5, 1, 0};
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IWrenchable) {
            IWrenchable tebh = (IWrenchable)te;
            facing = tebh.getFacing();
        }
        return this.getIconFromFacing(facing, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getIconFromFacing(3, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromFacing(int facing, int side) {
        int[] mask = new int[]{0, 1, 2, 3, 4, 5, 1, 0, 3, 2, 4, 5, 2, 3, 0, 1, 4, 5, 2, 3, 1, 0, 4, 5, 2, 3, 5, 4, 0, 1, 2, 3, 4, 5, 1, 0};
        switch (mask[facing * 6 + side]) {
            case 0: {
                switch (this.type) {
                    case AchesonFurnace: {
                        return this.field_149761_L;
                    }
                    case MuffleFurnace: {
                        return this.textureFrontMuffleFurnance;
                    }
                    case ImpregnatingMachine: {
                        return this.field_149761_L;
                    }
                    case LeadOven: {
                        return this.textureFrontGoldFurnace;
                    }
                }
            }
            case 1: {
                switch (this.type) {
                    case LeadOven: {
                        return this.textureSideGoldFurnace;
                    }
                }
                return this.textureBack;
            }
            case 2: {
                switch (this.type) {
                    case LeadOven: {
                        return this.textureSideGoldFurnace;
                    }
                }
                return this.textureTop;
            }
            case 3: {
                switch (this.type) {
                    case AchesonFurnace: {
                        return this.textureTopAchesonFurnance;
                    }
                    case MuffleFurnace: {
                        return this.textureTop;
                    }
                    case ImpregnatingMachine: {
                        return this.textureTop;
                    }
                    case LeadOven: {
                        return this.textureTopGoldFurnace;
                    }
                }
                return this.textureTop;
            }
            case 4: {
                switch (this.type) {
                    case LeadOven: {
                        return this.textureSideGoldFurnace;
                    }
                }
                return this.textureSide;
            }
            case 5: {
                switch (this.type) {
                    case LeadOven: {
                        return this.textureSideGoldFurnace;
                    }
                }
                return this.textureSide;
            }
        }
        return this.textureSide;
    }

    public int func_149645_b() {
        return this.type.isNormalBlock ? 0 : -2;
    }

    public boolean func_149662_c() {
        return this.type == null ? false : this.type.isNormalBlock;
    }

    public boolean func_149686_d() {
        return this.type.isNormalBlock;
    }

    public static enum MachineType {
        FiberglassSpinnerets("fiberglassSpinnerets", FiberglassSpinneretsTileEntity.class),
        PrecipitatorCondenser("goldPrecipitatorCondenser", PrecipitatorCondenserTileEntity.class, false),
        GoldChimneyKnee("goldChimneyKnee", GoldChimneyKneeTileEntity.class, false),
        LeadOven("leadOven", LeadOvenTileEntity.class),
        DrawingDesk("drawingDesk", DrawingDeskTileEntity.class, false),
        DetonationSprayingMachine("cannonBronze", DetonationSprayingMachineTileEntity.class, false),
        BronzeTub("tubBronze", ImpregnatingMachineTileEntity.class, false),
        ImpregnatingMachine("impregnatingMachine", ImpregnatingMachineTileEntity.class),
        AchesonFurnace("achesonFurnance", AchesonFurnanceTileEntity.class),
        MuffleFurnace("muffleFurnance", MuffleFurnanceTileEntity.class);

        String unlocalizedName;
        Class teclass;
        boolean isNormalBlock = true;

        private MachineType(String unlocalizedName1, Class teclass1) {
            this.unlocalizedName = unlocalizedName1;
            this.teclass = teclass1;
        }

        private MachineType(String unlocalizedName1, Class teclass1, boolean isNormalBlock1) {
            this.unlocalizedName = unlocalizedName1;
            this.teclass = teclass1;
            this.isNormalBlock = isNormalBlock1;
        }
    }
}

