/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen.ores;

import cpw.mods.fml.common.registry.GameRegistry;
import ihl.IHLCreativeTab;
import ihl.chemistry.IHLItemCell;
import ihl.crop_harvestors.BlockFluidRubberTreeSap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class IHLFluid
extends Fluid {
    private Type type;
    private Item cell;
    private static List<Fluid> fluidInstances = new ArrayList<Fluid>();
    private static Map<String, IHLFluid> localFluidRegistry = new HashMap<String, IHLFluid>();
    private static Map<String, String> condensationMap = new HashMap<String, String>();
    private static Map<String, List<String>> solutionMap = new HashMap<String, List<String>>();
    public static final int maxGaseousStateVapoursDensity = 40;

    public IHLFluid(Type type1) {
        super(type1.fluidRegistryName);
        this.type = type1;
        this.setTemperature(this.type.temperature);
        this.setDensity(this.type.density);
        this.setGaseous(this.type.isGaseous);
        this.setUnlocalizedName(this.type.fluidRegistryName.replaceFirst("fluid", ""));
        IHLFluid instance = this;
        if (!FluidRegistry.registerFluid((Fluid)instance)) {
            instance = FluidRegistry.getFluid((String)this.type.fluidRegistryName);
        }
        localFluidRegistry.put(type1.fluidRegistryName, this);
        this.cell = new IHLItemCell(this.type.cellName, this.type.fluidRegistryName).func_77637_a(IHLCreativeTab.tab);
        OreDictionary.registerOre((String)("cell" + this.type.fluidName.replaceFirst("fluid", "")), (Item)this.cell);
        if (instance.getBlock() == null) {
            instance.setBlock(new BlockFluidRubberTreeSap(instance, this.type.blockMaterial, "fluid" + this.type.fluidName.replaceFirst("fluid", "")).func_149663_c("block" + this.type.fluidName).func_149647_a(IHLCreativeTab.tab));
        }
        if (this.type.haveBucket) {
            Item bucket = new ItemBucket(this.block).func_111206_d("ihl:bucket_" + this.type.fluidName).func_77655_b("bucket_" + this.type.fluidName).func_77637_a(IHLCreativeTab.tab);
            GameRegistry.registerItem((Item)bucket, (String)("bucket_" + this.type.fluidName));
            FluidContainerRegistry.registerFluidContainer((Fluid)instance, (ItemStack)new ItemStack(bucket), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        fluidInstances.add(instance);
    }

    public static void init() {
        Type[] var1 = Type.values();
        for (int i = 0; i < var1.length; ++i) {
            new IHLFluid(var1[i]);
        }
        condensationMap.put("steam", "ic2distilledwater");
        condensationMap.put("ic2steam", "ic2distilledwater");
        condensationMap.put("ic2superheatedsteam", "ic2distilledwater");
        condensationMap.put("vapour.sulfuricacid", "sulfuricacid");
        solutionMap.put("water", Arrays.asList("aquaregia", "sulfuricacid", "solution.nickelsulfate", "solution.bluevitriol"));
        solutionMap.put("ic2distilledwater", Arrays.asList("aquaregia", "sulfuricacid", "solution.nickelsulfate", "solution.bluevitriol"));
    }

    public static void registerIcons() {
        for (Fluid instance : fluidInstances) {
            instance.setIcons(instance.getBlock().func_149733_h(0), instance.getBlock().func_149733_h(1));
        }
    }

    public static ItemStack getCell(String fluidname) {
        return new ItemStack(IHLFluid.localFluidRegistry.get((Object)fluidname).cell);
    }

    public static int getMeltingPoint(Fluid fluid) {
        if (localFluidRegistry.get(fluid.getName()) != null) {
            IHLFluid ihlfluid = localFluidRegistry.get(fluid.getName());
            return ihlfluid.type.meltingPoint;
        }
        if (fluid.isGaseous()) {
            return fluid.getTemperature() > 100 ? fluid.getTemperature() - 100 : 0;
        }
        return fluid.getTemperature();
    }

    public static int getBoilingPoint(Fluid fluid) {
        if (localFluidRegistry.get(fluid.getName()) != null) {
            IHLFluid ihlfluid = localFluidRegistry.get(fluid.getName());
            return ihlfluid.type.boilingPoint;
        }
        if (fluid.getName() == "steam" || fluid.getName() == "ic2steam" || fluid.getName() == "ic2superheatedsteam") {
            return 373;
        }
        if (fluid.isGaseous()) {
            return fluid.getTemperature();
        }
        return fluid.getTemperature() + 100;
    }

    public static FluidStack getCondensationResult(FluidStack condensatedGas) {
        int quantity;
        String fluidname = condensationMap.get(condensatedGas.getFluid().getName());
        Fluid fluid = FluidRegistry.getFluid((String)fluidname);
        if (fluid != null && (quantity = Math.round((float)condensatedGas.amount * IHLFluid.getCondensationConversionRate(condensatedGas.getFluid()))) > 0) {
            return new FluidStack(fluid, quantity);
        }
        return null;
    }

    public static float getCondensationConversionRate(Fluid gas) {
        String fluidname = condensationMap.get(gas.getName());
        Fluid fluid = FluidRegistry.getFluid((String)fluidname);
        if (fluid != null) {
            float rate = (float)gas.getDensity() / (float)fluid.getDensity();
            if (gas.getDensity() < 0) {
                rate = -8000.0f / (float)gas.getDensity() / (float)fluid.getDensity();
            }
            return rate;
        }
        return 0.0f;
    }

    public static boolean canBeDissolvedIn(FluidStack solvent, String impurity) {
        return solutionMap.get(solvent.getFluid().getName()).contains(impurity);
    }

    public static enum Type {
        fluidRubberTreeSap("fluidRubberTreeSap", "itemCellRubberTreeSap", 293, 273, 393, 1200, true),
        SpruceResin("SpruceResin", 293, 273, 533, 1070, true),
        CablingColophony("CablingColophony", 363, 363, 533, 1070),
        Glyceryl("Glyceryl", 293, 291, 583, 1261),
        SeedOil("SeedOil", 293, 256, 583, 920),
        AquaRegia("AquaRegia", 293, 231, 356, 1060),
        SodiumPeroxide("SodiumPeroxide", 950, 950, 2223, 1800),
        OsmiumTetroxide("OsmiumTetroxide", 313, 313, 403, 9),
        OleicAcid("OleicAcid", 293, 288, 633, 895),
        Limemilk("Limemilk", 293, 253, 373, 1020),
        NickelSulfateDissolvedInWater("NickelSulfateDissolvedInWater", 293, 253, 373, 1220, "solution.nickelsulfate"),
        BlueVitriolDissolvedInWater("BlueVitriolDissolvedInWater", 293, 253, 373, 1180, "solution.bluevitriol"),
        MoltenSteel("MoltenSteel", 1800, 1800, 3134, 7800, "molten.steel", Material.field_151587_i),
        MoltenBronze("MoltenBronze", 940, 940, 2840, 8000, "molten.bronze", Material.field_151587_i),
        VapourSulfuricAcid("VapourSulfuricAcid", 610, 283, 610, 4, "vapour.sulfuricacid"),
        SulfuricAnhydride("SulfuricAnhydride", 45, 17, 45, 2, "sulfuricanhydride"),
        SulfuricAcid("SulfuricAcid", 293, 283, 610, 1836),
        NitricAcid("NitricAcid", 293, 231, 356, 1100);

        String fluidName;
        String fluidRegistryName;
        String cellName;
        int temperature;
        int density;
        boolean isGaseous;
        boolean haveBucket;
        Material blockMaterial = Material.field_151586_h;
        int meltingPoint;
        int boilingPoint;

        private Type(String fluidName1, int temperature1, int meltingPoint1, int boilingPoint1, int density1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = this.fluidName.toLowerCase();
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = false;
            this.isGaseous = density1 < 40;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
        }

        private Type(String fluidName1, int temperature1, int meltingPoint1, int boilingPoint1, int density1, String fluidRegistryName1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = fluidRegistryName1;
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = false;
            this.isGaseous = density1 < 40;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
        }

        private Type(String fluidName1, int temperature1, int meltingPoint1, int boilingPoint1, int density1, String fluidRegistryName1, Material blockMaterial1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = fluidRegistryName1;
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = false;
            this.isGaseous = density1 < 40;
            this.blockMaterial = blockMaterial1;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
        }

        private Type(String fluidName1, String cellName1, int temperature1, int meltingPoint1, int boilingPoint1, int density1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = this.fluidName.toLowerCase();
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = cellName1;
            this.haveBucket = false;
            this.isGaseous = density1 < 40;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
        }

        private Type(String fluidName1, String cellName1, int temperature1, int meltingPoint1, int boilingPoint1, int density1, boolean haveBucket1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = this.fluidName.toLowerCase();
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = cellName1;
            this.haveBucket = haveBucket1;
            this.isGaseous = density1 < 40;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
        }

        private Type(String fluidName1, int temperature1, int meltingPoint1, int boilingPoint1, int density1, boolean haveBucket1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = this.fluidName.toLowerCase();
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = haveBucket1;
            this.isGaseous = density1 < 40;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
        }

        private Type(String fluidName1, int density1, int meltingPoint1, int boilingPoint1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = this.fluidName.toLowerCase();
            this.temperature = 20;
            this.density = density1;
            this.cellName = "cell" + this.fluidName;
            this.haveBucket = false;
            this.isGaseous = density1 < 40;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
        }
    }
}

