/*
 * Decompiled with CFR 0.152.
 */
package com.chrislikesbirds.TileEntity;

import com.chrislikesbirds.Container.FurnaceContainer;
import com.chrislikesbirds.GUI.FurnaceGUI;
import com.chrislikesbirds.IC2.OutputUpgrade;
import com.chrislikesbirds.IC2.OverclockUpgrade;
import com.chrislikesbirds.Mod.Init;
import com.chrislikesbirds.ModUtils.Formater;
import com.chrislikesbirds.ModUtils.StackUtils;
import com.chrislikesbirds.TileEntity.TileEntityGUI;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class FurnaceTileEntity
extends TileEntity
implements IEnergyTile,
IEnergySink,
INetworkDataProvider,
INetworkUpdateListener,
IWrenchable,
IInventory,
ISidedInventory,
TileEntityGUI {
    boolean addedToENet;
    boolean loaded;
    boolean init;
    public int burnRate;
    public int energyCostTick;
    public int count;
    public int energyStored;
    public int maxEnergy;
    public int facing;
    public int lastX;
    public int lastY;
    public int lastZ;
    public int overclockedBurnRate;
    public int overclockedEnergyCostTick;
    ItemStack[] items = new ItemStack[4];

    public FurnaceTileEntity(int burnRate, int energyCostTick, int maxEnergy) {
        this.burnRate = burnRate;
        this.energyCostTick = energyCostTick;
        this.maxEnergy = maxEnergy;
        this.overclockedBurnRate = burnRate;
        this.overclockedEnergyCostTick = energyCostTick;
    }

    public static String getName() {
        return "tileEntityFurnace";
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || this.func_145831_w().func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void init() {
        this.init = true;
        if (!this.addedToENet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToENet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToENet = false;
        }
        this.loaded = false;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.init) {
            this.init();
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145848_d || this.lastY != this.field_145849_e) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.init();
        }
        if (this.items[2] != null && this.items[2].func_77973_b() instanceof OverclockUpgrade) {
            this.overclockedEnergyCostTick = (int)Math.ceil(OverclockUpgrade.getEnergyPerTick(this.items[2].field_77994_a, this.energyCostTick));
            this.overclockedBurnRate = (int)Math.ceil(OverclockUpgrade.getSpeed(this.items[2].field_77994_a, this.burnRate));
            if (this.overclockedBurnRate < 1) {
                this.overclockedBurnRate = 1;
            }
        } else if (this.items[2] == null) {
            this.overclockedBurnRate = this.burnRate;
            this.overclockedEnergyCostTick = this.energyCostTick;
        }
        if (this.items[3] != null && this.items[3].func_77973_b() instanceof OutputUpgrade) {
            TileEntity tile = null;
            switch (this.items[3].func_77960_j()) {
                case 1: {
                    tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                    break;
                }
                case 2: {
                    tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                    break;
                }
                case 3: {
                    tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                    break;
                }
                case 4: {
                    tile = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                    break;
                }
                case 5: {
                    tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                    break;
                }
                case 6: {
                    tile = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                }
            }
            if (tile != null && tile instanceof IInventory && this.items[1] != null) {
                this.items[1] = StackUtils.addToInventory(this.items[1], (IInventory)tile);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (this.energyStored >= this.energyCostTick && this.items[0] != null && FurnaceRecipes.func_77602_a().func_151395_a(this.items[0]) != null) {
            if (this.count >= this.overclockedBurnRate) {
                if (this.items[1] != null) {
                    if (FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.items[0]).field_77994_a + this.items[1].field_77994_a <= this.func_70297_j_() && FurnaceRecipes.func_77602_a().func_151395_a(this.items[0]).func_77969_a(this.items[1])) {
                        this.items[1] = new ItemStack(this.items[1].func_77973_b(), this.items[1].field_77994_a + FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.items[0]).field_77994_a, this.items[1].func_77960_j());
                        this.func_70298_a(0, 1);
                        if (this.items[0] != null) {
                            this.energyStored -= this.overclockedEnergyCostTick;
                            this.count = 1;
                        } else {
                            this.count = 0;
                        }
                    }
                } else if (FurnaceRecipes.func_77602_a().func_151395_a(this.items[0]) != null) {
                    this.func_70299_a(1, FurnaceRecipes.func_77602_a().func_151395_a(this.items[0]));
                    this.func_70298_a(0, 1);
                    if (this.items[0] != null) {
                        this.energyStored -= this.overclockedEnergyCostTick;
                        this.count = 1;
                    } else {
                        this.count = 0;
                    }
                }
            } else if (this.count <= this.overclockedBurnRate) {
                this.energyStored -= this.overclockedEnergyCostTick;
                ++this.count;
            }
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return this.maxEnergy - this.energyStored > 0 ? (double)(this.maxEnergy - this.energyStored) : 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energyStored = (int)((double)this.energyStored + amount);
        return 0.0;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != this.facing;
    }

    public short getFacing() {
        return (short)this.facing;
    }

    public void setFacing(short facing) {
        this.facing = facing;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)Init.fisher);
    }

    public void onNetworkUpdate(String field) {
    }

    public List<String> getNetworkedFields() {
        return Arrays.asList(new String[0]);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("storage", this.energyStored);
        nbt.func_74768_a("lastX", this.lastX);
        nbt.func_74768_a("lastY", this.lastY);
        nbt.func_74768_a("lastZ", this.lastZ);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74768_a("count", this.count);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStored = nbt.func_74762_e("storage");
        this.lastX = nbt.func_74762_e("lastX");
        this.lastY = nbt.func_74762_e("lastY");
        this.lastZ = nbt.func_74762_e("lastZ");
        this.count = nbt.func_74762_e("count");
        this.facing = nbt.func_74762_e("facing");
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.items.length) continue;
            this.items[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int gaugeEnergyScaled(int i) {
        int l = this.energyStored * i / this.maxEnergy;
        return l > i ? i : l;
    }

    public int gaugeBurn(int i) {
        return this.count * i / this.burnRate;
    }

    public String getEnergyString() {
        String message = this.energyStored != 0 ? Double.toString((double)this.energyStored / (double)this.maxEnergy * 100.0) : "0.0";
        return Formater.formatMessage("message.text.energy") + " : " + this.energyStored + "/" + this.maxEnergy + " " + (message.length() > 4 ? message.substring(0, 5) : message) + "%";
    }

    public int[] func_94128_d(int side) {
        int[] slots = new int[]{0, 1};
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.items[slot] != null) {
            if (this.items[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.items[slot].func_77946_l();
                this.items[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[slot].func_77979_a(amount);
            if (this.items[slot].field_77994_a == 0) {
                this.items[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] != null) {
            ItemStack item = this.items[slot].func_77946_l();
            this.items[slot] = null;
            return item;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.items[slot] = stack;
    }

    public String func_145825_b() {
        return "Furnace";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 16.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUI(InventoryPlayer playerInventory) {
        return new FurnaceGUI(this, playerInventory);
    }

    @Override
    public Object getGUIContainer(InventoryPlayer playerInventory) {
        return new FurnaceContainer(this, playerInventory);
    }
}

