/*
 * Decompiled with CFR 0.152.
 */
package com.chrislikesbirds.TileEntity;

import com.chrislikesbirds.ModUtils.Formater;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class WirelessChargerTileEntity
extends TileEntity
implements IEnergyTile,
IWrenchable,
IEnergySink,
INetworkTileEntityEventListener,
INetworkDataProvider,
INetworkUpdateListener {
    boolean addedToENet;
    boolean loaded;
    boolean init;
    public int energyStored;
    public int energyStorage;
    public int energyOutput;
    public int range;
    public int lastX;
    public int lastY;
    public int lastZ;

    public WirelessChargerTileEntity(int energyStorage, int energyOutput, int range) {
        this.energyStorage = energyStorage;
        this.energyOutput = energyOutput;
        this.range = range;
    }

    public static String getName() {
        return "tileWirelessCharger";
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || this.func_145831_w().func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void init() {
        this.init = true;
        if (!this.addedToENet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToENet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToENet = false;
        }
        this.loaded = false;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.init) {
            this.init();
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145848_d || this.lastY != this.field_145849_e) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.init();
        }
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.range), (double)(this.field_145848_d - this.range), (double)(this.field_145849_e - this.range), (double)(this.field_145851_c + this.range), (double)(this.field_145848_d + this.range), (double)(this.field_145849_e + this.range)));
        int energyOut = 0;
        for (EntityPlayer player : players) {
            InventoryPlayer inventory = player.field_71071_by;
            for (ItemStack is : inventory.field_70460_b) {
                if (is == null || is.func_77973_b() == null || !(is.func_77973_b() instanceof IElectricItem) || this.energyStored < this.energyOutput) continue;
                double out = ElectricItem.manager.charge(is, (double)this.energyOutput, 4, false, false);
                this.energyStored = (int)((double)this.energyStored - out);
                energyOut = (int)out;
            }
            for (ItemStack is : inventory.field_70462_a) {
                if (is == null || is.func_77973_b() == null || !(is.func_77973_b() instanceof IElectricItem) || this.energyStored < this.energyOutput) continue;
                this.energyStored = (int)((double)this.energyStored - ElectricItem.manager.charge(is, (double)(this.energyOutput - energyOut), 4, false, false));
            }
        }
    }

    public void onNetworkEvent(int event) {
    }

    public void onNetworkUpdate(String field) {
    }

    public List<String> getNetworkedFields() {
        return Arrays.asList(new String[0]);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public short getFacing() {
        return 0;
    }

    public void setFacing(short facing) {
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return this.energyStorage - this.energyStored > 0 ? (double)(this.energyStorage - this.energyStored) : 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energyStored = (int)((double)this.energyStored + amount);
        return 0.0;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("storage", this.energyStored);
        nbt.func_74768_a("lastX", this.lastX);
        nbt.func_74768_a("lastY", this.lastY);
        nbt.func_74768_a("lastZ", this.lastZ);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStored = nbt.func_74762_e("storage");
        this.lastX = nbt.func_74762_e("lastX");
        this.lastY = nbt.func_74762_e("lastY");
        this.lastZ = nbt.func_74762_e("lastZ");
    }

    public String getEnergyString() {
        String message = this.energyStored != 0 ? Double.toString((double)this.energyStored / (double)this.energyStorage * 100.0) : "0.0";
        return Formater.formatMessage("message.text.energy") + " : " + this.energyStored + "/" + this.energyStorage + " " + (message.length() > 4 ? message.substring(0, 5) : message) + "%";
    }
}

