/*
 * Decompiled with CFR 0.152.
 */
package com.chrislikesbirds.TileEntity;

import com.chrislikesbirds.Container.CarbonCrystalizerContainer;
import com.chrislikesbirds.GUI.CarbonCrystalizerGUI;
import com.chrislikesbirds.Mod.Init;
import com.chrislikesbirds.ModUtils.Formater;
import com.chrislikesbirds.TileEntity.TileEntityGUI;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import scala.actors.threadpool.Arrays;

public class CarbonCrystalizerTileEntity
extends TileEntity
implements IEnergyTile,
IWrenchable,
IEnergySink,
IInventory,
INetworkTileEntityEventListener,
INetworkDataProvider,
INetworkUpdateListener,
TileEntityGUI,
IFluidHandler {
    boolean addedToENet = false;
    boolean loaded = false;
    boolean init = false;
    boolean formed = false;
    public int uuPerMatter;
    public int energyPerTick;
    public int tickPerMatter;
    public int energyStorage;
    public int energyStored;
    public int count;
    public int lastX;
    public int lastY;
    public int lastZ;
    ItemStack[] items = new ItemStack[2];
    public FluidTank uuTank;

    public CarbonCrystalizerTileEntity(int uuPerMatter, int energyPerTick, int tickPerMatter, int energyStorage, int tankSize) {
        this.uuPerMatter = uuPerMatter;
        this.energyPerTick = energyPerTick;
        this.tickPerMatter = tickPerMatter;
        this.energyStorage = energyStorage;
        this.uuTank = new FluidTank(tankSize * 1000);
    }

    public static String getName() {
        return "tileEntityCarbonCrystalizer";
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || this.func_145831_w().func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void init() {
        this.init = true;
        if (!this.addedToENet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToENet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToENet = false;
        }
        this.loaded = false;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.init) {
            this.init();
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145848_d || this.lastY != this.field_145849_e) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.init();
        }
        if (this.energyStored >= this.energyPerTick && this.formed) {
            if (this.count == this.tickPerMatter && this.uuTank.getFluidAmount() >= this.uuPerMatter) {
                if (this.items[0] == null) {
                    this.items[0] = new ItemStack((Item)Init.carbonNanotube, 1);
                    this.uuTank.drain(this.uuPerMatter, true);
                    this.count = 0;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else if (this.items[0].field_77994_a < 64 && this.items[0].func_77969_a(new ItemStack((Item)Init.matter))) {
                    ++this.items[0].field_77994_a;
                    this.uuTank.drain(this.uuPerMatter, true);
                    this.count = 0;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (this.count < this.tickPerMatter) {
                ++this.count;
                this.energyStored -= this.energyPerTick;
            }
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUI(InventoryPlayer inventory) {
        return new CarbonCrystalizerGUI(this, inventory);
    }

    @Override
    public Object getGUIContainer(InventoryPlayer inventory) {
        return new CarbonCrystalizerContainer(this, inventory);
    }

    public void onNetworkUpdate(String field) {
    }

    public List<String> getNetworkedFields() {
        return Arrays.asList((Object[])new Object[0]);
    }

    public void onNetworkEvent(int event) {
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.items[slot] != null) {
            if (this.items[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.items[slot].func_77946_l();
                this.items[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[slot].func_77979_a(amount);
            if (this.items[slot].field_77994_a == 0) {
                // empty if block
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] != null) {
            ItemStack itemsC = this.items[slot].func_77946_l();
            this.items = null;
            return itemsC;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.items[slot] = stack;
    }

    public String func_145825_b() {
        return "UU Crystalizer";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 16.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public double getDemandedEnergy() {
        return this.energyStorage - this.energyStored > 0 ? (double)(this.energyStorage - this.energyStored) : 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energyStored = (int)((double)this.energyStored + amount);
        return this.energyStored;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public short getFacing() {
        return 0;
    }

    public void setFacing(short facing) {
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.uuTank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return resource != null && resource.isFluidEqual(this.uuTank.getFluid()) ? (!this.canDrain(from, resource.getFluid()) ? null : this.uuTank.drain(resource.amount, doDrain)) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.uuTank.drain(maxDrain, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.uuTank.getInfo()};
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.getName().equals("ic2uumatter");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("storage", this.energyStored);
        nbt.func_74768_a("lastX", this.lastX);
        nbt.func_74768_a("lastY", this.lastY);
        nbt.func_74768_a("lastZ", this.lastZ);
        nbt.func_74768_a("count", this.count);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        NBTTagCompound nbtFluid = new NBTTagCompound();
        if (this.uuTank != null) {
            this.uuTank.writeToNBT(nbtFluid);
        }
        nbt.func_74782_a("Fluid", (NBTBase)nbtFluid);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStored = nbt.func_74762_e("storage");
        this.lastX = nbt.func_74762_e("lastX");
        this.lastY = nbt.func_74762_e("lastY");
        this.lastZ = nbt.func_74762_e("lastZ");
        this.count = nbt.func_74762_e("count");
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.items.length) continue;
            this.items[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        NBTTagCompound nbtTagFluid = nbt.func_74775_l("Fluid");
        this.uuTank = this.uuTank.readFromNBT(nbtTagFluid);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int gaugeEnergyScaled(int i) {
        int l = this.energyStored * i / this.energyStorage;
        return l > i ? i : l;
    }

    public int gaugeFluidScaled(int i) {
        int l = this.uuTank.getFluidAmount() * i / this.uuTank.getCapacity();
        return l > i ? i : l;
    }

    public String getEnergyString() {
        String message = this.energyStored != 0 ? Double.toString((double)this.energyStored / (double)this.energyStorage * 100.0) : "0.0";
        return Formater.formatMessage("message.text.energy") + " : " + this.energyStored + "/" + this.energyStorage + " " + (message.length() > 4 ? message.substring(0, 5) : message) + "%";
    }

    public String getUUString() {
        return this.uuTank.getFluidAmount() + "mB/" + this.uuTank.getCapacity() + "mB";
    }
}

