/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.worldModifier.common.helper;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import speiger.src.worldModifier.common.helper.WorldConfig;

public class WorldGenHelper {
    List<DecorateBiomeEvent.Decorate.EventType> allowedDecorations = Arrays.asList(DecorateBiomeEvent.Decorate.EventType.CLAY, DecorateBiomeEvent.Decorate.EventType.LAKE, DecorateBiomeEvent.Decorate.EventType.SAND, DecorateBiomeEvent.Decorate.EventType.SAND_PASS2, DecorateBiomeEvent.Decorate.EventType.CUSTOM);
    static HashMap<Material, Block> replacements = new HashMap();
    static HashMap<World, WorldHandler> worlds = new HashMap();
    static List<Integer> invalidBlocks = Arrays.asList(WorldGenHelper.getID(Blocks.field_150364_r), WorldGenHelper.getID(Blocks.field_150363_s), WorldGenHelper.getID((Block)Blocks.field_150362_t), WorldGenHelper.getID((Block)Blocks.field_150361_u), WorldGenHelper.getID((Block)Blocks.field_150398_cm), WorldGenHelper.getID(Blocks.field_150420_aW), WorldGenHelper.getID((Block)Blocks.field_150338_P), WorldGenHelper.getID(Blocks.field_150419_aX), WorldGenHelper.getID((Block)Blocks.field_150337_Q));

    static int getID(Block par1) {
        return Block.func_149682_b((Block)par1);
    }

    public WorldGenHelper() {
        replacements.put(Material.field_151577_b, Blocks.field_150346_d);
        replacements.put(Material.field_151585_k, Blocks.field_150350_a);
        replacements.put(Material.field_151570_A, Blocks.field_150350_a);
        replacements.put(Material.field_151589_v, Blocks.field_150350_a);
        replacements.put(Material.field_151596_z, Blocks.field_150350_a);
        replacements.put(Material.field_151584_j, Blocks.field_150350_a);
        replacements.put(Material.field_151597_y, Blocks.field_150350_a);
        replacements.put(Material.field_151582_l, Blocks.field_150350_a);
        replacements.put(Material.field_151575_d, Blocks.field_150350_a);
    }

    private boolean isOverworld(World world) {
        if (world == null) {
            return false;
        }
        return world.field_73011_w.field_76574_g == 0;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChunkDecorate(DecorateBiomeEvent.Decorate evt) {
        DecorateBiomeEvent.Decorate.EventType type = evt.type;
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && this.isOverworld(evt.world) && !this.allowedDecorations.contains(type)) {
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBiomeGenerate(ChunkProviderEvent.ReplaceBiomeBlocks evt) {
        BiomeGenBase[] gen;
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && (gen = evt.biomeArray) != null && gen.length > 0) {
            for (int i = 0; i < gen.length; ++i) {
                BiomeGenBase biome = gen[i];
                if (biome.field_76752_A != Blocks.field_150349_c) continue;
                biome.field_76752_A = Blocks.field_150346_d;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChunkPopulated(PopulateChunkEvent.Post evt) {
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && this.isOverworld(evt.world)) {
            this.getHandler(evt.world).addChunkToCheck(new ChunkCoordIntPair(evt.chunkX, evt.chunkZ));
            int xCoord = evt.chunkX * 16;
            int zCoord = evt.chunkZ * 16;
            for (int x = xCoord; x < xCoord + 16; ++x) {
                for (int y = 0; y < 256; ++y) {
                    for (int z = zCoord; z < zCoord + 16; ++z) {
                        Block block = evt.world.func_147439_a(x, y, z);
                        boolean did = false;
                        if (replacements.containsKey(block.func_149688_o())) {
                            evt.world.func_147465_d(x, y, z, replacements.get(block.func_149688_o()), 0, 0);
                            did = true;
                        }
                        if (!invalidBlocks.contains(Block.func_149682_b((Block)block)) || did) continue;
                        evt.world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 0);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChunkPopulate(PopulateChunkEvent.Populate evt) {
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && this.isOverworld(evt.world) && evt.type == PopulateChunkEvent.Populate.EventType.LAKE) {
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTick(TickEvent.WorldTickEvent evt) {
        if (evt.side == Side.CLIENT || evt.world.field_73011_w.field_76574_g != 0 || evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && this.isOverworld(evt.world)) {
            this.getHandler(evt.world).handleChunk();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldUnload(WorldEvent.Unload evt) {
        worlds.remove(evt.world);
    }

    private WorldHandler getHandler(World world) {
        if (!worlds.containsKey(world)) {
            worlds.put(world, new WorldHandler(world));
        }
        return worlds.get(world);
    }

    public static class ChunkContainer {
        ChunkCoordIntPair chunk;
        int times = 0;
    }

    public static class WorldHandler {
        ArrayList<ChunkContainer> chunksToCheck = new ArrayList();
        World world;

        public WorldHandler(World par1) {
            this.world = par1;
        }

        public void addChunkToCheck(ChunkCoordIntPair par1) {
            ChunkContainer cont = new ChunkContainer();
            cont.chunk = par1;
            cont.times = 0;
            this.chunksToCheck.add(cont);
        }

        public void handleChunk() {
            if (this.chunksToCheck.size() > 0) {
                ChunkContainer cu = this.chunksToCheck.remove(0);
                if (this.checkChunk(cu.chunk.field_77276_a, cu.chunk.field_77275_b) && cu.times++ < 5) {
                    this.chunksToCheck.add(cu);
                }
            }
        }

        boolean checkChunk(int chunkX, int chunkZ) {
            int xCoord = chunkX * 16;
            int zCoord = chunkZ * 16;
            int found = 0;
            for (int x = xCoord; x < xCoord + 16; ++x) {
                for (int y = 0; y < 256; ++y) {
                    for (int z = zCoord; z < zCoord + 16; ++z) {
                        Block block = this.world.func_147439_a(x, y, z);
                        boolean flag = false;
                        if (replacements.containsKey(block.func_149688_o())) {
                            flag = true;
                            ++found;
                            this.world.func_147465_d(x, y, z, replacements.get(block.func_149688_o()), 0, 0);
                        }
                        if (!invalidBlocks.contains(Block.func_149682_b((Block)block)) || flag) continue;
                        ++found;
                        this.world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 0);
                    }
                }
            }
            return found > 0;
        }
    }
}

