/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.api.common.world.blocks;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import speiger.src.api.common.world.blocks.BlockStack;

public class BlockPosition
implements IBlockSource {
    public World worldID;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public ForgeDirection facing;

    public BlockPosition(List<Integer> par1) {
        this(par1.get(0), (int)par1.get(1), (int)par1.get(2), (int)par1.get(3));
    }

    public BlockPosition(NBTTagCompound par1) {
        this(par1.func_74762_e("World"), par1.func_74762_e("xCoord"), par1.func_74762_e("yCoord"), par1.func_74762_e("zCoord"));
    }

    public BlockPosition(int dimID, int x, int y, int z) {
        this((World)DimensionManager.getWorld((int)dimID), x, y, z);
    }

    public BlockPosition(World world, int x, int y, int z, ForgeDirection face) {
        this(world, x, y, z);
        this.facing = face;
    }

    public BlockPosition(World world, int x, int y, int z) {
        this(x, y, z);
        this.worldID = world;
    }

    public BlockPosition(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public BlockPosition(TileEntity tile) {
        this(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public BlockStack getAsBlockStack() {
        return new BlockStack((IBlockAccess)this.worldID, this.xCoord, this.yCoord, this.zCoord);
    }

    public List<Integer> getAsList() {
        if (this.worldID == null) {
            return Arrays.asList(0, 0, -1, 0);
        }
        return Arrays.asList(this.worldID.field_73011_w.field_76574_g, this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean doesBlockExsist() {
        if (this.worldID.func_72899_e(this.xCoord, this.yCoord, this.zCoord)) {
            return this.getBlockID() > 0;
        }
        return false;
    }

    public int func_82620_h() {
        return this.func_82618_k().func_72805_g(this.xCoord, this.yCoord, this.zCoord);
    }

    public int getBlockID() {
        return Block.func_149682_b((Block)this.getBlock());
    }

    public Block getBlock() {
        return this.func_82618_k().func_147439_a(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean isThisBlock(BlockStack block, boolean meta) {
        if (meta) {
            return this.getBlockID() == block.getBlockID() && this.func_82620_h() == block.getMeta();
        }
        return this.getBlockID() == block.getBlockID();
    }

    public boolean isAirBlock() {
        return this.worldID.func_147437_c(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean isThisPosition(BlockPosition par1) {
        return par1 != null && this.worldID.field_73011_w.field_76574_g == par1.worldID.field_73011_w.field_76574_g && this.xCoord == par1.xCoord && this.yCoord == par1.yCoord && par1.zCoord == this.zCoord;
    }

    public boolean setBlock(BlockStack par1) {
        return this.worldID.func_147465_d(this.xCoord, this.yCoord, this.zCoord, par1.getBlock(), par1.getMeta(), 3);
    }

    public boolean hasTileEntity() {
        return this.getTileEntity() != null;
    }

    public int getXCoord() {
        return this.xCoord;
    }

    public int getYCoord() {
        return this.yCoord;
    }

    public int getZCoord() {
        return this.zCoord;
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    public TileEntity getTileEntity() {
        return this.func_82618_k().func_147438_o(this.xCoord, this.yCoord, this.zCoord);
    }

    public World func_82618_k() {
        return this.worldID;
    }

    public void remove() {
        this.worldID.func_147468_f(this.xCoord, this.yCoord, this.zCoord);
    }

    public void writeToNBT(NBTTagCompound par1) {
        par1.func_74768_a("World", this.worldID.field_73011_w.field_76574_g);
        par1.func_74768_a("xCoord", this.xCoord);
        par1.func_74768_a("yCoord", this.yCoord);
        par1.func_74768_a("zCoord", this.zCoord);
    }

    public BlockPosition getPosFromSide(int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        return this.getPosFromFSide(direction);
    }

    public BlockPosition getPosFromFSide(ForgeDirection direction) {
        return new BlockPosition(this.worldID, this.xCoord + direction.offsetX, this.yCoord + direction.offsetY, this.zCoord + direction.offsetZ);
    }

    public boolean isBlockAir() {
        BlockStack stack = this.getAsBlockStack();
        return stack != null && stack.getBlock() != null && stack.getBlock().isAir((IBlockAccess)this.worldID, this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean isBlockFull() {
        BlockStack stack = this.getAsBlockStack();
        return stack == null || stack.getBlock() == null || !stack.getBlock().func_149662_c();
    }

    public BlockPosition copy() {
        return new BlockPosition(this.worldID, this.xCoord, this.yCoord, this.zCoord);
    }

    public int getDimensionID() {
        return this.worldID.field_73011_w.field_76574_g;
    }

    public boolean worldPositionMatch(BlockPosition par1) {
        return this.getDimensionID() == par1.getDimensionID() && this.getXCoord() == par1.getXCoord() && this.getZCoord() == par1.getZCoord();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockPosition)) {
            return false;
        }
        BlockPosition pos = (BlockPosition)obj;
        return this.isThisPosition(pos);
    }

    public int hashCode() {
        return this.worldID.field_73011_w.field_76574_g + this.xCoord + this.yCoord + this.zCoord;
    }

    public BlockPosition add(int x, int y, int z) {
        BlockPosition pos = this.copy();
        pos.xCoord += x;
        pos.yCoord += y;
        pos.zCoord += z;
        return pos;
    }

    public int getDistanceSq(BlockPosition pos) {
        int d3 = this.xCoord - pos.xCoord;
        int d4 = this.yCoord - pos.yCoord;
        int d5 = this.zCoord - pos.zCoord;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public int getDistance(BlockPosition pos) {
        int d3 = this.xCoord - pos.xCoord;
        int d4 = this.yCoord - pos.yCoord;
        int d5 = this.zCoord - pos.zCoord;
        return new Double(MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5))).intValue();
    }

    public BlockPosition add(ForgeDirection dir) {
        return this.add(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public BlockPosition add(ForgeDirection ... par1) {
        BlockPosition pos = this.copy();
        for (ForgeDirection dir : par1) {
            pos = pos.add(dir);
        }
        return pos;
    }

    public double func_82615_a() {
        return this.xCoord;
    }

    public double func_82617_b() {
        return this.yCoord;
    }

    public double func_82616_c() {
        return this.zCoord;
    }

    public int func_82623_d() {
        return this.xCoord;
    }

    public int func_82622_e() {
        return this.yCoord;
    }

    public int func_82621_f() {
        return this.zCoord;
    }

    public TileEntity func_150835_j() {
        return this.getTileEntity();
    }

    public boolean match(List<Integer> list) {
        return this.worldID.field_73011_w.field_76574_g == list.get(0) && this.xCoord == list.get(1) && this.yCoord == list.get(2) && this.zCoord == list.get(3);
    }
}

