/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.api.common.world.blocks;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import speiger.src.api.common.world.blocks.BlockPosition;

public class BlockStack {
    public static final Random rand = new Random();
    Block blocks;
    int meta;

    public BlockStack() {
        this.blocks = null;
        this.meta = 0;
    }

    public BlockStack(TileEntity par1) {
        this(par1.func_145838_q(), par1.func_145832_p());
    }

    public BlockStack(ItemStack par1) {
        this(((ItemBlock)par1.func_77973_b()).field_150939_a, par1.func_77973_b().func_77647_b(par1.func_77960_j()));
    }

    public BlockStack(Block block) {
        this(block, 0);
    }

    public BlockStack(int id) {
        this(Block.func_149729_e((int)id));
    }

    public BlockStack(IBlockAccess world, int x, int y, int z) {
        this(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
    }

    public BlockStack(int id, int meta) {
        this(Block.func_149729_e((int)id), meta);
    }

    public BlockStack(BlockStack block) {
        this(block.blocks, block.meta);
    }

    public BlockStack(ItemBlock par1) {
        this(par1.field_150939_a);
    }

    public BlockStack(IBlockAccess world, int x, int y, int z, boolean removeAir) {
        this(world, x, y, z);
        if (removeAir && world.func_147437_c(x, y, z)) {
            this.blocks = null;
        }
    }

    public BlockStack(Block block, int metadata) {
        this.blocks = block;
        this.meta = metadata;
    }

    public ItemStack asItemStack() {
        return new ItemStack(this.blocks, 1, this.meta);
    }

    public ItemStack getAsDroppedStack() {
        if (this.blocks == null) {
            return null;
        }
        Item id = this.blocks.func_149650_a(this.meta, rand, 0);
        if (id == null) {
            return null;
        }
        return new ItemStack(id, 1, this.blocks.func_149692_a(this.meta));
    }

    public ItemStack getAsDroppedStack(BlockPosition par1) {
        if (this.blocks == null) {
            return this.asItemStack();
        }
        ArrayList stack = this.blocks.getDrops(par1.func_82618_k(), par1.getXCoord(), par1.getYCoord(), par1.getZCoord(), this.meta, 0);
        if (stack == null) {
            return this.asItemStack();
        }
        return (ItemStack)stack.get(0);
    }

    public Block getBlock() {
        return this.blocks;
    }

    public int getBlockID() {
        if (this.blocks == null) {
            return 0;
        }
        return Block.func_149682_b((Block)this.blocks);
    }

    public int getMeta() {
        return this.meta;
    }

    public <T> T getCastedBlock(Class<T> classToCast) {
        return (T)this.blocks;
    }

    public IIcon getTexture(int side) {
        return this.blocks.func_149691_a(side, this.meta);
    }

    public String getBlockDisplayName() {
        if (this.blocks == null) {
            return "No Block!";
        }
        ItemStack stack = new ItemStack(this.blocks, 1, this.meta);
        Item item = stack.func_77973_b();
        return item.func_77653_i(stack);
    }

    public String getDroppedBlockDisplayName() {
        if (this.blocks == null) {
            return "No Block!";
        }
        Item id = this.blocks.func_149650_a(this.meta, rand, 0);
        if (id == null) {
            return "No Block!";
        }
        ItemStack result = new ItemStack(id, 1, this.blocks.func_149692_a(this.meta));
        return result.func_82833_r();
    }

    public String getPickedBlockDisplayName(BlockPosition pos, int side) {
        return this.getPicketBlock(pos, side).func_82833_r();
    }

    public String getDroppedBlockDisplayName(BlockPosition par1) {
        if (this.blocks == null || par1 == null) {
            return "No Block!";
        }
        ArrayList drops = this.blocks.getDrops(par1.func_82618_k(), par1.getXCoord(), par1.getYCoord(), par1.getZCoord(), this.meta, 0);
        if (drops == null || drops.size() <= 0) {
            return "No Block!";
        }
        ItemStack stack = (ItemStack)drops.get(0);
        if (stack == null) {
            return "No Block!";
        }
        return stack.func_82833_r();
    }

    public String getHiddenName() {
        if (this.blocks == null) {
            return "No Block!";
        }
        ItemStack stack = new ItemStack(this.blocks, 1, this.meta);
        return stack.func_77977_a();
    }

    public boolean match(BlockStack block) {
        return block.blocks == this.blocks && block.meta == this.meta;
    }

    public boolean placeBlock(World world, int x, int y, int z) {
        return world.func_147465_d(x, y, z, this.blocks, this.meta, 3);
    }

    public ItemStack getPicketBlock(BlockPosition pos, int side) {
        return this.blocks.getPickBlock(new MovingObjectPosition(pos.getXCoord(), pos.getYCoord(), pos.getZCoord(), side, Vec3.func_72443_a((double)pos.getXCoord(), (double)pos.getYCoord(), (double)pos.getZCoord())), pos.func_82618_k(), pos.getXCoord(), pos.getYCoord(), pos.getZCoord());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockStack)) {
            return false;
        }
        BlockStack stack = (BlockStack)obj;
        return stack.match(this);
    }

    public int hashCode() {
        return this.getBlockID() + this.getMeta();
    }
}

