/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.api.common.registry.helpers;

import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import java.util.Collection;
import java.util.HashMap;
import speiger.src.api.common.registry.helpers.SpmodMod;
import speiger.src.api.common.utils.LogProxy;

public class SpmodModRegistry {
    private static HashMap<String, SpmodMod> addons = new HashMap();
    private static LogProxy defaultProxy;

    public static void registerMod(SpmodMod par1) {
        if (par1.getClass().isAnnotationPresent(Mod.class) && !Strings.isNullOrEmpty((String)par1.getName())) {
            addons.put(par1.getName(), par1);
        } else {
            FMLLog.getLogger().info(par1.getName() + " Is not a valid SpmodMod, He will not registered");
        }
    }

    public static boolean isModRegistered(SpmodMod par1) {
        return addons.containsValue(par1);
    }

    public static boolean areModsEqual(SpmodMod par1, SpmodMod par2) {
        if (!SpmodModRegistry.isModRegistered(par1) || !SpmodModRegistry.isModRegistered(par2)) {
            return false;
        }
        return par1.getName().equalsIgnoreCase(par2.getName());
    }

    public static SpmodMod getModFromName(String name) {
        return addons.get(name);
    }

    public static Collection<SpmodMod> getRegisteredMods() {
        return addons.values();
    }

    public static LogProxy getDefaultProxy(SpmodMod par1) {
        if (!SpmodModRegistry.isModRegistered(par1)) {
            return null;
        }
        return defaultProxy;
    }

    static {
        FakeSpmodMod fakeMod = new FakeSpmodMod();
        addons.put("Spmod Mod", fakeMod);
        defaultProxy = new LogProxy(fakeMod);
    }

    static class FakeSpmodMod
    implements SpmodMod {
        FakeSpmodMod() {
        }

        @Override
        public String getName() {
            return "Spmod Mod";
        }

        @Override
        public LogProxy getLogger() {
            return defaultProxy;
        }
    }
}

