/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.worldModifier.common.helper;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import speiger.src.worldModifier.WorldModifier;
import speiger.src.worldModifier.common.helper.WorldConfig;

public class WorldGenHelper {
    List<DecorateBiomeEvent.Decorate.EventType> allowedDecorations = Arrays.asList(DecorateBiomeEvent.Decorate.EventType.CLAY, DecorateBiomeEvent.Decorate.EventType.LAKE, DecorateBiomeEvent.Decorate.EventType.SAND, DecorateBiomeEvent.Decorate.EventType.SAND_PASS2, DecorateBiomeEvent.Decorate.EventType.CUSTOM);
    static HashMap<Material, Block> replacements = new HashMap();

    static int getID(Block par1) {
        return Block.func_149682_b((Block)par1);
    }

    public WorldGenHelper() {
        replacements.put(Material.field_151577_b, WorldModifier.dirt);
        replacements.put(Material.field_151585_k, Blocks.field_150350_a);
        replacements.put(Material.field_151570_A, Blocks.field_150350_a);
        replacements.put(Material.field_151589_v, Blocks.field_150350_a);
        replacements.put(Material.field_151584_j, Blocks.field_150350_a);
        replacements.put(Material.field_151582_l, Blocks.field_150350_a);
        replacements.put(Material.field_151575_d, Blocks.field_150350_a);
    }

    private boolean isOverworld(World world) {
        if (world == null) {
            return false;
        }
        return world.field_73011_w.field_76574_g == 0;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChunkDecorate(DecorateBiomeEvent.Decorate evt) {
        DecorateBiomeEvent.Decorate.EventType type = evt.type;
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && this.isOverworld(evt.world) && !this.allowedDecorations.contains(type)) {
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBiomeGenerate(ChunkProviderEvent.ReplaceBiomeBlocks evt) {
        BiomeGenBase[] gen;
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && (gen = evt.biomeArray) != null && gen.length > 0) {
            for (int i = 0; i < gen.length; ++i) {
                BiomeGenBase biome = gen[i];
                if (biome.field_76752_A != Blocks.field_150349_c) continue;
                biome.field_76752_A = WorldModifier.dirt;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChunkPopulated(PopulateChunkEvent.Post evt) {
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && this.isOverworld(evt.world)) {
            int xCoord = evt.chunkX * 16;
            int zCoord = evt.chunkZ * 16;
            for (int x = xCoord; x < xCoord + 16; ++x) {
                for (int y = 0; y < 256; ++y) {
                    for (int z = zCoord; z < zCoord + 16; ++z) {
                        Block block = evt.world.func_147439_a(x, y, z);
                        if (!replacements.containsKey(block.func_149688_o())) continue;
                        evt.world.func_147465_d(x, y, z, replacements.get(block.func_149688_o()), 0, 0);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChunkPopulate(PopulateChunkEvent.Populate evt) {
        if (WorldConfig.bConfigs.get("Overworld").booleanValue() && this.isOverworld(evt.world) && evt.type == PopulateChunkEvent.Populate.EventType.LAKE) {
            evt.setResult(Event.Result.DENY);
        }
    }
}

