/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

public class GT_RenderedTexture
implements ITexture,
IColorModulationContainer {
    private final IIconContainer mIconContainer;
    public short[] mRGBa;
    private final boolean mAllowAlpha;

    public GT_RenderedTexture(IIconContainer aIcon, short[] aRGBa, boolean aAllowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_RenderedTexture");
        }
        this.mIconContainer = aIcon;
        this.mAllowAlpha = aAllowAlpha;
        this.mRGBa = aRGBa;
    }

    public GT_RenderedTexture(IIconContainer aIcon, short[] aRGBa) {
        this(aIcon, aRGBa, true);
    }

    public GT_RenderedTexture(IIconContainer aIcon) {
        this(aIcon, Dyes._NULL.mRGBa);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.6f), (int)((float)this.mRGBa[1] * 0.6f), (int)((float)this.mRGBa[2] * 0.6f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78370_a(153, 153, 153, 255);
            aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.6f), (int)((float)this.mRGBa[1] * 0.6f), (int)((float)this.mRGBa[2] * 0.6f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78370_a(153, 153, 153, 255);
            aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 1.0f), (int)((float)this.mRGBa[1] * 1.0f), (int)((float)this.mRGBa[2] * 1.0f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78370_a(255, 255, 255, 255);
            aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.5f), (int)((float)this.mRGBa[1] * 0.5f), (int)((float)this.mRGBa[2] * 0.5f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        IIcon aIcon = this.mIconContainer.getIcon();
        double d3 = aIcon.func_94214_a(aRenderer.field_147861_i * 16.0);
        double d4 = aIcon.func_94214_a(aRenderer.field_147859_h * 16.0);
        double d5 = aIcon.func_94207_b(aRenderer.field_147851_l * 16.0);
        double d6 = aIcon.func_94207_b(aRenderer.field_147853_m * 16.0);
        if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
            d3 = aIcon.func_94212_f();
            d4 = aIcon.func_94209_e();
        }
        if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
            d5 = aIcon.func_94206_g();
            d6 = aIcon.func_94210_h();
        }
        double d11 = (double)aX + aRenderer.field_147859_h;
        double d12 = (double)aX + aRenderer.field_147861_i;
        double d13 = (double)aY + aRenderer.field_147855_j;
        double d14 = (double)aZ + aRenderer.field_147851_l;
        double d15 = (double)aZ + aRenderer.field_147853_m;
        Tessellator.field_78398_a.func_78374_a(d11, d13, d15, d3, d6);
        Tessellator.field_78398_a.func_78374_a(d11, d13, d14, d3, d5);
        Tessellator.field_78398_a.func_78374_a(d12, d13, d14, d4, d5);
        Tessellator.field_78398_a.func_78374_a(d12, d13, d15, d4, d6);
        aIcon = this.mIconContainer.getOverlayIcon();
        if (aIcon != null) {
            Tessellator.field_78398_a.func_78370_a(128, 128, 128, 255);
            Tessellator.field_78398_a.func_78374_a(d11, d13, d15, d3, d6);
            Tessellator.field_78398_a.func_78374_a(d11, d13, d14, d3, d5);
            Tessellator.field_78398_a.func_78374_a(d12, d13, d14, d4, d5);
            Tessellator.field_78398_a.func_78374_a(d12, d13, d15, d4, d6);
        }
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.8f), (int)((float)this.mRGBa[1] * 0.8f), (int)((float)this.mRGBa[2] * 0.8f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78370_a(204, 204, 204, 255);
            aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator.field_78398_a.func_78370_a((int)((float)this.mRGBa[0] * 0.8f), (int)((float)this.mRGBa[1] * 0.8f), (int)((float)this.mRGBa[2] * 0.8f), this.mAllowAlpha ? 255 - this.mRGBa[3] : 255);
        aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78370_a(204, 204, 204, 255);
            aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }
}

