/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.GT_FluidStack;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class GT_Recipe {
    public static volatile int VERSION = 508;
    public ItemStack[] mInputs;
    public ItemStack[] mOutputs;
    public FluidStack[] mFluidInputs;
    public FluidStack[] mFluidOutputs;
    public int[] mChances;
    public Object mSpecialItems;
    public int mDuration;
    public int mEUt;
    public int mSpecialValue;
    public boolean mEnabled;
    public boolean mHidden;
    public boolean mFakeRecipe;
    public boolean mCanBeBuffered;
    public boolean mNeedsEmptyOutput;

    public static void reInit() {
        GT_Log.out.println("GT_Mod: Re-Unificating Recipes.");
        for (GT_Recipe_Map tMapEntry : GT_Recipe_Map.sMappings) {
            tMapEntry.reInit();
        }
    }

    public ItemStack getRepresentativeInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mInputs.length) {
            return null;
        }
        return GT_Utility.copy(this.mInputs[aIndex]);
    }

    public ItemStack getOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mOutputs.length) {
            return null;
        }
        return GT_Utility.copy(this.mOutputs[aIndex]);
    }

    public int getOutputChance(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mChances.length) {
            return 10000;
        }
        return this.mChances[aIndex];
    }

    public FluidStack getRepresentativeFluidInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidInputs.length || this.mFluidInputs[aIndex] == null) {
            return null;
        }
        return this.mFluidInputs[aIndex].copy();
    }

    public FluidStack getFluidOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidOutputs.length || this.mFluidOutputs[aIndex] == null) {
            return null;
        }
        return this.mFluidOutputs[aIndex].copy();
    }

    public void checkCellBalance() {
        int tOutputAmount;
        if (!GT_Values.D2 || this.mInputs.length < 1) {
            return;
        }
        int tInputAmount = GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(this.mInputs);
        if (tInputAmount < (tOutputAmount = GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(this.mOutputs))) {
            if (!Materials.Tin.contains(this.mInputs)) {
                GT_Log.err.println("You get more Cells, than you put in? There must be something wrong.");
                new Exception().printStackTrace(GT_Log.err);
            }
        } else if (tInputAmount > tOutputAmount && !Materials.Tin.contains(this.mOutputs)) {
            GT_Log.err.println("You get less Cells, than you put in? GT Machines usually don't destroy Cells.");
            new Exception().printStackTrace(GT_Log.err);
        }
    }

    public GT_Recipe copy() {
        return new GT_Recipe(this);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, false, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        boolean temp;
        if (this.mFluidInputs.length > 0 && aFluidInputs == null) {
            return false;
        }
        for (FluidStack fluidStack : this.mFluidInputs) {
            if (fluidStack == null) continue;
            temp = true;
            for (FluidStack fluidStack2 : aFluidInputs) {
                if (fluidStack2 == null || !fluidStack2.isFluidEqual(fluidStack) || !aDontCheckStackSizes && fluidStack2.amount < fluidStack.amount) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (this.mInputs.length > 0 && aInputs == null) {
            return false;
        }
        for (FluidStack fluidStack : this.mInputs) {
            if (fluidStack == null) continue;
            temp = true;
            for (FluidStack fluidStack3 : aInputs) {
                if (!GT_Utility.areUnificationsEqual((ItemStack)fluidStack3, (ItemStack)fluidStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, (ItemStack)fluidStack3), (ItemStack)fluidStack, true) || !aDontCheckStackSizes && fluidStack3.field_77994_a < fluidStack.field_77994_a) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            if (aFluidInputs != null) {
                block4: for (FluidStack fluidStack : this.mFluidInputs) {
                    if (fluidStack == null) continue;
                    FluidStack[] arr$ = aFluidInputs;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        FluidStack aFluid = arr$[i$];
                        if (aFluid == null || !aFluid.isFluidEqual(fluidStack) || !aDontCheckStackSizes && aFluid.amount < fluidStack.amount) continue;
                        aFluid.amount -= fluidStack.amount;
                        continue block4;
                    }
                }
            }
            if (aInputs != null) {
                block6: for (FluidStack fluidStack : this.mInputs) {
                    if (fluidStack == null) continue;
                    for (ItemStack aStack : aInputs) {
                        if (!GT_Utility.areUnificationsEqual(aStack, (ItemStack)fluidStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, aStack), (ItemStack)fluidStack, true) || !aDontCheckStackSizes && aStack.field_77994_a < fluidStack.field_77994_a) continue;
                        aStack.field_77994_a -= fluidStack.field_77994_a;
                        continue block6;
                    }
                }
            }
        }
        return true;
    }

    private GT_Recipe(GT_Recipe aRecipe) {
        this.mEnabled = true;
        this.mHidden = false;
        this.mFakeRecipe = false;
        this.mCanBeBuffered = true;
        this.mNeedsEmptyOutput = false;
        this.mInputs = GT_Utility.copyStackArray(aRecipe.mInputs);
        this.mOutputs = GT_Utility.copyStackArray(aRecipe.mOutputs);
        this.mSpecialItems = aRecipe.mSpecialItems;
        this.mChances = aRecipe.mChances;
        this.mFluidInputs = GT_Utility.copyFluidArray(aRecipe.mFluidInputs);
        this.mFluidOutputs = GT_Utility.copyFluidArray(aRecipe.mFluidOutputs);
        this.mDuration = aRecipe.mDuration;
        this.mSpecialValue = aRecipe.mSpecialValue;
        this.mEUt = aRecipe.mEUt;
        this.mNeedsEmptyOutput = aRecipe.mNeedsEmptyOutput;
        this.mCanBeBuffered = aRecipe.mCanBeBuffered;
        this.mFakeRecipe = aRecipe.mFakeRecipe;
        this.mEnabled = aRecipe.mEnabled;
        this.mHidden = aRecipe.mHidden;
    }

    protected GT_Recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        int i;
        this.mEnabled = true;
        this.mHidden = false;
        this.mFakeRecipe = false;
        this.mCanBeBuffered = true;
        this.mNeedsEmptyOutput = false;
        if (aInputs == null) {
            aInputs = new ItemStack[]{};
        }
        if (aOutputs == null) {
            aOutputs = new ItemStack[]{};
        }
        if (aFluidInputs == null) {
            aFluidInputs = new FluidStack[]{};
        }
        if (aFluidOutputs == null) {
            aFluidOutputs = new FluidStack[]{};
        }
        if (aChances == null) {
            aChances = new int[aOutputs.length];
        }
        if (aChances.length < aOutputs.length) {
            aChances = Arrays.copyOf(aChances, aOutputs.length);
        }
        aInputs = GT_Utility.getArrayListWithoutTrailingNulls(aInputs).toArray(new ItemStack[0]);
        aOutputs = GT_Utility.getArrayListWithoutTrailingNulls(aOutputs).toArray(new ItemStack[0]);
        aFluidInputs = GT_Utility.getArrayListWithoutNulls(aFluidInputs).toArray(new FluidStack[0]);
        aFluidOutputs = GT_Utility.getArrayListWithoutNulls(aFluidOutputs).toArray(new FluidStack[0]);
        GT_OreDictUnificator.setStackArray(true, aInputs);
        GT_OreDictUnificator.setStackArray(true, aOutputs);
        for (ItemStack tStack : aOutputs) {
            GT_Utility.updateItemStack(tStack);
        }
        for (i = 0; i < aChances.length; ++i) {
            if (aChances[i] > 0) continue;
            aChances[i] = 10000;
        }
        for (i = 0; i < aFluidInputs.length; ++i) {
            aFluidInputs[i] = new GT_FluidStack(aFluidInputs[i]);
        }
        for (i = 0; i < aFluidOutputs.length; ++i) {
            aFluidOutputs[i] = new GT_FluidStack(aFluidOutputs[i]);
        }
        for (i = 0; i < aInputs.length; ++i) {
            if (aInputs[i] == null || Items.field_151008_G.getDamage(aInputs[i]) == Short.MAX_VALUE) continue;
            for (int j = 0; j < aOutputs.length; ++j) {
                if (!GT_Utility.areStacksEqual(aInputs[i], aOutputs[j])) continue;
                if (aInputs[i].field_77994_a >= aOutputs[j].field_77994_a) {
                    aInputs[i].field_77994_a -= aOutputs[j].field_77994_a;
                    aOutputs[j] = null;
                    continue;
                }
                aOutputs[j].field_77994_a -= aInputs[i].field_77994_a;
            }
        }
        if (aOptimize && aDuration >= 32) {
            int i2;
            ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
            tList.addAll(Arrays.asList(aInputs));
            tList.addAll(Arrays.asList(aOutputs));
            for (i2 = 0; i2 < tList.size(); ++i2) {
                if (tList.get(i2) != null) continue;
                tList.remove(i2--);
            }
            for (i2 = (int)((byte)Math.min(64, aDuration / 16)); i2 > 1; i2 = (int)((byte)(i2 - 1))) {
                int j;
                if (aDuration / i2 < 16) continue;
                boolean temp = true;
                int k = tList.size();
                for (j = 0; temp && j < k; ++j) {
                    if (((ItemStack)tList.get((int)j)).field_77994_a % i2 == 0) continue;
                    temp = false;
                }
                for (j = 0; temp && j < aFluidInputs.length; ++j) {
                    if (aFluidInputs[j].amount % i2 == 0) continue;
                    temp = false;
                }
                for (j = 0; temp && j < aFluidOutputs.length; ++j) {
                    if (aFluidOutputs[j].amount % i2 == 0) continue;
                    temp = false;
                }
                if (!temp) continue;
                k = tList.size();
                for (j = 0; j < k; ++j) {
                    ((ItemStack)tList.get((int)j)).field_77994_a /= i2;
                }
                for (j = 0; j < aFluidInputs.length; ++j) {
                    aFluidInputs[j].amount /= i2;
                }
                for (j = 0; j < aFluidOutputs.length; ++j) {
                    aFluidOutputs[j].amount /= i2;
                }
                aDuration /= i2;
            }
        }
        this.mInputs = aInputs;
        this.mOutputs = aOutputs;
        this.mSpecialItems = aSpecialItems;
        this.mChances = aChances;
        this.mFluidInputs = aFluidInputs;
        this.mFluidOutputs = aFluidOutputs;
        this.mDuration = aDuration;
        this.mSpecialValue = aSpecialValue;
        this.mEUt = aEUt;
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, int aFuelValue, int aType) {
        this(aInput1, aOutput1, null, null, null, aFuelValue, aType);
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aSpecialValue, int aType) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, 0, 0, Math.max(1, aSpecialValue));
        if (this.mInputs.length > 0 && aSpecialValue > 0) {
            switch (aType) {
                case 0: {
                    GT_Recipe_Map.sDieselFuels.addRecipe(this);
                    break;
                }
                case 1: {
                    GT_Recipe_Map.sTurbineFuels.addRecipe(this);
                    break;
                }
                case 2: {
                    GT_Recipe_Map.sHotFuels.addRecipe(this);
                    break;
                }
                case 4: {
                    GT_Recipe_Map.sPlasmaFuels.addRecipe(this);
                    break;
                }
                case 5: {
                    GT_Recipe_Map.sMagicFuels.addRecipe(this);
                    break;
                }
                default: {
                    GT_Recipe_Map.sDenseLiquidFuels.addRecipe(this);
                }
            }
        }
    }

    public GT_Recipe(FluidStack aInput1, FluidStack aInput2, FluidStack aOutput1, int aDuration, int aEUt, int aSpecialValue) {
        this(true, null, null, null, null, new FluidStack[]{aInput1, aInput2}, new FluidStack[]{aOutput1}, Math.max(aDuration, 1), aEUt, Math.max(Math.min(aSpecialValue, 160000000), 0));
        if (this.mInputs.length > 1) {
            GT_Recipe_Map.sFusionRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, int aDuration, int aEUt) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, aDuration, aEUt, 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sLatheRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, int aCellAmount, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aDuration, int aEUt) {
        this(true, new ItemStack[]{aInput1, aCellAmount > 0 ? ItemList.Cell_Empty.get(Math.min(64, Math.max(1, aCellAmount)), new Object[0]) : null}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, Math.max(aDuration, 1), Math.max(aEUt, 1), 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sDistillationRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, int aInput2, ItemStack aOutput1, ItemStack aOutput2) {
        ItemStack[] itemStackArray = new ItemStack[2];
        itemStackArray[0] = aInput1;
        itemStackArray[1] = GT_ModHandler.getIC2Item("industrialTnt", aInput2 > 0 ? (aInput2 < 64 ? (long)aInput2 : 64L) : 1L, new ItemStack(Blocks.field_150335_W, aInput2 > 0 ? (aInput2 < 64 ? aInput2 : 64) : 1));
        this(true, itemStackArray, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, 20, 30, 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sImplosionRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(int aEUt, int aDuration, ItemStack aInput1, ItemStack aOutput1) {
        this(true, new ItemStack[]{aInput1, ItemList.Circuit_Integrated.getWithDamage(0L, aInput1.field_77994_a, new Object[0])}, new ItemStack[]{aOutput1}, null, null, null, null, Math.max(aDuration, 1), Math.max(aEUt, 1), 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sBenderRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aInput2, int aEUt, int aDuration, ItemStack aOutput1) {
        ItemStack[] itemStackArray;
        if (aInput2 == null) {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = aInput1;
        } else {
            ItemStack[] itemStackArray3 = new ItemStack[2];
            itemStackArray3[0] = aInput1;
            itemStackArray = itemStackArray3;
            itemStackArray3[1] = aInput2;
        }
        this(true, itemStackArray, new ItemStack[]{aOutput1}, null, null, null, null, Math.max(aDuration, 1), Math.max(aEUt, 1), 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sAlloySmelterRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, int aEUt, ItemStack aInput2, int aDuration, ItemStack aOutput1, ItemStack aOutput2) {
        ItemStack[] itemStackArray;
        if (aInput2 == null) {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = aInput1;
        } else {
            ItemStack[] itemStackArray3 = new ItemStack[2];
            itemStackArray3[0] = aInput1;
            itemStackArray = itemStackArray3;
            itemStackArray3[1] = aInput2;
        }
        this(true, itemStackArray, new ItemStack[]{aOutput1, aOutput2}, null, null, null, null, Math.max(aDuration, 1), Math.max(aEUt, 1), 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sCannerRecipes.addRecipe(this);
        }
    }

    public GT_Recipe(ItemStack aInput1, ItemStack aOutput1, int aDuration) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1}, null, null, null, null, Math.max(aDuration, 1), 120, 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GT_Recipe_Map.sVacuumRecipes.addRecipe(this);
        }
    }

    public static class GT_Recipe_Map_Printer
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Printer(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            GT_Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null || aFluids == null || aFluids.length <= 0 || aFluids[0] == null || !GregTech_API.sPostloadFinished) {
                return rRecipe;
            }
            Dyes aDye = null;
            for (Dyes tDye : Dyes.VALUES) {
                if (!tDye.isFluidDye(aFluids[0])) continue;
                aDye = tDye;
                break;
            }
            if (aDye == null) {
                return rRecipe;
            }
            if (rRecipe == null) {
                ItemStack tOutput = GT_ModHandler.getAllRecipeOutput(aTileEntity == null ? null : aTileEntity.getWorld(), aInputs[0], aInputs[0], aInputs[0], aInputs[0], ItemList.DYE_ONLY_ITEMS[aDye.mIndex].get(1L, new Object[0]), aInputs[0], aInputs[0], aInputs[0], aInputs[0]);
                if (tOutput != null) {
                    return this.addRecipe(new GT_Recipe(true, new ItemStack[]{GT_Utility.copyAmount(8L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, new FluidStack[]{new FluidStack(aFluids[0].getFluid(), 144)}, null, 256, 2, 0), false, false, true);
                }
                tOutput = GT_ModHandler.getAllRecipeOutput(aTileEntity == null ? null : aTileEntity.getWorld(), aInputs[0], ItemList.DYE_ONLY_ITEMS[aDye.mIndex].get(1L, new Object[0]));
                if (tOutput != null) {
                    return this.addRecipe(new GT_Recipe(true, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, new FluidStack[]{new FluidStack(aFluids[0].getFluid(), 144)}, null, 32, 2, 0), false, false, true);
                }
            } else {
                NBTTagCompound tNBT;
                if (aInputs[0].func_77973_b() == Items.field_151121_aF) {
                    if (!ItemList.Tool_DataStick.isStackEqual(aSpecialSlot, false, true)) {
                        return null;
                    }
                    tNBT = aSpecialSlot.func_77978_p();
                    if (tNBT == null || GT_Utility.isStringInvalid(tNBT.func_74779_i("title")) || GT_Utility.isStringInvalid(tNBT.func_74779_i("author"))) {
                        return null;
                    }
                    rRecipe = rRecipe.copy();
                    rRecipe.mCanBeBuffered = false;
                    rRecipe.mOutputs[0].func_77982_d(tNBT);
                    return rRecipe;
                }
                if (aInputs[0].func_77973_b() == Items.field_151148_bJ) {
                    if (!ItemList.Tool_DataStick.isStackEqual(aSpecialSlot, false, true)) {
                        return null;
                    }
                    tNBT = aSpecialSlot.func_77978_p();
                    if (tNBT == null || !tNBT.func_74764_b("map_id")) {
                        return null;
                    }
                    rRecipe = rRecipe.copy();
                    rRecipe.mCanBeBuffered = false;
                    rRecipe.mOutputs[0].func_77964_b((int)tNBT.func_74765_d("map_id"));
                    return rRecipe;
                }
                if (ItemList.Paper_Punch_Card_Empty.isStackEqual(aInputs[0], false, true)) {
                    if (!ItemList.Tool_DataStick.isStackEqual(aSpecialSlot, false, true)) {
                        return null;
                    }
                    tNBT = aSpecialSlot.func_77978_p();
                    if (tNBT == null || !tNBT.func_74764_b("GT.PunchCardData")) {
                        return null;
                    }
                    rRecipe = rRecipe.copy();
                    rRecipe.mCanBeBuffered = false;
                    rRecipe.mOutputs[0].func_77982_d(GT_Utility.getNBTContainingString(new NBTTagCompound(), "GT.PunchCardData", tNBT.func_74779_i("GT.PunchCardData")));
                    return rRecipe;
                }
            }
            return rRecipe;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return true;
        }

        @Override
        public boolean containsInput(FluidStack aFluid) {
            return super.containsInput(aFluid) || Dyes.isAnyFluidDye(aFluid);
        }

        @Override
        public boolean containsInput(Fluid aFluid) {
            return super.containsInput(aFluid) || Dyes.isAnyFluidDye(aFluid);
        }
    }

    public static class GT_Recipe_Map_FormingPress
    extends GT_Recipe_Map {
        public GT_Recipe_Map_FormingPress(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            GT_Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (aInputs == null || aInputs.length < 2 || aInputs[0] == null || aInputs[1] == null || !GregTech_API.sPostloadFinished) {
                return rRecipe;
            }
            if (rRecipe == null) {
                if (ItemList.Shape_Mold_Name.isStackEqual(aInputs[0], false, true)) {
                    ItemStack tOutput = GT_Utility.copyAmount(1L, aInputs[1]);
                    tOutput.func_151001_c(aInputs[0].func_82833_r());
                    rRecipe = new GT_Recipe(false, new ItemStack[]{ItemList.Shape_Mold_Name.get(0L, new Object[0]), GT_Utility.copyAmount(1L, aInputs[1])}, new ItemStack[]{tOutput}, null, null, null, null, 128, 8, 0);
                    rRecipe.mCanBeBuffered = false;
                    return rRecipe;
                }
                if (ItemList.Shape_Mold_Name.isStackEqual(aInputs[1], false, true)) {
                    ItemStack tOutput = GT_Utility.copyAmount(1L, aInputs[0]);
                    tOutput.func_151001_c(aInputs[1].func_82833_r());
                    rRecipe = new GT_Recipe(false, new ItemStack[]{ItemList.Shape_Mold_Name.get(0L, new Object[0]), GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, null, null, 128, 8, 0);
                    rRecipe.mCanBeBuffered = false;
                    return rRecipe;
                }
                return null;
            }
            for (ItemStack aMold : aInputs) {
                if (!ItemList.Shape_Mold_Credit.isStackEqual(aMold, false, true)) continue;
                NBTTagCompound tNBT = aMold.func_77978_p();
                if (tNBT == null) {
                    tNBT = new NBTTagCompound();
                }
                if (!tNBT.func_74764_b("credit_security_id")) {
                    tNBT.func_74772_a("credit_security_id", System.nanoTime());
                }
                aMold.func_77982_d(tNBT);
                rRecipe = rRecipe.copy();
                rRecipe.mCanBeBuffered = false;
                rRecipe.mOutputs[0].func_77982_d(tNBT);
                return rRecipe;
            }
            return rRecipe;
        }
    }

    public static class GT_Recipe_Map_Assembler
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Assembler(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            GT_Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null || rRecipe == null || !GregTech_API.sPostloadFinished) {
                return rRecipe;
            }
            for (ItemStack aInput : aInputs) {
                if (!ItemList.Paper_Printed_Pages.isStackEqual(aInput, false, true)) continue;
                rRecipe = rRecipe.copy();
                rRecipe.mCanBeBuffered = false;
                rRecipe.mOutputs[0].func_77982_d(aInput.func_77978_p());
            }
            return rRecipe;
        }
    }

    public static class GT_Recipe_Map_Macerator
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Macerator(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null || !GregTech_API.sPostloadFinished) {
                return super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs);
            }
            if ((aRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs)) != null) {
                return aRecipe;
            }
            try {
                List tRecipeOutputs = RailcraftCraftingManager.rockCrusher.getRecipe(GT_Utility.copyAmount(1L, aInputs[0])).getRandomizedOuputs();
                if (tRecipeOutputs != null) {
                    aRecipe = new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, tRecipeOutputs.toArray(new ItemStack[tRecipeOutputs.size()]), null, null, null, null, 800, 2, 0);
                    aRecipe.mCanBeBuffered = false;
                    aRecipe.mNeedsEmptyOutput = true;
                    return aRecipe;
                }
            }
            catch (NoClassDefFoundError e) {
                if (GT_Values.D1) {
                    GT_Log.err.println("Railcraft Not loaded");
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            ItemStack tComparedInput = GT_Utility.copy(aInputs[0]);
            ItemStack[] tOutputItems = GT_ModHandler.getMachineOutput(tComparedInput, Recipes.macerator.getRecipes(), true, new NBTTagCompound(), null, null, null);
            return GT_Utility.arrayContainsNonNull(tOutputItems) ? new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(aInputs[0].field_77994_a - tComparedInput.field_77994_a, aInputs[0])}, tOutputItems, null, null, null, null, 400, 2, 0) : null;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return super.containsInput(aStack) || GT_Utility.arrayContainsNonNull(GT_ModHandler.getMachineOutput(GT_Utility.copyAmount(64L, aStack), Recipes.macerator.getRecipes(), false, new NBTTagCompound(), null, null, null));
        }
    }

    public static class GT_Recipe_Map_OreWasher
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_OreWasher(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null || aFluids == null || aFluids.length < 1 || !GT_ModHandler.isWater(aFluids[0])) {
                return null;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe;
            }
            ItemStack tComparedInput = GT_Utility.copy(aInputs[0]);
            NBTTagCompound aRecipeMetaData = new NBTTagCompound();
            ItemStack[] tOutputItems = GT_ModHandler.getMachineOutput(tComparedInput, Recipes.oreWashing.getRecipes(), true, aRecipeMetaData, null, null, null);
            return GT_Utility.arrayContainsNonNull(tOutputItems) ? new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(aInputs[0].field_77994_a - tComparedInput.field_77994_a, aInputs[0])}, tOutputItems, null, null, new FluidStack[]{new FluidStack(aFluids[0].getFluid(), ((NBTTagCompound)aRecipeMetaData.func_74781_a("return")).func_74762_e("amount"))}, null, 400, 16, 0) : null;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_Utility.arrayContainsNonNull(GT_ModHandler.getMachineOutput(GT_Utility.copyAmount(64L, aStack), Recipes.oreWashing.getRecipes(), false, new NBTTagCompound(), null, null, null));
        }

        @Override
        public boolean containsInput(FluidStack aFluid) {
            return GT_ModHandler.isWater(aFluid);
        }

        @Override
        public boolean containsInput(Fluid aFluid) {
            return GT_ModHandler.isWater(new FluidStack(aFluid, 0));
        }
    }

    public static class GT_Recipe_Map_ThermalCentrifuge
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_ThermalCentrifuge(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null) {
                return null;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe;
            }
            ItemStack tComparedInput = GT_Utility.copy(aInputs[0]);
            ItemStack[] tOutputItems = GT_ModHandler.getMachineOutput(tComparedInput, Recipes.centrifuge.getRecipes(), true, new NBTTagCompound(), null, null, null);
            return GT_Utility.arrayContainsNonNull(tOutputItems) ? new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(aInputs[0].field_77994_a - tComparedInput.field_77994_a, aInputs[0])}, tOutputItems, null, null, null, null, 400, 48, 0) : null;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_Utility.arrayContainsNonNull(GT_ModHandler.getMachineOutput(GT_Utility.copyAmount(64L, aStack), Recipes.centrifuge.getRecipes(), false, new NBTTagCompound(), null, null, null));
        }
    }

    public static class GT_Recipe_Map_Extractor
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_Extractor(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null) {
                return null;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe;
            }
            ItemStack tComparedInput = GT_Utility.copy(aInputs[0]);
            ItemStack[] tOutputItems = GT_ModHandler.getMachineOutput(tComparedInput, Recipes.extractor.getRecipes(), true, new NBTTagCompound(), null, null, null);
            return GT_Utility.arrayContainsNonNull(tOutputItems) ? new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(aInputs[0].field_77994_a - tComparedInput.field_77994_a, aInputs[0])}, tOutputItems, null, null, null, null, 400, 2, 0) : null;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_Utility.arrayContainsNonNull(GT_ModHandler.getMachineOutput(GT_Utility.copyAmount(64L, aStack), Recipes.extractor.getRecipes(), false, new NBTTagCompound(), null, null, null));
        }
    }

    public static class GT_Recipe_Map_Compressor
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_Compressor(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null) {
                return null;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe;
            }
            ItemStack tComparedInput = GT_Utility.copy(aInputs[0]);
            ItemStack[] tOutputItems = GT_ModHandler.getMachineOutput(tComparedInput, Recipes.compressor.getRecipes(), true, new NBTTagCompound(), null, null, null);
            return GT_Utility.arrayContainsNonNull(tOutputItems) ? new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(aInputs[0].field_77994_a - tComparedInput.field_77994_a, aInputs[0])}, tOutputItems, null, null, null, null, 400, 2, 0) : null;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_Utility.arrayContainsNonNull(GT_ModHandler.getMachineOutput(GT_Utility.copyAmount(64L, aStack), Recipes.compressor.getRecipes(), false, new NBTTagCompound(), null, null, null));
        }
    }

    public static class GT_Recipe_Map_Recycler
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_Recycler(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            ItemStack[] itemStackArray;
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null) {
                return null;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe;
            }
            ItemStack[] itemStackArray2 = new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])};
            if (GT_ModHandler.getRecyclerOutput(GT_Utility.copyAmount(64L, aInputs[0]), 0) == null) {
                itemStackArray = null;
            } else {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = ItemList.IC2_Scrap.get(1L, new Object[0]);
            }
            return new GT_Recipe(false, itemStackArray2, itemStackArray, null, new int[]{1250}, null, null, 45, 1, 0);
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_ModHandler.getRecyclerOutput(GT_Utility.copyAmount(64L, aStack), 0) != null;
        }
    }

    public static class GT_Recipe_Map_FluidCanner
    extends GT_Recipe_Map {
        public GT_Recipe_Map_FluidCanner(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            FluidStack tFluid;
            ItemStack tOutput;
            FluidStack tFluid2;
            GT_Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs);
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null || rRecipe != null || !GregTech_API.sPostloadFinished) {
                return rRecipe;
            }
            if (aFluids != null && aFluids.length > 0 && aFluids[0] != null && (tFluid2 = GT_Utility.getFluidForFilledItem(tOutput = GT_Utility.fillFluidContainer(aFluids[0], aInputs[0], false, true), true)) != null) {
                rRecipe = new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, new FluidStack[]{tFluid2}, null, Math.max(tFluid2.amount / 64, 16), 1, 0);
            }
            if (rRecipe == null && (tFluid = GT_Utility.getFluidForFilledItem(aInputs[0], true)) != null) {
                rRecipe = new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{GT_Utility.getContainerItem(aInputs[0], true)}, null, null, null, new FluidStack[]{tFluid}, Math.max(tFluid.amount / 64, 16), 1, 0);
            }
            if (rRecipe != null) {
                rRecipe.mCanBeBuffered = false;
            }
            return rRecipe;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return aStack != null && (super.containsInput(aStack) || aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0);
        }

        @Override
        public boolean containsInput(FluidStack aFluid) {
            return true;
        }

        @Override
        public boolean containsInput(Fluid aFluid) {
            return true;
        }
    }

    public static class GT_Recipe_Map_Unboxinator
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Unboxinator(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length <= 0 || !ItemList.IC2_Scrapbox.isStackEqual(aInputs[0], false, true)) {
                return super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs);
            }
            ItemStack tOutput = GT_ModHandler.getRandomScrapboxDrop();
            if (tOutput == null) {
                return super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs);
            }
            GT_Recipe rRecipe = new GT_Recipe(false, new ItemStack[]{ItemList.IC2_Scrapbox.get(1L, new Object[0])}, new ItemStack[]{tOutput}, null, null, null, null, 16, 1, 0);
            rRecipe.mCanBeBuffered = false;
            rRecipe.mNeedsEmptyOutput = true;
            return rRecipe;
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return ItemList.IC2_Scrapbox.isStackEqual(aStack, false, true) || super.containsInput(aStack);
        }
    }

    public static class GT_Recipe_Map_Microwave
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_Microwave(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null) {
                return null;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe;
            }
            ItemStack tOutput = GT_ModHandler.getSmeltingOutput(aInputs[0], false, null);
            if (GT_Utility.areStacksEqual(aInputs[0], new ItemStack(Items.field_151122_aG, 1, Short.MAX_VALUE))) {
                return new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{GT_Utility.getWrittenBook("Manual_Microwave", ItemList.Book_Written_03.get(1L, new Object[0]))}, null, null, null, null, 32, 4, 0);
            }
            for (ItemStack tStack : new ItemStack[]{GT_Utility.getContainerItem(aInputs[0], true), aInputs[0], GT_Utility.getContainerItem(tOutput, true), tOutput}) {
                if (tStack == null) continue;
                if (GT_Utility.areStacksEqual(tStack, new ItemStack(Blocks.field_150424_aL, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Blocks.field_150335_W, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Items.field_151110_aK, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Items.field_151154_bQ, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Items.field_151152_bP, 1, Short.MAX_VALUE), true) || GT_Utility.areStacksEqual(tStack, new ItemStack(Items.field_151059_bz, 1, Short.MAX_VALUE), true)) {
                    if (aTileEntity instanceof IGregTechTileEntity) {
                        ((IGregTechTileEntity)aTileEntity).doExplosion(aVoltage * 4L);
                    }
                    return null;
                }
                ItemData tData = GT_OreDictUnificator.getItemData(tStack);
                if (tData != null) {
                    if (tData.mMaterial != null && tData.mMaterial.mMaterial != null) {
                        if (tData.mMaterial.mMaterial.contains(SubTag.METAL) || tData.mMaterial.mMaterial.contains(SubTag.EXPLOSIVE)) {
                            if (aTileEntity instanceof IGregTechTileEntity) {
                                ((IGregTechTileEntity)aTileEntity).doExplosion(aVoltage * 4L);
                            }
                            return null;
                        }
                        if (tData.mMaterial.mMaterial.contains(SubTag.FLAMMABLE)) {
                            if (aTileEntity instanceof IGregTechTileEntity) {
                                ((IGregTechTileEntity)aTileEntity).setOnFire();
                            }
                            return null;
                        }
                    }
                    for (MaterialStack tMaterial : tData.mByProducts) {
                        if (tMaterial == null) continue;
                        if (tMaterial.mMaterial.contains(SubTag.METAL) || tMaterial.mMaterial.contains(SubTag.EXPLOSIVE)) {
                            if (aTileEntity instanceof IGregTechTileEntity) {
                                ((IGregTechTileEntity)aTileEntity).doExplosion(aVoltage * 4L);
                            }
                            return null;
                        }
                        if (!tMaterial.mMaterial.contains(SubTag.FLAMMABLE)) continue;
                        if (aTileEntity instanceof IGregTechTileEntity) {
                            ((IGregTechTileEntity)aTileEntity).setOnFire();
                        }
                        return null;
                    }
                }
                if (TileEntityFurnace.func_145952_a((ItemStack)tStack) <= 0) continue;
                if (aTileEntity instanceof IGregTechTileEntity) {
                    ((IGregTechTileEntity)aTileEntity).setOnFire();
                }
                return null;
            }
            return tOutput == null ? null : new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, null, null, 32, 4, 0);
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_ModHandler.getSmeltingOutput(aStack, false, null) != null;
        }
    }

    public static class GT_Recipe_Map_Furnace
    extends GT_Recipe_Map_NonGTRecipes {
        public GT_Recipe_Map_Furnace(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (aInputs == null || aInputs.length <= 0 || aInputs[0] == null) {
                return null;
            }
            if (aRecipe != null && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe;
            }
            ItemStack tOutput = GT_ModHandler.getSmeltingOutput(aInputs[0], false, null);
            return tOutput == null ? null : new GT_Recipe(false, new ItemStack[]{GT_Utility.copyAmount(1L, aInputs[0])}, new ItemStack[]{tOutput}, null, null, null, null, 128, 4, 0);
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return GT_ModHandler.getSmeltingOutput(aStack, false, null) != null;
        }
    }

    public static class GT_Recipe_Map_Fuel
    extends GT_Recipe_Map {
        public GT_Recipe_Map_Fuel(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public GT_Recipe addFuel(ItemStack aInput, ItemStack aOutput, int aFuelValueInEU) {
            return this.addFuel(aInput, aOutput, null, null, 10000, aFuelValueInEU);
        }

        public GT_Recipe addFuel(ItemStack aInput, ItemStack aOutput, int aChance, int aFuelValueInEU) {
            return this.addFuel(aInput, aOutput, null, null, aChance, aFuelValueInEU);
        }

        public GT_Recipe addFuel(FluidStack aFluidInput, FluidStack aFluidOutput, int aFuelValueInEU) {
            return this.addFuel(null, null, aFluidInput, aFluidOutput, 10000, aFuelValueInEU);
        }

        public GT_Recipe addFuel(ItemStack aInput, ItemStack aOutput, FluidStack aFluidInput, FluidStack aFluidOutput, int aFuelValueInEU) {
            return this.addFuel(aInput, aOutput, aFluidInput, aFluidOutput, 10000, aFuelValueInEU);
        }

        public GT_Recipe addFuel(ItemStack aInput, ItemStack aOutput, FluidStack aFluidInput, FluidStack aFluidOutput, int aChance, int aFuelValueInEU) {
            return this.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, 0, 0, aFuelValueInEU);
        }
    }

    public static abstract class GT_Recipe_Map_NonGTRecipes
    extends GT_Recipe_Map {
        public GT_Recipe_Map_NonGTRecipes(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return false;
        }

        @Override
        public boolean containsInput(FluidStack aFluid) {
            return false;
        }

        @Override
        public boolean containsInput(Fluid aFluid) {
            return false;
        }

        @Override
        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GT_Recipe addRecipe(GT_Recipe aRecipe) {
            return null;
        }

        @Override
        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, GT_Recipe aRecipe) {
            return null;
        }

        @Override
        public GT_Recipe add(GT_Recipe aRecipe) {
            return null;
        }

        @Override
        public void reInit() {
        }

        @Override
        protected GT_Recipe addToItemMap(GT_Recipe aRecipe) {
            return null;
        }
    }

    public static class GT_Recipe_Map {
        public static final Collection<GT_Recipe_Map> sMappings = new ArrayList<GT_Recipe_Map>();
        public static final GT_Recipe_Map sOreWasherRecipes = new GT_Recipe_Map_OreWasher(new HashSet<GT_Recipe>(0), "ic.recipe.orewasher", "Ore Washer", "ic2.blockOreWashingPlant", "gregtech:textures/gui/basicmachines/OreWasher", 1, 3, 1, 1, 1, "", 1, "", true, false);
        public static final GT_Recipe_Map sThermalCentrifugeRecipes = new GT_Recipe_Map_ThermalCentrifuge(new HashSet<GT_Recipe>(0), "ic.recipe.thermalcentrifuge", "Thermal Centrifuge", "ic2.blockCentrifuge", "gregtech:textures/gui/basicmachines/ThermalCentrifuge", 1, 3, 1, 0, 2, "", 1, "", true, false);
        public static final GT_Recipe_Map sCompressorRecipes = new GT_Recipe_Map_Compressor(new HashSet<GT_Recipe>(0), "ic.recipe.compressor", "Compressor", "ic2.compressor", "gregtech:textures/gui/basicmachines/Compressor", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static final GT_Recipe_Map sExtractorRecipes = new GT_Recipe_Map_Extractor(new HashSet<GT_Recipe>(0), "ic.recipe.extractor", "Extractor", "ic2.extractor", "gregtech:textures/gui/basicmachines/Extractor", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static final GT_Recipe_Map sRecyclerRecipes = new GT_Recipe_Map_Recycler(new HashSet<GT_Recipe>(0), "ic.recipe.recycler", "Recycler", "ic2.recycler", "gregtech:textures/gui/basicmachines/Recycler", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static final GT_Recipe_Map sFurnaceRecipes = new GT_Recipe_Map_Furnace(new HashSet<GT_Recipe>(0), "mc.recipe.furnace", "Furnace", "smelting", "gregtech:textures/gui/basicmachines/E_Furnace", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static final GT_Recipe_Map sMicrowaveRecipes = new GT_Recipe_Map_Microwave(new HashSet<GT_Recipe>(0), "gt.recipe.microwave", "Microwave", "smelting", "gregtech:textures/gui/basicmachines/E_Furnace", 1, 1, 1, 0, 1, "", 1, "", true, false);
        public static final GT_Recipe_Map sScannerFakeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(3), "gt.recipe.scanner", "Scanner", null, "gregtech:textures/gui/basicmachines/Scanner", 1, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sRockBreakerFakeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(3), "gt.recipe.rockbreaker", "Rock Breaker", null, "gregtech:textures/gui/basicmachines/RockBreaker", 1, 1, 0, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sByProductList = new GT_Recipe_Map(new HashSet<GT_Recipe>(1000), "gt.recipe.byproductlist", "Ore Byproduct List", null, "gregtech:textures/gui/basicmachines/Default", 1, 6, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sPlasmaArcFurnaceRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(10000), "gt.recipe.plasmaarcfurnace", "Plasma Arc Furnace", null, "gregtech:textures/gui/basicmachines/PlasmaArcFurnace", 1, 4, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sArcFurnaceRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(10000), "gt.recipe.arcfurnace", "Arc Furnace", null, "gregtech:textures/gui/basicmachines/ArcFurnace", 1, 4, 1, 1, 3, "", 1, "", true, true);
        public static final GT_Recipe_Map sPrinterRecipes = new GT_Recipe_Map_Printer(new HashSet<GT_Recipe>(100), "gt.recipe.printer", "Printer", null, "gregtech:textures/gui/basicmachines/Printer", 1, 1, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sSifterRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.sifter", "Sifter", null, "gregtech:textures/gui/basicmachines/Sifter", 1, 9, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sPressRecipes = new GT_Recipe_Map_FormingPress(new HashSet<GT_Recipe>(100), "gt.recipe.press", "Forming Press", null, "gregtech:textures/gui/basicmachines/Press", 2, 1, 2, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sLaserEngraverRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.laserengraver", "Precision Laser Engraver", null, "gregtech:textures/gui/basicmachines/LaserEngraver", 2, 1, 2, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sMixerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.mixer", "Mixer", null, "gregtech:textures/gui/basicmachines/Mixer", 4, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sAutoclaveRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(200), "gt.recipe.autoclave", "Autoclave", null, "gregtech:textures/gui/basicmachines/Autoclave", 1, 1, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sElectroMagneticSeparatorRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(50), "gt.recipe.electromagneticseparator", "Electromagnetic Separator", null, "gregtech:textures/gui/basicmachines/ElectromagneticSeparator", 1, 3, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sPolarizerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.polarizer", "Electromagnetic Polarizer", null, "gregtech:textures/gui/basicmachines/Polarizer", 1, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sMaceratorRecipes = new GT_Recipe_Map_Macerator(new HashSet<GT_Recipe>(10000), "gt.recipe.macerator", "Pulverization", null, "gregtech:textures/gui/basicmachines/Macerator4", 1, 4, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sChemicalBathRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(200), "gt.recipe.chemicalbath", "Chemical Bath", null, "gregtech:textures/gui/basicmachines/ChemicalBath", 1, 3, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sFluidCannerRecipes = new GT_Recipe_Map_FluidCanner(new HashSet<GT_Recipe>(100), "gt.recipe.fluidcanner", "Fluid Canning Machine", null, "gregtech:textures/gui/basicmachines/FluidCannerNEI", 1, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sBrewingRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.brewer", "Brewing Machine", null, "gregtech:textures/gui/basicmachines/PotionBrewer", 1, 0, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sFluidHeaterRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.fluidheater", "Fluid Heater", null, "gregtech:textures/gui/basicmachines/FluidHeater", 1, 0, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sDistilleryRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.distillery", "Distillery", null, "gregtech:textures/gui/basicmachines/Distillery", 1, 0, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sFermentingRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.fermenter", "Fermenter", null, "gregtech:textures/gui/basicmachines/Fermenter", 0, 0, 0, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sFluidSolidficationRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.fluidsolidifier", "Fluid Solidifier", null, "gregtech:textures/gui/basicmachines/FluidSolidifier", 1, 1, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sFluidExtractionRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.fluidextractor", "Fluid Extractor", null, "gregtech:textures/gui/basicmachines/FluidExtractor", 1, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sBoxinatorRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(2500), "gt.recipe.packager", "Packager", null, "gregtech:textures/gui/basicmachines/Packager", 2, 1, 2, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sUnboxinatorRecipes = new GT_Recipe_Map_Unboxinator(new HashSet<GT_Recipe>(2500), "gt.recipe.unpackager", "Unpackager", null, "gregtech:textures/gui/basicmachines/Unpackager", 1, 2, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sFusionRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(50), "gt.recipe.fusionreactor", "Fusion Reactor", null, "gregtech:textures/gui/basicmachines/Default", 0, 0, 0, 2, 1, "Start: ", 1, " EU", true, true);
        public static final GT_Recipe_Map sCentrifugeRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(1000), "gt.recipe.centrifuge", "Centrifuge", null, "gregtech:textures/gui/basicmachines/Centrifuge", 2, 6, 0, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sElectrolyzerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(200), "gt.recipe.electrolyzer", "Electrolyzer", null, "gregtech:textures/gui/basicmachines/Electrolyzer", 2, 6, 0, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sBlastRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(500), "gt.recipe.blastfurnace", "Blast Furnace", null, "gregtech:textures/gui/basicmachines/Default", 2, 2, 1, 0, 1, "Heat Capacity: ", 1, " K", false, true);
        public static final GT_Recipe_Map sImplosionRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(50), "gt.recipe.implosioncompressor", "Implosion Compressor", null, "gregtech:textures/gui/basicmachines/Default", 2, 2, 2, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sVacuumRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.vacuumfreezer", "Vacuum Freezer", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sChemicalRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.chemicalreactor", "Chemical Reactor", null, "gregtech:textures/gui/basicmachines/ChemicalReactor", 2, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sDistillationRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(50), "gt.recipe.distillationtower", "Distillation Tower", null, "gregtech:textures/gui/basicmachines/Default", 2, 4, 0, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sWiremillRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(50), "gt.recipe.wiremill", "Wiremill", null, "gregtech:textures/gui/basicmachines/Wiremill", 1, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sBenderRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(400), "gt.recipe.metalbender", "Metal Bender", null, "gregtech:textures/gui/basicmachines/Bender", 2, 1, 2, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sAlloySmelterRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(3000), "gt.recipe.alloysmelter", "Alloy Smelter", null, "gregtech:textures/gui/basicmachines/AlloySmelter", 2, 1, 2, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sAssemblerRecipes = new GT_Recipe_Map_Assembler(new HashSet<GT_Recipe>(300), "gt.recipe.assembler", "Assembler", null, "gregtech:textures/gui/basicmachines/Assembler", 2, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sCannerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(300), "gt.recipe.canner", "Canning Machine", null, "gregtech:textures/gui/basicmachines/Canner", 2, 2, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sCNCRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(100), "gt.recipe.cncmachine", "CNC Machine", null, "gregtech:textures/gui/basicmachines/Default", 2, 1, 2, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sLatheRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(400), "gt.recipe.lathe", "Lathe", null, "gregtech:textures/gui/basicmachines/Lathe", 1, 2, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sCutterRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(200), "gt.recipe.cuttingsaw", "Cutting Saw", null, "gregtech:textures/gui/basicmachines/Cutter", 1, 2, 1, 1, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sSlicerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(200), "gt.recipe.slicer", "Slicer", null, "gregtech:textures/gui/basicmachines/Slicer", 2, 1, 2, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sExtruderRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(1000), "gt.recipe.extruder", "Extruder", null, "gregtech:textures/gui/basicmachines/Extruder", 2, 1, 2, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sHammerRecipes = new GT_Recipe_Map(new HashSet<GT_Recipe>(200), "gt.recipe.hammer", "Hammer", null, "gregtech:textures/gui/basicmachines/Hammer", 1, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map sAmplifiers = new GT_Recipe_Map(new HashSet<GT_Recipe>(10), "gt.recipe.uuamplifier", "UU Amplifier", null, "gregtech:textures/gui/basicmachines/Amplifabricator", 1, 0, 1, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe_Map_Fuel sDieselFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.dieselgeneratorfuel", "Diesel Generator Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GT_Recipe_Map_Fuel sTurbineFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.gasturbinefuel", "Gas Turbine Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GT_Recipe_Map_Fuel sHotFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.thermalgeneratorfuel", "Thermal Generator Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, false);
        public static final GT_Recipe_Map_Fuel sDenseLiquidFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.semifluidboilerfuels", "Semifluid Boiler Fuels", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GT_Recipe_Map_Fuel sPlasmaFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.plasmageneratorfuels", "Plasma generator Fuels", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GT_Recipe_Map_Fuel sMagicFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.magicfuels", "Magic Fuels", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GT_Recipe_Map_Fuel sSmallNaquadahReactorFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.smallnaquadahreactor", "Small Naquadah Reactor", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GT_Recipe_Map_Fuel sLargeNaquadahReactorFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.largenaquadahreactor", "Large Naquadah Reactor", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GT_Recipe_Map_Fuel sFluidNaquadahReactorFuels = new GT_Recipe_Map_Fuel(new HashSet<GT_Recipe>(10), "gt.recipe.fluidnaquadahreactor", "Fluid Naquadah Reactor", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public final Map<GT_ItemStack, Collection<GT_Recipe>> mRecipeItemMap = new HashMap<GT_ItemStack, Collection<GT_Recipe>>();
        public final Map<Fluid, Collection<GT_Recipe>> mRecipeFluidMap = new HashMap<Fluid, Collection<GT_Recipe>>();
        public final Collection<GT_Recipe> mRecipeList;
        public final String mUnlocalizedName;
        public final String mNEIName;
        public final String mNEIGUIPath;
        public final String mNEISpecialValuePre;
        public final String mNEISpecialValuePost;
        public final int mUsualInputCount;
        public final int mUsualOutputCount;
        public final int mNEISpecialValueMultiplier;
        public final int mMinimalInputItems;
        public final int mMinimalInputFluids;
        public final int mAmperage;
        public final boolean mNEIAllowed;
        public final boolean mShowVoltageAmperageInNEI;

        public GT_Recipe_Map(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            sMappings.add(this);
            this.mNEIAllowed = aNEIAllowed;
            this.mShowVoltageAmperageInNEI = aShowVoltageAmperageInNEI;
            this.mRecipeList = aRecipeList;
            this.mNEIName = aNEIName == null ? aUnlocalizedName : aNEIName;
            this.mNEIGUIPath = aNEIGUIPath.endsWith(".png") ? aNEIGUIPath : aNEIGUIPath + ".png";
            this.mNEISpecialValuePre = aNEISpecialValuePre;
            this.mNEISpecialValueMultiplier = aNEISpecialValueMultiplier;
            this.mNEISpecialValuePost = aNEISpecialValuePost;
            this.mAmperage = aAmperage;
            this.mUsualInputCount = aUsualInputCount;
            this.mUsualOutputCount = aUsualOutputCount;
            this.mMinimalInputItems = aMinimalInputItems;
            this.mMinimalInputFluids = aMinimalInputFluids;
            GregTech_API.sFluidMappings.add(this.mRecipeFluidMap);
            GregTech_API.sItemStackMappings.add(this.mRecipeItemMap);
            this.mUnlocalizedName = aUnlocalizedName;
            GT_LanguageManager.addStringLocalization(this.mUnlocalizedName, aLocalName);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GT_Recipe(aOptimize, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addRecipe(int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GT_Recipe(false, null, null, null, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue), false, false, false);
        }

        public GT_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GT_Recipe(aOptimize, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addRecipe(GT_Recipe aRecipe) {
            return this.addRecipe(aRecipe, true, false, false);
        }

        protected GT_Recipe addRecipe(GT_Recipe aRecipe, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden) {
            aRecipe.mHidden = aHidden;
            aRecipe.mFakeRecipe = aFakeRecipe;
            if (aRecipe.mFluidInputs.length < this.mMinimalInputFluids && aRecipe.mInputs.length < this.mMinimalInputItems) {
                return null;
            }
            if (aCheckForCollisions && this.findRecipe(null, false, Long.MAX_VALUE, aRecipe.mFluidInputs, aRecipe.mInputs) != null) {
                return null;
            }
            return this.add(aRecipe);
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new GT_Recipe(false, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new GT_Recipe(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GT_Recipe addFakeRecipe(boolean aCheckForCollisions, GT_Recipe aRecipe) {
            return this.addRecipe(aRecipe, aCheckForCollisions, true, false);
        }

        public GT_Recipe add(GT_Recipe aRecipe) {
            this.mRecipeList.add(aRecipe);
            for (FluidStack aFluid : aRecipe.mFluidInputs) {
                if (aFluid == null) continue;
                Collection<GT_Recipe> tList = this.mRecipeFluidMap.get(aFluid.getFluid());
                if (tList == null) {
                    tList = new HashSet<GT_Recipe>(1);
                    this.mRecipeFluidMap.put(aFluid.getFluid(), tList);
                }
                tList.add(aRecipe);
            }
            return this.addToItemMap(aRecipe);
        }

        public void reInit() {
            Map<GT_ItemStack, Collection<GT_Recipe>> tMap = this.mRecipeItemMap;
            if (tMap != null) {
                tMap.clear();
            }
            for (GT_Recipe tRecipe : this.mRecipeList) {
                GT_OreDictUnificator.setStackArray(true, tRecipe.mInputs);
                GT_OreDictUnificator.setStackArray(true, tRecipe.mOutputs);
                if (tMap == null) continue;
                this.addToItemMap(tRecipe);
            }
        }

        public boolean containsInput(ItemStack aStack) {
            return aStack != null && (this.mRecipeItemMap.containsKey(new GT_ItemStack(aStack)) || this.mRecipeItemMap.containsKey(new GT_ItemStack(GT_Utility.copyMetaData(32767L, aStack))));
        }

        public boolean containsInput(FluidStack aFluid) {
            return aFluid != null && this.containsInput(aFluid.getFluid());
        }

        public boolean containsInput(Fluid aFluid) {
            return aFluid != null && this.mRecipeFluidMap.containsKey(aFluid);
        }

        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, (GT_Recipe)null, aNotUnificated, aVoltage, aFluids, (ItemStack)null, aInputs);
        }

        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, (ItemStack)null, aInputs);
        }

        public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            if (this.mRecipeList.isEmpty()) {
                return null;
            }
            if (GregTech_API.sPostloadFinished) {
                int tAmount;
                if (this.mMinimalInputFluids > 0) {
                    if (aFluids == null) {
                        return null;
                    }
                    tAmount = 0;
                    for (FluidStack fluidStack : aFluids) {
                        if (fluidStack == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputFluids) {
                        return null;
                    }
                }
                if (this.mMinimalInputItems > 0) {
                    if (aInputs == null) {
                        return null;
                    }
                    tAmount = 0;
                    for (FluidStack fluidStack : aInputs) {
                        if (fluidStack == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputItems) {
                        return null;
                    }
                }
            }
            if (aNotUnificated) {
                aInputs = GT_OreDictUnificator.getStackArray(true, aInputs);
            }
            if (aRecipe != null && !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)aRecipe.mEUt ? aRecipe : null;
            }
            if (this.mUsualInputCount > 0 && aInputs != null) {
                ItemStack[] arr$ = aInputs;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Collection<GT_Recipe> collection;
                    ItemStack tStack = arr$[i$];
                    if (tStack == null) continue;
                    Collection<GT_Recipe> collection2 = this.mRecipeItemMap.get(new GT_ItemStack(tStack));
                    if (collection2 != null) {
                        for (GT_Recipe tRecipe : collection2) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                            return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                        }
                    }
                    if ((collection = this.mRecipeItemMap.get(new GT_ItemStack(GT_Utility.copyMetaData(32767L, tStack)))) == null) continue;
                    for (GT_Recipe tRecipe : collection) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                    }
                }
            }
            if (this.mMinimalInputItems == 0 && aFluids != null) {
                for (FluidStack aFluid : aFluids) {
                    Collection<GT_Recipe> collection;
                    if (aFluid == null || (collection = this.mRecipeFluidMap.get(aFluid.getFluid())) == null) continue;
                    for (GT_Recipe tRecipe : collection) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                    }
                }
            }
            return null;
        }

        protected GT_Recipe addToItemMap(GT_Recipe aRecipe) {
            for (ItemStack aStack : aRecipe.mInputs) {
                if (aStack == null) continue;
                GT_ItemStack tStack = new GT_ItemStack(aStack);
                Collection<GT_Recipe> tList = this.mRecipeItemMap.get(tStack);
                if (tList == null) {
                    tList = new HashSet<GT_Recipe>(1);
                    this.mRecipeItemMap.put(tStack, tList);
                }
                tList.add(aRecipe);
            }
            return aRecipe;
        }
    }
}

