/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import buildcraft.api.transport.IPipeTile;
import cofh.api.transport.IItemDuct;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.GregTech_API;
import gregtech.api.damagesources.GT_DamageSources;
import gregtech.api.enchants.Enchantment_Radioactivity;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.SubTag;
import gregtech.api.events.BlockScanningEvent;
import gregtech.api.interfaces.IDebugableBlock;
import gregtech.api.interfaces.IProjectileItem;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.interfaces.tileentity.IUpgradableMachine;
import gregtech.api.items.GT_EnergyArmor_Item;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.net.GT_Packet_Sound;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.threads.GT_Runnable_Sound;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_PlayedSound;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.tile.IEnergyStorage;
import ic2.api.tile.IWrenchable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Utility {
    public static volatile int VERSION = 508;
    public static boolean TE_CHECK = false;
    public static boolean BC_CHECK = false;
    public static boolean CHECK_ALL = true;
    private static final List<FluidContainerRegistry.FluidContainerData> sFluidContainerList = new ArrayList<FluidContainerRegistry.FluidContainerData>();
    private static final Map<GT_ItemStack, FluidContainerRegistry.FluidContainerData> sFilledContainerToData = new HashMap<GT_ItemStack, FluidContainerRegistry.FluidContainerData>();
    private static final Map<GT_ItemStack, Map<Fluid, FluidContainerRegistry.FluidContainerData>> sEmptyContainerToFluidToData = new HashMap<GT_ItemStack, Map<Fluid, FluidContainerRegistry.FluidContainerData>>();
    private static int sBookCount;
    public static Map<GT_PlayedSound, Integer> sPlayedSoundMap;

    public static Field getPublicField(Object aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getClass().getDeclaredField(aField);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Field getField(Object aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getClass().getDeclaredField(aField);
            rField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Field getField(Class aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getDeclaredField(aField);
            rField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Method getMethod(Class aObject, String aMethod, Class<?> ... aParameterTypes) {
        Method rMethod = null;
        try {
            rMethod = aObject.getMethod(aMethod, aParameterTypes);
            rMethod.setAccessible(true);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return rMethod;
    }

    public static Method getMethod(Object aObject, String aMethod, Class<?> ... aParameterTypes) {
        Method rMethod = null;
        try {
            rMethod = aObject.getClass().getMethod(aMethod, aParameterTypes);
            rMethod.setAccessible(true);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return rMethod;
    }

    public static Field getField(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
        try {
            Field tField;
            Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
            if (aPrivate) {
                tField.setAccessible(true);
            }
            return tField;
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    public static Object getFieldContent(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
        try {
            Field tField;
            Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
            if (aPrivate) {
                tField.setAccessible(true);
            }
            return tField.get(aObject instanceof Class || aObject instanceof String ? null : aObject);
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    public static Object callPublicMethod(Object aObject, String aMethod, Object ... aParameters) {
        return GT_Utility.callMethod(aObject, aMethod, false, false, true, aParameters);
    }

    public static Object callPrivateMethod(Object aObject, String aMethod, Object ... aParameters) {
        return GT_Utility.callMethod(aObject, aMethod, true, false, true, aParameters);
    }

    public static Object callMethod(Object aObject, String aMethod, boolean aPrivate, boolean aUseUpperCasedDataTypes, boolean aLogErrors, Object ... aParameters) {
        try {
            Method tMethod;
            Class[] tParameterTypes = new Class[aParameters.length];
            for (int i = 0; i < aParameters.length; i = (int)((byte)(i + 1))) {
                if (aParameters[i] instanceof Class) {
                    tParameterTypes[i] = (Class)aParameters[i];
                    aParameters[i] = null;
                } else {
                    tParameterTypes[i] = aParameters[i].getClass();
                }
                if (aUseUpperCasedDataTypes) continue;
                if (tParameterTypes[i] == Boolean.class) {
                    tParameterTypes[i] = Boolean.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Byte.class) {
                    tParameterTypes[i] = Byte.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Short.class) {
                    tParameterTypes[i] = Short.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Integer.class) {
                    tParameterTypes[i] = Integer.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Long.class) {
                    tParameterTypes[i] = Long.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Float.class) {
                    tParameterTypes[i] = Float.TYPE;
                    continue;
                }
                if (tParameterTypes[i] != Double.class) continue;
                tParameterTypes[i] = Double.TYPE;
            }
            Method method = tMethod = aObject instanceof Class ? ((Class)aObject).getMethod(aMethod, tParameterTypes) : aObject.getClass().getMethod(aMethod, tParameterTypes);
            if (aPrivate) {
                tMethod.setAccessible(true);
            }
            return tMethod.invoke(aObject, aParameters);
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object callConstructor(String aClass, int aConstructorIndex, Object aReplacementObject, boolean aLogErrors, Object ... aParameters) {
        if (aConstructorIndex < 0) {
            try {
                for (Constructor<?> tConstructor : Class.forName(aClass).getConstructors()) {
                    try {
                        return tConstructor.newInstance(aParameters);
                    }
                    catch (Throwable e) {
                    }
                }
                return aReplacementObject;
            }
            catch (Throwable e) {
                if (!aLogErrors) return aReplacementObject;
                e.printStackTrace(GT_Log.err);
                return aReplacementObject;
            }
        } else {
            try {
                return Class.forName(aClass).getConstructors()[aConstructorIndex].newInstance(aParameters);
            }
            catch (Throwable e) {
                if (!aLogErrors) return aReplacementObject;
                e.printStackTrace(GT_Log.err);
            }
        }
        return aReplacementObject;
    }

    public static String capitalizeString(String aString) {
        if (aString != null && aString.length() > 0) {
            return aString.substring(0, 1).toUpperCase() + aString.substring(1);
        }
        return "";
    }

    public static boolean getPotion(EntityLivingBase aPlayer, int aPotionIndex) {
        block4: {
            try {
                Field tPotionHashmap = null;
                for (Field var6 : EntityLiving.class.getDeclaredFields()) {
                    if (var6.getType() != HashMap.class) continue;
                    tPotionHashmap = var6;
                    tPotionHashmap.setAccessible(true);
                    break;
                }
                if (tPotionHashmap != null) {
                    return ((HashMap)tPotionHashmap.get(aPlayer)).get(aPotionIndex) != null;
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public static String getClassName(Object aObject) {
        if (aObject == null) {
            return "null";
        }
        return aObject.getClass().getName().substring(aObject.getClass().getName().lastIndexOf(".") + 1);
    }

    public static void removePotion(EntityLivingBase aPlayer, int aPotionIndex) {
        block4: {
            try {
                Field tPotionHashmap = null;
                for (Field var6 : EntityLiving.class.getDeclaredFields()) {
                    if (var6.getType() != HashMap.class) continue;
                    tPotionHashmap = var6;
                    tPotionHashmap.setAccessible(true);
                    break;
                }
                if (tPotionHashmap != null) {
                    ((HashMap)tPotionHashmap.get(aPlayer)).remove(aPotionIndex);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
    }

    public static boolean getFullInvisibility(EntityPlayer aPlayer) {
        block4: {
            try {
                if (aPlayer.func_82150_aj()) {
                    for (int i = 0; i < 4; ++i) {
                        if (aPlayer.field_71071_by.field_70460_b[i] == null || !(aPlayer.field_71071_by.field_70460_b[i].func_77973_b() instanceof GT_EnergyArmor_Item) || (((GT_EnergyArmor_Item)aPlayer.field_71071_by.field_70460_b[i].func_77973_b()).mSpecials & 0x200) == 0 || !GT_ModHandler.canUseElectricItem(aPlayer.field_71071_by.field_70460_b[i], 10000)) continue;
                        return true;
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public static ItemStack suckOneItemStackAt(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
        for (EntityItem tItem : (ArrayList)aWorld.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + aL), (double)(aY + aH), (double)(aZ + aW)))) {
            if (tItem.field_70128_L) continue;
            aWorld.func_72900_e((Entity)tItem);
            tItem.func_70106_y();
            return tItem.func_92059_d();
        }
        return null;
    }

    public static byte getOppositeSide(int aSide) {
        return (byte)ForgeDirection.getOrientation((int)aSide).getOpposite().ordinal();
    }

    public static byte getTier(long l) {
        byte i = -1;
        while ((i = (byte)((byte)(i + 1))) < GT_Values.V.length) {
            if (l > GT_Values.V[i]) continue;
            return i;
        }
        return i;
    }

    public static void sendChatToPlayer(EntityPlayer aPlayer, String aChatMessage) {
        if (aPlayer != null && aPlayer instanceof EntityPlayerMP && aChatMessage != null) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentText(aChatMessage));
        }
    }

    public static void checkAvailabilities() {
        if (CHECK_ALL) {
            Class<IItemDuct> tClass;
            try {
                tClass = IItemDuct.class;
                tClass.getCanonicalName();
                TE_CHECK = true;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                tClass = IPipeTile.class;
                tClass.getCanonicalName();
                BC_CHECK = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CHECK_ALL = false;
        }
    }

    public static boolean isConnectableNonInventoryPipe(Object aTileEntity, int aSide) {
        if (aTileEntity == null) {
            return false;
        }
        GT_Utility.checkAvailabilities();
        if (TE_CHECK && aTileEntity instanceof IItemDuct) {
            return true;
        }
        if (BC_CHECK && aTileEntity instanceof IPipeTile) {
            return ((IPipeTile)aTileEntity).isPipeConnected(ForgeDirection.getOrientation((int)aSide));
        }
        return false;
    }

    public static byte moveStackIntoPipe(IInventory aTileEntity1, Object aTileEntity2, int[] aGrabSlots, int aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        if (aTileEntity1 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMaxMoveAtOnce <= 0 || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        if (aTileEntity2 != null) {
            GT_Utility.checkAvailabilities();
            if (TE_CHECK && aTileEntity2 instanceof IItemDuct) {
                for (int i = 0; i < aGrabSlots.length; ++i) {
                    if (!GT_Utility.listContainsItem(aFilter, aTileEntity1.func_70301_a(aGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], (byte)aGrabFrom, aTileEntity1.func_70301_a(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a) continue;
                    ItemStack tStack = GT_Utility.copyAmount(Math.min(aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.func_70301_a(aGrabSlots[i]));
                    ItemStack rStack = ((IItemDuct)aTileEntity2).insertItem(ForgeDirection.getOrientation((int)aPutTo), GT_Utility.copy(tStack));
                    byte tMovedItemCount = (byte)(tStack.field_77994_a - (rStack == null ? 0 : rStack.field_77994_a));
                    if (tMovedItemCount < 1) continue;
                    aTileEntity1.func_70298_a(aGrabSlots[i], (int)tMovedItemCount);
                    aTileEntity1.func_70296_d();
                    return tMovedItemCount;
                }
                return 0;
            }
            if (BC_CHECK && aTileEntity2 instanceof IPipeTile) {
                for (int i = 0; i < aGrabSlots.length; ++i) {
                    ItemStack tStack;
                    byte tMovedItemCount;
                    if (!GT_Utility.listContainsItem(aFilter, aTileEntity1.func_70301_a(aGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], (byte)aGrabFrom, aTileEntity1.func_70301_a(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a || (tMovedItemCount = (byte)((IPipeTile)aTileEntity2).injectItem(GT_Utility.copy(tStack = GT_Utility.copyAmount(Math.min(aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.func_70301_a(aGrabSlots[i]))), false, ForgeDirection.getOrientation((int)aPutTo))) < Math.max(aMinMoveAtOnce, aMinTargetStackSize)) continue;
                    tMovedItemCount = (byte)((IPipeTile)aTileEntity2).injectItem(GT_Utility.copyAmount(tMovedItemCount, tStack), true, ForgeDirection.getOrientation((int)aPutTo));
                    aTileEntity1.func_70298_a(aGrabSlots[i], (int)tMovedItemCount);
                    aTileEntity1.func_70296_d();
                    return tMovedItemCount;
                }
                return 0;
            }
        }
        ForgeDirection tDirection = ForgeDirection.getOrientation((int)aGrabFrom);
        if (aTileEntity1 instanceof TileEntity && tDirection != ForgeDirection.UNKNOWN && tDirection.getOpposite() == ForgeDirection.getOrientation((int)aPutTo)) {
            int tX = ((TileEntity)aTileEntity1).field_145851_c + tDirection.offsetX;
            int tY = ((TileEntity)aTileEntity1).field_145848_d + tDirection.offsetY;
            int tZ = ((TileEntity)aTileEntity1).field_145849_e + tDirection.offsetZ;
            if (!GT_Utility.hasBlockHitBox(((TileEntity)aTileEntity1).func_145831_w(), tX, tY, tZ)) {
                for (int i = 0; i < aGrabSlots.length; ++i) {
                    if (!GT_Utility.listContainsItem(aFilter, aTileEntity1.func_70301_a(aGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, aGrabSlots[i], (byte)aGrabFrom, aTileEntity1.func_70301_a(aGrabSlots[i])) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a) continue;
                    ItemStack tStack = GT_Utility.copyAmount(Math.min(aTileEntity1.func_70301_a((int)aGrabSlots[i]).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), aTileEntity1.func_70301_a(aGrabSlots[i]));
                    EntityItem tEntity = new EntityItem(((TileEntity)aTileEntity1).func_145831_w(), (double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5, tStack);
                    tEntity.field_70179_y = 0.0;
                    tEntity.field_70181_x = 0.0;
                    tEntity.field_70159_w = 0.0;
                    ((TileEntity)aTileEntity1).func_145831_w().func_72838_d((Entity)tEntity);
                    aTileEntity1.func_70298_a(aGrabSlots[i], tStack.field_77994_a);
                    aTileEntity1.func_70296_d();
                    return (byte)tStack.field_77994_a;
                }
            }
        }
        return 0;
    }

    public static byte moveStackFromSlotAToSlotB(IInventory aTileEntity1, IInventory aTileEntity2, int aGrabFrom, int aPutTo, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        if (aTileEntity1 == null || aTileEntity2 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMaxMoveAtOnce <= 0 || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        ItemStack tStack1 = aTileEntity1.func_70301_a(aGrabFrom);
        ItemStack tStack2 = aTileEntity2.func_70301_a(aPutTo);
        ItemStack tStack3 = null;
        if (tStack1 != null) {
            if (tStack2 != null && !GT_Utility.areStacksEqual(tStack1, tStack2)) {
                return 0;
            }
            tStack3 = GT_Utility.copy(tStack1);
            aMaxTargetStackSize = (byte)Math.min(aMaxTargetStackSize, Math.min(tStack3.func_77976_d(), Math.min(tStack2 == null ? Integer.MAX_VALUE : tStack2.func_77976_d(), aTileEntity2.func_70297_j_())));
            tStack3.field_77994_a = Math.min(tStack3.field_77994_a, aMaxTargetStackSize - (tStack2 == null ? 0 : tStack2.field_77994_a));
            if (tStack3.field_77994_a > aMaxMoveAtOnce) {
                tStack3.field_77994_a = aMaxMoveAtOnce;
            }
            if (tStack3.field_77994_a + (tStack2 == null ? 0 : tStack2.field_77994_a) >= Math.min(tStack3.func_77976_d(), aMinTargetStackSize) && tStack3.field_77994_a >= aMinMoveAtOnce) {
                tStack3 = aTileEntity1.func_70298_a(aGrabFrom, tStack3.field_77994_a);
                aTileEntity1.func_70296_d();
                if (tStack3 != null) {
                    if (tStack2 == null) {
                        aTileEntity2.func_70299_a(aPutTo, GT_Utility.copy(tStack3));
                        aTileEntity2.func_70296_d();
                    } else {
                        tStack2.field_77994_a += tStack3.field_77994_a;
                        aTileEntity2.func_70296_d();
                    }
                    return (byte)tStack3.field_77994_a;
                }
            }
        }
        return 0;
    }

    public static boolean isAllowedToTakeFromSlot(IInventory aTileEntity, int aSlot, byte aSide, ItemStack aStack) {
        if (ForgeDirection.getOrientation((int)aSide) == ForgeDirection.UNKNOWN) {
            return GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)0, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)1, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)2, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)3, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)4, aStack) || GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, (byte)5, aStack);
        }
        if (aTileEntity instanceof ISidedInventory) {
            return ((ISidedInventory)aTileEntity).func_102008_b(aSlot, aStack, (int)aSide);
        }
        return true;
    }

    public static boolean isAllowedToPutIntoSlot(IInventory aTileEntity, int aSlot, byte aSide, ItemStack aStack, byte aMaxStackSize) {
        ItemStack tStack = aTileEntity.func_70301_a(aSlot);
        if (!(tStack == null || GT_Utility.areStacksEqual(tStack, aStack) && tStack.field_77994_a < tStack.func_77976_d())) {
            return false;
        }
        if (ForgeDirection.getOrientation((int)aSide) == ForgeDirection.UNKNOWN) {
            return GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)0, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)1, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)2, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)3, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)4, aStack, aMaxStackSize) || GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, (byte)5, aStack, aMaxStackSize);
        }
        if (aTileEntity instanceof ISidedInventory && !((ISidedInventory)aTileEntity).func_102007_a(aSlot, aStack, (int)aSide)) {
            return false;
        }
        return aTileEntity.func_94041_b(aSlot, aStack);
    }

    public static byte moveOneItemStack(Object aTileEntity1, Object aTileEntity2, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        if (aTileEntity1 != null && aTileEntity1 instanceof IInventory) {
            return GT_Utility.moveOneItemStack((IInventory)aTileEntity1, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, true);
        }
        return 0;
    }

    private static byte moveOneItemStack(IInventory aTileEntity1, Object aTileEntity2, byte aGrabFrom, byte aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, boolean aDoCheckChests) {
        if (aTileEntity1 == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        int[] tGrabSlots = null;
        if (aTileEntity1 instanceof ISidedInventory) {
            tGrabSlots = ((ISidedInventory)aTileEntity1).func_94128_d((int)aGrabFrom);
        }
        if (tGrabSlots == null) {
            tGrabSlots = new int[aTileEntity1.func_70302_i_()];
            for (int i = 0; i < tGrabSlots.length; ++i) {
                tGrabSlots[i] = i;
            }
        }
        if (aTileEntity2 != null && aTileEntity2 instanceof IInventory) {
            byte tAmount;
            int i;
            int[] tPutSlots = null;
            if (aTileEntity2 instanceof ISidedInventory) {
                tPutSlots = ((ISidedInventory)aTileEntity2).func_94128_d((int)aPutTo);
            }
            if (tPutSlots == null) {
                tPutSlots = new int[((IInventory)aTileEntity2).func_70302_i_()];
                for (i = 0; i < tPutSlots.length; ++i) {
                    tPutSlots[i] = i;
                }
            }
            for (i = 0; i < tGrabSlots.length; ++i) {
                for (int j = 0; j < tPutSlots.length; ++j) {
                    byte tMovedItemCount;
                    if (!GT_Utility.listContainsItem(aFilter, aTileEntity1.func_70301_a(tGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, tGrabSlots[i], aGrabFrom, aTileEntity1.func_70301_a(tGrabSlots[i])) || !GT_Utility.isAllowedToPutIntoSlot((IInventory)aTileEntity2, tPutSlots[j], aPutTo, aTileEntity1.func_70301_a(tGrabSlots[i]), aMaxTargetStackSize) || (tMovedItemCount = GT_Utility.moveStackFromSlotAToSlotB(aTileEntity1, (IInventory)aTileEntity2, tGrabSlots[i], tPutSlots[j], aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) <= 0) continue;
                    return tMovedItemCount;
                }
            }
            if (aDoCheckChests && aTileEntity1 instanceof TileEntityChest) {
                TileEntityChest tTileEntity1 = (TileEntityChest)aTileEntity1;
                if (tTileEntity1.field_145984_a) {
                    tAmount = 0;
                    if (tTileEntity1.field_145991_k != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)tTileEntity1.field_145991_k, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity1.field_145992_i != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)tTileEntity1.field_145992_i, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity1.field_145990_j != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)tTileEntity1.field_145990_j, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity1.field_145988_l != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)tTileEntity1.field_145988_l, aTileEntity2, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    }
                    if (tAmount != 0) {
                        return tAmount;
                    }
                }
            }
            if (aDoCheckChests && aTileEntity2 instanceof TileEntityChest) {
                TileEntityChest tTileEntity2 = (TileEntityChest)aTileEntity2;
                if (tTileEntity2.field_145984_a) {
                    tAmount = 0;
                    if (tTileEntity2.field_145991_k != null) {
                        tAmount = GT_Utility.moveOneItemStack(aTileEntity1, tTileEntity2.field_145991_k, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.field_145992_i != null) {
                        tAmount = GT_Utility.moveOneItemStack(aTileEntity1, tTileEntity2.field_145992_i, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.field_145990_j != null) {
                        tAmount = GT_Utility.moveOneItemStack(aTileEntity1, tTileEntity2.field_145990_j, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.field_145988_l != null) {
                        tAmount = GT_Utility.moveOneItemStack(aTileEntity1, tTileEntity2.field_145988_l, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    }
                    if (tAmount != 0) {
                        return tAmount;
                    }
                }
            }
        }
        return GT_Utility.moveStackIntoPipe(aTileEntity1, aTileEntity2, tGrabSlots, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce);
    }

    public static byte moveOneItemStackIntoSlot(Object aTileEntity1, Object aTileEntity2, byte aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        int i;
        if (aTileEntity1 == null || !(aTileEntity1 instanceof IInventory) || aPutTo < 0 || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        int[] tGrabSlots = null;
        if (aTileEntity1 instanceof ISidedInventory) {
            tGrabSlots = ((ISidedInventory)aTileEntity1).func_94128_d((int)aGrabFrom);
        }
        if (tGrabSlots == null) {
            tGrabSlots = new int[((IInventory)aTileEntity1).func_70302_i_()];
            for (i = 0; i < tGrabSlots.length; ++i) {
                tGrabSlots[i] = i;
            }
        }
        if (aTileEntity2 != null && aTileEntity2 instanceof IInventory) {
            for (i = 0; i < tGrabSlots.length; ++i) {
                byte tMovedItemCount;
                if (!GT_Utility.listContainsItem(aFilter, ((IInventory)aTileEntity1).func_70301_a(tGrabSlots[i]), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot((IInventory)aTileEntity1, tGrabSlots[i], aGrabFrom, ((IInventory)aTileEntity1).func_70301_a(tGrabSlots[i])) || !GT_Utility.isAllowedToPutIntoSlot((IInventory)aTileEntity2, aPutTo, (byte)6, ((IInventory)aTileEntity1).func_70301_a(tGrabSlots[i]), aMaxTargetStackSize) || (tMovedItemCount = GT_Utility.moveStackFromSlotAToSlotB((IInventory)aTileEntity1, (IInventory)aTileEntity2, tGrabSlots[i], aPutTo, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) <= 0) continue;
                return tMovedItemCount;
            }
        }
        GT_Utility.moveStackIntoPipe((IInventory)aTileEntity1, aTileEntity2, tGrabSlots, aGrabFrom, aPutTo, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce);
        return 0;
    }

    public static byte moveFromSlotToSlot(IInventory aTileEntity1, IInventory aTileEntity2, int aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        byte tMovedItemCount;
        if (aTileEntity1 == null || aTileEntity2 == null || aGrabFrom < 0 || aPutTo < 0 || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        if (GT_Utility.listContainsItem(aFilter, aTileEntity1.func_70301_a(aGrabFrom), true, aInvertFilter) && GT_Utility.isAllowedToTakeFromSlot(aTileEntity1, aGrabFrom, (byte)6, aTileEntity1.func_70301_a(aGrabFrom)) && GT_Utility.isAllowedToPutIntoSlot(aTileEntity2, aPutTo, (byte)6, aTileEntity1.func_70301_a(aGrabFrom), aMaxTargetStackSize) && (tMovedItemCount = GT_Utility.moveStackFromSlotAToSlotB(aTileEntity1, aTileEntity2, aGrabFrom, aPutTo, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) > 0) {
            return tMovedItemCount;
        }
        return 0;
    }

    public static boolean listContainsItem(Collection<ItemStack> aList, ItemStack aStack, boolean aTIfListEmpty, boolean aInvertFilter) {
        if (aStack == null || aStack.field_77994_a < 1) {
            return false;
        }
        if (aList == null) {
            return aTIfListEmpty;
        }
        while (aList.contains(null)) {
            aList.remove(null);
        }
        if (aList.size() < 1) {
            return aTIfListEmpty;
        }
        Iterator<ItemStack> tIterator = aList.iterator();
        ItemStack tStack = null;
        while (tIterator.hasNext()) {
            tStack = tIterator.next();
            if (tStack == null || !GT_Utility.areStacksEqual(aStack, tStack)) continue;
            return !aInvertFilter;
        }
        return aInvertFilter;
    }

    public static boolean areStacksOrToolsEqual(ItemStack aStack1, ItemStack aStack2) {
        if (aStack1 != null && aStack2 != null && aStack1.func_77973_b() == aStack2.func_77973_b()) {
            if (aStack1.func_77973_b().func_77645_m()) {
                return true;
            }
            boolean bl = aStack1.func_77978_p() == null;
            boolean bl2 = aStack2.func_77978_p() == null;
            return !(bl != bl2 || aStack1.func_77978_p() != null && !aStack1.func_77978_p().equals((Object)aStack2.func_77978_p()) || Items.field_151008_G.getDamage(aStack1) != Items.field_151008_G.getDamage(aStack2) && Items.field_151008_G.getDamage(aStack1) != Short.MAX_VALUE && Items.field_151008_G.getDamage(aStack2) != Short.MAX_VALUE);
        }
        return false;
    }

    public static boolean areFluidsEqual(FluidStack aFluid1, FluidStack aFluid2) {
        return GT_Utility.areFluidsEqual(aFluid1, aFluid2, false);
    }

    public static boolean areFluidsEqual(FluidStack aFluid1, FluidStack aFluid2, boolean aIgnoreNBT) {
        return aFluid1 != null && aFluid2 != null && aFluid1.getFluid() == aFluid2.getFluid() && (aIgnoreNBT || aFluid1.tag == null == (aFluid2.tag == null) && (aFluid1.tag == null || aFluid1.tag.equals((Object)aFluid2.tag)));
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2) {
        return GT_Utility.areStacksEqual(aStack1, aStack2, false);
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return !(aStack1 == null || aStack2 == null || aStack1.func_77973_b() != aStack2.func_77973_b() || !aIgnoreNBT && (aStack1.func_77978_p() == null != (aStack2.func_77978_p() == null) || aStack1.func_77978_p() != null && !aStack1.func_77978_p().equals((Object)aStack2.func_77978_p())) || Items.field_151008_G.getDamage(aStack1) != Items.field_151008_G.getDamage(aStack2) && Items.field_151008_G.getDamage(aStack1) != Short.MAX_VALUE && Items.field_151008_G.getDamage(aStack2) != Short.MAX_VALUE);
    }

    public static boolean areUnificationsEqual(ItemStack aStack1, ItemStack aStack2) {
        return GT_Utility.areUnificationsEqual(aStack1, aStack2, false);
    }

    public static boolean areUnificationsEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return GT_Utility.areStacksEqual(GT_OreDictUnificator.get(aStack1), GT_OreDictUnificator.get(aStack2), aIgnoreNBT);
    }

    public static String getFluidName(Fluid aFluid, boolean aLocalized) {
        String rName;
        if (aFluid == null) {
            return "";
        }
        String string = rName = aLocalized ? aFluid.getLocalizedName(new FluidStack(aFluid, 0)) : aFluid.getUnlocalizedName();
        if (rName.contains("fluid.") || rName.contains("tile.")) {
            return GT_Utility.capitalizeString(rName.replaceAll("fluid.", "").replaceAll("tile.", ""));
        }
        return rName;
    }

    public static String getFluidName(FluidStack aFluid, boolean aLocalized) {
        if (aFluid == null) {
            return "";
        }
        return GT_Utility.getFluidName(aFluid.getFluid(), aLocalized);
    }

    public static void reInit() {
        sFilledContainerToData.clear();
        sEmptyContainerToFluidToData.clear();
        for (FluidContainerRegistry.FluidContainerData tData : sFluidContainerList) {
            sFilledContainerToData.put(new GT_ItemStack(tData.filledContainer), tData);
            Map<Fluid, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(tData.emptyContainer));
            if (tFluidToContainer == null) {
                tFluidToContainer = new HashMap<Fluid, FluidContainerRegistry.FluidContainerData>();
                sEmptyContainerToFluidToData.put(new GT_ItemStack(tData.emptyContainer), tFluidToContainer);
                GregTech_API.sFluidMappings.add(tFluidToContainer);
            }
            tFluidToContainer.put(tData.fluid.getFluid(), tData);
        }
    }

    public static void addFluidContainerData(FluidContainerRegistry.FluidContainerData aData) {
        sFluidContainerList.add(aData);
        sFilledContainerToData.put(new GT_ItemStack(aData.filledContainer), aData);
        Map<Fluid, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(aData.emptyContainer));
        if (tFluidToContainer == null) {
            tFluidToContainer = new HashMap<Fluid, FluidContainerRegistry.FluidContainerData>();
            sEmptyContainerToFluidToData.put(new GT_ItemStack(aData.emptyContainer), tFluidToContainer);
            GregTech_API.sFluidMappings.add(tFluidToContainer);
        }
        tFluidToContainer.put(aData.fluid.getFluid(), aData);
    }

    public static ItemStack fillFluidContainer(FluidStack aFluid, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack) || aFluid == null) {
            return null;
        }
        if (GT_ModHandler.isWater(aFluid) && ItemList.Bottle_Empty.isStackEqual(aStack)) {
            if (aFluid.amount >= 250) {
                if (aRemoveFluidDirectly) {
                    aFluid.amount -= 250;
                }
                return new ItemStack((Item)Items.field_151068_bn, 1, 0);
            }
            return null;
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getFluid(aStack) == null && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) <= aFluid.amount) {
            if (aRemoveFluidDirectly) {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
                aStack = GT_Utility.copyAmount(1L, aStack);
                aFluid.amount -= iFluidContainerItem.fill(aStack, aFluid, true);
            } else {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
                aStack = GT_Utility.copyAmount(1L, aStack);
                iFluidContainerItem.fill(aStack, aFluid, true);
            }
            return aStack;
        }
        Map<Fluid, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(aStack));
        if (tFluidToContainer == null) {
            return null;
        }
        FluidContainerRegistry.FluidContainerData tData = tFluidToContainer.get(aFluid.getFluid());
        if (tData == null || tData.fluid.amount > aFluid.amount) {
            return null;
        }
        if (aRemoveFluidDirectly) {
            aFluid.amount -= tData.fluid.amount;
        }
        return GT_Utility.copyAmount(1L, tData.filledContainer);
    }

    public static ItemStack getFluidDisplayStack(Fluid aFluid) {
        return aFluid == null ? null : GT_Utility.getFluidDisplayStack(new FluidStack(aFluid, 0), false);
    }

    public static ItemStack getFluidDisplayStack(FluidStack aFluid, boolean aUseStackSize) {
        if (aFluid == null || aFluid.getFluid() == null) {
            return null;
        }
        int tmp = 0;
        try {
            tmp = aFluid.getFluid().getID();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        ItemStack rStack = ItemList.Display_Fluid.getWithDamage(aUseStackSize ? (long)(aFluid.amount / 1000) : 1L, tmp, new Object[0]);
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.func_74772_a("mFluidDisplayAmount", (long)aFluid.amount);
        tNBT.func_74772_a("mFluidDisplayHeat", (long)aFluid.getFluid().getTemperature(aFluid));
        tNBT.func_74757_a("mFluidState", aFluid.getFluid().isGaseous(aFluid));
        rStack.func_77982_d(tNBT);
        return rStack;
    }

    public static boolean containsFluid(ItemStack aStack, FluidStack aFluid, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack) || aFluid == null) {
            return false;
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
            aStack = GT_Utility.copyAmount(1L, aStack);
            return aFluid.isFluidEqual(iFluidContainerItem.getFluid(aStack));
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        return tData == null ? false : tData.fluid.isFluidEqual(aFluid);
    }

    public static FluidStack getFluidForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            return ((IFluidContainerItem)aStack.func_77973_b()).drain(GT_Utility.copyAmount(1L, aStack), Integer.MAX_VALUE, true);
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        return tData == null ? null : tData.fluid.copy();
    }

    public static ItemStack getContainerForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        if (tData != null) {
            return GT_Utility.copyAmount(1L, tData.emptyContainer);
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
            aStack = GT_Utility.copyAmount(1L, aStack);
            iFluidContainerItem.drain(aStack, Integer.MAX_VALUE, true);
            return aStack;
        }
        return null;
    }

    public static ItemStack getContainerItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        if (aStack.func_77973_b().hasContainerItem(aStack)) {
            return aStack.func_77973_b().getContainerItem(aStack);
        }
        if (ItemList.Cell_Empty.isStackEqual(aStack, false, true)) {
            return null;
        }
        if (ItemList.IC2_Fuel_Can_Filled.isStackEqual(aStack, false, true)) {
            return ItemList.IC2_Fuel_Can_Empty.get(1L, new Object[0]);
        }
        if (aStack.func_77973_b() == Items.field_151068_bn || aStack.func_77973_b() == Items.field_151062_by || ItemList.TF_Vial_FieryBlood.isStackEqual(aStack) || ItemList.TF_Vial_FieryTears.isStackEqual(aStack)) {
            return ItemList.Bottle_Empty.get(1L, new Object[0]);
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            ItemStack tStack = GT_Utility.copyAmount(1L, aStack);
            ((IFluidContainerItem)aStack.func_77973_b()).drain(tStack, Integer.MAX_VALUE, true);
            if (!GT_Utility.areStacksEqual(aStack, tStack)) {
                return tStack;
            }
            return null;
        }
        int tCapsuleCount = GT_ModHandler.getCapsuleCellContainerCount(aStack);
        if (tCapsuleCount > 0) {
            return ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]);
        }
        if (ItemList.IC2_ForgeHammer.isStackEqual(aStack) || ItemList.IC2_WireCutter.isStackEqual(aStack)) {
            return GT_Utility.copyMetaData(Items.field_151008_G.getDamage(aStack) + 1, aStack);
        }
        return null;
    }

    public static synchronized boolean removeSimpleIC2MachineRecipe(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, ItemStack aOutput) {
        if (GT_Utility.isStackInvalid(aInput) && GT_Utility.isStackInvalid(aOutput) || aRecipeList == null) {
            return false;
        }
        boolean rReturn = false;
        Iterator<Map.Entry<IRecipeInput, RecipeOutput>> tIterator = aRecipeList.entrySet().iterator();
        aOutput = GT_OreDictUnificator.get(aOutput);
        block0: while (tIterator.hasNext()) {
            List tList;
            Map.Entry<IRecipeInput, RecipeOutput> tEntry = tIterator.next();
            if (aInput != null && !tEntry.getKey().matches(aInput) || (tList = tEntry.getValue().items) == null) continue;
            for (ItemStack tOutput : tList) {
                if (aOutput != null && !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tOutput), aOutput)) continue;
                tIterator.remove();
                rReturn = true;
                continue block0;
            }
        }
        return rReturn;
    }

    public static boolean addSimpleIC2MachineRecipe(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, NBTTagCompound aNBT, Object ... aOutput) {
        if (GT_Utility.isStackInvalid(aInput) || aOutput.length == 0 || aRecipeList == null) {
            return false;
        }
        ItemData tOreName = GT_OreDictUnificator.getAssociation(aInput);
        for (int i = 0; i < aOutput.length; ++i) {
            if (aOutput[i] != null) continue;
            System.out.println("EmptyIC2Output!" + aInput.func_77977_a());
            return false;
        }
        if (tOreName != null) {
            aRecipeList.put((IRecipeInput)new RecipeInputOreDict(tOreName.toString(), aInput.field_77994_a), new RecipeOutput(aNBT, GT_OreDictUnificator.getStackArray(true, aOutput)));
        } else {
            aRecipeList.put((IRecipeInput)new RecipeInputItemStack(GT_Utility.copy(aInput), aInput.field_77994_a), new RecipeOutput(aNBT, GT_OreDictUnificator.getStackArray(true, aOutput)));
        }
        return true;
    }

    public static ItemStack getWrittenBook(String aMapping, ItemStack aStackToPutNBT) {
        if (GT_Utility.isStringInvalid(aMapping)) {
            return null;
        }
        ItemStack rStack = GregTech_API.sBookList.get(aMapping);
        if (rStack == null) {
            return aStackToPutNBT;
        }
        if (aStackToPutNBT != null) {
            aStackToPutNBT.func_77982_d(rStack.func_77978_p());
            return aStackToPutNBT;
        }
        return GT_Utility.copyAmount(1L, rStack);
    }

    public static ItemStack getWrittenBook(String aMapping, String aTitle, String aAuthor, String ... aPages) {
        if (GT_Utility.isStringInvalid(aMapping)) {
            return null;
        }
        ItemStack rStack = GregTech_API.sBookList.get(aMapping);
        if (rStack != null) {
            return GT_Utility.copyAmount(1L, rStack);
        }
        if (GT_Utility.isStringInvalid(aTitle) || GT_Utility.isStringInvalid(aAuthor) || aPages.length <= 0) {
            return null;
        }
        ++sBookCount;
        rStack = new ItemStack(Items.field_151164_bB, 1);
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.func_74778_a("title", GT_LanguageManager.addStringLocalization("Book." + aTitle + ".Name", aTitle));
        tNBT.func_74778_a("author", aAuthor);
        NBTTagList tNBTList = new NBTTagList();
        for (byte i = 0; i < aPages.length; i = (byte)(i + 1)) {
            aPages[i] = GT_LanguageManager.addStringLocalization("Book." + aTitle + ".Page" + (i < 10 ? "0" + i : Byte.valueOf(i)), aPages[i]);
            if (i < 48) {
                if (aPages[i].length() < 256) {
                    tNBTList.func_74742_a((NBTBase)new NBTTagString(aPages[i]));
                    continue;
                }
                GT_Log.err.println("WARNING: String for written Book too long! -> " + aPages[i]);
                continue;
            }
            GT_Log.err.println("WARNING: Too much Pages for written Book! -> " + aTitle);
            break;
        }
        tNBTList.func_74742_a((NBTBase)new NBTTagString("Credits to " + aAuthor + " for writing this Book. This was Book Nr. " + sBookCount + " at its creation. Gotta get 'em all!"));
        tNBT.func_74782_a("pages", (NBTBase)tNBTList);
        rStack.func_77982_d(tNBT);
        GT_Log.out.println("GT_Mod: Added Book to Book List  -  Mapping: '" + aMapping + "'  -  Name: '" + aTitle + "'  -  Author: '" + aAuthor + "'");
        GregTech_API.sBookList.put(aMapping, rStack);
        return GT_Utility.copy(rStack);
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength) {
        return GT_Utility.doSoundAtClient(aSoundName, aTimeUntilNextSound, aSoundStrength, (Entity)GT_Values.GT.getThePlayer());
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, Entity aEntity) {
        if (aEntity == null) {
            return false;
        }
        return GT_Utility.doSoundAtClient(aSoundName, aTimeUntilNextSound, aSoundStrength, aEntity.field_70165_t, aEntity.field_70163_u, aEntity.field_70161_v);
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, double aX, double aY, double aZ) {
        return GT_Utility.doSoundAtClient(aSoundName, aTimeUntilNextSound, aSoundStrength, 0.9f + new Random().nextFloat() * 0.2f, aX, aY, aZ);
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, float aSoundModulation, double aX, double aY, double aZ) {
        if (GT_Utility.isStringInvalid(aSoundName) || !FMLCommonHandler.instance().getEffectiveSide().isClient() || GT_Values.GT.getThePlayer() == null || !GT_Values.GT.getThePlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (GregTech_API.sMultiThreadedSounds) {
            new Thread((Runnable)new GT_Runnable_Sound(GT_Values.GT.getThePlayer().field_70170_p, MathHelper.func_76128_c((double)aX), MathHelper.func_76128_c((double)aY), MathHelper.func_76128_c((double)aZ), aTimeUntilNextSound, aSoundName, aSoundStrength, aSoundModulation), "Sound Effect").start();
        } else {
            new GT_Runnable_Sound(GT_Values.GT.getThePlayer().field_70170_p, MathHelper.func_76128_c((double)aX), MathHelper.func_76128_c((double)aY), MathHelper.func_76128_c((double)aZ), aTimeUntilNextSound, aSoundName, aSoundStrength, aSoundModulation).run();
        }
        return true;
    }

    public static boolean sendSoundToPlayers(World aWorld, String aSoundName, float aSoundStrength, float aSoundModulation, int aX, int aY, int aZ) {
        if (GT_Utility.isStringInvalid(aSoundName) || aWorld == null || aWorld.field_72995_K) {
            return false;
        }
        GT_Values.NW.sendPacketToAllPlayersInRange(aWorld, new GT_Packet_Sound(aSoundName, aSoundStrength, aSoundModulation, aX, (short)aY, aZ), aX, aZ);
        return true;
    }

    public static int stackToInt(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        return Item.func_150891_b((Item)aStack.func_77973_b()) | Items.field_151008_G.getDamage(aStack) << 16;
    }

    public static int stackToWildcard(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        return Item.func_150891_b((Item)aStack.func_77973_b()) | 0x7FFF0000;
    }

    public static ItemStack intToStack(int aStack) {
        int tID = aStack & 0xFFFF;
        int tMeta = aStack >>> 16;
        Item tItem = Item.func_150899_d((int)tID);
        if (tItem != null) {
            return new ItemStack(tItem, 1, tMeta);
        }
        return null;
    }

    public static Integer[] stacksToIntegerArray(ItemStack ... aStacks) {
        Integer[] rArray = new Integer[aStacks.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = GT_Utility.stackToInt(aStacks[i]);
        }
        return rArray;
    }

    public static int[] stacksToIntArray(ItemStack ... aStacks) {
        int[] rArray = new int[aStacks.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = GT_Utility.stackToInt(aStacks[i]);
        }
        return rArray;
    }

    public static boolean arrayContains(Object aObject, Object ... aObjects) {
        return GT_Utility.listContains(aObject, Arrays.asList(aObjects));
    }

    public static boolean listContains(Object aObject, Collection aObjects) {
        if (aObjects == null) {
            return false;
        }
        return aObjects.contains(aObject);
    }

    public static <T> boolean arrayContainsNonNull(T ... aArray) {
        if (aArray != null) {
            for (T tObject : aArray) {
                if (tObject == null) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> ArrayList<T> getArrayListWithoutNulls(T ... aArray) {
        if (aArray == null) {
            return new ArrayList();
        }
        ArrayList<T> rList = new ArrayList<T>(Arrays.asList(aArray));
        for (int i = 0; i < rList.size(); ++i) {
            if (rList.get(i) != null) continue;
            rList.remove(i--);
        }
        return rList;
    }

    public static <T> ArrayList<T> getArrayListWithoutTrailingNulls(T ... aArray) {
        if (aArray == null) {
            return new ArrayList();
        }
        ArrayList<T> rList = new ArrayList<T>(Arrays.asList(aArray));
        int i = rList.size() - 1;
        while (i >= 0 && rList.get(i) == null) {
            rList.remove(i--);
        }
        return rList;
    }

    public static Block getBlock(Object aBlock) {
        return (Block)aBlock;
    }

    public static Block getBlockFromStack(Object aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return Blocks.field_150350_a;
        }
        return Block.func_149634_a((Item)((ItemStack)aStack).func_77973_b());
    }

    public static boolean isBlockValid(Object aBlock) {
        return aBlock != null && aBlock instanceof Block;
    }

    public static boolean isBlockInvalid(Object aBlock) {
        return aBlock == null || !(aBlock instanceof Block);
    }

    public static boolean isStringValid(Object aString) {
        return aString != null && !aString.toString().isEmpty();
    }

    public static boolean isStringInvalid(Object aString) {
        return aString == null || aString.toString().isEmpty();
    }

    public static boolean isStackValid(Object aStack) {
        return aStack != null && aStack instanceof ItemStack && ((ItemStack)aStack).func_77973_b() != null && ((ItemStack)aStack).field_77994_a >= 0;
    }

    public static boolean isStackInvalid(Object aStack) {
        return aStack == null || !(aStack instanceof ItemStack) || ((ItemStack)aStack).func_77973_b() == null || ((ItemStack)aStack).field_77994_a < 0;
    }

    public static boolean isDebugItem(ItemStack aStack) {
        return GT_Utility.areStacksEqual(GT_ModHandler.getIC2Item("debug", 1L), aStack, true);
    }

    public static ItemStack updateItemStack(ItemStack aStack) {
        if (GT_Utility.isStackValid(aStack) && aStack.func_77973_b() instanceof GT_Generic_Item) {
            ((GT_Generic_Item)aStack.func_77973_b()).isItemStackUsable(aStack);
        }
        return aStack;
    }

    public static boolean isOpaqueBlock(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ).func_149662_c();
    }

    public static boolean isAirBlock(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ).isAir((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public static boolean hasBlockHitBox(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ).func_149668_a(aWorld, aX, aY, aZ) != null;
    }

    public static void setCoordsOnFire(World aWorld, int aX, int aY, int aZ, boolean aReplaceCenter) {
        if (aReplaceCenter && aWorld.func_147439_a(aX, aY, aZ).func_149668_a(aWorld, aX, aY, aZ) == null) {
            aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX + 1, aY, aZ).func_149668_a(aWorld, aX + 1, aY, aZ) == null) {
            aWorld.func_147449_b(aX + 1, aY, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX - 1, aY, aZ).func_149668_a(aWorld, aX - 1, aY, aZ) == null) {
            aWorld.func_147449_b(aX - 1, aY, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX, aY + 1, aZ).func_149668_a(aWorld, aX, aY + 1, aZ) == null) {
            aWorld.func_147449_b(aX, aY + 1, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX, aY - 1, aZ).func_149668_a(aWorld, aX, aY - 1, aZ) == null) {
            aWorld.func_147449_b(aX, aY - 1, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX, aY, aZ + 1).func_149668_a(aWorld, aX, aY, aZ + 1) == null) {
            aWorld.func_147449_b(aX, aY, aZ + 1, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX, aY, aZ - 1).func_149668_a(aWorld, aX, aY, aZ - 1) == null) {
            aWorld.func_147449_b(aX, aY, aZ - 1, (Block)Blocks.field_150480_ab);
        }
    }

    public static ItemStack getProjectile(SubTag aProjectileType, IInventory aInventory) {
        if (aInventory != null) {
            int j = aInventory.func_70302_i_();
            for (int i = 0; i < j; ++i) {
                ItemStack rStack = aInventory.func_70301_a(i);
                if (!GT_Utility.isStackValid(rStack) || !(rStack.func_77973_b() instanceof IProjectileItem) || !((IProjectileItem)rStack.func_77973_b()).hasProjectile(aProjectileType, rStack)) continue;
                return GT_Utility.updateItemStack(rStack);
            }
        }
        return null;
    }

    public static void removeNullStacksFromInventory(IInventory aInventory) {
        if (aInventory != null) {
            int j = aInventory.func_70302_i_();
            for (int i = 0; i < j; ++i) {
                ItemStack tStack = aInventory.func_70301_a(i);
                if (tStack == null || tStack.field_77994_a != 0 && tStack.func_77973_b() != null) continue;
                aInventory.func_70299_a(i, null);
            }
        }
    }

    public static String parseNumberToString(int aNumber) {
        String tString = "";
        boolean temp = true;
        boolean negative = false;
        if (aNumber < 0) {
            aNumber *= -1;
            negative = true;
        }
        for (int i = 1000000000; i > 0; i /= 10) {
            int tDigit = aNumber / i % 10;
            if (temp && tDigit != 0) {
                temp = false;
            }
            if (temp) continue;
            tString = tString + tDigit;
            if (i == 1) continue;
            for (int j = i; j > 0; j /= 1000) {
                if (j != 1) continue;
                tString = tString + ",";
            }
        }
        if (tString.equals("")) {
            tString = "0";
        }
        return negative ? "-" + tString : tString;
    }

    public static NBTTagCompound getNBTContainingBoolean(NBTTagCompound aNBT, Object aTag, boolean aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74757_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingByte(NBTTagCompound aNBT, Object aTag, byte aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74774_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingShort(NBTTagCompound aNBT, Object aTag, short aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74777_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingInteger(NBTTagCompound aNBT, Object aTag, int aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74768_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingFloat(NBTTagCompound aNBT, Object aTag, float aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74776_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingDouble(NBTTagCompound aNBT, Object aTag, double aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74780_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingString(NBTTagCompound aNBT, Object aTag, Object aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        if (aValue == null) {
            return aNBT;
        }
        aNBT.func_74778_a(aTag.toString(), aValue.toString());
        return aNBT;
    }

    public static boolean isWearingFullFrostHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.func_71124_b(i), GregTech_API.sFrostHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullHeatHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.func_71124_b(i), GregTech_API.sHeatHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullBioHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.func_71124_b(i), GregTech_API.sBioHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullRadioHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.func_71124_b(i), GregTech_API.sRadioHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullElectroHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.func_71124_b(i), GregTech_API.sElectroHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullGasHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            if (GT_Utility.isStackInList(aEntity.func_71124_b(i), GregTech_API.sGasHazmatList)) continue;
            return false;
        }
        return true;
    }

    public static float getHeatDamageFromItem(ItemStack aStack) {
        ItemData tData = GT_OreDictUnificator.getItemData(aStack);
        return tData == null ? 0.0f : (tData.mPrefix == null ? 0.0f : tData.mPrefix.mHeatDamage) + (tData.hasValidMaterialData() ? tData.mMaterial.mMaterial.mHeatDamage : 0.0f);
    }

    public static int getRadioactivityLevel(ItemStack aStack) {
        ItemData tData = GT_OreDictUnificator.getItemData(aStack);
        if (tData != null && tData.hasValidMaterialData()) {
            if (tData.mMaterial.mMaterial.mEnchantmentArmors instanceof Enchantment_Radioactivity) {
                return tData.mMaterial.mMaterial.mEnchantmentArmorsLevel;
            }
            if (tData.mMaterial.mMaterial.mEnchantmentTools instanceof Enchantment_Radioactivity) {
                return tData.mMaterial.mMaterial.mEnchantmentToolsLevel;
            }
        }
        return EnchantmentHelper.func_77506_a((int)Enchantment_Radioactivity.INSTANCE.field_77352_x, (ItemStack)aStack);
    }

    public static boolean isImmuneToBreathingGasses(EntityLivingBase aEntity) {
        return GT_Utility.isWearingFullGasHazmat(aEntity);
    }

    public static boolean applyHeatDamage(EntityLivingBase aEntity, float aDamage) {
        if (aDamage > 0.0f && aEntity != null && aEntity.func_70660_b(Potion.field_76426_n) == null && !GT_Utility.isWearingFullHeatHazmat(aEntity)) {
            aEntity.func_70097_a(GT_DamageSources.getHeatDamage(), aDamage);
            return true;
        }
        return false;
    }

    public static boolean applyFrostDamage(EntityLivingBase aEntity, float aDamage) {
        if (aDamage > 0.0f && aEntity != null && !GT_Utility.isWearingFullFrostHazmat(aEntity)) {
            aEntity.func_70097_a(GT_DamageSources.getFrostDamage(), aDamage);
            return true;
        }
        return false;
    }

    public static boolean applyElectricityDamage(EntityLivingBase aEntity, long aVoltage, long aAmperage) {
        long aDamage = (long)GT_Utility.getTier(aVoltage) * aAmperage * 4L;
        if (aDamage > 0L && aEntity != null && !GT_Utility.isWearingFullElectroHazmat(aEntity)) {
            aEntity.func_70097_a(GT_DamageSources.getElectricDamage(), (float)aDamage);
            return true;
        }
        return false;
    }

    public static boolean applyRadioactivity(EntityLivingBase aEntity, int aLevel, int aAmountOfItems) {
        if (aLevel > 0 && aEntity != null && aEntity.func_70668_bt() != EnumCreatureAttribute.UNDEAD && aEntity.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD && !GT_Utility.isWearingFullRadioHazmat(aEntity)) {
            PotionEffect tEffect = null;
            tEffect = aEntity.func_70660_b(Potion.field_76421_d);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, aLevel * 140 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76419_f);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76431_k);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76437_t);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76438_s);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76425_a[24]);
            aEntity.func_70690_d(new PotionEffect(24, aLevel * 180 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            return true;
        }
        return false;
    }

    public static ItemStack setStack(Object aSetStack, Object aToStack) {
        if (GT_Utility.isStackInvalid(aSetStack) || GT_Utility.isStackInvalid(aToStack)) {
            return null;
        }
        ((ItemStack)aSetStack).func_150996_a(((ItemStack)aToStack).func_77973_b());
        ((ItemStack)aSetStack).field_77994_a = ((ItemStack)aToStack).field_77994_a;
        Items.field_151008_G.setDamage((ItemStack)aSetStack, Items.field_151008_G.getDamage((ItemStack)aToStack));
        ((ItemStack)aSetStack).func_77982_d(((ItemStack)aToStack).func_77978_p());
        return (ItemStack)aSetStack;
    }

    public static FluidStack[] copyFluidArray(FluidStack ... aStacks) {
        FluidStack[] rStacks = new FluidStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            if (aStacks[i] == null) continue;
            rStacks[i] = aStacks[i].copy();
        }
        return rStacks;
    }

    public static ItemStack[] copyStackArray(Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = GT_Utility.copy(aStacks[i]);
        }
        return rStacks;
    }

    public static ItemStack copy(Object ... aStacks) {
        for (Object tStack : aStacks) {
            if (!GT_Utility.isStackValid(tStack)) continue;
            return ((ItemStack)tStack).func_77946_l();
        }
        return null;
    }

    public static ItemStack copyAmount(long aAmount, Object ... aStacks) {
        ItemStack rStack = GT_Utility.copy(aStacks);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        if (aAmount > 64L) {
            aAmount = 64L;
        } else if (aAmount == -1L) {
            aAmount = 111L;
        } else if (aAmount < 0L) {
            aAmount = 0L;
        }
        rStack.field_77994_a = (byte)aAmount;
        return rStack;
    }

    public static ItemStack copyMetaData(long aMetaData, Object ... aStacks) {
        ItemStack rStack = GT_Utility.copy(aStacks);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, (int)((short)aMetaData));
        return rStack;
    }

    public static ItemStack copyAmountAndMetaData(long aAmount, long aMetaData, Object ... aStacks) {
        ItemStack rStack = GT_Utility.copyAmount(aAmount, aStacks);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, (int)((short)aMetaData));
        return rStack;
    }

    public static ItemStack mul(long aMultiplier, Object ... aStacks) {
        ItemStack rStack = GT_Utility.copy(aStacks);
        if (rStack == null) {
            return null;
        }
        rStack.field_77994_a = (int)((long)rStack.field_77994_a * aMultiplier);
        return rStack;
    }

    public static ItemStack loadItem(NBTTagCompound aNBT, String aTagName) {
        return GT_Utility.loadItem(aNBT.func_74775_l(aTagName));
    }

    public static ItemStack loadItem(NBTTagCompound aNBT) {
        if (aNBT == null) {
            return null;
        }
        ItemStack rStack = ItemStack.func_77949_a((NBTTagCompound)aNBT);
        try {
            if (rStack != null && rStack.func_77973_b().getClass().getName().startsWith("ic2.core.migration")) {
                rStack.func_77973_b().func_77663_a(rStack, GT_Values.DW, null, 0, false);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        return GT_OreDictUnificator.get(true, rStack);
    }

    public static <E> E selectItemInList(int aIndex, E aReplacement, List<E> aList) {
        if (aList == null || aList.isEmpty()) {
            return aReplacement;
        }
        if (aList.size() <= aIndex) {
            return aList.get(aList.size() - 1);
        }
        if (aIndex < 0) {
            return aList.get(0);
        }
        return aList.get(aIndex);
    }

    public static <E> E selectItemInList(int aIndex, E aReplacement, E ... aList) {
        if (aList == null || aList.length == 0) {
            return aReplacement;
        }
        if (aList.length <= aIndex) {
            return aList[aList.length - 1];
        }
        if (aIndex < 0) {
            return aList[0];
        }
        return aList[aIndex];
    }

    public static boolean isStackInList(ItemStack aStack, Collection<GT_ItemStack> aList) {
        if (aStack == null) {
            return false;
        }
        return GT_Utility.isStackInList(new GT_ItemStack(aStack), aList);
    }

    public static boolean isStackInList(GT_ItemStack aStack, Collection<GT_ItemStack> aList) {
        return aStack != null && (aList.contains(aStack) || aList.contains(new GT_ItemStack(aStack.mItem, aStack.mStackSize, 32767L)));
    }

    public static <X, Y> Map<X, Y> reMap(Map<X, Y> aMap) {
        HashMap<X, Y> tMap = new HashMap<X, Y>();
        tMap.putAll(aMap);
        aMap.clear();
        aMap.putAll(tMap);
        return aMap;
    }

    public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortMapByValuesAcending(Map<X, Y> aMap) {
        LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
        Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

            @Override
            public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                return ((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
            }
        });
        LinkedHashMap rMap = new LinkedHashMap();
        for (Map.Entry entry : tEntrySet) {
            rMap.put(entry.getKey(), entry.getValue());
        }
        return rMap;
    }

    public static <X, Y extends Comparable> LinkedHashMap<X, Y> sortMapByValuesDescending(Map<X, Y> aMap) {
        LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
        Collections.sort(tEntrySet, new Comparator<Map.Entry<X, Y>>(){

            @Override
            public int compare(Map.Entry<X, Y> aValue1, Map.Entry<X, Y> aValue2) {
                return -((Comparable)aValue1.getValue()).compareTo(aValue2.getValue());
            }
        });
        LinkedHashMap rMap = new LinkedHashMap();
        for (Map.Entry entry : tEntrySet) {
            rMap.put(entry.getKey(), entry.getValue());
        }
        return rMap;
    }

    public static long translateMaterialToFluidAmount(long aMaterialAmount, boolean aRoundUp) {
        return GT_Utility.translateMaterialToAmount(aMaterialAmount, 144L, aRoundUp);
    }

    public static long translateMaterialToAmount(long aMaterialAmount, long aAmountPerUnit, boolean aRoundUp) {
        return Math.max(0L, aMaterialAmount * aAmountPerUnit / 3628800L + (long)(aRoundUp && aMaterialAmount * aAmountPerUnit % 3628800L > 0L ? 1 : 0));
    }

    public static boolean isRealDimension(int aDimensionID) {
        try {
            if (DimensionManager.getProvider((int)aDimensionID).getClass().getName().contains("com.xcompwiz.mystcraft")) {
                return true;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (DimensionManager.getProvider((int)aDimensionID).getClass().getName().contains("TwilightForest")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return GregTech_API.sDimensionalList.contains(aDimensionID);
    }

    public static boolean moveEntityToDimensionAtCoords(Entity aEntity, int aDimension, double aX, double aY, double aZ) {
        WorldServer tTargetWorld = DimensionManager.getWorld((int)aDimension);
        WorldServer tOriginalWorld = DimensionManager.getWorld((int)aEntity.field_70170_p.field_73011_w.field_76574_g);
        if (tTargetWorld != null && tOriginalWorld != null && tTargetWorld != tOriginalWorld) {
            if (aEntity.field_70154_o != null) {
                aEntity.func_70078_a(null);
            }
            if (aEntity.field_70153_n != null) {
                aEntity.field_70153_n.func_70078_a(null);
            }
            if (aEntity instanceof EntityPlayerMP) {
                EntityPlayerMP aPlayer = (EntityPlayerMP)aEntity;
                aPlayer.field_71093_bK = aDimension;
                aPlayer.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(aPlayer.field_71093_bK, aPlayer.field_70170_p.field_73013_u, aPlayer.field_70170_p.func_72912_H().func_76067_t(), aPlayer.field_71134_c.func_73081_b()));
                tOriginalWorld.func_72973_f((Entity)aPlayer);
                aPlayer.field_70128_L = false;
                aPlayer.func_70029_a((World)tTargetWorld);
                MinecraftServer.func_71276_C().func_71203_ab().func_72375_a(aPlayer, tOriginalWorld);
                aPlayer.field_71135_a.func_147364_a(aX + 0.5, aY + 0.5, aZ + 0.5, aPlayer.field_70177_z, aPlayer.field_70125_A);
                aPlayer.field_71134_c.func_73080_a(tTargetWorld);
                MinecraftServer.func_71276_C().func_71203_ab().func_72354_b(aPlayer, tTargetWorld);
                MinecraftServer.func_71276_C().func_71203_ab().func_72385_f(aPlayer);
                for (PotionEffect potioneffect : aPlayer.func_70651_bq()) {
                    aPlayer.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(aPlayer.func_145782_y(), potioneffect));
                }
                aPlayer.field_71135_a.func_147364_a(aX + 0.5, aY + 0.5, aZ + 0.5, aPlayer.field_70177_z, aPlayer.field_70125_A);
                FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)aPlayer, tOriginalWorld.field_73011_w.field_76574_g, aDimension);
            } else {
                aEntity.func_70107_b(aX + 0.5, aY + 0.5, aZ + 0.5);
                aEntity.field_70170_p.func_72900_e(aEntity);
                aEntity.field_71093_bK = aDimension;
                aEntity.field_70128_L = false;
                Entity tNewEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)aEntity), (World)tTargetWorld);
                if (tNewEntity != null) {
                    tNewEntity.func_82141_a(aEntity, true);
                    aEntity.func_70106_y();
                    tNewEntity.field_70128_L = false;
                    boolean temp = tNewEntity.field_98038_p;
                    tNewEntity.field_98038_p = true;
                    tTargetWorld.func_72838_d(tNewEntity);
                    tNewEntity.field_98038_p = temp;
                    tNewEntity.field_70128_L = false;
                    aEntity = tNewEntity;
                }
            }
            if (aEntity instanceof EntityLivingBase) {
                ((EntityLivingBase)aEntity).func_70634_a(aX, aY, aZ);
            } else {
                aEntity.func_70107_b(aX, aY, aZ);
            }
            tOriginalWorld.func_82742_i();
            tTargetWorld.func_82742_i();
            return true;
        }
        return false;
    }

    public static int getCoordinateScan(ArrayList<String> aList, EntityPlayer aPlayer, World aWorld, int aScanLevel, int aX, int aY, int aZ, int aSide, float aClickX, float aClickY, float aClickZ) {
        Block tBlock;
        TileEntity tTileEntity;
        int rEUAmount;
        ArrayList<String> tList;
        block85: {
            block84: {
                block68: {
                    if (aList == null) {
                        return 0;
                    }
                    tList = new ArrayList<String>();
                    rEUAmount = 0;
                    tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
                    tBlock = aWorld.func_147439_a(aX, aY, aZ);
                    tList.add("----- X: " + aX + " Y: " + aY + " Z: " + aZ + " -----");
                    try {
                        if (tTileEntity != null && tTileEntity instanceof IInventory) {
                            tList.add("Name: " + ((IInventory)tTileEntity).func_145825_b() + "  MetaData: " + aWorld.func_72805_g(aX, aY, aZ));
                        } else {
                            tList.add("Name: " + tBlock.func_149739_a() + "  MetaData: " + aWorld.func_72805_g(aX, aY, aZ));
                        }
                        tList.add("Hardness: " + tBlock.func_149712_f(aWorld, aX, aY, aZ) + "  Blast Resistance: " + tBlock.getExplosionResistance((Entity)aPlayer, aWorld, aX, aY, aZ, aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v));
                        if (tBlock.isBeaconBase((IBlockAccess)aWorld, aX, aY, aZ, aX, aY + 1, aZ)) {
                            tList.add("Is valid Beacon Pyramid Material");
                        }
                    }
                    catch (Throwable e) {
                        if (!GT_Values.D1) break block68;
                        e.printStackTrace(GT_Log.err);
                    }
                }
                if (tTileEntity != null) {
                    block83: {
                        block82: {
                            block81: {
                                block80: {
                                    block79: {
                                        block78: {
                                            block77: {
                                                block76: {
                                                    block75: {
                                                        block74: {
                                                            block73: {
                                                                block72: {
                                                                    block71: {
                                                                        block70: {
                                                                            block69: {
                                                                                try {
                                                                                    if (tTileEntity instanceof IFluidHandler) {
                                                                                        rEUAmount += 500;
                                                                                        FluidTankInfo[] tTanks = ((IFluidHandler)tTileEntity).getTankInfo(ForgeDirection.getOrientation((int)aSide));
                                                                                        if (tTanks != null) {
                                                                                            for (int i = 0; i < tTanks.length; i = (int)((byte)(i + 1))) {
                                                                                                tList.add("Tank " + i + ": " + GT_Utility.formatNumbers(tTanks[i].fluid == null ? 0 : tTanks[i].fluid.amount) + " / " + GT_Utility.formatNumbers(tTanks[i].capacity) + " " + GT_Utility.getFluidName(tTanks[i].fluid, true));
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                                catch (Throwable e) {
                                                                                    if (!GT_Values.D1) break block69;
                                                                                    e.printStackTrace(GT_Log.err);
                                                                                }
                                                                            }
                                                                            try {
                                                                                if (tTileEntity instanceof IReactorChamber) {
                                                                                    rEUAmount += 500;
                                                                                    tTileEntity = (TileEntity)((IReactorChamber)tTileEntity).getReactor();
                                                                                }
                                                                            }
                                                                            catch (Throwable e) {
                                                                                if (!GT_Values.D1) break block70;
                                                                                e.printStackTrace(GT_Log.err);
                                                                            }
                                                                        }
                                                                        try {
                                                                            if (tTileEntity instanceof IReactor) {
                                                                                rEUAmount += 500;
                                                                                tList.add("Heat: " + ((IReactor)tTileEntity).getHeat() + "/" + ((IReactor)tTileEntity).getMaxHeat() + "  HEM: " + ((IReactor)tTileEntity).getHeatEffectModifier() + "  Base EU Output: ");
                                                                            }
                                                                        }
                                                                        catch (Throwable e) {
                                                                            if (!GT_Values.D1) break block71;
                                                                            e.printStackTrace(GT_Log.err);
                                                                        }
                                                                    }
                                                                    try {
                                                                        if (tTileEntity instanceof IWrenchable) {
                                                                            rEUAmount += 100;
                                                                            tList.add("Facing: " + ((IWrenchable)tTileEntity).getFacing() + " / Chance: " + ((IWrenchable)tTileEntity).getWrenchDropRate() * 100.0f + "%");
                                                                            tList.add(((IWrenchable)tTileEntity).wrenchCanRemove(aPlayer) ? "You can remove this with a Wrench" : "You can NOT remove this with a Wrench");
                                                                        }
                                                                    }
                                                                    catch (Throwable e) {
                                                                        if (!GT_Values.D1) break block72;
                                                                        e.printStackTrace(GT_Log.err);
                                                                    }
                                                                }
                                                                try {
                                                                    if (tTileEntity instanceof IEnergyTile) {
                                                                        rEUAmount += 200;
                                                                    }
                                                                }
                                                                catch (Throwable e) {
                                                                    if (!GT_Values.D1) break block73;
                                                                    e.printStackTrace(GT_Log.err);
                                                                }
                                                            }
                                                            try {
                                                                if (tTileEntity instanceof IEnergySink) {
                                                                    rEUAmount += 400;
                                                                }
                                                            }
                                                            catch (Throwable e) {
                                                                if (!GT_Values.D1) break block74;
                                                                e.printStackTrace(GT_Log.err);
                                                            }
                                                        }
                                                        try {
                                                            if (tTileEntity instanceof IEnergySource) {
                                                                rEUAmount += 400;
                                                            }
                                                        }
                                                        catch (Throwable e) {
                                                            if (!GT_Values.D1) break block75;
                                                            e.printStackTrace(GT_Log.err);
                                                        }
                                                    }
                                                    try {
                                                        if (tTileEntity instanceof IEnergyConductor) {
                                                            rEUAmount += 200;
                                                            tList.add("Conduction Loss: " + ((IEnergyConductor)tTileEntity).getConductionLoss());
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        if (!GT_Values.D1) break block76;
                                                        e.printStackTrace(GT_Log.err);
                                                    }
                                                }
                                                try {
                                                    if (tTileEntity instanceof IEnergyStorage) {
                                                        rEUAmount += 200;
                                                        tList.add("Contained Energy: " + ((IEnergyStorage)tTileEntity).getStored() + " of " + ((IEnergyStorage)tTileEntity).getCapacity());
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    if (!GT_Values.D1) break block77;
                                                    e.printStackTrace(GT_Log.err);
                                                }
                                            }
                                            try {
                                                if (tTileEntity instanceof IUpgradableMachine) {
                                                    rEUAmount += 500;
                                                    if (((IUpgradableMachine)tTileEntity).hasMufflerUpgrade()) {
                                                        tList.add("Has Muffler Upgrade");
                                                    }
                                                }
                                            }
                                            catch (Throwable e) {
                                                if (!GT_Values.D1) break block78;
                                                e.printStackTrace(GT_Log.err);
                                            }
                                        }
                                        try {
                                            if (tTileEntity instanceof IMachineProgress) {
                                                rEUAmount += 400;
                                                int tValue = 0;
                                                tValue = ((IMachineProgress)tTileEntity).getMaxProgress();
                                                if (0 < tValue) {
                                                    tList.add("Progress: " + GT_Utility.formatNumbers(tValue) + " / " + GT_Utility.formatNumbers(((IMachineProgress)tTileEntity).getProgress()));
                                                }
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!GT_Values.D1) break block79;
                                            e.printStackTrace(GT_Log.err);
                                        }
                                    }
                                    try {
                                        if (tTileEntity instanceof ICoverable) {
                                            rEUAmount += 300;
                                            String tString = ((ICoverable)tTileEntity).getCoverBehaviorAtSide((byte)aSide).getDescription((byte)aSide, ((ICoverable)tTileEntity).getCoverIDAtSide((byte)aSide), ((ICoverable)tTileEntity).getCoverDataAtSide((byte)aSide), (ICoverable)tTileEntity);
                                            if (tString != null && !tString.equals("")) {
                                                tList.add(tString);
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!GT_Values.D1) break block80;
                                        e.printStackTrace(GT_Log.err);
                                    }
                                }
                                try {
                                    if (tTileEntity instanceof IBasicEnergyContainer && ((IBasicEnergyContainer)tTileEntity).getEUCapacity() > 0L) {
                                        tList.add("Max IN: " + ((IBasicEnergyContainer)tTileEntity).getInputVoltage() + " EU");
                                        tList.add("Max OUT: " + ((IBasicEnergyContainer)tTileEntity).getOutputVoltage() + " EU at " + ((IBasicEnergyContainer)tTileEntity).getOutputAmperage() + " Amperes");
                                        tList.add("Energy: " + GT_Utility.formatNumbers(((IBasicEnergyContainer)tTileEntity).getStoredEU()) + " / " + GT_Utility.formatNumbers(((IBasicEnergyContainer)tTileEntity).getEUCapacity()) + "EU");
                                    }
                                }
                                catch (Throwable e) {
                                    if (!GT_Values.D1) break block81;
                                    e.printStackTrace(GT_Log.err);
                                }
                            }
                            try {
                                if (tTileEntity instanceof IGregTechTileEntity) {
                                    tList.add("Owned by: " + ((IGregTechTileEntity)tTileEntity).getOwnerName());
                                }
                            }
                            catch (Throwable e) {
                                if (!GT_Values.D1) break block82;
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                        try {
                            if (tTileEntity instanceof IGregTechDeviceInformation && ((IGregTechDeviceInformation)tTileEntity).isGivingInformation()) {
                                tList.addAll(Arrays.asList(((IGregTechDeviceInformation)tTileEntity).getInfoData()));
                            }
                        }
                        catch (Throwable e) {
                            if (!GT_Values.D1) break block83;
                            e.printStackTrace(GT_Log.err);
                        }
                    }
                    try {
                        if (tTileEntity instanceof ICropTile) {
                            if (((ICropTile)tTileEntity).getScanLevel() < 4) {
                                rEUAmount += 10000;
                                ((ICropTile)tTileEntity).setScanLevel((byte)4);
                            }
                            if (((ICropTile)tTileEntity).getID() >= 0 && ((ICropTile)tTileEntity).getID() < Crops.instance.getCropList().length && Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()] != null) {
                                rEUAmount += 1000;
                                tList.add("Type -- Crop-Name: " + Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].name() + "  Growth: " + ((ICropTile)tTileEntity).getGrowth() + "  Gain: " + ((ICropTile)tTileEntity).getGain() + "  Resistance: " + ((ICropTile)tTileEntity).getResistance());
                                tList.add("Plant -- Fertilizer: " + ((ICropTile)tTileEntity).getNutrientStorage() + "  Water: " + ((ICropTile)tTileEntity).getHydrationStorage() + "  Weed-Ex: " + ((ICropTile)tTileEntity).getWeedExStorage() + "  Scan-Level: " + ((ICropTile)tTileEntity).getScanLevel());
                                tList.add("Environment -- Nutrients: " + ((ICropTile)tTileEntity).getNutrients() + "  Humidity: " + ((ICropTile)tTileEntity).getHumidity() + "  Air-Quality: " + ((ICropTile)tTileEntity).getAirQuality());
                                String tString = "";
                                for (String tAttribute : Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].attributes()) {
                                    tString = tString + ", " + tAttribute;
                                }
                                tList.add("Attributes:" + tString.replaceFirst(",", ""));
                                tList.add("Discovered by: " + Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].discoveredBy());
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (!GT_Values.D1) break block84;
                        e.printStackTrace(GT_Log.err);
                    }
                }
            }
            try {
                if (tBlock instanceof IDebugableBlock) {
                    rEUAmount += 500;
                    ArrayList<String> temp = ((IDebugableBlock)tBlock).getDebugInfo(aPlayer, aX, aY, aZ, 3);
                    if (temp != null) {
                        tList.addAll(temp);
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block85;
                e.printStackTrace(GT_Log.err);
            }
        }
        BlockScanningEvent tEvent = new BlockScanningEvent(aWorld, aPlayer, aX, aY, aZ, (byte)aSide, aScanLevel, tBlock, tTileEntity, tList, aClickX, aClickY, aClickZ);
        tEvent.mEUCost = rEUAmount;
        MinecraftForge.EVENT_BUS.post((Event)tEvent);
        if (!tEvent.isCanceled()) {
            aList.addAll(tList);
        }
        return tEvent.mEUCost;
    }

    public static float[] getClickedFacingCoords(byte aSide, float aX, float aY, float aZ) {
        switch (aSide) {
            case 0: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aX)), Math.min(0.99f, Math.max(0.0f, aZ))};
            }
            case 1: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, aX)), Math.min(0.99f, Math.max(0.0f, aZ))};
            }
            case 2: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aY))};
            }
            case 3: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, aX)), Math.min(0.99f, Math.max(0.0f, 1.0f - aY))};
            }
            case 4: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, aZ)), Math.min(0.99f, Math.max(0.0f, 1.0f - aY))};
            }
            case 5: {
                return new float[]{Math.min(0.99f, Math.max(0.0f, 1.0f - aZ)), Math.min(0.99f, Math.max(0.0f, 1.0f - aY))};
            }
        }
        return new float[]{0.5f, 0.5f};
    }

    public static byte determineWrenchingSide(byte aSide, float aX, float aY, float aZ) {
        byte tBack = GT_Utility.getOppositeSide(aSide);
        switch (aSide) {
            case 0: 
            case 1: {
                if ((double)aX < 0.25) {
                    if ((double)aZ < 0.25) {
                        return tBack;
                    }
                    if ((double)aZ > 0.75) {
                        return tBack;
                    }
                    return 4;
                }
                if ((double)aX > 0.75) {
                    if ((double)aZ < 0.25) {
                        return tBack;
                    }
                    if ((double)aZ > 0.75) {
                        return tBack;
                    }
                    return 5;
                }
                if ((double)aZ < 0.25) {
                    return 2;
                }
                if ((double)aZ > 0.75) {
                    return 3;
                }
                return aSide;
            }
            case 2: 
            case 3: {
                if ((double)aX < 0.25) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return 4;
                }
                if ((double)aX > 0.75) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return 5;
                }
                if ((double)aY < 0.25) {
                    return 0;
                }
                if ((double)aY > 0.75) {
                    return 1;
                }
                return aSide;
            }
            case 4: 
            case 5: {
                if ((double)aZ < 0.25) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return 2;
                }
                if ((double)aZ > 0.75) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return 3;
                }
                if ((double)aY < 0.25) {
                    return 0;
                }
                if ((double)aY > 0.75) {
                    return 1;
                }
                return aSide;
            }
        }
        return -1;
    }

    public static String formatNumbers(long aNumber) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator(' ');
        return formatter.format(aNumber);
    }

    static {
        GregTech_API.sItemStackMappings.add(sFilledContainerToData);
        GregTech_API.sItemStackMappings.add(sEmptyContainerToFluidToData);
        sBookCount = 0;
        sPlayedSoundMap = new HashMap<GT_PlayedSound, Integer>();
    }

    public static class GT_EnchantmentHelper {
        private static final BullshitIteratorA mBullshitIteratorA = new BullshitIteratorA();
        private static final BullshitIteratorB mBullshitIteratorB = new BullshitIteratorB();

        private static void applyBullshit(IBullshit aBullshitModifier, ItemStack aStack) {
            NBTTagList nbttaglist;
            if (aStack != null && (nbttaglist = aStack.func_77986_q()) != null) {
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    try {
                        short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                        short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                        if (Enchantment.field_77331_b[short1] == null) continue;
                        aBullshitModifier.calculateModifier(Enchantment.field_77331_b[short1], short2);
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }

        private static void applyArrayOfBullshit(IBullshit aBullshitModifier, ItemStack[] aStacks) {
            ItemStack[] aitemstack1 = aStacks;
            int i = aStacks.length;
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = aitemstack1[j];
                GT_EnchantmentHelper.applyBullshit(aBullshitModifier, itemstack);
            }
        }

        public static void applyBullshitA(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            GT_EnchantmentHelper.mBullshitIteratorA.mPlayer = aPlayer;
            GT_EnchantmentHelper.mBullshitIteratorA.mEntity = aEntity;
            if (aPlayer != null) {
                GT_EnchantmentHelper.applyArrayOfBullshit(mBullshitIteratorA, aPlayer.func_70035_c());
            }
            if (aStack != null) {
                GT_EnchantmentHelper.applyBullshit(mBullshitIteratorA, aStack);
            }
        }

        public static void applyBullshitB(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            GT_EnchantmentHelper.mBullshitIteratorB.mPlayer = aPlayer;
            GT_EnchantmentHelper.mBullshitIteratorB.mEntity = aEntity;
            if (aPlayer != null) {
                GT_EnchantmentHelper.applyArrayOfBullshit(mBullshitIteratorB, aPlayer.func_70035_c());
            }
            if (aStack != null) {
                GT_EnchantmentHelper.applyBullshit(mBullshitIteratorB, aStack);
            }
        }

        static interface IBullshit {
            public void calculateModifier(Enchantment var1, int var2);
        }

        static final class BullshitIteratorB
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorB() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151368_a(this.mPlayer, this.mEntity, aLevel);
            }
        }

        static final class BullshitIteratorA
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorA() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151367_b(this.mPlayer, this.mEntity, aLevel);
            }
        }
    }

    public static class ItemNBT {
        public static void setNBT(ItemStack aStack, NBTTagCompound aNBT) {
            if (aNBT == null) {
                aStack.func_77982_d(null);
                return;
            }
            ArrayList<String> tTagsToRemove = new ArrayList<String>();
            for (Object e : aNBT.func_150296_c()) {
                NBTBase tValue = aNBT.func_74781_a((String)e);
                if (tValue != null && (!(tValue instanceof NBTBase.NBTPrimitive) || ((NBTBase.NBTPrimitive)tValue).func_150291_c() != 0L) && (!(tValue instanceof NBTTagString) || !GT_Utility.isStringInvalid(((NBTTagString)tValue).func_150285_a_()))) continue;
                tTagsToRemove.add((String)e);
            }
            for (Object e : tTagsToRemove) {
                aNBT.func_82580_o((String)e);
            }
            aStack.func_77982_d(aNBT.func_82582_d() ? null : aNBT);
        }

        public static NBTTagCompound getNBT(ItemStack aStack) {
            NBTTagCompound rNBT = aStack.func_77978_p();
            return rNBT == null ? new NBTTagCompound() : rNBT;
        }

        public static void setPunchCardData(ItemStack aStack, String aPunchCardData) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74778_a("GT.PunchCardData", aPunchCardData);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getPunchCardData(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.func_74779_i("GT.PunchCardData");
        }

        public static void setLighterFuel(ItemStack aStack, long aFuel) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74772_a("GT.LighterFuel", aFuel);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static long getLighterFuel(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.func_74763_f("GT.LighterFuel");
        }

        public static void setMapID(ItemStack aStack, short aMapID) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74777_a("map_id", aMapID);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static short getMapID(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            if (!tNBT.func_74764_b("map_id")) {
                return -1;
            }
            return tNBT.func_74765_d("map_id");
        }

        public static void setBookTitle(ItemStack aStack, String aTitle) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74778_a("title", aTitle);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getBookTitle(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.func_74779_i("title");
        }

        public static void setBookAuthor(ItemStack aStack, String aAuthor) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74778_a("author", aAuthor);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getBookAuthor(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.func_74779_i("author");
        }

        public static void addEnchantment(ItemStack aStack, Enchantment aEnchantment, int aLevel) {
            NBTTagCompound tEnchantmentTag;
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            if (!tNBT.func_150297_b("ench", 9)) {
                tNBT.func_74782_a("ench", (NBTBase)new NBTTagList());
            }
            NBTTagList tList = tNBT.func_150295_c("ench", 10);
            boolean temp = true;
            for (int i = 0; i < tList.func_74745_c(); ++i) {
                tEnchantmentTag = tList.func_150305_b(i);
                if (tEnchantmentTag.func_74765_d("id") != aEnchantment.field_77352_x) continue;
                tEnchantmentTag.func_74777_a("id", (short)aEnchantment.field_77352_x);
                tEnchantmentTag.func_74777_a("lvl", (short)((byte)aLevel));
                temp = false;
                break;
            }
            if (temp) {
                tEnchantmentTag = new NBTTagCompound();
                tEnchantmentTag.func_74777_a("id", (short)aEnchantment.field_77352_x);
                tEnchantmentTag.func_74777_a("lvl", (short)((byte)aLevel));
                tList.func_74742_a((NBTBase)tEnchantmentTag);
            }
            aStack.func_77982_d(tNBT);
        }
    }
}

