/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;

public class GT_MetaTileEntity_LargeTurbine
extends GT_MetaTileEntity_MultiBlockBase {
    public GT_MetaTileEntity_LargeTurbine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1], aFacing == aSide ? new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE5) : Textures.BlockIcons.CASING_BLOCKS[57]};
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large Turbine", "Size: 3x3x4 (Hollow)", "Controller (front centered)", "1x Input Hatch (side centered)", "1x Output Hatch(side centered)", "1x Dynamo Hatch (back centered)", "1x Maintenance Hatch (side centered)", "Turbine Casings for the rest (24 at least!)"};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (this.depleteInput(GT_ModHandler.getSteam(1600L))) {
            this.mEUt = 800;
            this.mMaxProgresstime = 1;
            this.mEfficiencyIncrease = ItemList.Component_Turbine_Bronze.isStackEqual(aStack, true, true) ? this.mMaxProgresstime * 10 : (ItemList.Component_Turbine_Steel.isStackEqual(aStack, true, true) ? this.mMaxProgresstime * 20 : (ItemList.Component_Turbine_Magnalium.isStackEqual(aStack, true, true) ? this.mMaxProgresstime * 50 : (ItemList.Component_Turbine_TungstenSteel.isStackEqual(aStack, true, true) ? this.mMaxProgresstime * 15 : (ItemList.Component_Turbine_Carbon.isStackEqual(aStack, true, true) ? this.mMaxProgresstime * 100 : this.mMaxProgresstime * 20))));
            this.addOutput(GT_ModHandler.getWater(10L));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        byte i;
        byte tSide = this.getBaseMetaTileEntity().getBackFacing();
        if (!this.getBaseMetaTileEntity().getAirAtSideAndDistance(this.getBaseMetaTileEntity().getBackFacing(), 1) || !this.getBaseMetaTileEntity().getAirAtSideAndDistance(this.getBaseMetaTileEntity().getBackFacing(), 2)) return false;
        int tAirCount = 0;
        for (i = -1; i < 2; i = (byte)((byte)(i + 1))) {
            for (int j = -1; j < 2; j = (int)((byte)(j + 1))) {
                for (int k = -1; k < 2; k = (int)((byte)(k + 1))) {
                    if (!this.getBaseMetaTileEntity().getAirOffset(i, j, k)) continue;
                    ++tAirCount;
                }
            }
        }
        if (tAirCount != 10) {
            return false;
        }
        for (i = 2; i < 6; i = (byte)(i + 1)) {
            IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance(i, 2);
            if (null == tTileEntity || tTileEntity.getFrontFacing() != this.getBaseMetaTileEntity().getFrontFacing() || tTileEntity.getMetaTileEntity() == null || !(tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_LargeTurbine)) continue;
            return false;
        }
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        for (int i2 = -1; i2 < 2; i2 = (int)((byte)(i2 + 1))) {
            for (int j = -1; j < 2; j = (int)((byte)(j + 1))) {
                if (i2 == 0 && j == 0) continue;
                for (int k = 0; k < 4; k = (int)((byte)(k + 1))) {
                    if (!(i2 != 0 && j != 0 || k != 1 && k != 2)) {
                        if (this.getBaseMetaTileEntity().getBlock(tX + (tSide == 5 ? k : (tSide < 4 ? i2 : -k)), tY + j, tZ + (tSide < 4 ? -k : (tSide == 3 ? k : i2))) == GregTech_API.sBlockCasings4) {
                            if (this.getBaseMetaTileEntity().getMetaID(tX + (tSide == 5 ? k : (tSide < 4 ? i2 : -k)), tY + j, tZ + (tSide < 4 ? -k : (tSide == 3 ? k : i2))) != 13) continue;
                            continue;
                        }
                        if (this.addToMachineList(this.getBaseMetaTileEntity().getIGregTechTileEntity(tX + (tSide == 5 ? k : (tSide < 4 ? i2 : -k)), tY + j, tZ + (tSide < 4 ? -k : (tSide == 3 ? k : i2))))) continue;
                        return false;
                    }
                    if (this.getBaseMetaTileEntity().getBlock(tX + (tSide == 5 ? k : (tSide < 4 ? i2 : -k)), tY + j, tZ + (tSide < 4 ? -k : (tSide == 3 ? k : i2))) != GregTech_API.sBlockCasings4) return false;
                    if (this.getBaseMetaTileEntity().getMetaID(tX + (tSide == 5 ? k : (tSide < 4 ? i2 : -k)), tY + j, tZ + (tSide < 4 ? -k : (tSide == 3 ? k : i2))) != 13) continue;
                }
            }
        }
        this.mDynamoHatches.clear();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance(this.getBaseMetaTileEntity().getBackFacing(), 3);
        if (tTileEntity == null || tTileEntity.getMetaTileEntity() == null) return true;
        if (!(tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_Dynamo)) return false;
        this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)tTileEntity.getMetaTileEntity());
        return true;
    }

    private boolean addToMachineList(IGregTechTileEntity tTileEntity) {
        return !this.addMaintenanceToMachineList(tTileEntity, 11) && !this.addInputToMachineList(tTileEntity, 11) && !this.addOutputToMachineList(tTileEntity, 11);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return GT_Utility.areStacksEqual(GT_ModHandler.getModItem("Railcraft", "part.turbine.rotor", 1L, Short.MAX_VALUE), aStack) ? 2 : 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        if (ItemList.Component_Turbine_Bronze.isStackEqual(aStack, true, true)) {
            return 6000;
        }
        if (ItemList.Component_Turbine_Steel.isStackEqual(aStack, true, true)) {
            return 8000;
        }
        if (ItemList.Component_Turbine_Magnalium.isStackEqual(aStack, true, true)) {
            return 10000;
        }
        if (ItemList.Component_Turbine_TungstenSteel.isStackEqual(aStack, true, true)) {
            return 9000;
        }
        if (ItemList.Component_Turbine_Carbon.isStackEqual(aStack, true, true)) {
            return 12500;
        }
        if (GT_Utility.areStacksEqual(aStack, GT_ModHandler.getModItem("Railcraft", "part.turbine.rotor", 1L, Short.MAX_VALUE))) {
            return 8000;
        }
        return 0;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine(this.mName);
    }
}

