/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.enums.Materials;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;

public enum Element {
    _NULL(0L, 0L, 0L, -1L, null, "", false),
    H(1L, 0L, 0L, -1L, null, "Hydrogen", false),
    D(1L, 1L, 0L, -1L, "H", "Deuterium", true),
    T(1L, 2L, 0L, -1L, "D", "Tritium", true),
    He(2L, 2L, 0L, -1L, null, "Helium", false),
    He_3(2L, 1L, 0L, -1L, "H&D", "Helium-3", true),
    Li(3L, 4L, 0L, -1L, null, "Lithium", false),
    Be(4L, 5L, 0L, -1L, null, "Beryllium", false),
    B(5L, 5L, 0L, -1L, null, "Boron", false),
    C(6L, 6L, 0L, -1L, null, "Carbon", false),
    N(7L, 7L, 0L, -1L, null, "Nitrogen", false),
    O(8L, 8L, 0L, -1L, null, "Oxygen", false),
    F(9L, 9L, 0L, -1L, null, "Fluorine", false),
    Ne(10L, 10L, 0L, -1L, null, "Neon", false),
    Na(11L, 11L, 0L, -1L, null, "Sodium", false),
    Mg(12L, 12L, 0L, -1L, null, "Magnesium", false),
    Al(13L, 13L, 0L, -1L, null, "Aluminium", false),
    Si(14L, 14L, 0L, -1L, null, "Silicon", false),
    P(15L, 15L, 0L, -1L, null, "Phosphorus", false),
    S(16L, 16L, 0L, -1L, null, "Sulfur", false),
    Cl(17L, 18L, 0L, -1L, null, "Chlorine", false),
    Ar(18L, 22L, 0L, -1L, null, "Argon", false),
    K(19L, 20L, 0L, -1L, null, "Potassium", false),
    Ca(20L, 20L, 0L, -1L, null, "Calcium", false),
    Sc(21L, 24L, 0L, -1L, null, "Scandium", false),
    Ti(22L, 26L, 0L, -1L, null, "Titanium", false),
    V(23L, 28L, 0L, -1L, null, "Vanadium", false),
    Cr(24L, 28L, 0L, -1L, null, "Chrome", false),
    Mn(25L, 30L, 0L, -1L, null, "Manganese", false),
    Fe(26L, 30L, 0L, -1L, null, "Iron", false),
    Co(27L, 32L, 0L, -1L, null, "Cobalt", false),
    Ni(28L, 30L, 0L, -1L, null, "Nickel", false),
    Cu(29L, 34L, 0L, -1L, null, "Copper", false),
    Zn(30L, 35L, 0L, -1L, null, "Zinc", false),
    Ga(31L, 39L, 0L, -1L, null, "Gallium", false),
    Ge(32L, 40L, 0L, -1L, null, "Germanium", false),
    As(33L, 42L, 0L, -1L, null, "Arsenic", false),
    Se(34L, 45L, 0L, -1L, null, "Selenium", false),
    Br(35L, 45L, 0L, -1L, null, "Bromine", false),
    Kr(36L, 48L, 0L, -1L, null, "Krypton", false),
    Rb(37L, 48L, 0L, -1L, null, "Rubidium", false),
    Sr(38L, 49L, 0L, -1L, null, "Strontium", false),
    Y(39L, 50L, 0L, -1L, null, "Yttrium", false),
    Zr(40L, 51L, 0L, -1L, null, "Zirconium", false),
    Nb(41L, 53L, 0L, -1L, null, "Niobium", false),
    Mo(42L, 53L, 0L, -1L, null, "Molybdenum", false),
    Tc(43L, 55L, 0L, -1L, null, "Technetium", false),
    Ru(44L, 57L, 0L, -1L, null, "Ruthenium", false),
    Rh(45L, 58L, 0L, -1L, null, "Rhodium", false),
    Pd(46L, 60L, 0L, -1L, null, "Palladium", false),
    Ag(47L, 60L, 0L, -1L, null, "Silver", false),
    Cd(48L, 64L, 0L, -1L, null, "Cadmium", false),
    In(49L, 65L, 0L, -1L, null, "Indium", false),
    Sn(50L, 68L, 0L, -1L, null, "Tin", false),
    Sb(51L, 70L, 0L, -1L, null, "Antimony", false),
    Te(52L, 75L, 0L, -1L, null, "Tellurium", false),
    I(53L, 74L, 0L, -1L, null, "Iodine", false),
    Xe(54L, 77L, 0L, -1L, null, "Xenon", false),
    Cs(55L, 77L, 0L, -1L, null, "Caesium", false),
    Ba(56L, 81L, 0L, -1L, null, "Barium", false),
    La(57L, 81L, 0L, -1L, null, "Lantanium", false),
    Ce(58L, 82L, 0L, -1L, null, "Cerium", false),
    Pr(59L, 81L, 0L, -1L, null, "Praseodymium", false),
    Nd(60L, 84L, 0L, -1L, null, "Neodymium", false),
    Pm(61L, 83L, 0L, -1L, null, "Promethium", false),
    Sm(62L, 88L, 0L, -1L, null, "Samarium", false),
    Eu(63L, 88L, 0L, -1L, null, "Europium", false),
    Gd(64L, 93L, 0L, -1L, null, "Gadolinium", false),
    Tb(65L, 93L, 0L, -1L, null, "Terbium", false),
    Dy(66L, 96L, 0L, -1L, null, "Dysprosium", false),
    Ho(67L, 97L, 0L, -1L, null, "Holmium", false),
    Er(68L, 99L, 0L, -1L, null, "Erbium", false),
    Tm(69L, 99L, 0L, -1L, null, "Thulium", false),
    Yb(70L, 103L, 0L, -1L, null, "Ytterbium", false),
    Lu(71L, 103L, 0L, -1L, null, "Lutetium", false),
    Hf(72L, 106L, 0L, -1L, null, "Hafnium", false),
    Ta(73L, 107L, 0L, -1L, null, "Tantalum", false),
    W(74L, 109L, 0L, -1L, null, "Wolframium", false),
    Re(75L, 111L, 0L, -1L, null, "Rhenium", false),
    Os(76L, 114L, 0L, -1L, null, "Osmium", false),
    Ir(77L, 115L, 0L, -1L, null, "Iridium", false),
    Pt(78L, 117L, 0L, -1L, null, "Platinum", false),
    Au(79L, 117L, 0L, -1L, null, "Gold", false),
    Hg(80L, 120L, 0L, -1L, null, "Mercury", false),
    Tl(81L, 123L, 0L, -1L, null, "Thallium", false),
    Pb(82L, 125L, 0L, -1L, null, "Lead", false),
    Bi(83L, 125L, 0L, -1L, null, "Bismuth", false),
    Po(84L, 124L, 0L, -1L, null, "Polonium", false),
    At(85L, 124L, 0L, -1L, null, "Astatine", false),
    Rn(86L, 134L, 0L, -1L, null, "Radon", false),
    Fr(87L, 134L, 0L, -1L, null, "Francium", false),
    Ra(88L, 136L, 0L, -1L, null, "Radium", false),
    Ac(89L, 136L, 0L, -1L, null, "Actinium", false),
    Th(90L, 140L, 0L, -1L, null, "Thorium", false),
    Pa(91L, 138L, 0L, -1L, null, "Protactinium", false),
    U(92L, 146L, 0L, -1L, null, "Uranium", false),
    U_235(92L, 143L, 0L, -1L, null, "Uranium-235", true),
    Np(93L, 144L, 0L, -1L, null, "Neptunium", false),
    Pu(94L, 152L, 0L, -1L, null, "Plutonium", false),
    Pu_241(94L, 149L, 0L, -1L, null, "Plutonium-241", true),
    Am(95L, 150L, 0L, -1L, null, "Americium", false),
    Cm(96L, 153L, 0L, -1L, null, "Curium", false),
    Bk(97L, 152L, 0L, -1L, null, "Berkelium", false),
    Cf(98L, 153L, 0L, -1L, null, "Californium", false),
    Es(99L, 153L, 0L, -1L, null, "Einsteinium", false),
    Fm(100L, 157L, 0L, -1L, null, "Fermium", false),
    Md(101L, 157L, 0L, -1L, null, "Mendelevium", false),
    No(102L, 157L, 0L, -1L, null, "Nobelium", false),
    Lr(103L, 159L, 0L, -1L, null, "Lawrencium", false),
    Rf(104L, 161L, 0L, -1L, null, "Rutherfordium", false),
    Db(105L, 163L, 0L, -1L, null, "Dubnium", false),
    Sg(106L, 165L, 0L, -1L, null, "Seaborgium", false),
    Bh(107L, 163L, 0L, -1L, null, "Bohrium", false),
    Hs(108L, 169L, 0L, -1L, null, "Hassium", false),
    Mt(109L, 167L, 0L, -1L, null, "Meitnerium", false),
    Ds(110L, 171L, 0L, -1L, null, "Darmstadtium", false),
    Rg(111L, 169L, 0L, -1L, null, "Roentgenium", false),
    Cn(112L, 173L, 0L, -1L, null, "Copernicium", false),
    Uut(113L, 171L, 0L, -1L, null, "Ununtrium", false),
    Fl(114L, 175L, 0L, -1L, null, "Flerovium", false),
    Uup(115L, 173L, 0L, -1L, null, "Ununpentium", false),
    Lv(116L, 177L, 0L, -1L, null, "Livermorium", false),
    Fa(117L, 177L, 0L, -1L, null, "Farnsium", false),
    Uuo(118L, 176L, 0L, -1L, null, "Ununoctium", false),
    Ma(0L, 0L, 100L, -1L, null, "Magic", false),
    Nt(0L, 100000L, 0L, -1L, null, "Neutronium", false),
    $H(-1L, 0L, 0L, -1L, null, "Anti-Hydrogen", false),
    $D(-1L, -1L, 0L, -1L, "H", "Anti-Deuterium", true),
    $T(-1L, -2L, 0L, -1L, "D", "Anti-Tritium", true),
    $He(-2L, -2L, 0L, -1L, null, "Anti-Helium", false),
    $He_3(-2L, -1L, 0L, -1L, "H&D", "Anti-Helium-3", true),
    $Li(-3L, -4L, 0L, -1L, null, "Anti-Lithium", false),
    $Be(-4L, -5L, 0L, -1L, null, "Anti-Beryllium", false),
    $B(-5L, -5L, 0L, -1L, null, "Anti-Boron", false),
    $C(-6L, -6L, 0L, -1L, null, "Anti-Carbon", false),
    $N(-7L, -7L, 0L, -1L, null, "Anti-Nitrogen", false),
    $O(-8L, -8L, 0L, -1L, null, "Anti-Oxygen", false),
    $F(-9L, -9L, 0L, -1L, null, "Anti-Fluorine", false),
    $Ne(-10L, -10L, 0L, -1L, null, "Anti-Neon", false),
    $Na(-11L, -11L, 0L, -1L, null, "Anti-Sodium", false),
    $Mg(-12L, -12L, 0L, -1L, null, "Anti-Magnesium", false),
    $Al(-13L, -13L, 0L, -1L, null, "Anti-Aluminium", false),
    $Si(-14L, -14L, 0L, -1L, null, "Anti-Silicon", false),
    $P(-15L, -15L, 0L, -1L, null, "Anti-Phosphorus", false),
    $S(-16L, -16L, 0L, -1L, null, "Anti-Sulfur", false),
    $Cl(-17L, -18L, 0L, -1L, null, "Anti-Chlorine", false),
    $Ar(-18L, -22L, 0L, -1L, null, "Anti-Argon", false),
    $K(-19L, -20L, 0L, -1L, null, "Anti-Potassium", false),
    $Ca(-20L, -20L, 0L, -1L, null, "Anti-Calcium", false),
    $Sc(-21L, -24L, 0L, -1L, null, "Anti-Scandium", false),
    $Ti(-22L, -26L, 0L, -1L, null, "Anti-Titanium", false),
    $V(-23L, -28L, 0L, -1L, null, "Anti-Vanadium", false),
    $Cr(-24L, -28L, 0L, -1L, null, "Anti-Chrome", false),
    $Mn(-25L, -30L, 0L, -1L, null, "Anti-Manganese", false),
    $Fe(-26L, -30L, 0L, -1L, null, "Anti-Iron", false),
    $Co(-27L, -32L, 0L, -1L, null, "Anti-Cobalt", false),
    $Ni(-28L, -30L, 0L, -1L, null, "Anti-Nickel", false),
    $Cu(-29L, -34L, 0L, -1L, null, "Anti-Copper", false),
    $Zn(-30L, -35L, 0L, -1L, null, "Anti-Zinc", false),
    $Ga(-31L, -39L, 0L, -1L, null, "Anti-Gallium", false),
    $Ge(-32L, -40L, 0L, -1L, null, "Anti-Germanium", false),
    $As(-33L, -42L, 0L, -1L, null, "Anti-Arsenic", false),
    $Se(-34L, -45L, 0L, -1L, null, "Anti-Selenium", false),
    $Br(-35L, -45L, 0L, -1L, null, "Anti-Bromine", false),
    $Kr(-36L, -48L, 0L, -1L, null, "Anti-Krypton", false),
    $Rb(-37L, -48L, 0L, -1L, null, "Anti-Rubidium", false),
    $Sr(-38L, -49L, 0L, -1L, null, "Anti-Strontium", false),
    $Y(-39L, -50L, 0L, -1L, null, "Anti-Yttrium", false),
    $Zr(-40L, -51L, 0L, -1L, null, "Anti-Zirconium", false),
    $Nb(-41L, -53L, 0L, -1L, null, "Anti-Niobium", false),
    $Mo(-42L, -53L, 0L, -1L, null, "Anti-Molybdenum", false),
    $Tc(-43L, -55L, 0L, -1L, null, "Anti-Technetium", false),
    $Ru(-44L, -57L, 0L, -1L, null, "Anti-Ruthenium", false),
    $Rh(-45L, -58L, 0L, -1L, null, "Anti-Rhodium", false),
    $Pd(-46L, -60L, 0L, -1L, null, "Anti-Palladium", false),
    $Ag(-47L, -60L, 0L, -1L, null, "Anti-Silver", false),
    $Cd(-48L, -64L, 0L, -1L, null, "Anti-Cadmium", false),
    $In(-49L, -65L, 0L, -1L, null, "Anti-Indium", false),
    $Sn(-50L, -68L, 0L, -1L, null, "Anti-Tin", false),
    $Sb(-51L, -70L, 0L, -1L, null, "Anti-Antimony", false),
    $Te(-52L, -75L, 0L, -1L, null, "Anti-Tellurium", false),
    $I(-53L, -74L, 0L, -1L, null, "Anti-Iodine", false),
    $Xe(-54L, -77L, 0L, -1L, null, "Anti-Xenon", false),
    $Cs(-55L, -77L, 0L, -1L, null, "Anti-Caesium", false),
    $Ba(-56L, -81L, 0L, -1L, null, "Anti-Barium", false),
    $La(-57L, -81L, 0L, -1L, null, "Anti-Lantanium", false),
    $Ce(-58L, -82L, 0L, -1L, null, "Anti-Cerium", false),
    $Pr(-59L, -81L, 0L, -1L, null, "Anti-Praseodymium", false),
    $Nd(-60L, -84L, 0L, -1L, null, "Anti-Neidymium", false),
    $Pm(-61L, -83L, 0L, -1L, null, "Anti-Promethium", false),
    $Sm(-62L, -88L, 0L, -1L, null, "Anti-Samarium", false),
    $Eu(-63L, -88L, 0L, -1L, null, "Anti-Europium", false),
    $Gd(-64L, -93L, 0L, -1L, null, "Anti-Gadolinium", false),
    $Tb(-65L, -93L, 0L, -1L, null, "Anti-Terbium", false),
    $Dy(-66L, -96L, 0L, -1L, null, "Anti-Dysprosium", false),
    $Ho(-67L, -97L, 0L, -1L, null, "Anti-Holmium", false),
    $Er(-68L, -99L, 0L, -1L, null, "Anti-Erbium", false),
    $Tm(-69L, -99L, 0L, -1L, null, "Anti-Thulium", false),
    $Yb(-70L, -103L, 0L, -1L, null, "Anti-Ytterbium", false),
    $Lu(-71L, -103L, 0L, -1L, null, "Anti-Lutetium", false),
    $Hf(-72L, -106L, 0L, -1L, null, "Anti-Hafnium", false),
    $Ta(-73L, -107L, 0L, -1L, null, "Anti-Tantalum", false),
    $W(-74L, -109L, 0L, -1L, null, "Anti-Wolframium", false),
    $Re(-75L, -111L, 0L, -1L, null, "Anti-Rhenium", false),
    $Os(-76L, -114L, 0L, -1L, null, "Anti-Osmium", false),
    $Ir(-77L, -115L, 0L, -1L, null, "Anti-Iridium", false),
    $Pt(-78L, -117L, 0L, -1L, null, "Anti-Platinum", false),
    $Au(-79L, -117L, 0L, -1L, null, "Anti-Gold", false),
    $Hg(-80L, -120L, 0L, -1L, null, "Anti-Mercury", false),
    $Tl(-81L, -123L, 0L, -1L, null, "Anti-Thallium", false),
    $Pb(-82L, -125L, 0L, -1L, null, "Anti-Lead", false),
    $Bi(-83L, -125L, 0L, -1L, null, "Anti-Bismuth", false),
    $Po(-84L, -124L, 0L, -1L, null, "Anti-Polonium", false),
    $At(-85L, -124L, 0L, -1L, null, "Anti-Astatine", false),
    $Rn(-86L, -134L, 0L, -1L, null, "Anti-Radon", false),
    $Fr(-87L, -134L, 0L, -1L, null, "Anti-Francium", false),
    $Ra(-88L, -136L, 0L, -1L, null, "Anti-Radium", false),
    $Ac(-89L, -136L, 0L, -1L, null, "Anti-Actinium", false),
    $Th(-90L, -140L, 0L, -1L, null, "Anti-Thorium", false),
    $Pa(-91L, -138L, 0L, -1L, null, "Anti-Protactinium", false),
    $U(-92L, -146L, 0L, -1L, null, "Anti-Uranium", false),
    $U_235(-92L, -143L, 0L, -1L, null, "Anti-Uranium-235", true),
    $Np(-93L, -144L, 0L, -1L, null, "Anti-Neptunium", false),
    $Pu(-94L, -152L, 0L, -1L, null, "Anti-Plutonium", false),
    $Pu_241(-94L, -149L, 0L, -1L, null, "Anti-Plutonium-241", true),
    $Am(-95L, -150L, 0L, -1L, null, "Anti-Americum", false),
    $Cm(-96L, -153L, 0L, -1L, null, "Anti-Curium", false),
    $Bk(-97L, -152L, 0L, -1L, null, "Anti-Berkelium", false),
    $Cf(-98L, -153L, 0L, -1L, null, "Anti-Californium", false),
    $Es(-99L, -153L, 0L, -1L, null, "Anti-Einsteinium", false),
    $Fm(-100L, -157L, 0L, -1L, null, "Anti-Fermium", false),
    $Md(-101L, -157L, 0L, -1L, null, "Anti-Mendelevium", false),
    $No(-102L, -157L, 0L, -1L, null, "Anti-Nobelium", false),
    $Lr(-103L, -159L, 0L, -1L, null, "Anti-Lawrencium", false),
    $Rf(-104L, -161L, 0L, -1L, null, "Anti-Rutherfordium", false),
    $Db(-105L, -163L, 0L, -1L, null, "Anti-Dubnium", false),
    $Sg(-106L, -165L, 0L, -1L, null, "Anti-Seaborgium", false),
    $Bh(-107L, -163L, 0L, -1L, null, "Anti-Bohrium", false),
    $Hs(-108L, -169L, 0L, -1L, null, "Anti-Hassium", false),
    $Mt(-109L, -167L, 0L, -1L, null, "Anti-Meitnerium", false),
    $Ds(-110L, -171L, 0L, -1L, null, "Anti-Darmstadtium", false),
    $Rg(-111L, -169L, 0L, -1L, null, "Anti-Roentgenium", false),
    $Cn(-112L, -173L, 0L, -1L, null, "Anti-Copernicium", false),
    $Uut(-113L, -171L, 0L, -1L, null, "Anti-Ununtrium", false),
    $Fl(-114L, -175L, 0L, -1L, null, "Anti-Flerovium", false),
    $Uup(-115L, -173L, 0L, -1L, null, "Anti-Ununpentium", false),
    $Lv(-116L, -177L, 0L, -1L, null, "Anti-Livermorium", false),
    $Uus(-117L, -177L, 0L, -1L, null, "Anti-Ununseptium", false),
    $Uuo(-118L, -176L, 0L, -1L, null, "Anti-Ununoctium", false),
    $Ma(0L, 0L, -100L, -1L, null, "Anti-Magic", false),
    $Nt(0L, -100000L, 0L, -1L, null, "Anti-Neutronium", false);

    public final long mProtons;
    public final long mNeutrons;
    public final long mAdditionalMass;
    public final long mHalfLifeSeconds;
    public final String mName;
    public final String mDecayTo;
    public final boolean mIsIsotope;
    public ArrayList<Materials> mLinkedMaterials = new ArrayList();
    public static volatile int VERSION;

    public static Element get(String aMaterialName) {
        Object tObject = GT_Utility.getFieldContent(Element.class, aMaterialName, false, false);
        if (tObject != null && tObject instanceof Element) {
            return (Element)((Object)tObject);
        }
        return _NULL;
    }

    private Element(long aProtons, long aNeutrons, long aAdditionalMass, long aHalfLifeSeconds, String aDecayTo, String aName, boolean aIsIsotope) {
        this.mProtons = aProtons;
        this.mNeutrons = aNeutrons;
        this.mAdditionalMass = aAdditionalMass;
        this.mHalfLifeSeconds = aHalfLifeSeconds;
        this.mDecayTo = aDecayTo;
        this.mName = aName;
        this.mIsIsotope = aIsIsotope;
    }

    public long getProtons() {
        return this.mProtons;
    }

    public long getNeutrons() {
        return this.mNeutrons;
    }

    public long getMass() {
        return this.mProtons + this.mNeutrons + this.mAdditionalMass;
    }

    static {
        VERSION = 508;
    }
}

