/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_Log;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderHell;

public class GT_Worldgenerator
implements IWorldGenerator {
    public static boolean sAsteroids = true;
    public List<Runnable> mList = new ArrayList<Runnable>();
    public boolean mIsGenerating = false;

    public GT_Worldgenerator() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0x3FFFFFFF);
    }

    public void generate(Random aRandom, int aX, int aZ, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        this.mList.add(new WorldGenContainer(new Random(aRandom.nextInt()), aX * 16, aZ * 16, aChunkGenerator instanceof ChunkProviderEnd || aWorld.func_72807_a(aX * 16 + 8, aZ * 16 + 8) == BiomeGenBase.field_76779_k ? 1 : (aChunkGenerator instanceof ChunkProviderHell || aWorld.func_72807_a(aX * 16 + 8, aZ * 16 + 8) == BiomeGenBase.field_76778_j ? -1 : 0), aWorld, aChunkGenerator, aChunkProvider, aWorld.func_72807_a((int)(aX * 16 + 8), (int)(aZ * 16 + 8)).field_76791_y));
        if (!this.mIsGenerating) {
            this.mIsGenerating = true;
            for (int i = 0; i < this.mList.size(); ++i) {
                this.mList.get(i).run();
            }
            this.mList.clear();
            this.mIsGenerating = false;
        }
    }

    public static class WorldGenContainer
    implements Runnable {
        public final Random mRandom;
        public final int mX;
        public final int mZ;
        public final int mDimensionType;
        public final World mWorld;
        public final IChunkProvider mChunkGenerator;
        public final IChunkProvider mChunkProvider;
        public final String mBiome;

        public WorldGenContainer(Random aRandom, int aX, int aZ, int aDimensionType, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider, String aBiome) {
            this.mRandom = aRandom;
            this.mX = aX;
            this.mZ = aZ;
            this.mDimensionType = aDimensionType;
            this.mWorld = aWorld;
            this.mChunkGenerator = aChunkGenerator;
            this.mChunkProvider = aChunkProvider;
            this.mBiome = aBiome;
        }

        @Override
        public void run() {
            Chunk tChunk;
            if (Math.abs(this.mX / 16) % 3 == 1 && Math.abs(this.mZ / 16) % 3 == 1) {
                if (GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                    boolean temp = true;
                    block4: for (int i = 0; i < 256 && temp; ++i) {
                        int tRandomWeight = this.mRandom.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                        for (GT_Worldgen gT_Worldgen : GT_Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= ((GT_Worldgen_GT_Ore_Layer)gT_Worldgen).mWeight) > 0) continue;
                            try {
                                if (!gT_Worldgen.executeWorldgen(this.mWorld, this.mRandom, this.mBiome, this.mDimensionType, this.mX, this.mZ, this.mChunkGenerator, this.mChunkProvider)) continue;
                                temp = false;
                                continue block4;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                }
                int i = 0;
                int tX = this.mX - 16;
                while (i < 3) {
                    int j = 0;
                    int tZ = this.mZ - 16;
                    while (j < 3) {
                        String string = this.mWorld.func_72807_a((int)(tX + 8), (int)(tZ + 8)).field_76791_y;
                        if (string == null) {
                            String string2 = BiomeGenBase.field_76772_c.field_76791_y;
                        }
                        for (GT_Worldgen tWorldGen : GregTech_API.sWorldgenList) {
                            try {
                                tWorldGen.executeWorldgen(this.mWorld, this.mRandom, this.mBiome, this.mDimensionType, tX, tZ, this.mChunkGenerator, this.mChunkProvider);
                            }
                            catch (Throwable e) {
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                        ++j;
                        tZ += 16;
                    }
                    ++i;
                    tX += 16;
                }
            }
            if ((tChunk = this.mWorld.func_72938_d(this.mX, this.mZ)) != null) {
                tChunk.field_76643_l = true;
            }
        }
    }
}

