/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.ItemList;
import gregtech.api.gui.GT_Container_BasicTank;
import gregtech.api.gui.GT_GUIContainer_BasicTank;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_BasicTank
extends GT_MetaTileEntity_TieredMachineBlock {
    public FluidStack mFluid;

    public GT_MetaTileEntity_BasicTank(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicTank(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex != this.getStackDisplaySlot();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"));
    }

    public abstract boolean doesFillContainers();

    public abstract boolean doesEmptyContainers();

    public abstract boolean canTankBeFilled();

    public abstract boolean canTankBeEmptied();

    public abstract boolean displaysItemStack();

    public abstract boolean displaysStackSize();

    public int getInputSlot() {
        return 0;
    }

    public int getOutputSlot() {
        return 1;
    }

    public int getStackDisplaySlot() {
        return 2;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return true;
    }

    public boolean isFluidChangingAllowed() {
        return true;
    }

    public FluidStack getFillableStack() {
        return this.mFluid;
    }

    public FluidStack setFillableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public FluidStack getDrainableStack() {
        return this.mFluid;
    }

    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public FluidStack getDisplayedFluid() {
        return this.getDrainableStack();
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicTank(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicTank(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack tOutput;
            FluidStack tFluid;
            if (this.isFluidChangingAllowed() && this.getFillableStack() != null && this.getFillableStack().amount <= 0) {
                this.setFillableStack(null);
            }
            if (this.displaysItemStack() && this.getStackDisplaySlot() >= 0 && this.getStackDisplaySlot() < this.mInventory.length) {
                if (this.getDisplayedFluid() == null) {
                    if (ItemList.Display_Fluid.isStackEqual(this.mInventory[this.getStackDisplaySlot()], true, true)) {
                        this.mInventory[this.getStackDisplaySlot()] = null;
                    }
                } else {
                    this.mInventory[this.getStackDisplaySlot()] = GT_Utility.getFluidDisplayStack(this.getDisplayedFluid(), this.displaysStackSize());
                }
            }
            if (this.doesEmptyContainers() && (tFluid = GT_Utility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true)) != null && this.isFluidInputAllowed(tFluid)) {
                if (this.getFillableStack() == null) {
                    if (this.isFluidInputAllowed(tFluid) && tFluid.amount <= this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerItem(this.mInventory[this.getInputSlot()], true), 1)) {
                        this.setFillableStack(tFluid.copy());
                        aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                    }
                } else if (tFluid.isFluidEqual(this.getFillableStack()) && tFluid.amount + this.getFillableStack().amount <= this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerItem(this.mInventory[this.getInputSlot()], true), 1)) {
                    this.getFillableStack().amount += tFluid.amount;
                    aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                }
            }
            if (this.doesFillContainers() && (tOutput = GT_Utility.fillFluidContainer(this.getDrainableStack(), this.mInventory[this.getInputSlot()], false, true)) != null && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tOutput, 1)) {
                FluidStack tFluid2 = GT_Utility.getFluidForFilledItem(tOutput, true);
                aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                if (tFluid2 != null) {
                    this.getDrainableStack().amount -= tFluid2.amount;
                }
                if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
                    this.setDrainableStack(null);
                }
            }
        }
    }

    @Override
    public FluidStack getFluid() {
        return this.getDrainableStack();
    }

    @Override
    public int getFluidAmount() {
        return this.getDrainableStack() != null ? this.getDrainableStack().amount : 0;
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (this.getFillableStack() == null || this.getFillableStack().getFluid().getID() <= 0) {
            if (aFluid.amount <= this.getCapacity()) {
                if (doFill) {
                    this.setFillableStack(aFluid.copy());
                    this.getBaseMetaTileEntity().func_70296_d();
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.setFillableStack(aFluid.copy());
                this.getFillableStack().amount = this.getCapacity();
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return this.getCapacity();
        }
        if (!this.getFillableStack().isFluidEqual(aFluid)) {
            return 0;
        }
        int space = this.getCapacity() - this.getFillableStack().amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                this.getFillableStack().amount += aFluid.amount;
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return aFluid.amount;
        }
        if (doFill) {
            this.getFillableStack().amount = this.getCapacity();
        }
        return space;
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getDrainableStack() == null || !this.canTankBeEmptied()) {
            return null;
        }
        if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setDrainableStack(null);
            this.getBaseMetaTileEntity().func_70296_d();
            return null;
        }
        int used = maxDrain;
        if (this.getDrainableStack().amount < used) {
            used = this.getDrainableStack().amount;
        }
        if (doDrain) {
            this.getDrainableStack().amount -= used;
            this.getBaseMetaTileEntity().func_70296_d();
        }
        FluidStack drained = this.getDrainableStack().copy();
        drained.amount = used;
        if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
            this.setDrainableStack(null);
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return drained;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == this.getOutputSlot();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == this.getInputSlot();
    }
}

