/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.GregTech_API;
import gregtech.api.world.GT_Worldgen_Ore;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class GT_Worldgen_Stone
extends GT_Worldgen_Ore {
    public GT_Worldgen_Stone(String aName, boolean aDefault, Block aBlock, int aBlockMeta, int aDimensionType, int aAmount, int aSize, int aProbability, int aMinY, int aMaxY, Collection<String> aBiomeList, boolean aAllowToGenerateinVoid) {
        super(aName, aDefault, aBlock, aBlockMeta, aDimensionType, aAmount, aSize, aProbability, aMinY, aMaxY, aBiomeList, aAllowToGenerateinVoid);
    }

    @Override
    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        if (this.isGenerationAllowed(aWorld, aDimensionType, this.mDimensionType) && (this.mBiomeList.isEmpty() || this.mBiomeList.contains(aBiome)) && (this.mProbability <= 1 || aRandom.nextInt(this.mProbability) == 0)) {
            for (int i = 0; i < this.mAmount; ++i) {
                int tX = aChunkX + aRandom.nextInt(16);
                int tY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY);
                int tZ = aChunkZ + aRandom.nextInt(16);
                if (!this.mAllowToGenerateinVoid && aWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)aWorld, tX, tY, tZ)) continue;
                float var6 = aRandom.nextFloat() * 3.141593f;
                double var7 = (float)(tX + 8) + MathHelper.func_76126_a((float)var6) * (float)this.mSize / 8.0f;
                double var9 = (float)(tX + 8) - MathHelper.func_76126_a((float)var6) * (float)this.mSize / 8.0f;
                double var11 = (float)(tZ + 8) + MathHelper.func_76134_b((float)var6) * (float)this.mSize / 8.0f;
                double var13 = (float)(tZ + 8) - MathHelper.func_76134_b((float)var6) * (float)this.mSize / 8.0f;
                double var15 = tY + aRandom.nextInt(3) - 2;
                double var17 = tY + aRandom.nextInt(3) - 2;
                for (int var19 = 0; var19 <= this.mSize; ++var19) {
                    double var20 = var7 + (var9 - var7) * (double)var19 / (double)this.mSize;
                    double var22 = var15 + (var17 - var15) * (double)var19 / (double)this.mSize;
                    double var24 = var11 + (var13 - var11) * (double)var19 / (double)this.mSize;
                    double var26 = aRandom.nextDouble() * (double)this.mSize / 16.0;
                    double var28 = (double)(MathHelper.func_76126_a((float)((float)var19 * 3.141593f / (float)this.mSize)) + 1.0f) * var26 + 1.0;
                    double var30 = (double)(MathHelper.func_76126_a((float)((float)var19 * 3.141593f / (float)this.mSize)) + 1.0f) * var26 + 1.0;
                    int tMinX = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
                    int tMinY = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
                    int tMinZ = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
                    int tMaxX = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
                    int tMaxY = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
                    int tMaxZ = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
                    for (int eX = tMinX; eX <= tMaxX; ++eX) {
                        double var39 = ((double)eX + 0.5 - var20) / (var28 / 2.0);
                        if (!(var39 * var39 < 1.0)) continue;
                        for (int eY = tMinY; eY <= tMaxY; ++eY) {
                            double var42 = ((double)eY + 0.5 - var22) / (var30 / 2.0);
                            if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                            for (int eZ = tMinZ; eZ <= tMaxZ; ++eZ) {
                                double var45 = ((double)eZ + 0.5 - var24) / (var28 / 2.0);
                                if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0)) continue;
                                Block tTargetedBlock = aWorld.func_147439_a(eX, eY, eZ);
                                if (tTargetedBlock == GregTech_API.sBlockOres1) {
                                    TileEntity tTileEntity = aWorld.func_147438_o(eX, eY, eZ);
                                    if (!(tTileEntity instanceof GT_TileEntity_Ores)) continue;
                                    ((GT_TileEntity_Ores)tTileEntity).overrideOreBlockMaterial(this.mBlock, (byte)this.mBlockMeta);
                                    continue;
                                }
                                if ((!this.mAllowToGenerateinVoid || !aWorld.func_147439_a(eX, eY, eZ).isAir((IBlockAccess)aWorld, eX, eY, eZ)) && (tTargetedBlock == null || !tTargetedBlock.isReplaceableOreGen(aWorld, eX, eY, eZ, Blocks.field_150348_b) && !tTargetedBlock.isReplaceableOreGen(aWorld, eX, eY, eZ, Blocks.field_150377_bs) && !tTargetedBlock.isReplaceableOreGen(aWorld, eX, eY, eZ, Blocks.field_150424_aL))) continue;
                                aWorld.func_147465_d(eX, eY, eZ, this.mBlock, this.mBlockMeta, 0);
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }
}

