/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GregTech_API;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_None;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Behaviour_Wrench
extends Behaviour_None {
    private final int mCosts;
    private final String mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.wrench", "Rotates Blocks on Rightclick");

    public Behaviour_Wrench(int aCosts) {
        this.mCosts = aCosts;
    }

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == null) {
            return false;
        }
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        byte aTargetSide = GT_Utility.determineWrenchingSide((byte)aSide, hitX, hitY, hitZ);
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        try {
            if (aTileEntity != null && aTileEntity instanceof IWrenchable) {
                if (((IWrenchable)aTileEntity).wrenchCanSetFacing(aPlayer, (int)aTargetSide)) {
                    if (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts)) {
                        ((IWrenchable)aTileEntity).setFacing((short)aTargetSide);
                        GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
                    }
                    return true;
                }
                if (((IWrenchable)aTileEntity).wrenchCanRemove(aPlayer)) {
                    int tDamage;
                    int n = tDamage = ((IWrenchable)aTileEntity).getWrenchDropRate() < 1.0f ? 10 : 3;
                    if (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, tDamage * this.mCosts)) {
                        ItemStack tOutput = ((IWrenchable)aTileEntity).getWrenchDrop(aPlayer);
                        for (ItemStack tStack : aBlock.getDrops(aWorld, aX, aY, aZ, (int)aMeta, 0)) {
                            if (tOutput == null) {
                                aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, tStack));
                                continue;
                            }
                            aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, tOutput));
                            tOutput = null;
                        }
                        aWorld.func_147468_f(aX, aY, aZ);
                        GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
                    }
                    return true;
                }
                return true;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (aBlock == Blocks.field_150364_r || aBlock == Blocks.field_150363_s || aBlock == Blocks.field_150407_cf) {
            if (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts)) {
                aWorld.func_72921_c(aX, aY, aZ, (aMeta + 4) % 12, 3);
                GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
            }
            return true;
        }
        if (aBlock == Blocks.field_150416_aS || aBlock == Blocks.field_150413_aR) {
            if (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts)) {
                aWorld.func_72921_c(aX, aY, aZ, aMeta / 4 * 4 + (aMeta % 4 + 1) % 4, 3);
                GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
            }
            return true;
        }
        if (aBlock == Blocks.field_150455_bV || aBlock == Blocks.field_150441_bU) {
            if (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts)) {
                aWorld.func_72921_c(aX, aY, aZ, aMeta / 4 * 4 + (aMeta % 4 + 1) % 4, 3);
                GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
            }
            return true;
        }
        if (aBlock == Blocks.field_150462_ai || aBlock == Blocks.field_150342_X) {
            if (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts)) {
                aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, new ItemStack(aBlock, 1, (int)aMeta)));
                aWorld.func_147468_f(aX, aY, aZ);
                GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
            }
            return true;
        }
        if (aMeta == aTargetSide) {
            if (aBlock == Blocks.field_150423_aK || aBlock == Blocks.field_150428_aP || aBlock == Blocks.field_150331_J || aBlock == Blocks.field_150320_F || aBlock == Blocks.field_150367_z || aBlock == Blocks.field_150409_cd || aBlock == Blocks.field_150460_al || aBlock == Blocks.field_150470_am || aBlock == Blocks.field_150486_ae || aBlock == Blocks.field_150447_bR || aBlock == Blocks.field_150477_bB || aBlock == Blocks.field_150438_bZ) {
                if (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts)) {
                    aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, new ItemStack(aBlock, 1, 0)));
                    aWorld.func_147468_f(aX, aY, aZ);
                    GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
                }
                return true;
            }
        } else {
            if (aBlock == Blocks.field_150331_J || aBlock == Blocks.field_150320_F || aBlock == Blocks.field_150367_z || aBlock == Blocks.field_150409_cd) {
                if (aMeta < 6 && (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts))) {
                    aWorld.func_72921_c(aX, aY, aZ, (int)aTargetSide, 3);
                    GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
                }
                return true;
            }
            if (aBlock == Blocks.field_150423_aK || aBlock == Blocks.field_150428_aP || aBlock == Blocks.field_150460_al || aBlock == Blocks.field_150470_am || aBlock == Blocks.field_150486_ae || aBlock == Blocks.field_150477_bB || aBlock == Blocks.field_150447_bR) {
                if (aTargetSide > 1 && (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts))) {
                    aWorld.func_72921_c(aX, aY, aZ, (int)aTargetSide, 3);
                    GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
                }
                return true;
            }
            if (aBlock == Blocks.field_150438_bZ) {
                if (aTargetSide != 1 && (aPlayer.field_71075_bZ.field_75098_d || ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts))) {
                    aWorld.func_72921_c(aX, aY, aZ, (int)aTargetSide, 3);
                    GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
                }
                return true;
            }
        }
        if (Arrays.asList(aBlock.getValidRotations(aWorld, aX, aY, aZ)).contains(ForgeDirection.getOrientation((int)aTargetSide)) && (aPlayer.field_71075_bZ.field_75098_d || !GT_ModHandler.isElectricItem(aStack) || GT_ModHandler.canUseElectricItem(aStack, this.mCosts)) && aBlock.rotateBlock(aWorld, aX, aY, aZ, ForgeDirection.getOrientation((int)aTargetSide))) {
            if (!aPlayer.field_71075_bZ.field_75098_d) {
                ((GT_MetaGenerated_Tool)aItem).doDamage(aStack, this.mCosts);
            }
            GT_Utility.sendSoundToPlayers(aWorld, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, aX, aY, aZ);
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }
}

