/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_DistillationTower
extends GT_MetaTileEntity_MultiBlockBase {
    private static boolean controller;

    public GT_MetaTileEntity_DistillationTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_DistillationTower(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DistillationTower(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Distillation Tower", "Size: 3x6x3 (Hollow)", "Controller (front bottom)", "1x Input Hatch (bottom)", "5x Output Hatch (one each height level besides botton)", "1x Output Bus (Botton)", "1x Energy Hatch (anywhere)", "1x Maintenance Hatch (anywhere)", "Clean Stainless Steel Casings for the rest (26 at least!)"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "VacuumFreezer.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sDistillationRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        if (this.mInputHatches.size() > 0 && this.mInputHatches.get(0) != null && ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid != null && ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid.amount > 0 && (tRecipe = GT_Recipe.GT_Recipe_Map.sDistillationRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], new FluidStack[]{((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid}, new ItemStack[0])) != null && tRecipe.isRecipeInputEqual(true, new FluidStack[]{((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid}, new ItemStack[0])) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            if (tRecipe.mEUt <= 16) {
                this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
            } else {
                this.mEUt = tRecipe.mEUt;
                this.mMaxProgresstime = tRecipe.mDuration;
                while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                    this.mEUt *= 4;
                    this.mMaxProgresstime /= 2;
                }
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0)};
            this.mOutputFluids = tRecipe.mFluidOutputs;
            this.updateSlots();
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 1, zDir)) {
            return false;
        }
        int tAmount = 0;
        controller = false;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int h = 0; h < 6; ++h) {
                    IGregTechTileEntity tTileEntity;
                    if (i == 0 && j == 0 && h > 0 && h < 5 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, h, zDir + j), 49) || this.addInputToMachineList(tTileEntity, 49) || this.addOutputToMachineList(tTileEntity, 49) || this.addEnergyInputToMachineList(tTileEntity, 49) || this.ignoreController(aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j))) continue;
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != GregTech_API.sBlockCasings4) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) != 1) {
                        return false;
                    }
                    ++tAmount;
                }
            }
        }
        if (this.mInputHatches.size() != 1 || this.mOutputBusses.size() != 1 || this.mInputBusses.size() != 0 || this.mOutputHatches.size() != 5) {
            return false;
        }
        short height = this.getBaseMetaTileEntity().getYCoord();
        if (((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(0)).getBaseMetaTileEntity().getYCoord() != height || ((GT_MetaTileEntity_Hatch_OutputBus)this.mOutputBusses.get(0)).getBaseMetaTileEntity().getYCoord() != height) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Output[] tmpHatches = new GT_MetaTileEntity_Hatch_Output[5];
        for (int i = 0; i < this.mOutputHatches.size(); ++i) {
            int hatchNumber = ((GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(i)).getBaseMetaTileEntity().getYCoord() - 1 - height;
            if (tmpHatches[hatchNumber] != null) {
                return false;
            }
            tmpHatches[hatchNumber] = (GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(i);
        }
        return tAmount >= 26;
    }

    public boolean ignoreController(Block tTileEntity) {
        return !controller && tTileEntity == GregTech_API.sBlockMachines;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

