/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ITexturedTileEntity;
import gregtech.api.objects.GT_CopiedBlockTexture;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Packet_Ores;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GT_TileEntity_Ores
extends TileEntity
implements ITexturedTileEntity {
    private static final ITexture[] mStoneTextures = new ITexture[]{new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150424_aL, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150377_bs, 0, 0), new GT_RenderedTexture(Textures.BlockIcons.GRANITE_BLACK_STONE), new GT_RenderedTexture(Textures.BlockIcons.GRANITE_RED_STONE), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), new GT_CopiedBlockTexture(Blocks.field_150348_b, 0, 0)};
    public short mMetaData = 0;
    public boolean mNatural = false;
    public boolean mBlocked = true;

    public void func_145839_a(NBTTagCompound aNBT) {
        super.func_145839_a(aNBT);
        this.mMetaData = aNBT.func_74765_d("m");
        this.mNatural = aNBT.func_74767_n("n");
    }

    public void func_145841_b(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
        aNBT.func_74777_a("m", this.mMetaData);
        aNBT.func_74757_a("n", this.mNatural);
    }

    public void onUpdated() {
        if (!this.field_145850_b.field_72995_K && this.mBlocked) {
            this.mBlocked = false;
            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GT_Packet_Ores(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mMetaData), this.field_145851_c, this.field_145849_e);
        }
    }

    public Packet func_145844_m() {
        if (!this.field_145850_b.field_72995_K && !(this.mBlocked == GT_Utility.isOpaqueBlock(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) && GT_Utility.isOpaqueBlock(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) && GT_Utility.isOpaqueBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && GT_Utility.isOpaqueBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) && GT_Utility.isOpaqueBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) && GT_Utility.isOpaqueBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1))) {
            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GT_Packet_Ores(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mMetaData), this.field_145851_c, this.field_145849_e);
        }
        return null;
    }

    public static byte getHarvestData(short aMetaData) {
        Materials aMaterial = GregTech_API.sGeneratedMaterials[aMetaData % 1000];
        return aMaterial == null ? (byte)0 : (byte)Math.max(aMetaData % 16000 / 1000 == 3 || aMetaData % 16000 / 1000 == 4 ? 3 : 0, Math.min(7, aMaterial.mToolQuality - (aMetaData < 16000 ? (byte)0 : 1)));
    }

    public void overrideOreBlockMaterial(Block aOverridingStoneBlock, byte aOverridingStoneMeta) {
        this.mMetaData = (short)((long)this.mMetaData % 1000L + (long)this.mMetaData / 16000L * 16000L);
        if (aOverridingStoneBlock.isReplaceableOreGen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150424_aL)) {
            this.mMetaData = (short)(this.mMetaData + 1000);
        } else if (aOverridingStoneBlock.isReplaceableOreGen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150377_bs)) {
            this.mMetaData = (short)(this.mMetaData + 2000);
        } else if (aOverridingStoneBlock.isReplaceableOreGen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, GregTech_API.sBlockGranites)) {
            this.mMetaData = aOverridingStoneBlock == GregTech_API.sBlockGranites ? (aOverridingStoneMeta < 8 ? (short)(this.mMetaData + 3000) : (short)(this.mMetaData + 4000)) : (short)(this.mMetaData + 3000);
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)GT_TileEntity_Ores.getHarvestData(this.mMetaData), 0);
    }

    public static boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int aMetaData) {
        aY = Math.min(aWorld.func_72940_L(), Math.max(aY, 1));
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aMetaData > 0 && tBlock != Blocks.field_150350_a) {
            if (tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) {
                aMetaData += 1000;
            } else if (tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs)) {
                aMetaData += 2000;
            } else if (tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTech_API.sBlockGranites)) {
                aMetaData = tBlock == GregTech_API.sBlockGranites ? (aWorld.func_72805_g(aX, aY, aZ) < 8 ? (aMetaData += 3000) : (aMetaData += 4000)) : (aMetaData += 3000);
            } else if (!tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b)) {
                return false;
            }
            aWorld.func_147465_d(aX, aY, aZ, GregTech_API.sBlockOres1, (int)GT_TileEntity_Ores.getHarvestData((short)aMetaData), 0);
            TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (tTileEntity instanceof GT_TileEntity_Ores) {
                ((GT_TileEntity_Ores)tTileEntity).mMetaData = (short)aMetaData;
                ((GT_TileEntity_Ores)tTileEntity).mNatural = true;
            }
            return true;
        }
        return false;
    }

    public short getMetaData() {
        return this.mMetaData;
    }

    public boolean canUpdate() {
        return false;
    }

    public ArrayList<ItemStack> getDrops(int aFortune) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (this.mMetaData <= 0) {
            rList.add(new ItemStack(Blocks.field_150366_p, 1, 0));
            return rList;
        }
        if (this.mMetaData < 16000) {
            rList.add(new ItemStack(GregTech_API.sBlockOres1, 1, (int)this.mMetaData));
            return rList;
        }
        Materials aMaterial = GregTech_API.sGeneratedMaterials[this.mMetaData % 1000];
        if (!this.mNatural) {
            aFortune = 0;
        }
        if (aMaterial != null) {
            int i;
            Random tRandom = new Random(this.field_145851_c ^ this.field_145848_d ^ this.field_145849_e);
            ArrayList<ItemStack> tSelector = new ArrayList<ItemStack>();
            ItemStack tStack = GT_OreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), 1L);
            if (tStack != null) {
                for (i = 0; i < 1; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GT_OreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), 1L)) != null) {
                for (i = 0; i < 2; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GT_OreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)) != null) {
                for (i = 0; i < 12; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GT_OreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), 1L)) != null) {
                for (i = 0; i < 5; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GT_OreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L)) != null) {
                for (i = 0; i < 10; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GT_OreDictUnificator.get(OrePrefixes.gemChipped, aMaterial, GT_OreDictUnificator.get(OrePrefixes.dustImpure, aMaterial, 1L), 1L)) != null) {
                for (i = 0; i < 5; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GT_OreDictUnificator.get(OrePrefixes.dustImpure, aMaterial, 1L)) != null) {
                for (i = 0; i < 10; ++i) {
                    tSelector.add(tStack);
                }
            }
            if (tSelector.size() > 0) {
                int j = Math.max(1, aMaterial.mOreMultiplier + (aFortune > 0 ? tRandom.nextInt(1 + aFortune * aMaterial.mOreMultiplier) : 0) / 2);
                for (i = 0; i < j; ++i) {
                    rList.add(GT_Utility.copyAmount(1L, tSelector.get(tRandom.nextInt(tSelector.size()))));
                }
            }
            if (tRandom.nextInt(3 + aFortune) > 1) {
                switch (this.mMetaData / 1000 % 16) {
                    case 0: {
                        rList.add(GT_OreDictUnificator.get(tRandom.nextInt(3) > 0 ? OrePrefixes.dustImpure : OrePrefixes.dust, Materials.Stone, 1L));
                        break;
                    }
                    case 1: {
                        rList.add(GT_OreDictUnificator.get(tRandom.nextInt(3) > 0 ? OrePrefixes.dustImpure : OrePrefixes.dust, Materials.Netherrack, 1L));
                        break;
                    }
                    case 2: {
                        rList.add(GT_OreDictUnificator.get(tRandom.nextInt(3) > 0 ? OrePrefixes.dustImpure : OrePrefixes.dust, Materials.Endstone, 1L));
                        break;
                    }
                    case 3: {
                        rList.add(GT_OreDictUnificator.get(tRandom.nextInt(3) > 0 ? OrePrefixes.dustImpure : OrePrefixes.dust, Materials.GraniteBlack, 1L));
                        break;
                    }
                    case 4: {
                        rList.add(GT_OreDictUnificator.get(tRandom.nextInt(3) > 0 ? OrePrefixes.dustImpure : OrePrefixes.dust, Materials.GraniteRed, 1L));
                    }
                }
            }
        }
        return rList;
    }

    @Override
    public ITexture[] getTexture(byte aSide) {
        Materials aMaterial = GregTech_API.sGeneratedMaterials[this.mMetaData % 1000];
        if (aMaterial != null && this.mMetaData < 32000) {
            return new ITexture[]{mStoneTextures[this.mMetaData / 1000 % 16], new GT_RenderedTexture(aMaterial.mIconSet.mTextures[this.mMetaData / 16000 == 0 ? OrePrefixes.ore.mTextureIndex : OrePrefixes.oreSmall.mTextureIndex], aMaterial.mRGBa)};
        }
        return new ITexture[]{mStoneTextures[0], new GT_RenderedTexture(TextureSet.SET_NONE.mTextures[OrePrefixes.ore.mTextureIndex])};
    }
}

