/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces.tileentity;

import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.util.GT_Utility;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public interface IEnergyConnected
extends IColoredTileEntity,
IHasWorldObjectAndCoords {
    public long injectEnergyUnits(byte var1, long var2, long var4);

    public boolean inputEnergyFrom(byte var1);

    public boolean outputsEnergyTo(byte var1);

    public static class Util {
        public static final long emitEnergyToNetwork(long aVoltage, long aAmperage, IEnergyConnected aEmitter) {
            long rUsedAmperes = 0L;
            byte j = 0;
            for (byte i = 0; i < 6 && aAmperage > rUsedAmperes; i = (byte)(i + 1)) {
                if (!aEmitter.outputsEnergyTo(i)) continue;
                j = GT_Utility.getOppositeSide(i);
                TileEntity tTileEntity = aEmitter.getTileEntityAtSide(i);
                if (tTileEntity instanceof IEnergyConnected) {
                    byte tColor;
                    if (aEmitter.getColorization() >= 0 && (tColor = ((IEnergyConnected)tTileEntity).getColorization()) >= 0 && tColor != aEmitter.getColorization()) continue;
                    rUsedAmperes += ((IEnergyConnected)tTileEntity).injectEnergyUnits(j, aVoltage, aAmperage - rUsedAmperes);
                    continue;
                }
                if (!(tTileEntity instanceof IEnergySink) || !((IEnergySink)tTileEntity).acceptsEnergyFrom((TileEntity)aEmitter, ForgeDirection.getOrientation((int)j))) continue;
                while (aAmperage > rUsedAmperes && ((IEnergySink)tTileEntity).getDemandedEnergy() > 0.0 && ((IEnergySink)tTileEntity).injectEnergy(ForgeDirection.getOrientation((int)j), (double)aVoltage, (double)aVoltage) < (double)aVoltage) {
                    ++rUsedAmperes;
                }
            }
            return rUsedAmperes;
        }
    }
}

