/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Hatch_Output
extends GT_MetaTileEntity_Hatch {
    public byte mMode = 0;

    public GT_MetaTileEntity_Hatch_Output(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "Use Screwdriver to specify Output Type", new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Output(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Output(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        IFluidHandler tTileEntity;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing())) != null) {
            boolean temp = true;
            while (temp && this.mFluid != null) {
                int tFilledAmount;
                temp = false;
                FluidStack tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()), Math.max(1, this.mFluid.amount), false);
                if (tDrained == null || (tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), tDrained, false)) <= 0) continue;
                temp = true;
                tTileEntity.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()), tFilledAmount, true), true);
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mMode", this.mMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mMode = aNBT.func_74771_c("mMode");
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0;
    }

    @Override
    public int getCapacity() {
        return 8000 * (this.mTier + 1);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).isGUIClickable(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), this.getBaseMetaTileEntity())) {
            return;
        }
        this.mMode = (byte)((this.mMode + 1) % 8);
        switch (this.mMode) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, "Outputs Liquids, Steam and Items");
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, "Outputs Steam and Items");
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, "Outputs Steam and Liquids");
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, "Outputs Steam");
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, "Outputs Liquids and Items");
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, "Outputs only Items");
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, "Outputs only Liquids");
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, "Outputs nothing");
            }
        }
    }

    public boolean outputsSteam() {
        return this.mMode < 4;
    }

    public boolean outputsLiquids() {
        return this.mMode % 2 == 0;
    }

    public boolean outputsItems() {
        return this.mMode % 4 < 2;
    }

    @Override
    public int getTankPressure() {
        return 100;
    }
}

