/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.generators;

import cpw.mods.fml.common.Loader;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicGenerator;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.VisNetHandler;

public class GT_MetaTileEntity_MagicalEnergyAbsorber
extends GT_MetaTileEntity_BasicGenerator {
    public int mEfficiency;
    public static boolean sAllowMultipleEggs = true;
    public static GT_MetaTileEntity_MagicalEnergyAbsorber mActiveSiphon = null;
    public static int sEnergyPerEnderCrystal = 32;
    public static int sEnergyFromVis = 12800;
    public static final ArrayList<EntityEnderCrystal> sUsedDragonCrystalList = new ArrayList();
    public EntityEnderCrystal mTargetedCrystal;
    public static int sDragonEggEnergyPerTick = 128;
    public static boolean isThaumcraftLoaded;

    @Override
    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public GT_MetaTileEntity_MagicalEnergyAbsorber(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Feasts on magic close to it", new ITexture[0]);
        this.onConfigLoad();
    }

    public GT_MetaTileEntity_MagicalEnergyAbsorber(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.onConfigLoad();
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MagicalEnergyAbsorber(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipes() {
        return GT_Recipe.GT_Recipe_Map.sMagicFuels;
    }

    @Override
    public int getCapacity() {
        return 16000;
    }

    public void onConfigLoad() {
        this.mEfficiency = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.efficiency.tier." + this.mTier, 100 - this.mTier * 10);
        sAllowMultipleEggs = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.AllowMultipleEggs", false);
        sEnergyPerEnderCrystal = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerTick.EnderCrystal", 32);
        sEnergyFromVis = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerVisDivisor", 2500);
        sDragonEggEnergyPerTick = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerTick", 2048);
        isThaumcraftLoaded = Loader.isModLoaded((String)"Thaumcraft");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + aBaseMetaTileEntity.getEUCapacity()) {
            if (this.hasEgg() && aTick % 10L == 0L) {
                this.getBaseMetaTileEntity().increaseStoredEnergyUnits(sDragonEggEnergyPerTick * this.getEfficiency() / 10, false);
                if (mActiveSiphon != this && !sAllowMultipleEggs) {
                    if (mActiveSiphon == null || mActiveSiphon.getBaseMetaTileEntity() == null || mActiveSiphon.getBaseMetaTileEntity().isInvalidTileEntity() || !mActiveSiphon.hasEgg()) {
                        mActiveSiphon = this;
                    } else {
                        this.getBaseMetaTileEntity().doExplosion(Integer.MAX_VALUE);
                    }
                }
            }
            if (isThaumcraftLoaded) {
                try {
                    World tmpWorld = this.getBaseMetaTileEntity().getWorld();
                    int tmpX = this.getBaseMetaTileEntity().getXCoord();
                    short tmpY = this.getBaseMetaTileEntity().getYCoord();
                    int tmpZ = this.getBaseMetaTileEntity().getZCoord();
                    int fire = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.FIRE, (int)1000);
                    int earth = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.EARTH, (int)1000);
                    int air = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.AIR, (int)1000);
                    int destruction = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.ENTROPY, (int)1000);
                    int order = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.ORDER, (int)1000);
                    int water = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.WATER, (int)1000);
                    int visEU = (int)(Math.pow(fire, 4.0) + Math.pow(earth, 4.0) + Math.pow(air, 4.0) + Math.pow(destruction, 4.0) + Math.pow(order, 4.0) + Math.pow(water, 4.0));
                    this.getBaseMetaTileEntity().increaseStoredEnergyUnits(Math.min(this.maxEUOutput(), (long)(visEU * this.getEfficiency() / sEnergyFromVis)), false);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void inValidate() {
        if (mActiveSiphon == this) {
            mActiveSiphon = null;
        }
    }

    public boolean hasEgg() {
        Block above = this.getBaseMetaTileEntity().getBlockOffset(0, 1, 0);
        if (above == null || Blocks.field_150350_a == above) {
            return false;
        }
        return Blocks.field_150380_bt == above || above.func_149739_a().equals("tile.dragonEgg");
    }

    @Override
    public int getEfficiency() {
        return this.mEfficiency;
    }

    @Override
    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT)};
    }

    @Override
    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC)};
    }

    @Override
    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_DRAGONEGG)};
    }

    @Override
    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC)};
    }

    @Override
    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_ACTIVE)};
    }

    @Override
    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE)};
    }

    @Override
    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_DRAGONEGG)};
    }

    @Override
    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE)};
    }
}

