/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_BronzeBlastFurnace;
import gregtech.common.gui.GT_GUIContainer_BronzeBlastFurnace;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_BronzeBlastFurnace
extends MetaTileEntity {
    public int mMaxProgresstime = 0;
    public int mUpdate = 5;
    public int mProgresstime = 0;
    public boolean mMachine = false;
    private static final ITexture[] FACING_SIDE = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEPLATEDBRICKS)};
    private static final ITexture[] FACING_FRONT = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBLASTFURNACE)};
    private static final ITexture[] FACING_ACTIVE = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBLASTFURNACE_ACTIVE)};
    public ItemStack mOutputItem1;
    public ItemStack mOutputItem2;

    public GT_MetaTileEntity_BronzeBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 4);
    }

    public GT_MetaTileEntity_BronzeBlastFurnace(String aName) {
        super(aName, 4);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"To get your first Steel", "Multiblock: 3x3x4 hollow with opening on top", "32 Bronze Plated Bricks required"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return aActive ? FACING_ACTIVE : FACING_FRONT;
        }
        return FACING_SIDE;
    }

    @Override
    public boolean isSteampowered() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isPneumatic() {
        return false;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public boolean isEnetOutput() {
        return false;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return GregTech_API.getCoverBehavior(aCoverID.toStack()).isSimpleCover() && super.allowCoverOnSide(aSide, aCoverID);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_BronzeBlastFurnace(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        NBTTagCompound tNBT;
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        if (this.mOutputItem1 != null) {
            tNBT = new NBTTagCompound();
            this.mOutputItem1.func_77955_b(tNBT);
            aNBT.func_74782_a("mOutputItem1", (NBTBase)tNBT);
        }
        if (this.mOutputItem2 != null) {
            tNBT = new NBTTagCompound();
            this.mOutputItem2.func_77955_b(tNBT);
            aNBT.func_74782_a("mOutputItem2", (NBTBase)tNBT);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mUpdate = 5;
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        this.mOutputItem1 = GT_Utility.loadItem(aNBT, "mOutputItem1");
        this.mOutputItem2 = GT_Utility.loadItem(aNBT, "mOutputItem2");
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BronzeBlastFurnace(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BronzeBlastFurnace(aPlayerInventory, aBaseMetaTileEntity);
    }

    private boolean checkMachine() {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 3; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (xDir + i == 0 && j == 0 && zDir + k == 0 || !(i != 0 || j == -1 || k != 0 ? this.getBaseMetaTileEntity().getBlockOffset(xDir + i, j, zDir + k) != GregTech_API.sBlockCasings1 || this.getBaseMetaTileEntity().getMetaIDOffset(xDir + i, j, zDir + k) != 10 : !GT_Utility.arrayContains(this.getBaseMetaTileEntity().getBlockOffset(xDir + i, j, zDir + k), Blocks.field_150353_l, Blocks.field_150356_k, null) && !this.getBaseMetaTileEntity().getAirOffset(xDir + i, j, zDir + k))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdate = 5;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            aBaseMetaTileEntity.getWorld().func_72869_a("largesmoke", (double)aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1) + Math.random(), (double)aBaseMetaTileEntity.getOffsetY(aBaseMetaTileEntity.getBackFacing(), 1), (double)aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1) + Math.random(), 0.0, 0.3, 0.0);
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mUpdate-- == 0) {
                this.mMachine = this.checkMachine();
            }
            if (this.mMachine) {
                if (this.mMaxProgresstime > 0) {
                    if (++this.mProgresstime >= this.mMaxProgresstime) {
                        this.addOutputProducts();
                        this.mOutputItem1 = null;
                        this.mOutputItem2 = null;
                        this.mProgresstime = 0;
                        this.mMaxProgresstime = 0;
                        try {
                            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "steel");
                        }
                        catch (Exception e) {}
                    }
                } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                    this.checkRecipe();
                }
            }
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0 && this.mMachine);
            if (aBaseMetaTileEntity.isActive()) {
                if (aBaseMetaTileEntity.getAir(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1))) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
                if (aBaseMetaTileEntity.getAir(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1))) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
            } else {
                if (aBaseMetaTileEntity.getBlock(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1)) == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
                if (aBaseMetaTileEntity.getBlock(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1)) == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
            }
        }
    }

    private void addOutputProducts() {
        if (this.mOutputItem1 != null) {
            if (this.mInventory[2] == null) {
                this.mInventory[2] = GT_Utility.copy(this.mOutputItem1);
            } else if (GT_Utility.areStacksEqual(this.mInventory[2], this.mOutputItem1)) {
                this.mInventory[2].field_77994_a = Math.min(this.mOutputItem1.func_77976_d(), this.mOutputItem1.field_77994_a + this.mInventory[2].field_77994_a);
            }
        }
        if (this.mOutputItem2 != null) {
            if (this.mInventory[3] == null) {
                this.mInventory[3] = GT_Utility.copy(this.mOutputItem2);
            } else if (GT_Utility.areStacksEqual(this.mInventory[3], this.mOutputItem2)) {
                this.mInventory[3].field_77994_a = Math.min(this.mOutputItem2.func_77976_d(), this.mOutputItem2.field_77994_a + this.mInventory[3].field_77994_a);
            }
        }
    }

    private boolean spaceForOutput(ItemStack aStack1, ItemStack aStack2) {
        return (this.mInventory[2] == null || aStack1 == null || this.mInventory[2].field_77994_a + aStack1.field_77994_a <= this.mInventory[2].func_77976_d() && GT_Utility.areStacksEqual(this.mInventory[2], aStack1)) && (this.mInventory[3] == null || aStack2 == null || this.mInventory[3].field_77994_a + aStack2.field_77994_a <= this.mInventory[3].func_77976_d() && GT_Utility.areStacksEqual(this.mInventory[3], aStack2));
    }

    private boolean checkRecipe() {
        if (!this.mMachine) {
            return false;
        }
        if (this.mInventory[0] != null && this.mInventory[1] != null && this.mInventory[0].field_77994_a >= 1) {
            if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[0], "dustIron") || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[0], "ingotIron")) {
                if (this.mInventory[1].func_77973_b() == Items.field_151044_h && this.mInventory[1].field_77994_a >= 4 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 1L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 4);
                    this.mMaxProgresstime = 7200;
                    return true;
                }
                if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "fuelCoke") && this.mInventory[1].field_77994_a >= 2 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 1L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Ash, 4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 2);
                    this.mMaxProgresstime = 4800;
                    return true;
                }
                if (this.mInventory[0].field_77994_a >= 9 && (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "blockCoal") || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "blockCharcoal")) && this.mInventory[1].field_77994_a >= 4 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 9L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 9);
                    this.getBaseMetaTileEntity().func_70298_a(1, 4);
                    this.mMaxProgresstime = 64800;
                    return true;
                }
            } else if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[0], "dustSteel")) {
                if (this.mInventory[1].func_77973_b() == Items.field_151044_h && this.mInventory[1].field_77994_a >= 2 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 1L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 2);
                    this.mMaxProgresstime = 3600;
                    return true;
                }
                if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "fuelCoke") && this.mInventory[1].field_77994_a >= 1 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 1L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Ash, 2L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 1);
                    this.mMaxProgresstime = 2400;
                    return true;
                }
                if (this.mInventory[0].field_77994_a >= 9 && (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "blockCoal") || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "blockCharcoal")) && this.mInventory[1].field_77994_a >= 2 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 9L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 2L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 9);
                    this.getBaseMetaTileEntity().func_70298_a(1, 2);
                    this.mMaxProgresstime = 32400;
                    return true;
                }
            } else if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[0], "blockIron")) {
                if (this.mInventory[1].func_77973_b() == Items.field_151044_h && this.mInventory[1].field_77994_a >= 36 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 9L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 36);
                    this.mMaxProgresstime = 64800;
                    return true;
                }
                if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "fuelCoke") && this.mInventory[1].field_77994_a >= 18 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 9L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Ash, 4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 18);
                    this.mMaxProgresstime = 43200;
                    return true;
                }
                if ((GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "blockCoal") || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[1], "blockCharcoal")) && this.mInventory[1].field_77994_a >= 4 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 9L), this.mOutputItem2 = GT_OreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 4);
                    this.mMaxProgresstime = 64800;
                    return true;
                }
            }
        }
        this.mOutputItem1 = null;
        this.mOutputItem2 = null;
        return false;
    }

    @Override
    public boolean isGivingInformation() {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex > 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (aIndex < 2) {
            // empty if block
        }
        return !GT_Utility.areStacksEqual(aStack, this.mInventory[0]);
    }

    @Override
    public byte getTileEntityBaseType() {
        return 0;
    }
}

