/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_LargeBoiler
extends GT_MetaTileEntity_MultiBlockBase {
    private boolean firstRun = true;

    public GT_MetaTileEntity_LargeBoiler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeBoiler(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large Boiler", "Size: 3x3x5", "Controller (front middle in Fireboxes)", "3x3 of Fire Boxes (bottom Layer, Min 3!)", "3x3x4 of Casing (above Fireboxes, hollow, Min 24!)", "3 Pipe Casing Blocks inside the Hollow Casing", "1x Input (one of Fireboxes)", "1x Maintenance Hatch (one of Fireboxes)", "1x Muffler Hatch (one of Fireboxes)", "1x Fluid Output (one of Main Casing)"};
    }

    public abstract Block getCasingBlock();

    public abstract byte getCasingMeta();

    public abstract byte getCasingTextureIndex();

    public abstract Block getPipeBlock();

    public abstract byte getPipeMeta();

    public abstract Block getFireboxBlock();

    public abstract byte getFireboxMeta();

    public abstract byte getFireboxTextureIndex();

    public abstract int getEUt();

    public abstract int getEfficiencyIncrease();

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[this.getCasingTextureIndex()], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[this.getCasingTextureIndex()]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeBoiler.png");
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        FluidStack tFluid;
        for (GT_Recipe tRecipe : GT_Recipe.GT_Recipe_Map.sDieselFuels.mRecipeList) {
            tFluid = GT_Utility.getFluidForFilledItem(tRecipe.getRepresentativeInput(0), true);
            if (tFluid == null || tRecipe.mSpecialValue <= 1) continue;
            tFluid.amount = 1000;
            if (!this.depleteInput(tFluid)) continue;
            this.mMaxProgresstime = tRecipe.mSpecialValue / 2;
            this.mEUt = this.getEUt();
            this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease() * 4;
            return true;
        }
        for (GT_Recipe tRecipe : GT_Recipe.GT_Recipe_Map.sDenseLiquidFuels.mRecipeList) {
            tFluid = GT_Utility.getFluidForFilledItem(tRecipe.getRepresentativeInput(0), true);
            if (tFluid == null) continue;
            tFluid.amount = 1000;
            if (!this.depleteInput(tFluid)) continue;
            this.mMaxProgresstime = Math.max(1, tRecipe.mSpecialValue * 2);
            this.mEUt = this.getEUt();
            this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
            return true;
        }
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        if (!tInputList.isEmpty()) {
            for (ItemStack tInput : tInputList) {
                if (GT_Utility.getFluidForFilledItem(tInput, true) != null || (this.mMaxProgresstime = GT_ModHandler.getFuelValue(tInput) / 80) <= 0) continue;
                this.mEUt = this.getEUt();
                this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
                this.mOutputItems = new ItemStack[]{GT_Utility.getContainerItem(tInput, true)};
                --tInput.field_77994_a;
                this.updateSlots();
                return true;
            }
        }
        this.mMaxProgresstime = 0;
        this.mEUt = 0;
        return false;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            int tGeneratedEU = (int)((long)this.mEUt * 2L * (long)this.mEfficiency / 10000L);
            if (tGeneratedEU > 0) {
                if (this.depleteInput(Materials.Water.getFluid((tGeneratedEU + 160) / 160))) {
                    this.addOutput(GT_ModHandler.getSteam(tGeneratedEU));
                } else {
                    this.explodeMultiblock();
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProgresstime > 0 && this.firstRun) {
            this.firstRun = false;
            try {
                GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "extremepressure");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int j;
        int i;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tCasingAmount = 0;
        int tFireboxAmount = 0;
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                int k;
                if (i != 0 || j != 0) {
                    for (k = 1; k <= 4; ++k) {
                        if (this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, k, zDir + j), this.getCasingTextureIndex())) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + i, k, zDir + j) != this.getCasingBlock()) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, k, zDir + j) != this.getCasingMeta()) {
                            return false;
                        }
                        ++tCasingAmount;
                    }
                    continue;
                }
                for (k = 1; k <= 3; ++k) {
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, k, zDir + j) != this.getPipeBlock()) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, k, zDir + j) == this.getPipeMeta()) continue;
                    return false;
                }
                if (this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 4, zDir + j), this.getCasingTextureIndex())) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 4, zDir + j) != this.getCasingBlock()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 4, zDir + j) != this.getCasingMeta()) {
                    return false;
                }
                ++tCasingAmount;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                IGregTechTileEntity tTileEntity;
                if (xDir + i == 0 && zDir + j == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), this.getFireboxTextureIndex()) || this.addInputToMachineList(tTileEntity, this.getFireboxTextureIndex()) || this.addMufflerToMachineList(tTileEntity, this.getFireboxTextureIndex())) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != this.getFireboxBlock()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) != this.getFireboxMeta()) {
                    return false;
                }
                ++tFireboxAmount;
            }
        }
        return tCasingAmount >= 24 && tFireboxAmount >= 3;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 10;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

