/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_ProcessingArray
extends GT_MetaTileEntity_MultiBlockBase {
    GT_Recipe mLastRecipe;

    public GT_MetaTileEntity_ProcessingArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ProcessingArray(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ProcessingArray(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Processing Array", "Size: 3x3x3 (Hollow)", "Controller (front centered)", "1x Input (anywhere)", "1x Output (anywhere)", "1x Energy Hatch (anywhere)", "1x Maintenance Hatch (anywhere)", "Robust Tungstensteel Casings for the rest (16 at least!)", "Put up to 16 Basic Machines into the GUI Inventory", "Currently only fluid Centrifuge Recipes work correctly", "Make Deuterium/Tritium with it."};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[48], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[48]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "VacuumFreezer.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        String tmp = this.mInventory[1].func_77977_a().replaceAll("gt.blockmachines.basicmachine.", "");
        if (tmp.startsWith("centrifuge")) {
            return GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes;
        }
        if (tmp.equals("")) {
            // empty if block
        }
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.func_77977_a().startsWith("gt.blockmachines.basicmachine.");
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        if (!this.isCorrectMachinePart(this.mInventory[1])) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map map = this.getRecipeMap();
        if (map == null) {
            return false;
        }
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        long tVoltage = this.getMaxInputVoltage();
        int tTier = 0;
        if (this.mInventory[1].func_77977_a().endsWith("1")) {
            tTier = 1;
        }
        if (this.mInventory[1].func_77977_a().endsWith("2")) {
            tTier = 2;
        }
        if (this.mInventory[1].func_77977_a().endsWith("3")) {
            tTier = 3;
        }
        if (this.mInventory[1].func_77977_a().endsWith("4")) {
            tTier = 4;
        }
        if (this.mInventory[1].func_77977_a().endsWith("5")) {
            tTier = 5;
        }
        FluidStack fluidIn = null;
        if (this.mInputHatches != null && this.mInputHatches.size() > 0) {
            fluidIn = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid;
        }
        ItemStack tInput = null;
        if (tInputList.size() > 0) {
            tInput = tInputList.get(0);
        }
        if ((tRecipe = map.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], new FluidStack[]{fluidIn}, tInput)) != null) {
            this.mLastRecipe = tRecipe;
            int machines = Math.max(16, this.mInventory[1].field_77994_a);
            if (tRecipe.mFluidOutputs.length > 0 && tRecipe.mFluidInputs.length > 0 && ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid.amount > tRecipe.mFluidInputs[0].amount * machines) {
                ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid.amount -= tRecipe.mFluidInputs[0].amount * machines;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                if (tRecipe.mEUt <= 16) {
                    this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1) * machines;
                    this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
                } else {
                    this.mEUt = tRecipe.mEUt * machines;
                    this.mMaxProgresstime = tRecipe.mDuration;
                    while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                        this.mEUt *= 4;
                        this.mMaxProgresstime /= 2;
                    }
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
                this.mOutputFluids[0].amount *= machines;
                this.updateSlots();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 0, zDir)) {
            return false;
        }
        int tAmount = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int h = -1; h < 2; ++h) {
                    IGregTechTileEntity tTileEntity;
                    if (h == 0 && (xDir + i == 0 && zDir + j == 0 || i == 0 && j == 0) || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, h, zDir + j), 48) || this.addInputToMachineList(tTileEntity, 48) || this.addOutputToMachineList(tTileEntity, 48) || this.addEnergyInputToMachineList(tTileEntity, 48)) continue;
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != GregTech_API.sBlockCasings4) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) != 0) {
                        return false;
                    }
                    ++tAmount;
                }
            }
        }
        return tAmount >= 16;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

