/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.audio.AudioSource;
import ic2classic.core.block.machine.ContainerCanner;
import ic2classic.core.block.machine.tileentity.TileEntityElecMachine;
import ic2classic.core.item.ItemFuelCanEmpty;
import ic2classic.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCanner
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public short progress = 0;
    public int energyconsume = 1;
    public int operationLength = 600;
    private int fuelQuality = 0;
    public AudioSource audioSource;

    public TileEntityCanner() {
        super(4, 1, 631, 32);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.fuelQuality = nbttagcompound.func_74762_e("fuelQuality");
        }
        catch (Throwable e) {
            this.fuelQuality = nbttagcompound.func_74765_d("fuelQuality");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuelQuality", this.fuelQuality);
    }

    public int gaugeProgressScaled(int i) {
        int food;
        int l = this.operationLength;
        if (this.getMode() == 1 && this.inventory[0] != null && (food = this.getFoodValue(this.inventory[0])) > 0) {
            l = 50 * food;
        }
        if (this.getMode() == 3) {
            l = 50;
        }
        return this.progress * i / l;
    }

    public int gaugeFuelScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / (this.operationLength * this.energyconsume);
        if (r > i) {
            return i;
        }
        return r;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        boolean canOperate = this.canOperate();
        if (this.energy <= this.energyconsume * this.operationLength && canOperate) {
            needsInvUpdate = this.provideEnergy();
        }
        boolean newActive = this.getActive();
        if (canOperate && (this.getMode() == 1 && this.progress >= this.getFoodValue(this.inventory[0]) * 50 || this.getMode() == 2 && this.progress > 0 && this.progress % 100 == 0 || this.getMode() == 3 && this.progress >= 50)) {
            if (this.getMode() == 1 || this.getMode() == 3 || this.progress >= 600) {
                this.operate(false);
                this.fuelQuality = 0;
                this.progress = 0;
                newActive = false;
            } else {
                this.operate(true);
            }
            needsInvUpdate = true;
        }
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= this.energyconsume) {
                    newActive = true;
                }
            } else if (this.getMode() != 2) {
                this.fuelQuality = 0;
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < this.energyconsume) {
            if (!canOperate && this.getMode() != 2) {
                this.fuelQuality = 0;
                this.progress = 0;
            }
            newActive = false;
        }
        if (newActive) {
            this.progress = (short)(this.progress + 1);
            this.energy -= this.energyconsume;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void operate(boolean incremental) {
        switch (this.getMode()) {
            case 1: {
                int food = this.getFoodValue(this.inventory[0]);
                int meta = this.getFoodMeta(this.inventory[0]);
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].func_77973_b() == Items.field_151009_A && this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = new ItemStack(Items.field_151054_z);
                }
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                this.inventory[3].field_77994_a -= food;
                if (this.inventory[3].field_77994_a <= 0) {
                    this.inventory[3] = null;
                }
                if (this.inventory[2] == null) {
                    this.inventory[2] = new ItemStack(Ic2Items.filledTinCan, food, meta);
                    break;
                }
                this.inventory[2].field_77994_a += food;
                break;
            }
            case 2: {
                int fuel = this.getFuelValue(this.inventory[0].func_77973_b());
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                this.fuelQuality += fuel;
                if (incremental) break;
                if (this.inventory[3].func_77973_b() instanceof ItemFuelCanEmpty) {
                    --this.inventory[3].field_77994_a;
                    if (this.inventory[3].field_77994_a <= 0) {
                        this.inventory[3] = null;
                    }
                    this.inventory[2] = new ItemStack(Ic2Items.filledFuelCan);
                    NBTTagCompound data = StackUtil.getOrCreateNbtData(this.inventory[2]);
                    data.func_74768_a("value", this.fuelQuality);
                    break;
                }
                int damage = this.inventory[3].func_77960_j();
                if ((damage -= this.fuelQuality) < 1) {
                    damage = 1;
                }
                this.inventory[3] = null;
                this.inventory[2] = new ItemStack(Ic2Items.jetpack, 1, damage);
                break;
            }
            case 3: {
                --this.inventory[0].field_77994_a;
                this.inventory[3].func_77964_b(this.inventory[3].func_77960_j() - 2);
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                if (this.inventory[0] != null && this.inventory[3].func_77960_j() > 1) break;
                this.inventory[2] = this.inventory[3];
                this.inventory[3] = null;
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        switch (this.getMode()) {
            case 1: {
                int food = this.getFoodValue(this.inventory[0]);
                if (food <= 0 || food > this.inventory[3].field_77994_a || this.inventory[2] != null && (this.inventory[2].field_77994_a + food > this.inventory[2].func_77976_d() || this.inventory[2].func_77973_b() != Ic2Items.filledTinCan || this.inventory[2].func_77960_j() != this.getFoodMeta(this.inventory[0]))) break;
                return true;
            }
            case 2: {
                int fuel = this.getFuelValue(this.inventory[0].func_77973_b());
                if (fuel <= 0 || this.inventory[2] != null) break;
                return true;
            }
            case 3: {
                if (this.inventory[3].func_77960_j() <= 2 || this.getPelletValue(this.inventory[0]) <= 0 || this.inventory[2] != null) break;
                return true;
            }
        }
        return false;
    }

    public int getMode() {
        if (this.inventory[3] == null) {
            return 0;
        }
        if (this.inventory[3].func_77973_b() == Ic2Items.tinCan) {
            return 1;
        }
        if (this.inventory[3].func_77973_b() instanceof ItemFuelCanEmpty || this.inventory[3].func_77973_b() == Ic2Items.jetpack) {
            return 2;
        }
        if (this.inventory[3].func_77973_b() == Ic2Items.cfPack) {
            return 3;
        }
        return 0;
    }

    @Override
    public String func_145825_b() {
        return "Canning Machine";
    }

    private int getFoodValue(ItemStack item) {
        if (item.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)item.func_77973_b();
            return (int)Math.ceil((double)food.func_150905_g(item) / 2.0);
        }
        if (item.func_77973_b() == Items.field_151105_aU || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150414_aQ)) {
            return 6;
        }
        return 0;
    }

    public int getFuelValue(Item id) {
        if (id == Ic2Items.coalfuelCell) {
            return 2548;
        }
        if (id == Ic2Items.biofuelCell) {
            return 868;
        }
        if (id == Items.field_151137_ax && this.fuelQuality > 0) {
            return (int)((double)this.fuelQuality * 0.2);
        }
        if (id == Items.field_151114_aO && this.fuelQuality > 0) {
            return (int)((double)this.fuelQuality * 0.3);
        }
        if (id == Items.field_151016_H && this.fuelQuality > 0) {
            return (int)((double)this.fuelQuality * 0.4);
        }
        return 0;
    }

    public int getPelletValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (item.func_77973_b() != Ic2Items.constructionFoamPellet) {
            return 0;
        }
        return item.field_77994_a;
    }

    private int getFoodMeta(ItemStack item) {
        return 0;
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCanner(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiCanner";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int side) {
        ForgeDirection leftSide;
        switch (this.getFacing()) {
            case 2: {
                leftSide = ForgeDirection.EAST;
                break;
            }
            case 3: {
                leftSide = ForgeDirection.WEST;
                break;
            }
            case 4: {
                leftSide = ForgeDirection.NORTH;
                break;
            }
            default: {
                leftSide = ForgeDirection.SOUTH;
            }
        }
        if (side == leftSide.ordinal()) {
            return new int[]{3};
        }
        if (side == 0) {
            return new int[]{1};
        }
        if (side == 1) {
            return new int[1];
        }
        return new int[]{2};
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }
}

